/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.model;

import jp.jasminesoft.jfc.appgen.component.appschema.ModelitemUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Attribute {
    private static Logger LOGGER = LogManager.getLogger(Attribute.class);
    private String name;
    private String dataType;
    private String javaDataType;
    private String className;
    private String label;
    private String filter;
    private boolean calendar_input_ = false;
    private boolean multiple_ = false;
    private boolean hasChild_ = false;

    public Attribute(Model model, Modelitem modelItem, String modelItemName, Project project) {
        String relType;
        Modelitem sitem = modelItem;
        if (!model.getType().equals("store")) {
            String name = modelItem.getName();
            if (name.endsWith("1jshparam") || name.endsWith("2jshparam")) {
                name = name.substring(0, name.length() - "1jshparam".length());
            }
            sitem = AppSchemaUtil.getModelitem(modelItem.getName(), AppSchemaUtil.getStoreModel(model));
            if ("list".equals(model.getType())) {
                modelItem = sitem;
            }
        }
        this.name = modelItemName;
        this.className = AppSchemaUtil.getModelitemClassname(this.name, model);
        if (!model.getType().equals("store")) {
            this.name = AppSchemaUtil.getChildPart(this.name);
        }
        this.dataType = modelItem.getType();
        this.multiple_ = modelItem.getMultiple();
        this.hasChild_ = modelItem.getHasChild();
        if (sitem != null && sitem.getDualinputmethod() != null) {
            this.dataType = modelItem.getDualinputmethodAsString();
            this.javaDataType = "ComboBox";
        } else if (ModelitemUtils.isStoreref(modelItem)) {
            relType = AppSchemaUtil.getRelationType(AppSchemaUtil.getRelation(modelItem), project);
            this.javaDataType = "combo".equals(relType) ? "ListBox" : ("check".equals(relType) ? "CheckBox" : ("radio".equals(relType) ? "RadioButton" : ("search".equals(relType) ? "SearchList" : "WebModelitem")));
        } else if ("masterref".equals(modelItem.getType())) {
            relType = AppSchemaUtil.getRelationType(AppSchemaUtil.getRelation(modelItem), project);
            if ("combo".equals(relType)) {
                this.javaDataType = "ListBox";
            } else if ("check".equals(relType)) {
                this.javaDataType = "CheckBox";
            } else if ("radio".equals(relType)) {
                this.javaDataType = "RadioButton";
            } else {
                LOGGER.warn("FIXME: " + relType + " is not implemented yet = " + modelItem);
            }
        } else {
            this.javaDataType = this.toJavaDataType(model, modelItem, project);
        }
    }

    private String toJavaDataType(Model model, Modelitem modelItem, Project project) {
        if (this.dataType.equals("combo")) {
            return "ListBox";
        }
        if (this.dataType.equals("storeref")) {
            return "RadioButton";
        }
        if (this.dataType.equals("zipcode")) {
            return "Postcode";
        }
        if (this.dataType.equals("date")) {
            String selectinput;
            if (modelItem.getMultiple()) {
                return "MultiDateTextBox";
            }
            Model pmodel = AppSchemaUtil.getPresentationModel(project, model);
            Modelitem pitem = AppSchemaUtil.getModelitem(modelItem.getName(), pmodel);
            if (pitem != null && StringUtils.isNotBlank((CharSequence)(selectinput = pitem.getSelectinput())) && (selectinput.startsWith("YMD:") || selectinput.startsWith("YM:") || selectinput.startsWith("Y:"))) {
                String rest;
                if (selectinput.equals("Y:text") || selectinput.equals("YM:text_ym")) {
                    return "SeparatedDateTextBox";
                }
                boolean isDateListBox = true;
                int ptr = selectinput.indexOf(":");
                if (ptr > 0 && ((rest = selectinput.substring(ptr)).indexOf("text") >= 0 || rest.indexOf("input") >= 0)) {
                    isDateListBox = false;
                }
                if (isDateListBox) {
                    return "DateListBox";
                }
            }
            return "DateTextBox";
        }
        if (this.dataType.equals("time")) {
            if (modelItem.getMultiple()) {
                return "WebMultiModelitem";
            }
            Model pmodel = AppSchemaUtil.getPresentationModel(project, model);
            Modelitem pitem = AppSchemaUtil.getModelitem(modelItem.getName(), pmodel);
            if (pitem != null && StringUtils.isNotBlank((CharSequence)pitem.getSelectinput())) {
                return "TimeListBox";
            }
            return "WebModelitem";
        }
        if (this.dataType.equals("dateTime")) {
            if (modelItem.getMultiple()) {
                return "MultiDateTimeTextBox";
            }
            return "DateTimeTextBox";
        }
        if (this.dataType.equals("string")) {
            if (AppSchemaUtil.getModelitem(modelItem.getName() + "_jshfilename", model) != null) {
                return "FileType";
            }
            if (!this.hasChild_ && this.multiple_) {
                return "WebMultiModelitem";
            }
            return "WebModelitem";
        }
        if (!this.hasChild_ && this.multiple_) {
            return "WebMultiModelitem";
        }
        return "WebModelitem";
    }

    public boolean isContainerClassDef() {
        return this.hasChild_ && this.multiple_;
    }

    public boolean isMultipleDef() {
        return !this.hasChild_ && this.multiple_;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return this.getMetadata();
    }

    public String getMetadata() {
        return "{id:" + this.name + ",name:" + this.label + ",dataType:" + this.javaDataType + ",hasChild:" + this.hasChild_ + ",multiple:" + this.multiple_ + "}";
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setFilter(String filterName) {
        this.filter = filterName;
    }

    public void setCalendarInput(boolean tf) {
        this.calendar_input_ = tf;
    }

    public String getName() {
        return this.name;
    }

    void setName(String newName) {
        this.name = newName;
    }

    public String getJavaDataType() {
        if (this.javaDataType.equals("WebModelitem") || this.javaDataType.equals("WebMultiModelitem")) {
            return this.javaDataType + "<?>";
        }
        return this.javaDataType;
    }

    public String getJavaDataType2() {
        if (this.getJavaDataType().endsWith("<?>")) {
            return this.javaDataType + "<>";
        }
        return this.javaDataType;
    }

    void setJavaDataType(String newJavaDataType) {
        this.javaDataType = newJavaDataType;
    }

    public String getLabel() {
        return this.label;
    }
}

