/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.appgen.component.BaseModel;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.test.support.testmodel.model.Attribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TModel
extends BaseModel {
    private static Logger LOGGER = LogManager.getLogger(TModel.class);
    protected Map<String, Attribute> attributes;
    protected Model baseModel_;
    protected Model presentationModel_;
    protected List<Map<String, Object>> childClassInfo = null;

    public TModel(Model storeModel, Model baseModel, Model presentationModel) {
        super(storeModel);
        if (!storeModel.getType().equals("store")) {
            throw new IllegalArgumentException("Input variable 'Model' is NOT 'store model'.");
        }
        this.baseModel_ = baseModel;
        this.presentationModel_ = presentationModel;
        this.initModelItems();
    }

    @Override
    public String getPackage() {
        String s = super.getPackage();
        s = this.getProject().getPackage() + ".tests.models." + s.substring(s.indexOf(".model.") + ".model.".length());
        return s;
    }

    @Override
    public abstract String getClassName();

    public String getJapaneseClassName() {
        return AppSchemaUtil.getStoreModel(this.baseModel_).getDescription();
    }

    public List<Attribute> getAttributes() {
        return new ArrayList<Attribute>(this.attributes.values());
    }

    public boolean getHasChildClasses() {
        return this.childClassInfo != null && this.childClassInfo.size() > 0;
    }

    public List<Map<String, Object>> getChildClasses() {
        return this.childClassInfo;
    }

    public boolean isSkip(Modelitem modelitem) {
        return false;
    }

    public String getMetadata() {
        String attrs = this.attributes.values().stream().map(attr -> attr.getMetadata()).collect(Collectors.joining(","));
        return "{id:" + this.getClassName() + ",name:" + this.getJapaneseClassName() + ",columns:" + attrs + "}";
    }

    private void initModelItems() {
        this.attributes = new LinkedHashMap<String, Attribute>();
        ArrayList<String> childContainerNames = new ArrayList<String>();
        HashSet<String> processedModelitemNameSet = new HashSet<String>();
        for (Modelitem modelItem : ModelUtils.getModelitems(this.baseModel_)) {
            Relation relation;
            if (this.isSkip(modelItem)) continue;
            String modelItemName = modelItem.getName();
            if ("storeref".equals(modelItem.getType()) && modelItemName.indexOf("_") > 0 && (relation = AppSchemaUtil.getRelation(modelItem)) != null) {
                String rest;
                int ptr2;
                String rid = null;
                String tmp = relation.toString();
                int ptr = tmp.indexOf("roleid=\"");
                if (ptr > 0 && (ptr2 = (rest = tmp.substring(ptr + "roleid=\"".length())).indexOf("\"")) > 0) {
                    rid = rest.substring(0, ptr2);
                }
                if (rid != null && modelItemName.substring(modelItemName.indexOf("_") + 1).equals(rid)) {
                    modelItemName = modelItem.getName().substring(0, modelItemName.indexOf("_"));
                }
            }
            if (processedModelitemNameSet.contains(modelItemName)) continue;
            Attribute attr = new Attribute(this.baseModel_, modelItem, modelItemName, super.getProject());
            this.attributes.put(modelItemName, attr);
            processedModelitemNameSet.add(modelItemName);
            if (!attr.isContainerClassDef()) continue;
            childContainerNames.add(attr.getName());
        }
        for (Modelitem modelItem : ModelUtils.getModelitems(this.presentationModel_)) {
            Attribute attr = this.attributes.get(modelItem.getName());
            if (attr == null) continue;
            attr.setLabel(modelItem.getLabel());
            attr.setFilter(modelItem.getFilter());
            attr.setCalendarInput(modelItem.getCalendarinput());
        }
        if (childContainerNames.size() > 0) {
            this.childClassInfo = new ArrayList<Map<String, Object>>();
            for (String ccName : childContainerNames) {
                Map<String, Object> containerInfo = this.pickUpChildContainerAttrs(ccName, this.attributes);
                this.childClassInfo.add(containerInfo);
                String childClassName = (String)containerInfo.get("className");
                Attribute containerAttr = this.attributes.get(ccName);
                containerAttr.setJavaDataType(childClassName);
            }
        }
    }

    private Map<String, Object> pickUpChildContainerAttrs(String containerName, Map<String, Attribute> attributes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", containerName);
        result.put("className", SourceGenerator.capFirst(containerName));
        ArrayList<Attribute> selectedAttrs = new ArrayList<Attribute>();
        for (String key : attributes.keySet()) {
            if (!key.startsWith(containerName + "/")) continue;
            Attribute childAttr = attributes.get(key);
            selectedAttrs.add(childAttr);
        }
        for (Attribute attr : selectedAttrs) {
            attributes.remove(attr.getName());
            attr.setName(AppSchemaUtil.getChildPart(attr.getName()));
        }
        result.put("attributes", selectedAttrs);
        return result;
    }
}

