/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StrUtil {
    private static final String SP_CHARS = " () {}[]<>,./*&^%$#@!-=+\\|~`";

    public static String swapSpecialChars(String input, char replacement) {
        return input.chars().mapToObj(c -> Character.valueOf((char)c)).map(c -> SP_CHARS.indexOf(c.charValue()) >= 0 ? String.valueOf(replacement) : String.valueOf(c)).collect(Collectors.joining());
    }

    public static String deleteCommentouts(String input) {
        String line;
        if (input == null || input.trim().length() < 1 || input.trim().startsWith("//")) {
            return null;
        }
        String newLine = line = input.trim();
        if (line.indexOf("//") > 0) {
            if (line.indexOf("\"") > 0) {
                int idxSlash = line.indexOf("//");
                int posBeginQ = line.indexOf("\"");
                int posEndQ = line.lastIndexOf("\"");
                newLine = posBeginQ < idxSlash && idxSlash < posEndQ ? line : line.substring(0, line.indexOf("//"));
            } else {
                newLine = line.substring(0, line.indexOf("//"));
            }
        }
        return newLine;
    }

    public static String[] splitBy(char delimiter, String input) {
        String v;
        if (input == null || input.trim().length() < 1) {
            return new String[]{input};
        }
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean inDoubleQuote = false;
        for (char c : input.toCharArray()) {
            if (!inDoubleQuote && c == delimiter) {
                String v2 = buf.toString().trim();
                if (StringUtils.isNotEmpty((CharSequence)v2)) {
                    results.add(v2);
                }
                buf = new StringBuilder();
            }
            buf.append(c);
            if (c != '\"') continue;
            inDoubleQuote = !inDoubleQuote;
        }
        if (buf.length() > 0 && StringUtils.isNotEmpty((CharSequence)(v = buf.toString().trim()))) {
            results.add(v);
        }
        return results.toArray(new String[0]);
    }

    public static String[] removeDoubleQuotes(String[] inputs) {
        if (inputs == null || inputs.length < 1) {
            return inputs;
        }
        return (String[])Arrays.stream(inputs).map(value -> {
            if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }).toArray(String[]::new);
    }
}

