/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;
import jp.jasminesoft.jfc.test.support.testmodel.model.ConditionTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.ListTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.StoreTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.UpdateListTModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.Command;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.StrUtil;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.BeAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.BeCondAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.ButtonAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.ClickListAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.CreateCondInstanceAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.CreateInstanceAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.DirectCode;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.DisplayAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.EmptyAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.EnableAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.FileAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.FontSizeAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.ImpExpAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.InputAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.InputConditionAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsClickableButtonAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsExistButtonAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsExistButtonCondAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsExistPaginationAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsHiddenAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsHiddenCondAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsLinkDisabledPaginationAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsLinkEnabledPaginationAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsNotExistButtonAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsNotExistButtonCondAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.IsNotExistPaginationAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.LogoffAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.LogonAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.MenuAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.MessageAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.NotBeAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.NotBeCondAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.PageTitleAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.PaginationAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.ResultCountAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.ScreenShotAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.ScrollAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.SubMenuAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.TitleAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.TitlePaneAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.UpdateListInputAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.VerifyAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.VerifyCondAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.VerifyCondOptionAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.VerifyListAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.VerifyOptionAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.VerifySizeAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.WindowSizeAction;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.WorkFlowAction;

public class TestStatement {
    private Map<String, Map<String, TModel>> testModelMap_;
    private String orig_statement_line_;
    private String actionName;
    private ArrayList<String> java_codes_;
    private TModel targetPageObj_ = null;
    private TModel targetPageObj_injected = null;
    private boolean init_pageobj_store_ = false;
    private boolean init_pageobj_condition_ = false;
    private boolean init_pageobj_list_ = false;
    private boolean init_pageobj_updatelist_ = false;
    private String pageobj_init_code_store_ = null;
    private String pageobj_init_code_condition_ = null;
    private String pageobj_init_code_list_ = null;
    private String pageobj_init_code_updatelist_ = null;
    private Command command = Command.getInstance();
    private static String latestCommand = null;
    private Map<String, String> localVariableMap_;
    private boolean isOutputStatus_;
    private boolean require_pageobj_ = false;

    public TestStatement(Map<String, Map<String, TModel>> testModelMap, String actionLine, TModel targetPageObj, Map<String, String> localVariableMap, boolean isOutputStatus) {
        if (actionLine == null) {
            throw new IllegalArgumentException("Empty action line is not valid.");
        }
        this.testModelMap_ = testModelMap;
        this.orig_statement_line_ = actionLine.trim();
        this.targetPageObj_injected = targetPageObj;
        this.localVariableMap_ = localVariableMap;
        this.isOutputStatus_ = isOutputStatus;
        String[] parts = StrUtil.splitBy(' ', this.orig_statement_line_);
        this.actionName = parts[0];
        String[] variables = null;
        if (parts.length > 1) {
            variables = Arrays.copyOfRange(parts, 1, parts.length);
            variables = StrUtil.removeDoubleQuotes(variables);
        }
        try {
            this.java_codes_ = this.translate(this.actionName, variables);
        }
        catch (InvalidTestConfigException e) {
            this.java_codes_ = new ArrayList();
            this.java_codes_.add("// [ERROR] " + e.getMessage());
        }
    }

    public TestStatement(String line) {
        if (this.java_codes_ == null) {
            this.java_codes_ = new ArrayList();
        }
        this.java_codes_.add(line);
        this.orig_statement_line_ = null;
    }

    public boolean requirePageObject() {
        return this.targetPageObj_ != null && this.require_pageobj_;
    }

    public boolean addPageObjectStoreInitCode() {
        if (!(this.targetPageObj_ instanceof StoreTModel)) {
            return false;
        }
        String className = this.targetPageObj_.getClassName();
        String instanceName = null;
        instanceName = className.toLowerCase();
        this.init_pageobj_store_ = true;
        this.pageobj_init_code_store_ = className + " " + instanceName + " = new " + className + "();";
        return true;
    }

    public boolean addPageObjectConditionInitCode() {
        if (!(this.targetPageObj_ instanceof ConditionTModel)) {
            return false;
        }
        String className = this.targetPageObj_.getClassName();
        String instanceName = "condition";
        this.init_pageobj_condition_ = true;
        this.pageobj_init_code_condition_ = className + " " + instanceName + " = new " + className + "();";
        return true;
    }

    public boolean addPageObjectListInitCode() {
        if (!(this.targetPageObj_ instanceof ListTModel)) {
            return false;
        }
        String className = this.targetPageObj_.getClassName();
        String instanceName = "list";
        this.init_pageobj_list_ = true;
        this.pageobj_init_code_list_ = className + " " + instanceName + " = new " + className + "();";
        return true;
    }

    public boolean addPageObjectUpdateListInitCode() {
        if (!(this.targetPageObj_ instanceof UpdateListTModel)) {
            return false;
        }
        String className = this.targetPageObj_.getClassName();
        String instanceName = "updateList";
        this.init_pageobj_updatelist_ = true;
        this.pageobj_init_code_updatelist_ = className + " " + instanceName + " = new " + className + "();";
        return true;
    }

    public String getOrigStatementLine() {
        return this.orig_statement_line_;
    }

    public TModel getTargetPageObject() {
        return this.targetPageObj_;
    }

    public String[] getCodes() {
        if (this.actionName != null && this.actionName.equals(this.command.get("NEWOBJ"))) {
            if (this.init_pageobj_store_ && !this.pageobj_init_code_store_.equals(this.java_codes_.get(0))) {
                this.java_codes_.add(0, this.pageobj_init_code_store_);
            }
            if (this.init_pageobj_list_ && !this.pageobj_init_code_list_.equals(this.java_codes_.get(0))) {
                this.java_codes_.add(0, this.pageobj_init_code_list_);
            }
            if (this.init_pageobj_updatelist_ && !this.pageobj_init_code_updatelist_.equals(this.java_codes_.get(0))) {
                this.java_codes_.add(0, this.pageobj_init_code_updatelist_);
            }
        } else if (this.actionName != null && this.actionName.equals(this.command.get("NEWOBJCOND"))) {
            if (this.init_pageobj_condition_ && this.pageobj_init_code_condition_ != null && !this.pageobj_init_code_condition_.equals(this.java_codes_.get(0))) {
                this.java_codes_.add(0, this.pageobj_init_code_condition_);
            }
        } else {
            if (this.init_pageobj_store_) {
                this.java_codes_.add(0, this.pageobj_init_code_store_);
            }
            if (this.init_pageobj_list_) {
                this.java_codes_.add(0, this.pageobj_init_code_list_);
            }
            if (this.init_pageobj_updatelist_) {
                this.java_codes_.add(0, this.pageobj_init_code_updatelist_);
            }
            if (this.init_pageobj_condition_) {
                this.java_codes_.add(0, this.pageobj_init_code_condition_);
            }
        }
        return this.java_codes_.toArray(new String[0]);
    }

    public String toString() {
        StringJoiner buf = new StringJoiner("\n");
        if (this.orig_statement_line_ != null) {
            buf.add("//" + this.orig_statement_line_);
        }
        for (String code : this.java_codes_) {
            buf.add(code);
        }
        return buf.toString();
    }

    private ArrayList<String> translate(String actionName, String[] variables) throws InvalidTestConfigException {
        if (actionName == null || actionName.trim().length() < 1) {
            throw new InvalidTestConfigException("Action name is empty.");
        }
        this.require_pageobj_ = false;
        Action action = null;
        String comment = null;
        if (actionName.startsWith(this.command.get("LOGON"))) {
            action = new LogonAction();
        } else if (actionName.equals(this.command.get("LOGOFF"))) {
            action = new LogoffAction();
        } else if (actionName.equals(this.command.get("FONTSIZE"))) {
            action = new FontSizeAction();
        } else if (actionName.equals(this.command.get("WINDOWSIZE"))) {
            action = new WindowSizeAction();
        } else if (actionName.startsWith(this.command.get("PAGETITLE"))) {
            action = new PageTitleAction();
        } else if (actionName.equals(this.command.get("TITLEPANE"))) {
            action = new TitlePaneAction();
        } else if (actionName.startsWith(this.command.get("TITLE"))) {
            action = new TitleAction();
        } else if (actionName.startsWith(this.command.get("ERRORMSG")) || actionName.startsWith(this.command.get("WARNMSG")) || actionName.startsWith(this.command.get("INFOMSG"))) {
            action = new MessageAction();
        } else if (actionName.equals(this.command.get("MENU"))) {
            action = new MenuAction();
        } else if (actionName.equals(this.command.get("SUBMENU"))) {
            action = new SubMenuAction();
        } else if (actionName.equals(this.command.get("SCREEN"))) {
            action = new DisplayAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("NEWOBJ"))) {
            this.require_pageobj_ = true;
            action = new CreateInstanceAction(this.testModelMap_, this.localVariableMap_);
        } else if (actionName.equals(this.command.get("NEWOBJCOND"))) {
            if (this.targetPageObj_injected == null) {
                this.require_pageobj_ = true;
                this.init_pageobj_condition_ = true;
                action = new CreateCondInstanceAction(this.testModelMap_, this.localVariableMap_);
            } else {
                action = !this.init_pageobj_condition_ ? new CreateCondInstanceAction(this.testModelMap_, this.localVariableMap_, true) : new EmptyAction(this.testModelMap_);
            }
        } else if (actionName.equals(this.command.get("CLICKLIST"))) {
            action = new ClickListAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("BUTTON")) || actionName.equals(this.command.get("BUTTON!"))) {
            action = new ButtonAction(this.testModelMap_);
            if (this.targetPageObj_injected != null) {
                ((ButtonAction)action).setTargetModel(this.targetPageObj_injected);
            }
        } else if (actionName.equals(this.command.get("?BUTTON"))) {
            action = this.targetPageObj_injected == null && latestCommand != null && latestCommand.equals(this.command.get("SCREEN_SEARCH")) || this.targetPageObj_injected != null && this.targetPageObj_injected instanceof ConditionTModel ? new IsExistButtonCondAction(this.testModelMap_, this.localVariableMap_) : new IsExistButtonAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("-BUTTON"))) {
            action = this.targetPageObj_injected == null && latestCommand != null && latestCommand.equals(this.command.get("SCREEN_SEARCH")) || this.targetPageObj_injected != null && this.targetPageObj_injected instanceof ConditionTModel ? new IsNotExistButtonCondAction(this.testModelMap_, this.localVariableMap_) : new IsNotExistButtonAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("+BUTTON")) || actionName.equals(this.command.get("~BUTTON"))) {
            action = new IsClickableButtonAction();
        } else if (actionName.equals(this.command.get("INPUT"))) {
            this.require_pageobj_ = true;
            String param = variables.length > 0 ? variables[0].trim() : null;
            String[] tokens = param.split("\\.");
            action = tokens != null && tokens.length == 2 && tokens[0].indexOf("[") > 0 && tokens[0].endsWith("]") ? new UpdateListInputAction(this.testModelMap_) : new InputAction(this.testModelMap_);
        } else if (actionName.startsWith(this.command.get("VERIFY"))) {
            this.require_pageobj_ = true;
            action = this.targetPageObj_injected == null && latestCommand != null && latestCommand.equals(this.command.get("SCREEN_SEARCH")) || this.targetPageObj_injected != null && this.targetPageObj_injected instanceof ConditionTModel ? new VerifyCondAction(this.testModelMap_, this.localVariableMap_) : new VerifyAction(this.testModelMap_);
        } else if (actionName.startsWith(this.command.get("VERIFYOPTION"))) {
            this.require_pageobj_ = true;
            action = this.targetPageObj_injected == null && latestCommand != null && latestCommand.equals(this.command.get("SCREEN_SEARCH")) || this.targetPageObj_injected != null && this.targetPageObj_injected instanceof ConditionTModel ? new VerifyCondOptionAction(this.testModelMap_, this.localVariableMap_) : new VerifyOptionAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("VERIFYSIZE"))) {
            this.require_pageobj_ = true;
            action = new VerifySizeAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("CONDITION"))) {
            this.require_pageobj_ = true;
            action = new InputConditionAction(this.testModelMap_, this.localVariableMap_);
        } else if (actionName.equals(this.command.get("SEARCHRESULT"))) {
            action = new ResultCountAction();
        } else if (actionName.startsWith(this.command.get("VERIFYLIST")) || actionName.startsWith(this.command.get("VERIFYLISTSIZE"))) {
            this.require_pageobj_ = true;
            action = new VerifyListAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("ISEXISTINPUT")) || actionName.equals(this.command.get("ISEXISTOUTPUT"))) {
            this.require_pageobj_ = true;
            action = this.targetPageObj_injected == null && latestCommand != null && latestCommand.equals(this.command.get("SCREEN_SEARCH")) || this.targetPageObj_injected != null && this.targetPageObj_injected instanceof ConditionTModel ? new BeCondAction(this.testModelMap_, this.localVariableMap_) : new BeAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("ISNOTEXISTINPUT")) || actionName.equals(this.command.get("ISNOTEXISTOUTPUT"))) {
            this.require_pageobj_ = true;
            action = this.targetPageObj_injected == null && latestCommand != null && latestCommand.equals(this.command.get("SCREEN_SEARCH")) || this.targetPageObj_injected != null && this.targetPageObj_injected instanceof ConditionTModel ? new NotBeCondAction(this.testModelMap_, this.localVariableMap_) : new NotBeAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("ISHIDDEN"))) {
            this.require_pageobj_ = true;
            action = this.targetPageObj_injected == null && latestCommand != null && latestCommand.equals(this.command.get("SCREEN_SEARCH")) || this.targetPageObj_injected != null && this.targetPageObj_injected instanceof ConditionTModel ? new IsHiddenCondAction(this.testModelMap_, this.localVariableMap_) : new IsHiddenAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("INPUTENABLE")) || actionName.equals(this.command.get("INPUTDISABLE"))) {
            this.require_pageobj_ = true;
            action = new EnableAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("PAGINATION"))) {
            action = new PaginationAction(this.testModelMap_);
            if (this.targetPageObj_injected != null) {
                ((PaginationAction)action).setTargetModel(this.targetPageObj_injected);
            }
        } else if (actionName.equals(this.command.get("?PAGINATION"))) {
            action = new IsExistPaginationAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("-PAGINATION"))) {
            action = new IsNotExistPaginationAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("+PAGINATION"))) {
            action = new IsLinkEnabledPaginationAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("~PAGINATION"))) {
            action = new IsLinkDisabledPaginationAction(this.testModelMap_);
        } else if (actionName.equals(this.command.get("UPLOAD")) || actionName.equals(this.command.get("DOWNLOAD"))) {
            this.require_pageobj_ = true;
            action = new FileAction(this.testModelMap_);
        } else if (actionName.startsWith(this.command.get("WORKFLOW"))) {
            action = new WorkFlowAction();
        } else if (actionName.equals(this.command.get("IMPORT")) || actionName.equals(this.command.get("EXPORT"))) {
            action = new ImpExpAction();
        } else if (actionName.equals(this.command.get("SCREENSHOT"))) {
            action = new ScreenShotAction();
        } else if (actionName.equals(this.command.get("FOCUSOUT"))) {
            action = new DirectCode("pageTitle().click();");
        } else if (actionName.equals(this.command.get("FOCUSMAIN"))) {
            action = new DirectCode("WebElementUtils.focusMainWindow();");
        } else if (actionName.equals(this.command.get("SCROLL_UP")) || actionName.equals(this.command.get("SCROLL_DOWN"))) {
            action = new ScrollAction(this.testModelMap_);
        } else {
            throw new InvalidTestConfigException("Test action [" + actionName + "] is not valid action.");
        }
        ArrayList<String> codes = ((Action)action).toCode(actionName, variables);
        if (action instanceof DisplayAction) {
            latestCommand = ((DisplayAction)action).getCommand();
        }
        if (this.require_pageobj_) {
            Action ciAction;
            Action vAction;
            if (action instanceof InputAction) {
                InputAction iAction = (InputAction)action;
                this.targetPageObj_ = iAction.getTargetModel();
            } else if (action instanceof VerifyAction) {
                vAction = (VerifyAction)action;
                this.targetPageObj_ = ((VerifyAction)vAction).getTargetModel();
            } else if (action instanceof VerifyCondAction) {
                vAction = (VerifyCondAction)action;
                this.targetPageObj_ = ((VerifyCondAction)vAction).getTargetModel();
            } else if (action instanceof VerifyOptionAction) {
                VerifyOptionAction voAction = (VerifyOptionAction)action;
                this.targetPageObj_ = voAction.getTargetModel();
            } else if (action instanceof VerifyCondOptionAction) {
                VerifyCondOptionAction vocAction = (VerifyCondOptionAction)action;
                this.targetPageObj_ = vocAction.getTargetModel();
            } else if (action instanceof InputConditionAction) {
                InputConditionAction icAction = (InputConditionAction)action;
                this.targetPageObj_ = icAction.getTargetModel();
            } else if (action instanceof VerifyListAction) {
                VerifyListAction vlAction = (VerifyListAction)action;
                this.targetPageObj_ = vlAction.getTargetModel();
            } else if (action instanceof UpdateListInputAction) {
                UpdateListInputAction uliAction = (UpdateListInputAction)action;
                this.targetPageObj_ = uliAction.getTargetModel();
            } else if (action instanceof CreateInstanceAction) {
                ciAction = (CreateInstanceAction)action;
                this.targetPageObj_ = ((CreateInstanceAction)ciAction).getTargetModel();
            } else if (action instanceof CreateCondInstanceAction) {
                ciAction = (CreateCondInstanceAction)action;
                this.targetPageObj_ = ((CreateCondInstanceAction)ciAction).getTargetModel();
            }
        }
        if (comment != null) {
            codes.add("//// " + comment);
        }
        return codes;
    }

    public String getStatusMessage() {
        if (!this.isOutputStatus_ || this.orig_statement_line_ == null) {
            return null;
        }
        return String.format("System.out.println(\"%s\");", this.orig_statement_line_.replaceAll("\"", "\\\\\\\""));
    }
}

