/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import jp.jasminesoft.jfc.test.support.testmodel.model.Attribute;
import jp.jasminesoft.jfc.test.support.testmodel.model.StoreTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.Command;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestEnvironment;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class Action {
    private TestEnvironment env_ = TestEnvironment.getInstance();
    protected Command command = Command.getInstance();

    public abstract ArrayList<String> toCode(String var1, String[] var2) throws InvalidTestConfigException;

    protected boolean useCheckNoErrors(String actionName) {
        return !actionName.endsWith("!");
    }

    protected String matchPattern(String actionName) {
        String matchPattern = "";
        if (actionName.endsWith("??")) {
            matchPattern = "partial";
        } else if (actionName.endsWith("?")) {
            matchPattern = "exact";
        }
        return matchPattern;
    }

    protected String[] parseVariable(String[] array) {
        ArrayList<String> rlist = new ArrayList<String>();
        rlist.add(array[0]);
        boolean collectMode = false;
        StringBuilder buf = null;
        for (int i = 1; i < array.length; ++i) {
            String v = array[i];
            if (v.equals("{")) {
                collectMode = true;
                buf = new StringBuilder();
                continue;
            }
            if (v.equals("}") && collectMode) {
                collectMode = false;
                rlist.add("{" + buf.toString() + "}");
                continue;
            }
            if (collectMode) {
                buf.append(v);
                continue;
            }
            rlist.add(v);
        }
        return rlist.toArray(new String[0]);
    }

    protected String getProperValue(String[] arrays) {
        String value = "";
        if (arrays.length == 2) {
            value = this.getProperValue(arrays[1]);
        } else if (arrays.length > 2) {
            StringJoiner buf = new StringJoiner(", ");
            Arrays.stream(ArrayUtils.remove((Object[])arrays, (int)0)).forEach(v -> buf.add(this.getProperValue((String)v)));
            value = buf.toString();
        }
        return value;
    }

    protected String getProperValue(String s) {
        return this.getProperValue0(s, "\"");
    }

    protected String getProperValueWithoutQuot(String s) {
        return this.getProperValue0(s, "");
    }

    private String getProperValue0(String s, String quot) {
        if (s == null || s.length() == 0) {
            if ("\"".equals(quot)) {
                return "\"\"";
            }
            return "";
        }
        if ((s = StringUtil.removePreAndPostWhitespaceWithoutInside((String)s)).charAt(0) == '{' && s.charAt(s.length() - 1) == '}') {
            return StringUtil.removePreAndPostWhitespaceWithoutInside((String)s.substring(1, s.length() - 1));
        }
        if (s.charAt(0) == '&') {
            return StringUtils.defaultString((String)this.env_.getDefinedString(s.substring(1)), (String)"");
        }
        return quot + s + quot;
    }

    class TargetModel {
        StoreTModel storeModel;
        Attribute attr;
        String modelJp;
        String containerJp;
        String attrJp;
        int index = -1;
        boolean isMultiple;
        boolean isContainer;
        String className;
        String instanceName;
        String containerName;
        String attributeName = "";
        String attributeJavaType = "";
        private final String CR = System.getProperty("line.separator");

        TargetModel(String model_attr, Map<String, Map<String, TModel>> testModelMap) throws InvalidTestConfigException {
            String cnt;
            Object suffix;
            int ptr;
            String[] tokens = model_attr.split("\\.");
            if (tokens == null || tokens.length < 1) {
                throw new InvalidTestConfigException("illegal parameter," + model_attr);
            }
            this.modelJp = tokens[0];
            if (tokens.length == 2) {
                this.attrJp = tokens[1];
                ptr = this.attrJp.indexOf("[");
                if (ptr > 0) {
                    suffix = this.attrJp.substring(ptr + 1);
                    this.attrJp = this.attrJp.substring(0, ptr);
                    ptr = ((String)suffix).indexOf("]");
                    if (ptr > 0) {
                        cnt = ((String)suffix).substring(0, ptr);
                        this.index = NumberUtils.toInt((String)cnt);
                    }
                }
            } else if (tokens.length > 2) {
                this.containerJp = tokens[1];
                ptr = this.containerJp.indexOf("[");
                if (ptr > 0) {
                    suffix = this.containerJp.substring(ptr + 1);
                    this.containerJp = this.containerJp.substring(0, ptr);
                    ptr = ((String)suffix).indexOf("]");
                    if (ptr > 0) {
                        cnt = ((String)suffix).substring(0, ptr);
                        this.index = NumberUtils.toInt((String)cnt);
                    }
                }
                this.attrJp = tokens[2];
            }
            Map<String, TModel> storeModelMap = testModelMap.get("store");
            this.storeModel = (StoreTModel)storeModelMap.get(this.modelJp);
            if (this.storeModel == null) {
                throw new InvalidTestConfigException("NO MODEL " + this.modelJp);
            }
            this.className = this.storeModel.getClassName();
            this.instanceName = this.className.toLowerCase();
            if (this.attrJp != null) {
                for (Attribute attr : this.storeModel.getAttributes()) {
                    if (this.attrJp.equals(attr.getLabel())) {
                        this.attr = attr;
                        this.attributeName = this.attr.getName();
                        this.attributeJavaType = this.attr.getJavaDataType();
                        if (this.attr.isMultipleDef()) {
                            this.isMultiple = true;
                            break;
                        }
                        if (!this.attr.isContainerClassDef()) break;
                        this.isContainer = true;
                        break;
                    }
                    if (this.containerJp == null || !this.containerJp.equals(attr.getLabel())) continue;
                    this.attr = attr;
                    this.containerName = attr.getName();
                    this.isContainer = true;
                    break;
                }
            }
            if (this.containerName != null) {
                List<Map<String, Object>> childAttrsList = this.storeModel.getChildClasses();
                block1: for (Map<String, Object> map : childAttrsList) {
                    List list;
                    if (!this.containerName.equals(map.get("id")) || (list = (List)map.get("attributes")) == null || list.size() <= 0) continue;
                    for (Attribute attr : list) {
                        if (!this.attrJp.equals(attr.getLabel())) continue;
                        this.attr = attr;
                        this.attributeName = this.attr.getName();
                        this.attributeJavaType = this.attr.getJavaDataType();
                        break block1;
                    }
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("modelJp=").append(this.modelJp).append(this.CR);
            if (this.attrJp != null) {
                sb.append("attrJp =").append(this.containerJp != null ? this.containerJp + "." : "").append(this.attrJp).append(this.CR);
                for (Attribute attr : this.storeModel.getAttributes()) {
                    sb.append("attr   =").append(attr).append(this.CR);
                }
            }
            sb.append("className=").append(this.className).append(this.CR);
            sb.append("instanceName=").append(this.instanceName).append(this.CR);
            if (this.containerName != null) {
                sb.append("containerName=").append(this.containerName).append(this.CR);
            }
            if (this.attributeName != null) {
                sb.append("attributeName=" + this.attributeName).append(this.CR);
            }
            if (this.attributeJavaType != null) {
                sb.append("attributeJavaType=" + this.attributeJavaType).append(this.CR);
            }
            if (this.index >= 0) {
                sb.append("index  =").append(this.index).append(this.CR);
            }
            if (this.isMultiple) {
                sb.append("isMultiple=true").append(this.CR);
            }
            if (this.isContainer) {
                sb.append("isContainer=true").append(this.CR);
            }
            return sb.toString();
        }
    }
}

