/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.test.support.testmodel.model.Attribute;
import jp.jasminesoft.jfc.test.support.testmodel.model.ConditionTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class InputConditionAction
extends Action {
    protected Map<String, Map<String, TModel>> testModelMap_;
    private Map<String, String> localVariableMap_;
    private ConditionTModel conditionModel_;

    public InputConditionAction(Map<String, Map<String, TModel>> testModelMap, Map<String, String> localVariableMap) {
        this.testModelMap_ = testModelMap;
        this.localVariableMap_ = localVariableMap;
    }

    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        ArrayList<String> list = new ArrayList<String>();
        if (variables == null || variables.length < 2) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 2 variables.");
        }
        String model_attr = variables[0];
        String[] tokens = model_attr.split("\\.");
        if (tokens == null || tokens.length < 2) {
            throw new InvalidTestConfigException("illegal parameter," + model_attr);
        }
        String modelJp = tokens[0];
        String attrJp = tokens[1];
        String attributeName = "";
        String attributeJavaType = "";
        Map<String, TModel> conditionModelMap = this.testModelMap_.get("condition");
        ConditionTModel conditionModel = (ConditionTModel)conditionModelMap.get(modelJp);
        if (conditionModel == null) {
            throw new InvalidTestConfigException("NO MODEL " + modelJp);
        }
        this.conditionModel_ = conditionModel;
        for (Attribute attr : conditionModel.getAttributes()) {
            if (!attrJp.equals(attr.getLabel())) continue;
            attributeName = attr.getName();
            attributeJavaType = attr.getJavaDataType();
            break;
        }
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new InvalidTestConfigException("No target attribute " + attrJp + " in model " + modelJp);
        }
        String instanceName = this.localVariableMap_.get(modelJp);
        if (StringUtils.isBlank((CharSequence)instanceName)) {
            instanceName = "condition";
        }
        String method = "val";
        variables = this.parseVariable(variables);
        if ("DateListBox".equals(attributeJavaType) && variables.length == 3 && "#YEAR".equals(variables[2])) {
            method = "yearListBox().val";
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        } else if ("DateListBox".equals(attributeJavaType) && variables.length == 3 && "#MONTH".equals(variables[2])) {
            method = "monthListBox().val";
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        } else if ("DateListBox".equals(attributeJavaType) && variables.length == 3 && "#DAY".equals(variables[2])) {
            method = "dayListBox().val";
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        } else if (variables.length == 3 && ("#YEAR".equals(variables[2]) || "#MONTH".equals(variables[2]) || "#DAY".equals(variables[2]))) {
            variables = (String[])ArrayUtils.remove((Object[])variables, (int)2);
        }
        String value = this.getProperValue(variables);
        String code = String.format("%s.%s.%s(%s);", instanceName, attributeName, method, value);
        list.add(code);
        return list;
    }

    public ConditionTModel getTargetModel() {
        return this.conditionModel_;
    }
}

