/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.test.support.testmodel.model.StoreTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import org.springframework.util.StringUtils;

public class VerifyAction
extends Action {
    private Map<String, Map<String, TModel>> testModelMap_;
    private StoreTModel storeModel_;

    public VerifyAction(Map<String, Map<String, TModel>> testModelMap) {
        this.testModelMap_ = testModelMap;
    }

    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        ArrayList<String> list = new ArrayList<String>();
        if (variables == null || variables.length < 2) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 2 variables.");
        }
        String verifyCode = "shouldHave";
        if (actionName.endsWith("RO")) {
            verifyCode = "shouldBeReadOnly()." + verifyCode;
        }
        String model_attr = variables[0];
        Action.TargetModel target = new Action.TargetModel(model_attr, this.testModelMap_);
        this.storeModel_ = target.storeModel;
        if (this.storeModel_ == null) {
            throw new InvalidTestConfigException("No target model " + target.modelJp);
        }
        variables = this.parseVariable(variables);
        String value = this.getProperValue(variables[1]);
        if (StringUtils.isEmpty((Object)target.attributeName)) {
            throw new InvalidTestConfigException("No attribute " + target.attrJp);
        }
        String code = "";
        if (target.isContainer && target.index > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s.%s.get(%s).%s.%s(", target.instanceName, target.containerName, String.valueOf(target.index), target.attributeName, verifyCode));
            for (int i = 1; i < variables.length; ++i) {
                sb.append(this.getProperValue(variables[i]));
                if (i >= variables.length - 1) continue;
                sb.append(",");
            }
            sb.append(");");
            code = sb.toString();
        } else if (variables.length == 2) {
            code = target.instanceName + "." + target.attributeName + "." + verifyCode + "(" + value + ");";
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s.%s.%s(", target.instanceName, target.attributeName, verifyCode));
            for (int i = 1; i < variables.length; ++i) {
                sb.append(this.getProperValue(variables[i]));
                if (i >= variables.length - 1) continue;
                sb.append(",");
            }
            sb.append(");");
            code = sb.toString();
        }
        list.add(code);
        return list;
    }

    public StoreTModel getTargetModel() {
        return this.storeModel_;
    }
}

