/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.AttachmentFileMap;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessor;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessorImpl_Zip;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorManager;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.controller.DbUploadUpdateBaseController;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrormsg;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.error.Jfcwarn;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDbUploadUpdateRunnableMonitor
implements DbUploadUpdateRunnableMonitor,
Runnable {
    private static final Logger logger = LogManager.getLogger(AbstractDbUploadUpdateRunnableMonitor.class);
    protected String[] statusHeader;
    private int status = 0;
    private Date start_date = null;
    private Date end_date = null;
    private String actionstatus;
    protected int filerowcnt = 0;
    protected int totalrowcnt = 0;
    protected int insert_rowcnt = 0;
    protected int update_rowcnt = 0;
    protected int delete_rowcnt = 0;
    protected int failed_rowcnt = 0;
    protected DbUploadUpdateRunnableMonitorFileProcessor fileProcessor;
    protected AttachmentFileMap attachmentFileMap;
    private String username;
    protected ActionParameter p;

    public void init(ActionParameter p, File file, String filename) {
        this.p = p;
        this.statusHeader = new String[3];
        this.statusHeader[0] = JFCUtils.getRValue("__jfc_common.csvHeader.success", p.locale);
        this.statusHeader[1] = JFCUtils.getRValue("__jfc_common.csvHeader.process", p.locale);
        this.statusHeader[2] = JFCUtils.getRValue("__jfc_common.csvHeader.message", p.locale);
        if (!JFCUtils.waitUntilCanRead(file)) {
            logger.error("File " + file + " is can't read.");
        }
        this.fileProcessor = DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.isProcessFile(filename) ? new DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv() : (DbUploadUpdateRunnableMonitorFileProcessorImpl_Zip.isProcessFile(filename) ? new DbUploadUpdateRunnableMonitorFileProcessorImpl_Zip() : (DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.isProcessFile(filename) ? new DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls() : new DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv()));
        this.fileProcessor.setModelId(this.getModelId());
        this.fileProcessor.setBaseFile(file, filename);
        this.fileProcessor.setDbUploadUpdateRunnableMonitor(this);
        this.fileProcessor.setActionParameter(p);
        this.attachmentFileMap = new AttachmentFileMap(this);
        this.username = p != null && p.user != null ? p.user.getUsername() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        this.start_date = new Date();
        this.status = 3;
        logger.info(JFCUtils.logmsg(this.username, " start process."));
        this.processStart();
        while (this.status == 3 && this.hasNextFile()) {
            this.openFile();
            if (this.status != 3) break;
            this.processFile();
            if (this.status != 3) break;
            this.closeFile();
        }
        try {
            this.processEnd();
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00213), LogCodeManager.getMessage(LogCode.JFC00213, e.getMessage()));
            logger.debug((Object)e);
        }
        finally {
            this.setEndStatus();
            this.afterProcessEnd();
            DbUploadUpdateRunnableMonitorManager _instance = DbUploadUpdateRunnableMonitorManager.getInstance();
            _instance.endMonitor(this.getUsername(), this);
            logger.info(JFCUtils.logmsg(this.username, " end process. " + this.getStatusString() + " all:" + this.getProcessCount() + "/insert:" + this.getInsertProcessCount() + "/update:" + this.getUpdateProcessCount() + "/delete:" + this.getDeleteProcessCount() + "/failed:" + this.getFailedProcessCount()));
        }
        catch (Exception e) {
            try {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00212), LogCodeManager.getMessage(LogCode.JFC00212, e.getMessage()));
                if (logger.isDebugEnabled()) {
                    logger.debug("occur Exception", (Throwable)e);
                    e.printStackTrace();
                }
                this.processFailed(e);
            }
            catch (Throwable throwable) {
                try {
                    this.processEnd();
                }
                catch (Exception e2) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00213), LogCodeManager.getMessage(LogCode.JFC00213, e2.getMessage()));
                    logger.debug((Object)e2);
                }
                finally {
                    this.setEndStatus();
                    this.afterProcessEnd();
                    DbUploadUpdateRunnableMonitorManager _instance = DbUploadUpdateRunnableMonitorManager.getInstance();
                    _instance.endMonitor(this.getUsername(), this);
                    logger.info(JFCUtils.logmsg(this.username, " end process. " + this.getStatusString() + " all:" + this.getProcessCount() + "/insert:" + this.getInsertProcessCount() + "/update:" + this.getUpdateProcessCount() + "/delete:" + this.getDeleteProcessCount() + "/failed:" + this.getFailedProcessCount()));
                }
                throw throwable;
            }
            try {
                this.processEnd();
            }
            catch (Exception e3) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00213), LogCodeManager.getMessage(LogCode.JFC00213, e3.getMessage()));
                logger.debug((Object)e3);
            }
            finally {
                this.setEndStatus();
                this.afterProcessEnd();
                DbUploadUpdateRunnableMonitorManager _instance = DbUploadUpdateRunnableMonitorManager.getInstance();
                _instance.endMonitor(this.getUsername(), this);
                logger.info(JFCUtils.logmsg(this.username, " end process. " + this.getStatusString() + " all:" + this.getProcessCount() + "/insert:" + this.getInsertProcessCount() + "/update:" + this.getUpdateProcessCount() + "/delete:" + this.getDeleteProcessCount() + "/failed:" + this.getFailedProcessCount()));
            }
        }
    }

    public void setEndStatus() {
        this.end_date = new Date();
        this.status = this.status == 2 ? 4 : 1;
    }

    protected void processFile() throws IOException {
        long print_count_time = System.currentTimeMillis() + 60000L;
        while (this.status == 3) {
            IJfcjobstatus jobstatus;
            try {
                this.readData();
            }
            catch (EOFException e) {
                break;
            }
            long now_time = System.currentTimeMillis();
            if (print_count_time <= now_time) {
                logger.info(JFCUtils.logmsg(this.username, " processing. " + this.getStatusString() + " all:" + this.getProcessCount() + "/insert:" + this.getInsertProcessCount() + "/update:" + this.getUpdateProcessCount() + "/delete:" + this.getDeleteProcessCount() + "/failed:" + this.getFailedProcessCount()));
                print_count_time = now_time + 60000L;
            }
            if ((jobstatus = (IJfcjobstatus)this.p.request.getAttribute(IJfcjobstatus.class.getName())) == null) continue;
            jobstatus.setStatustype(IJfcjobstatus.Statustype.Processing.toString());
            jobstatus.setProgress(this.getProcessCount());
            jobstatus.setMaximum(this.getProcessCount());
            JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)this.p.appctx.getBean(JfcjobstatusRegistryService.class);
            service.addInfo(jobstatus, "insert", Integer.toString(this.getInsertProcessCount()));
            service.addInfo(jobstatus, "update", Integer.toString(this.getUpdateProcessCount()));
            service.addInfo(jobstatus, "delete", Integer.toString(this.getDeleteProcessCount()));
            service.addInfo(jobstatus, "failed", Integer.toString(this.getFailedProcessCount()));
            service.updateJfcjobstatusInterval(this.p, jobstatus);
        }
    }

    public void setSeparateCharacter(char c) {
        this.fileProcessor.setSeparateCharacter(c);
    }

    public void setEncoding(String s) {
        this.fileProcessor.setEncoding(s);
    }

    public String getEncoding() {
        return this.fileProcessor.getEncoding();
    }

    public String getNumberFormat() {
        return this.fileProcessor.getNumberFormat();
    }

    public void setNumberFormat(String s) {
        this.fileProcessor.setNumberFormat(s);
    }

    public String getYmdFormat() {
        return this.fileProcessor.getYmdFormat();
    }

    public void setYmdFormat(String ymdFormatStr) {
        this.fileProcessor.setYmdFormat(ymdFormatStr);
    }

    public String getHmsFormat() {
        return this.fileProcessor.getHmsFormat();
    }

    public void setHmsFormat(String hmsFormatStr) {
        this.fileProcessor.setHmsFormat(hmsFormatStr);
    }

    public String getYmdhmsFormat() {
        return this.fileProcessor.getYmdhmsFormat();
    }

    public void setYmdhmsFormat(String ymdhmsFormatStr) {
        this.fileProcessor.setYmdhmsFormat(ymdhmsFormatStr);
    }

    @Override
    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.status = 2;
    }

    @Override
    public boolean isStopped() {
        return this.status == 0 || this.status == 1 || this.status == 4;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getStatusString() {
        return DbUploadUpdateBaseController.getStatusString(this.status);
    }

    @Override
    public Date getStartDate() {
        if (this.start_date == null) {
            return new Date();
        }
        return new Date(this.start_date.getTime());
    }

    @Override
    public Date getEndDate() {
        if (this.end_date == null) {
            return new Date();
        }
        return new Date(this.end_date.getTime());
    }

    @Override
    public abstract String getUsername();

    public abstract String getModelId();

    @Override
    public int getProcessCount() {
        return this.getInsertProcessCount() + this.getUpdateProcessCount() + this.getDeleteProcessCount() + this.getFailedProcessCount();
    }

    @Override
    public int getFileProcessCount() {
        return this.filerowcnt;
    }

    @Override
    public int getInsertProcessCount() {
        return this.insert_rowcnt;
    }

    @Override
    public int getUpdateProcessCount() {
        return this.update_rowcnt;
    }

    @Override
    public int getDeleteProcessCount() {
        return this.delete_rowcnt;
    }

    @Override
    public int getFailedProcessCount() {
        return this.failed_rowcnt;
    }

    @Override
    public int getFileCount() {
        return this.fileProcessor.getFileCount();
    }

    @Override
    public boolean isProcessMultiFiles() {
        return this.fileProcessor.isProcessMultiFiles();
    }

    @Override
    public String getOpenFilename() {
        return this.fileProcessor.getOpenFilename();
    }

    @Override
    public List<String> getOpenFilenames() {
        return this.fileProcessor.getOpenFilenames();
    }

    @Override
    public abstract Jfcerrors getJfcerrors();

    @Override
    public abstract String getUploadFilename();

    @Override
    public abstract File getProcessFile();

    @Override
    public abstract File getErrorFile();

    protected void processStart() {
        String ret = new ScriptCodeRunner(this.getModelId()).process("UploadUpdate" + StringUtil.capFirst((String)this.getModelId()), "processStart", this.p);
        if (StringUtils.isNotBlank((CharSequence)ret)) {
            Jfcerror _error = new Jfcerror();
            _error.setContent(ret);
            this.p.errors.addJfcerror(_error);
            throw new ScriptCheckFailedException();
        }
        this.fileProcessor.processStart();
        this.attachmentFileMap.processStart();
        if (this.attachmentFileMap.checkFile(this.p, this.getModelId())) {
            throw new ScriptCheckFailedException();
        }
    }

    protected void processEnd() {
        this.attachmentFileMap.processEnd();
        this.fileProcessor.processEnd();
        String ret = new ScriptCodeRunner(this.getModelId()).process("UploadUpdate" + StringUtil.capFirst((String)this.getModelId()), "processEnd", this.p);
        if (StringUtils.isNotBlank((CharSequence)ret)) {
            Jfcerror _error = new Jfcerror();
            _error.setContent(ret);
            this.p.errors.addJfcerror(_error);
        }
    }

    protected void afterProcessEnd() {
        String ret = new ScriptCodeRunner(this.getModelId()).process("UploadUpdate" + StringUtil.capFirst((String)this.getModelId()), "afterProcessEnd", this.p);
        if (StringUtils.isNotBlank((CharSequence)ret)) {
            Jfcerror _error = new Jfcerror();
            _error.setContent(ret);
            this.p.errors.addJfcerror(_error);
        }
    }

    protected void processFailed(Exception e) {
        this.fileProcessor.processFailed(e);
    }

    protected boolean hasNextFile() {
        return this.fileProcessor.hasNextFile();
    }

    protected void openFile() throws IOException {
        this.fileProcessor.openFile();
    }

    protected void reopenFile() throws IOException {
        this.fileProcessor.reopenFile();
    }

    protected void closeFile() throws IOException {
        this.fileProcessor.closeFile();
    }

    protected void incrementProcessCount() {
        ++this.filerowcnt;
        ++this.totalrowcnt;
    }

    protected void decrementProcessCount() {
        --this.filerowcnt;
        --this.totalrowcnt;
    }

    protected void resetFileProcessCount() {
        this.filerowcnt = 0;
    }

    public void readHeader() throws IOException {
        if (new ScriptCodeRunner(this.getModelId()).isProcessable("UploadUpdate" + StringUtil.capFirst((String)this.getModelId()), "readHeader", this.p)) {
            this.readHeaderCallScript();
        } else {
            this.fileProcessor.readHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaderCallScript() throws IOException {
        String HEADER_KEY = "DbUploadUpdateRunnableMonitor_header";
        String[] origheader = this.fileProcessor.readHeaderBeforeScript();
        String[] header = new String[origheader.length];
        System.arraycopy(origheader, 0, header, 0, header.length);
        this.p.request.setAttribute("DbUploadUpdateRunnableMonitor_header", (Object)header);
        try {
            String ret = new ScriptCodeRunner(this.getModelId()).process("UploadUpdate" + StringUtil.capFirst((String)this.getModelId()), "readHeader", this.p);
            if (StringUtils.isNotBlank((CharSequence)ret)) {
                Jfcerror _error = new Jfcerror();
                _error.setContent(ret);
                this.p.errors.addJfcerror(_error);
                return;
            }
            String[] n_header = (String[])this.p.request.getAttribute("DbUploadUpdateRunnableMonitor_header");
            if (n_header != null && n_header.length > 0) {
                header = n_header;
            }
            boolean isUseHeaderRow = this.isUseHeaderRow(origheader, n_header);
            this.fileProcessor.setHeader(header, isUseHeaderRow);
            if (!isUseHeaderRow) {
                this.decrementProcessCount();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Csv data header " + header.length);
                for (String s : header) {
                    logger.debug(s);
                }
            }
        }
        finally {
            this.p.request.removeAttribute("DbUploadUpdateRunnableMonitor_header");
        }
    }

    private boolean isUseHeaderRow(String[] origheader, String[] n_header) {
        return n_header == null || Arrays.equals(n_header, origheader);
    }

    public String[] readRowData() throws IOException {
        return this.fileProcessor.readRowData();
    }

    public DbUploadUpdateRunnableMonitorFileProcessor.CellAttrs readRowDataWithAttr() throws IOException {
        return this.fileProcessor.readRowDataWithAttr();
    }

    public Set<String> getAttachmentFilenameSet() {
        Set<String> set = this.fileProcessor.getAttachmentFilenameSet();
        logger.info(JFCUtils.logmsg(this.username, " getAttachmentFilenameSet size=" + set.size()));
        logger.info(JFCUtils.logmsg(this.username, " getAttachmentFilenameSet fileProcessor.getClass()=" + this.fileProcessor.getClass()));
        for (String s : set) {
            logger.info(JFCUtils.logmsg(this.username, " getAttachmentFilenameSet=" + s));
        }
        return set;
    }

    public InputStream getAttachmentInputStream(String filename) throws IOException {
        return this.fileProcessor.getAttachmentInputStream(filename);
    }

    protected File getAttachmentFileParentDir() throws IOException {
        return null;
    }

    protected File getCurrentDir() {
        return null;
    }

    public abstract void readHeader(String[] var1, boolean var2) throws IOException;

    public abstract void readData() throws IOException;

    protected String getCsvDataStatusString(String[] data, String[] header, ActionParameter p) {
        int len = header.length;
        if (len > data.length) {
            len = data.length;
        }
        for (int i = 0; i < len; ++i) {
            String key = header[i];
            String content = data[i];
            if (key.length() == 0 || content.length() == 0 || !key.equalsIgnoreCase(JFCUtils.getRValue("__jfc_common.csvHeader.status", p.locale))) continue;
            return content;
        }
        return null;
    }

    protected CsvDataStatus getCsvDataStatus(String[] data, String[] header, ActionParameter p) throws IllegalStateException {
        String status = this.getCsvDataStatusString(data, header, p);
        if (status == null) {
            return CsvDataStatus.Auto;
        }
        if ((status = status.trim()).equals("")) {
            return CsvDataStatus.Auto;
        }
        if (status.equalsIgnoreCase("i")) {
            return CsvDataStatus.Insert;
        }
        if (status.equalsIgnoreCase("u")) {
            return CsvDataStatus.Update;
        }
        if (status.equalsIgnoreCase("d")) {
            return CsvDataStatus.Delete;
        }
        if (status.equalsIgnoreCase("n")) {
            return CsvDataStatus.None;
        }
        throw new IllegalStateException(status);
    }

    protected String[] getStatusData(CsvDataStatus datastatus, ActionParameter p) {
        Jfcerror[] errormsgs = p.errors.getJfcerror();
        String[] statusdata = new String[3];
        statusdata[0] = errormsgs.length > 0 ? "Error" : "Success";
        if (datastatus == null) {
            statusdata[1] = "Unknown";
        } else {
            switch (datastatus) {
                case Auto: {
                    statusdata[1] = "Auto";
                    break;
                }
                case Insert: {
                    statusdata[1] = "Insert";
                    break;
                }
                case Update: {
                    statusdata[1] = "Update";
                    break;
                }
                case Delete: {
                    statusdata[1] = "Delete";
                    break;
                }
                case None: {
                    statusdata[1] = "None";
                    break;
                }
                default: {
                    statusdata[1] = "Unknown";
                }
            }
        }
        StringBuilder errmsg = new StringBuilder();
        for (Jfcerrormsg msg : this.getStatusJfcerrormsg(p.errors)) {
            String content = this.getStatusContent(msg);
            if (errmsg.length() == 0) {
                errmsg.append(content);
                continue;
            }
            errmsg.append("\n");
            errmsg.append(content);
        }
        statusdata[2] = errmsg.toString();
        return statusdata;
    }

    protected List<Jfcerrormsg> getStatusJfcerrormsg(Jfcerrors errors) {
        ArrayList<Jfcerrormsg> msglist = new ArrayList<Jfcerrormsg>(Arrays.asList(this.p.errors.getJfcerror()));
        msglist.addAll(Arrays.asList(this.p.errors.getJfcwarn()));
        return msglist;
    }

    protected String getStatusContent(Jfcerrormsg msg) {
        String header = msg instanceof Jfcerror ? JFCUtils.getRValue("__jfc_common.uploadupdate.statusheader.error", this.p.locale) : (msg instanceof Jfcwarn ? JFCUtils.getRValue("__jfc_common.uploadupdate.statusheader.warn", this.p.locale) : "UNKNOWN ");
        return header + msg.getContent();
    }

    protected LockObject addLockObject(ActionParameter p, JFCErrorManager errorManager, String modelname, Object primarykey, String sessionid) {
        if (modelname == null || primarykey == null || sessionid == null) {
            p.errors.addJfcerror(errorManager.getJfcerror("error.model.invalid", p.locale));
            logger.debug("modelname or primarykey is null");
            return null;
        }
        LockManager lman = LockManagerFactory.getLockManager(p);
        LockObject lo = lman.createLockObject(modelname, primarykey, sessionid, p);
        logger.debug("lo is " + lo);
        LockObject _lo = lman.addLockObject(lo);
        if (_lo == null) {
            logger.debug(lo + " LockManager locks the object successfully.");
            return lo;
        }
        if (_lo.equals(lo)) {
            logger.debug(lo + " LockManager has already locked the same key.");
            return lo;
        }
        logger.debug("_lo (locked object) is " + _lo);
        Object[] ep = new Object[]{_lo.getUsername()};
        p.errors.addJfcerror(errorManager.getJfcerror("error.dbaccess.lock", ep, p.locale));
        return null;
    }

    protected boolean isAllEmptyStringArray(String[] sa) {
        for (String s : sa) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExistsEmptyStringArray(String[] sa) {
        for (String s : sa) {
            if (!StringUtils.isBlank((CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setActionStatus(String s) {
        this.actionstatus = s;
    }

    @Override
    public String getActionStatus() {
        return this.actionstatus;
    }

    protected static enum CsvDataStatus {
        Auto,
        Insert,
        Update,
        Delete,
        None;

    }

    public static class ScriptCheckFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

