/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessor;
import jp.jasminesoft.jfc.EmptyHttpServletRequest;
import jp.jasminesoft.jfc.JFCAppMode;
import jp.jasminesoft.jfc.JFCAppModeManager;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCHelperUtils;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.ModelitemCsvPkey;
import jp.jasminesoft.jfc.ModelitemCsvRowList;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.CacheManagerBaseMethodImpl_threadLocal;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.UploadUpdateCSVHelper;
import jp.jasminesoft.jfc.app.UploadUpdateModelitemCSVHelper;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrormsg;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.error.Jfcwarn;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.jfc.service.LogonService;
import jp.jasminesoft.util.CSVUtil;
import jp.jasminesoft.util.IllegalCsvFormatException;
import jp.jasminesoft.util.IntegerRange;
import jp.jasminesoft.util.MultiPartForm;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

public abstract class AbstractDbUploadUpdateRunnableMonitor2
extends AbstractDbUploadUpdateRunnableMonitor {
    private static final Logger logger = LogManager.getLogger(AbstractDbUploadUpdateRunnableMonitor2.class);
    protected static final int ERROR_MESSAGE_COUNT_LIMIT = 100;
    protected char processFileSeparateChar;
    protected MultiPartForm multi;
    protected LockObject lockobject;
    protected boolean isLockData;
    protected long lastaccesstime;
    protected JFCErrorManager errorManager;
    protected Jfcerrors errors;
    protected LinkedHashMap<String, FilenameMessage> filenameMessageMap = new LinkedHashMap();
    protected String[] header;
    protected AbstractDbUploadUpdateRunnableMonitor.CsvDataStatus datastatus;
    protected String[] data;
    protected DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] cellattr;
    protected String uploadFilename;
    protected File processFile;
    protected File errorFile;
    protected PrintWriter processWriter;
    protected PrintWriter errorWriter;
    protected boolean[] headerValid;
    protected boolean isCreateUserObject = false;
    protected HttpServletRequest originalRequest;
    protected Map<String, Object> originalAppMap;
    protected Map<String, Object> originalPageMap;
    protected List<Integer> pkeyHeaderCount;
    protected boolean isModelitemCsv;
    protected boolean isDeleteProcessFiles = true;
    protected boolean isUploadUpdateJob = false;
    protected Map<ModelitemCsvPkey, ModelitemCsvRowList> modelitemCsvMap;
    private static final String ROW_ERROR_MESSAGE_LIMITOVER_RKEY = "error.uploadUpdateProcessBean.row_error_message_limitover";
    private static final String ROW_WARN_MESSAGE_LIMITOVER_RKEY = "warn.uploadUpdateProcessBean.row_warn_message_limitover";

    public void init(ActionParameter dp, File file, MultiPartForm multi2, LockObject lockobject2, long lastaccesstime2) {
        String uploadfilename = multi2 != null ? multi2.getSrcFilename("file") : file.getName();
        this.init(dp, file, uploadfilename, multi2, lockobject2, lastaccesstime2);
    }

    public void init(ActionParameter dp, File file, String uploadfilename, MultiPartForm multi2, LockObject lockobject2, long lastaccesstime2) {
        this.init(dp, file, uploadfilename);
        this.multi = multi2;
        this.lockobject = lockobject2;
        this.lastaccesstime = lastaccesstime2;
        this.errorManager = (JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class);
        this.errors = new Jfcerrors();
        this.setUploadFilename(uploadfilename);
        dp.request.setAttribute("__jfc_uploadupdate_filepath", (Object)file);
        JFCAppModeManager appmodeManager = (JFCAppModeManager)this.p.appctx.getBean(JFCAppModeManager.class);
        if (appmodeManager.getMode() == JFCAppMode.LimitBackgroundProcessStart) {
            Object[] ep = new Object[]{this.getUsername()};
            this.errors.addJfcerror(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.limitBackgroundProcessStart", ep, this.p.locale));
        }
    }

    public boolean isUploadUpdateJob() {
        return this.isUploadUpdateJob;
    }

    public void setUploadUpdateJob(boolean isUploadUpdateJob) {
        this.isUploadUpdateJob = isUploadUpdateJob;
    }

    public void setProcessFileSeparateCharacter(char c) {
        this.processFileSeparateChar = c;
    }

    public void setLockData(boolean isLockData1) {
        this.isLockData = isLockData1;
    }

    public void setDeleteProcessFiles(boolean isDeleteProcessFiles) {
        this.isDeleteProcessFiles = isDeleteProcessFiles;
    }

    public boolean isDeleteProcessFiles() {
        return this.isDeleteProcessFiles;
    }

    @Override
    public String getUsername() {
        if (this.p.user == null) {
            return "";
        }
        return this.p.user.getUsername();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Jfcerrors getJfcerrors() {
        Jfcerrors errors1 = new Jfcerrors();
        errors1.addJfcerror(this.errors.getJfcerror());
        errors1.addJfcwarn(this.errors.getJfcwarn());
        errors1.addJfcinfo(this.errors.getJfcinfo());
        if (this.isStopped()) {
            errors1.addJfcerror(this.p.errors.getJfcerror());
            errors1.addJfcwarn(this.p.errors.getJfcwarn());
            errors1.addJfcinfo(this.p.errors.getJfcinfo());
        }
        LinkedHashMap<String, FilenameMessage> linkedHashMap = this.filenameMessageMap;
        synchronized (linkedHashMap) {
            for (String filename : this.filenameMessageMap.keySet()) {
                FilenameMessage filenameMessage = this.filenameMessageMap.get(filename);
                this.setJfcerrors(errors1, filename, filenameMessage);
            }
        }
        return errors1;
    }

    protected void setJfcerrors(Jfcerrors errors1, String filename, FilenameMessage filenameMessage) {
        this.setJfcerror(errors1, filename, filenameMessage.getErrormsgMap());
        this.setJfcwarn(errors1, filename, filenameMessage.getWarnmsgMap());
    }

    private void setJfcerror(Jfcerrors errors1, String filename, Map<String, IntegerRange> errormsgMap) {
        for (Map.Entry<String, IntegerRange> e : errormsgMap.entrySet()) {
            Jfcerror jfcerror;
            Object[] ep;
            String msg = e.getKey();
            IntegerRange rowcntrange = e.getValue();
            if (this.isProcessMultiFiles()) {
                ep = new Object[]{rowcntrange.toString(), "", filename};
                jfcerror = this.errorManager.getJfcerror("error.uploadUpdateProcessBean.multifile_row_error_message", ep, this.p.locale);
                jfcerror.setContent(jfcerror.getContent() + msg);
                errors1.addJfcerror(jfcerror);
                continue;
            }
            ep = new Object[]{rowcntrange.toString(), ""};
            jfcerror = this.errorManager.getJfcerror("error.uploadUpdateProcessBean.row_error_message", ep, this.p.locale);
            jfcerror.setContent(jfcerror.getContent() + msg);
            errors1.addJfcerror(jfcerror);
        }
    }

    private void setJfcwarn(Jfcerrors errors1, String filename, Map<String, IntegerRange> warnmsgMap) {
        for (Map.Entry<String, IntegerRange> e : warnmsgMap.entrySet()) {
            Jfcwarn jfcerror;
            Object[] ep;
            String msg = e.getKey();
            IntegerRange rowcntrange = e.getValue();
            if (this.isProcessMultiFiles()) {
                ep = new Object[]{rowcntrange.toString(), "", filename};
                jfcerror = this.errorManager.getJfcwarn("error.uploadUpdateProcessBean.multifile_row_error_message", ep, this.p.locale);
                jfcerror.setContent(jfcerror.getContent() + msg);
                errors1.addJfcwarn(jfcerror);
                continue;
            }
            ep = new Object[]{rowcntrange.toString(), ""};
            jfcerror = this.errorManager.getJfcwarn("error.uploadUpdateProcessBean.row_error_message", ep, this.p.locale);
            jfcerror.setContent(jfcerror.getContent() + msg);
            errors1.addJfcwarn(jfcerror);
        }
    }

    @Override
    public String getUploadFilename() {
        return this.uploadFilename;
    }

    public void setUploadFilename(String filename) {
        this.uploadFilename = filename;
        this.p.request.setAttribute("__jfc_uploadupdate_filename", (Object)filename);
        logger.info("uploadfilename=" + filename);
    }

    @Override
    public File getProcessFile() {
        if (this.processWriter != null) {
            return null;
        }
        return this.processFile;
    }

    @Override
    public File getErrorFile() {
        if (this.errorWriter != null) {
            return null;
        }
        return this.errorFile;
    }

    protected abstract UploadUpdateCSVHelper getUploadUpdateCSVHelper();

    protected abstract File createTempProcessFile() throws IOException;

    protected abstract File createTempErrorProcessFile() throws IOException;

    protected boolean getCheckPrimaryKey() {
        return true;
    }

    protected boolean getCheckNothingValidHeader() {
        return true;
    }

    @Override
    protected void processStart() {
        ActionParameterContainer con = (ActionParameterContainer)this.p.appctx.getBean("ActionParameterContainer", ActionParameterContainer.class);
        con.set(this.p);
        if (!this.isUploadUpdateJob()) {
            this.p.user = this.logon(this.p.appctx, this.p.user.getUsername());
            this.isCreateUserObject = true;
            JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)this.p.appctx.getBean(JfcjobstatusRegistryService.class);
            boolean ignoreSaveJfcjobstatus = service.getIgnoreSaveJfcjobstatus();
            if (!ignoreSaveJfcjobstatus) {
                EntityHelper jfcjobstatusEntityHelper = (EntityHelper)this.p.appctx.getBean("JfcjobstatusHelper", EntityHelper.class);
                IJfcjobstatus jobstatus = (IJfcjobstatus)((Object)jfcjobstatusEntityHelper.initialize(this.p));
                jobstatus.setExectype(IJfcjobstatus.Exectype.Thread.toString());
                jobstatus.setJobname(this.getClass().getSimpleName());
                jobstatus.setUsername(this.p.user.getUsername());
                service.insertJfcjobstatus(this.p, jobstatus);
                this.p.request.setAttribute(IJfcjobstatus.class.getName(), (Object)jobstatus);
            }
        }
        try {
            this.processFile = this.createTempProcessFile();
            this.processWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.processFile), this.getProcessFileCsvEncoding()));
            this.errorFile = this.createTempErrorProcessFile();
            this.errorWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.errorFile), this.getProcessFileCsvEncoding()));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create process file", e);
        }
        super.processStart();
    }

    protected User logon(ApplicationContext appctx, String username) {
        if (!StringUtils.isNotBlank((CharSequence)username)) {
            logger.error("username is blank");
            return null;
        }
        LogonService logonService = (LogonService)appctx.getBean("logonService", LogonService.class);
        JFCErrorManager errorManager = (JFCErrorManager)appctx.getBean(JFCErrorManager.class);
        logonService.setJFCErrorManager(errorManager);
        JfcConfig jfcConfig = (JfcConfig)appctx.getBean(JfcConfig.class);
        logonService.setJFCConfig(jfcConfig);
        LogonStatusManager lsman = (LogonStatusManager)appctx.getBean(LogonStatusManager.class);
        logonService.setLogonStatusManager(lsman);
        User user = logonService.logon(username, "", this.errors, JFCUtils.getLocaleString(), "JFCAppJob", null, false);
        if (this.errors.sizeJfcerror() > 0) {
            logger.error("Failed to log on by user " + username);
            for (Jfcerror e : this.errors.getJfcerror()) {
                logger.error(e.getContent());
            }
            throw new LogonFailedException();
        }
        if (user == null) {
            logger.error("Failed to log on by user " + username);
            throw new LogonFailedException();
        }
        user.setSaveLastAccessTimeAtLogoff(false);
        return user;
    }

    protected String getProcessFileCsvEncoding() {
        if (this.getEncoding() != null) {
            return this.getEncoding();
        }
        JfcConfig jfcConfig = (JfcConfig)this.p.appctx.getBean(JfcConfig.class);
        return jfcConfig.getCsvEncoding();
    }

    @Override
    public void processEnd() {
        JfcjobstatusRegistryService service;
        boolean ignoreSaveJfcjobstatus;
        IJfcjobstatus jobstatus;
        super.processEnd();
        if (this.processWriter != null) {
            this.processWriter.close();
            this.processWriter = null;
        }
        if (this.processFile != null && this.isDeleteProcessFiles) {
            this.processFile.deleteOnExit();
        }
        if (this.errorWriter != null) {
            this.errorWriter.close();
            this.errorWriter = null;
        }
        if (this.errorFile != null && this.isDeleteProcessFiles) {
            this.errorFile.deleteOnExit();
        }
        if (this.multi != null) {
            this.multi.deleteAllFiles();
            this.multi.clear();
        }
        if (this.lockobject != null) {
            LockManager lman = LockManagerFactory.getLockManager(this.p);
            lman.releaseLockObject(this.lockobject);
        }
        if (!this.isUploadUpdateJob() && (jobstatus = (IJfcjobstatus)this.p.request.getAttribute(IJfcjobstatus.class.getName())) != null && !(ignoreSaveJfcjobstatus = (service = (JfcjobstatusRegistryService)this.p.appctx.getBean(JfcjobstatusRegistryService.class)).getIgnoreSaveJfcjobstatus())) {
            String exectype = jobstatus.getExectype();
            boolean ignoreLeave = service.getDefaultIgnoreLeaveJfcjobstatus(exectype);
            service.updateEndJfcjobstatus(this.p, jobstatus, IJfcjobstatus.Statustype.End, ignoreLeave);
            this.p.request.setAttribute(IJfcjobstatus.class.getName(), null);
        }
        this.releaseMap(this.originalPageMap);
        this.originalPageMap.clear();
        this.releaseMap(this.originalAppMap);
        this.originalAppMap.clear();
        if (this.isCreateUserObject) {
            this.p.user.logoff(this.lastaccesstime);
        }
    }

    private void releaseMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> o : map.entrySet()) {
            Map.Entry<String, Object> entry = o;
            if (!(entry.getValue() instanceof Releasable)) continue;
            ((Releasable)entry.getValue()).release();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("(" + this.p.user.getUsername() + ") object '" + entry.getKey() + "' is released.");
        }
    }

    @Override
    protected void afterProcessEnd() {
        super.afterProcessEnd();
    }

    @Override
    protected void processFailed(Exception e) {
        JfcjobstatusRegistryService service;
        super.processFailed(e);
        IJfcjobstatus jobstatus = (IJfcjobstatus)this.p.request.getAttribute(IJfcjobstatus.class.getName());
        if (jobstatus != null && !(service = (JfcjobstatusRegistryService)this.p.appctx.getBean(JfcjobstatusRegistryService.class)).getIgnoreSaveJfcjobstatus()) {
            service.updateEndJfcjobstatus(this.p, jobstatus, IJfcjobstatus.Statustype.Aborted);
            this.p.request.setAttribute(IJfcjobstatus.class.getName(), null);
        }
        if (e instanceof SecurityException) {
            logger.error("security error user " + this.getUsername(), (Throwable)e);
            Object[] ep = new Object[]{this.getUsername()};
            this.errors.addJfcerror(this.errorManager.getJfcerror("error.security.pbean", ep, this.p.locale));
        } else if (e instanceof AbstractDbUploadUpdateRunnableMonitor.ScriptCheckFailedException) {
            logger.debug("scrit check failed. user " + this.getUsername(), (Throwable)e);
        } else if (e instanceof LogonFailedException) {
            logger.debug("logon failed. user " + this.getUsername(), (Throwable)e);
            if (this.errors.sizeJfcerror() == 0) {
                this.errors.addJfcerror(this.errorManager.getJfcerror("error.unknown", this.p.locale));
            }
        } else {
            logger.error("unknown error user " + this.getUsername(), (Throwable)e);
            this.errors.addJfcerror(this.errorManager.getJfcerror("error.unknown", this.p.locale));
        }
    }

    @Override
    protected void openFile() throws IOException {
        super.openFile();
        if (this.isModelitemCsv) {
            this.modelitemCsvMap = new HashMap<ModelitemCsvPkey, ModelitemCsvRowList>();
            int cnt = this.getFileProcessCount();
            try {
                while (true) {
                    ++cnt;
                    String[] data1 = this.readRowData();
                    String[] pkeydata = this.getUploadUpdateCSVHelper().getPrimaryKeyForCsvData(data1, this.header, this.p);
                    ModelitemCsvPkey pkey = new ModelitemCsvPkey(pkeydata);
                    ModelitemCsvRowList rowlist = this.modelitemCsvMap.get(pkey);
                    if (rowlist == null) {
                        rowlist = new ModelitemCsvRowList(cnt);
                        this.modelitemCsvMap.put(pkey, rowlist);
                    }
                    logger.debug(pkey + " end row num " + cnt);
                    rowlist.addRowNum(cnt);
                }
            }
            catch (EOFException e) {
                this.reopenFile();
            }
            catch (IllegalCsvFormatException e) {
                logger.warn("Illegal csv format", (Throwable)e);
                this.p.errors.addJfcerror(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.illegal_csvformat", this.p.locale));
                this.stop();
                return;
            }
            catch (IOException e) {
                logger.warn("failed read", (Throwable)e);
                this.p.errors.addJfcerror(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.filed.read", this.p.locale));
                this.stop();
                return;
            }
        }
        this.outputProcessFileHeader();
    }

    @Override
    protected void closeFile() throws IOException {
        super.closeFile();
        this.modelitemCsvMap = null;
    }

    @Override
    public void readHeader(String[] header1, boolean isChangeProcessCount) throws IOException {
        if (isChangeProcessCount) {
            this.resetFileProcessCount();
            this.incrementProcessCount();
        }
        this.header = header1;
        UploadUpdateCSVHelper helper = this.getUploadUpdateCSVHelper();
        if (helper instanceof UploadUpdateModelitemCSVHelper) {
            boolean isModelitemCsv2;
            this.isModelitemCsv = isModelitemCsv2 = ((UploadUpdateModelitemCSVHelper)helper).checkModelitemCsvHeader(header1, this.p, this.errorManager);
            if (isModelitemCsv2) {
                this.headerValid = ((UploadUpdateModelitemCSVHelper)helper).getValidModelitemCsvHeader(header1, this.p);
                return;
            }
        }
        if (!this.getCheckPrimaryKey()) {
            helper.checkCsvHeader(header1, this.p, this.errorManager, false);
        } else {
            helper.checkCsvHeader(header1, this.p, this.errorManager);
        }
        this.headerValid = helper.getValidCsvHeader(header1, this.p);
        if (this.getCheckNothingValidHeader()) {
            boolean isNothingValidHeader = true;
            for (boolean b : this.headerValid) {
                if (!b) continue;
                isNothingValidHeader = false;
                break;
            }
            if (isNothingValidHeader) {
                Jfcerror _error = this.errorManager.getJfcerror("error.input.no_valid_header", this.p.locale);
                this.p.errors.addJfcerror(_error);
            }
        }
    }

    @Override
    public void readData() throws IOException {
        Jfcerrors errorsbackup = this.p.errors;
        try {
            this._readData();
        }
        finally {
            this.p.errors = errorsbackup;
        }
    }

    private void _readData() throws IOException {
        this.p.errors = new Jfcerrors();
        this.p.request = new EmptyHttpServletRequest(this.p.appctx, this.originalRequest);
        this.p.appMap = new HashMap<String, Object>(this.originalAppMap);
        this.p.pageMap = new HashMap<String, Object>(this.originalPageMap);
        CacheManagerBaseMethodImpl_threadLocal.removeCache();
        try {
            this.readRow();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IllegalCsvFormatException e) {
            logger.warn("Illegal csv format", (Throwable)e);
            this.p.errors.addJfcerror(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.illegal_csvformat", this.p.locale));
            this.stop();
        }
        catch (IOException e) {
            logger.warn("failed read", (Throwable)e);
            this.p.errors.addJfcerror(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.filed.read", this.p.locale));
            this.stop();
        }
        finally {
            this.releaseMapWithoutOriginal(this.p.pageMap, this.originalPageMap);
            this.releaseMapWithoutOriginal(this.p.appMap, this.originalAppMap);
        }
        JFCHelperUtils.clearWarnedError(this.p);
        this.appendMessage();
        this.outputStatusFile();
    }

    private void releaseMapWithoutOriginal(Map<String, Object> map, Map<String, Object> originalMap) {
        for (String key : map.keySet()) {
            Object originalValue;
            Object value = map.get(key);
            if (!(value instanceof Releasable) || originalMap.containsKey(key) && value == (originalValue = originalMap.get(key))) continue;
            ((Releasable)value).release();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("(" + this.p.user.getUsername() + ") object '" + key + "' is released.");
        }
    }

    protected abstract void readRow() throws IOException;

    protected void outputProcessFileHeader() {
        String[] header1 = this.createProcessCsvHeader();
        String[] headerValid1 = this.createProcessCsvHeaderValid(this.p);
        String[] errorheader = new String[1 + header1.length];
        errorheader[0] = "<RowNumber>";
        System.arraycopy(header1, 0, errorheader, 1, header1.length);
        String[] errorheaderValid = new String[1 + headerValid1.length];
        errorheaderValid[0] = "";
        System.arraycopy(headerValid1, 0, errorheaderValid, 1, headerValid1.length);
        this.outputProcessWriter(header1);
        this.outputProcessWriter(headerValid1);
        this.outputErrorWriter(errorheader);
        this.outputErrorWriter(errorheaderValid);
    }

    protected void outputProcessWriter(String[] data1) {
        if (this.isProcessMultiFiles()) {
            String[] newdata = new String[1 + data1.length];
            newdata[0] = this.getOpenFilename();
            System.arraycopy(data1, 0, newdata, 1, data1.length);
            data1 = newdata;
        }
        String line = this.processFileSeparateChar != '\u0000' ? CSVUtil.makeCSVLine((String[])data1, (char)'\"', (char)this.processFileSeparateChar) : CSVUtil.makeCSVLine((String[])data1);
        this.processWriter.println(line);
    }

    protected void outputErrorWriter(String[] data1) {
        if (this.isProcessMultiFiles()) {
            String[] newdata = new String[1 + data1.length];
            newdata[0] = this.getOpenFilename();
            System.arraycopy(data1, 0, newdata, 1, data1.length);
            data1 = newdata;
        }
        String line = this.processFileSeparateChar != '\u0000' ? CSVUtil.makeCSVLine((String[])data1, (char)'\"', (char)this.processFileSeparateChar) : CSVUtil.makeCSVLine((String[])data1);
        this.errorWriter.println(line);
    }

    protected String[] createProcessCsvHeader() {
        String[] header1 = new String[this.statusHeader.length + this.header.length];
        System.arraycopy(this.statusHeader, 0, header1, 0, this.statusHeader.length);
        System.arraycopy(this.header, 0, header1, this.statusHeader.length, this.header.length);
        return header1;
    }

    protected String[] createProcessCsvHeaderValid(ActionParameter dp) {
        String[] validHeaderData = new String[this.statusHeader.length + this.headerValid.length];
        int headerValidCnt = 0;
        validHeaderData[headerValidCnt++] = "Info";
        while (headerValidCnt < this.statusHeader.length) {
            validHeaderData[headerValidCnt++] = "";
        }
        assert (headerValidCnt == this.statusHeader.length);
        for (int i = 0; i < this.headerValid.length; ++i) {
            validHeaderData[this.statusHeader.length + i] = this.headerValid[i] ? JFCUtils.getRValue("__jfc_common.uploadupdate.header.valid", dp.locale) : JFCUtils.getRValue("__jfc_common.uploadupdate.header.invalid", dp.locale);
        }
        return validHeaderData;
    }

    protected int getErrorMessageCountLimit() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendMessage() {
        LinkedHashMap<String, FilenameMessage> linkedHashMap = this.filenameMessageMap;
        synchronized (linkedHashMap) {
            Object[] ep;
            String filename = this.getOpenFilename();
            FilenameMessage filenameMessage = this.filenameMessageMap.get(filename);
            if (filenameMessage == null) {
                filenameMessage = new FilenameMessage();
                this.filenameMessageMap.put(filename, filenameMessage);
            }
            if (!this.appendJfcerrormsg(filenameMessage.getErrormsgMap(), this.p.errors.getJfcerror()) && !this.containsKey(this.errors.getJfcerror(), ROW_ERROR_MESSAGE_LIMITOVER_RKEY)) {
                ep = new Object[]{this.getErrorMessageCountLimit()};
                this.errors.addJfcerror(this.errorManager.getJfcerror(ROW_ERROR_MESSAGE_LIMITOVER_RKEY, ep, this.p.locale));
            }
            if (!this.appendJfcerrormsg(filenameMessage.getWarnmsgMap(), this.p.errors.getJfcwarn()) && !this.containsKey(this.errors.getJfcwarn(), ROW_WARN_MESSAGE_LIMITOVER_RKEY)) {
                ep = new Object[]{this.getErrorMessageCountLimit()};
                this.errors.addJfcwarn(this.errorManager.getJfcwarn(ROW_WARN_MESSAGE_LIMITOVER_RKEY, ep, this.p.locale));
            }
        }
    }

    private boolean appendJfcerrormsg(Map<String, IntegerRange> errormsgMap, Jfcerrormsg[] msgs) {
        for (Jfcerrormsg msg : msgs) {
            String content = msg.getContent();
            IntegerRange rowcntrange = errormsgMap.get(content);
            if (rowcntrange == null) {
                if (errormsgMap.size() > this.getErrorMessageCountLimit()) continue;
                rowcntrange = new IntegerRange();
                if (msg.getSanitize()) {
                    content = StringEscapeUtils.escapeHtml4((String)content);
                }
                errormsgMap.put(content, rowcntrange);
            }
            rowcntrange.addRange(this.getFileProcessCount());
        }
        return errormsgMap.size() <= this.getErrorMessageCountLimit();
    }

    private boolean containsKey(Jfcerrormsg[] msgs, String key) {
        for (Jfcerrormsg msg : msgs) {
            if (!key.equals(msg.getCode())) continue;
            return true;
        }
        return false;
    }

    protected void outputStatusFile() {
        String[] data1;
        Jfcerror[] errormsgs = this.p.errors.getJfcerror();
        String[] statusdata = this.getStatusData(this.datastatus, this.p);
        if (this.data != null) {
            data1 = new String[statusdata.length + this.data.length];
            System.arraycopy(statusdata, 0, data1, 0, statusdata.length);
            System.arraycopy(this.data, 0, data1, statusdata.length, this.data.length);
        } else {
            data1 = statusdata;
        }
        this.outputProcessWriter(data1);
        if (errormsgs.length > 0) {
            String[] errordata = new String[1 + data1.length];
            errordata[0] = Integer.toString(this.getFileProcessCount());
            System.arraycopy(data1, 0, errordata, 1, data1.length);
            this.outputErrorWriter(errordata);
        }
    }

    protected void setNullForPrimaryKeyData(String[] data1, String[] header1, ActionParameter dp) {
        if (this.pkeyHeaderCount == null) {
            this.pkeyHeaderCount = new ArrayList<Integer>();
            String[] rkeys = this.getUploadUpdateCSVHelper().getPrimaryKeyLabelResourceKeys();
            block0: for (int i = 0; i < header1.length; ++i) {
                String h = header1[i];
                for (String rkey : rkeys) {
                    if (!h.equals(JFCUtils.getRValue(rkey, dp.locale))) continue;
                    this.pkeyHeaderCount.add(i);
                    continue block0;
                }
            }
        }
        for (Integer i : this.pkeyHeaderCount) {
            data1[i.intValue()] = null;
        }
    }

    protected String callScript(String modelId, ActionParameter p) {
        return this.callScript(modelId, p, "AfterUpdate");
    }

    protected String callScript(String modelId, ActionParameter p, String timing) {
        String clazzName = this.getClass().getName();
        clazzName = clazzName.substring(0, clazzName.length() - "ProcessBeanRunnable".length());
        return new ScriptCodeRunner(modelId).process(clazzName, timing, p);
    }

    @Override
    public String[] getHeader() {
        String[] header1 = new String[this.header.length];
        System.arraycopy(this.header, 0, header1, 0, this.header.length);
        return header1;
    }

    public static class LogonFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    private static final class FilenameMessage {
        LinkedHashMap<String, IntegerRange> errormsgMap = new LinkedHashMap();
        LinkedHashMap<String, IntegerRange> warnmsgMap = new LinkedHashMap();

        public Map<String, IntegerRange> getErrormsgMap() {
            return this.errormsgMap;
        }

        public Map<String, IntegerRange> getWarnmsgMap() {
            return this.warnmsgMap;
        }
    }
}

