/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessor;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.util.CSVUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDbUploadUpdateRunnableMonitorFileProcessorImpl
implements DbUploadUpdateRunnableMonitorFileProcessor {
    protected File file;
    protected AbstractDbUploadUpdateRunnableMonitor monitor;
    protected ActionParameter p;
    private InputStream istream;
    private BufferedReader reader;
    protected int filecnt;
    protected char SepChar = (char)44;
    protected String encoding;
    protected String[] header;
    protected boolean isUseHeaderRow = true;
    public final String _READHEADER_BEFORESCRIPT_KEY = "DbUploadUpdateRunnableMonitorFileProcessor_readHeaderBeforeScript";
    private String modelId;

    public boolean isUseScript() {
        return true;
    }

    @Override
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    private String getModelId() {
        return this.modelId;
    }

    @Override
    public void setEncoding(String s) {
        this.encoding = s;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getNumberFormat() {
        return null;
    }

    @Override
    public void setNumberFormat(String numberFormatStr) {
    }

    @Override
    public String getYmdFormat() {
        return null;
    }

    @Override
    public void setYmdFormat(String ymdFormatStr) {
    }

    @Override
    public String getHmsFormat() {
        return null;
    }

    @Override
    public void setHmsFormat(String hmsFormatStr) {
    }

    @Override
    public String getYmdhmsFormat() {
        return null;
    }

    @Override
    public void setYmdhmsFormat(String ymdhmsFormatStr) {
    }

    @Override
    public int getFileCount() {
        return this.filecnt;
    }

    protected boolean isOpenFile() throws IOException {
        return this.reader != null;
    }

    protected abstract void _openFile() throws IOException;

    protected void setReader(InputStream istream, String csvencoding) throws IOException {
        Charset charset = Charset.forName(csvencoding);
        if (charset.equals(StandardCharsets.UTF_8)) {
            if (!istream.markSupported()) {
                istream = new BufferedInputStream(istream);
            }
            istream.mark(3);
            if (istream.read() != 239 || istream.read() != 187 || istream.read() != 191) {
                istream.reset();
            }
        }
        InputStreamReader reader1 = new InputStreamReader(istream, charset);
        this.reader = new BufferedReader(reader1);
        if (this.isUseScript()) {
            this.istream = new BufferedInputStream(istream);
        }
    }

    protected void _closeFile() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.istream = null;
        }
    }

    @Override
    public void reopenFile() throws IOException {
        this._closeFile();
        this._openFile();
        if (this.header == null) {
            this.readRowData();
        }
    }

    @Override
    public void closeFile() throws IOException {
        try {
            this._closeFile();
        }
        finally {
            ++this.filecnt;
        }
    }

    @Override
    public void processStart() {
    }

    @Override
    public void processEnd() {
    }

    @Override
    public void processFailed(Exception e) {
    }

    @Override
    public void readHeader() throws IOException {
        this.header = null;
    }

    @Override
    public void setHeader(String[] header, boolean isUseHeaderRow) throws IOException {
        this.header = header;
        this.isUseHeaderRow = isUseHeaderRow;
    }

    @Override
    public String[] readRowData() throws IOException {
        if (!this.isUseScript()) {
            return this.readRowDataDirect(this.reader);
        }
        return this.readRowData(this.reader, this.istream);
    }

    @Override
    public DbUploadUpdateRunnableMonitorFileProcessor.CellAttrs readRowDataWithAttr() throws IOException {
        final String[] values = this.readRowData();
        return new DbUploadUpdateRunnableMonitorFileProcessor.CellAttrs(){

            @Override
            public String[] getValues() {
                return values;
            }

            @Override
            public DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] getCellAttr() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] readRowData(BufferedReader reader, InputStream istream) throws IOException {
        String ROWDATA_KEY = "DbUploadUpdateRunnableMonitorFileProcessor_rowData";
        this.p.request.removeAttribute("DbUploadUpdateRunnableMonitorFileProcessor_rowData");
        if (this.p.request.getAttribute("DbUploadUpdateRunnableMonitorFileProcessor_readHeaderBeforeScript") != null) {
            return CSVUtil.parse((Reader)reader, (char)'\"', (char)this.SepChar, (int)-1);
        }
        try {
            HashMap<String, Closeable> params = new HashMap<String, Closeable>();
            params.put("reader", reader);
            params.put("istream", istream);
            String ret = new ScriptCodeRunner(this.getModelId()).process("UploadUpdate" + StringUtil.capFirst((String)this.getModelId()), "readRowDataInFileProcessor", params, this.p);
            String[] rowdata = (String[])this.p.request.getAttribute("DbUploadUpdateRunnableMonitorFileProcessor_rowData");
            if (StringUtils.isNotBlank((CharSequence)ret)) {
                if ("EOF".equals(ret)) {
                    throw new EOFException();
                }
                Jfcerror _error = new Jfcerror();
                _error.setContent(ret);
                this.p.errors.addJfcerror(_error);
                if (rowdata != null && rowdata.length > 0) {
                    String[] stringArray = rowdata;
                    return stringArray;
                }
                String[] stringArray = new String[]{};
                return stringArray;
            }
            if (rowdata != null && rowdata.length > 0) {
                String[] stringArray = rowdata;
                return stringArray;
            }
        }
        finally {
            this.p.request.removeAttribute("DbUploadUpdateRunnableMonitorFileProcessor_rowData");
        }
        return CSVUtil.parse((Reader)reader, (char)'\"', (char)this.SepChar, (int)-1);
    }

    private String[] readRowDataDirect(BufferedReader reader) throws IOException {
        return CSVUtil.parse((Reader)reader, (char)'\"', (char)this.SepChar, (int)-1);
    }
}

