/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationPropertyManager {
    private static final Logger logger = LogManager.getLogger((String)ApplicationPropertyManager.class.getName());
    private static final String BundleBaseName = "wagbyapp";
    private static final String MyBundleBaseName = "mywagbyapp";

    public static String getProperty(String name) throws IllegalStateException {
        String value = null;
        try {
            ResourceBundle myres = ResourceBundle.getBundle(MyBundleBaseName);
            if (myres != null) {
                value = myres.getString(name);
            }
        }
        catch (MissingResourceException myres) {
            // empty catch block
        }
        if (value == null) {
            try {
                ResourceBundle res = ResourceBundle.getBundle(BundleBaseName);
                if (res != null) {
                    value = res.getString(name);
                }
            }
            catch (MissingResourceException e) {
                String msg = "No resource " + name + " is found in " + BundleBaseName + ".properties";
                logger.debug(msg, (Throwable)e);
                throw new IllegalStateException(msg);
            }
        }
        return value != null ? value : "";
    }

    public static String getBundleName() {
        return BundleBaseName;
    }

    public static String getMyBundleName() {
        return MyBundleBaseName;
    }
}

