/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionImpl;
import jp.jasminesoft.jfc.PropertyManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckPermissionFactory {
    private static final String CheckPermissionSystemPropertyName = "jp.jasminesoft.jfc.CheckPermissionFactory";
    private static CheckPermission instance;
    private static Logger logger;

    public static CheckPermission getCheckPermission() {
        return instance;
    }

    private static CheckPermission createCheckPermission(String checkPermissionClassname) {
        Class<?> checkPermissionClass;
        if (checkPermissionClassname == null) {
            return null;
        }
        try {
            checkPermissionClass = Class.forName(checkPermissionClassname);
        }
        catch (ClassNotFoundException e) {
            logger.warn("checkPermission class " + checkPermissionClassname + " is not found", (Throwable)e);
            return null;
        }
        return CheckPermissionFactory.createCheckPermission(checkPermissionClass);
    }

    private static CheckPermission createCheckPermission(Class checkPermissionClass) {
        Object checkPermissionObj;
        if (checkPermissionClass == null) {
            return null;
        }
        try {
            checkPermissionObj = checkPermissionClass.newInstance();
        }
        catch (InstantiationException e) {
            logger.warn("failed to create checkPermission class " + checkPermissionClass, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.warn("failed to create checkPermission class " + checkPermissionClass, (Throwable)e);
            return null;
        }
        if (!(checkPermissionObj instanceof CheckPermission)) {
            logger.warn("Invalid instance of CheckPermission, class " + checkPermissionClass);
            return null;
        }
        return (CheckPermission)checkPermissionObj;
    }

    static {
        logger = LogManager.getLogger((String)CheckPermissionFactory.class.getName());
        String checkPermissionClassname = PropertyManager.getProperty(CheckPermissionSystemPropertyName);
        CheckPermission checkPermission = CheckPermissionFactory.createCheckPermission(checkPermissionClassname);
        if (checkPermission == null) {
            checkPermission = new CheckPermissionImpl();
        }
        instance = checkPermission;
    }
}

