/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CssPropertyManager {
    private static Logger logger = LogManager.getLogger(CssPropertyManager.class);
    private final String CR = System.getProperty("line.separator");
    private Map<String, Map<String, Set<String>>> browserMap = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Object> configMap = new HashMap<String, Object>();
    private int count;
    private Map<String, String> cacheMap = new HashMap<String, String>();
    private boolean isLoadDoneFlag;
    @Autowired
    protected ServletContext servletContext;

    private CssPropertyManager() {
    }

    @PostConstruct
    public void init() {
        this.initCssPropertyManager(this.servletContext);
    }

    public boolean isReady() {
        return this.isLoadDoneFlag;
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in) {
        if (in == null) {
            return;
        }
        BufferedReader b_in = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = b_in.readLine()) != null) {
                int sep;
                String cssfilename;
                Set<String> set;
                if (StringUtils.isBlank((CharSequence)line) || line.trim().charAt(0) == '#') continue;
                String btype = line.substring(0, line.indexOf("."));
                String key = btype + ".";
                line = line.substring(key.length());
                Map<String, Set<String>> cssfileMap = this.browserMap.get(btype);
                if (cssfileMap == null) {
                    cssfileMap = new HashMap<String, Set<String>>();
                    this.browserMap.put(btype, cssfileMap);
                }
                if ((set = cssfileMap.get(cssfilename = line.substring(0, sep = line.indexOf(".")))) == null) {
                    set = new LinkedHashSet<String>();
                    cssfileMap.put(cssfilename, set);
                }
                String content = line.substring(sep + 1);
                set.add(content);
                ++this.count;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.isLoadDoneFlag = true;
        }
    }

    public void setConfig(String key, Object value) {
        this.configMap.put(key, value);
    }

    public String getCssContentByBrowserTypeAndCssfilename(String btype, String cssfilename) {
        if (btype == null || cssfilename == null) {
            return "";
        }
        StringBuilder cacheKey = new StringBuilder(btype);
        cacheKey.append(":");
        cacheKey.append(cssfilename);
        String cc = this.cacheMap.get(cacheKey.toString());
        if (cc != null) {
            return cc;
        }
        int sep = cssfilename.indexOf("/");
        if (sep > 0) {
            cssfilename = cssfilename.substring(sep + 1);
        }
        if (cssfilename.endsWith(".css")) {
            cssfilename = cssfilename.substring(0, cssfilename.length() - 4);
        }
        StringBuilder sb = new StringBuilder();
        Map<String, Set<String>> cssfileMap = this.browserMap.get(btype);
        if (cssfileMap == null) {
            return "";
        }
        Set<String> set = cssfileMap.get(cssfilename);
        Set<String> addSet = cssfileMap.get("*");
        if (set == null) {
            set = addSet;
        } else if (addSet != null) {
            set.addAll(addSet);
        }
        if (set == null) {
            return "";
        }
        for (String cnt : set) {
            this.createContent(cnt, sb);
        }
        this.cacheMap.put(cacheKey.toString(), sb.toString());
        return sb.toString();
    }

    private String createContent(String s, StringBuilder sb) {
        int ptr = s.indexOf("=");
        String leftv = s.substring(0, ptr);
        String rightv = s.substring(ptr + 1);
        if (leftv.startsWith("class.")) {
            leftv = leftv.substring("class.".length());
        } else if (leftv.startsWith("id.")) {
            leftv = leftv.substring("id.".length());
        } else if (leftv.startsWith("element.")) {
            leftv = leftv.substring("element.".length());
        }
        int ptr2 = leftv.lastIndexOf(".");
        String classname = leftv.substring(0, ptr2);
        String key = leftv.substring(ptr2 + 1);
        if (classname.startsWith("$DOT$")) {
            classname = classname.replace("$DOT$", ".");
        } else if (classname.startsWith("$SHARP$")) {
            classname = classname.replace("$SHARP$", "#");
        }
        sb.append(classname);
        sb.append(" {");
        sb.append(this.CR);
        sb.append("  ");
        sb.append(key);
        sb.append(" : ");
        sb.append(this.parse(rightv));
        sb.append(";");
        sb.append(this.CR);
        sb.append("}");
        sb.append(this.CR);
        return sb.toString();
    }

    private String parse(String v) {
        String _v = StringUtil.removePreAndPostWhitespace((String)v);
        if (_v.charAt(0) != '(') {
            return v;
        }
        int ptr = _v.indexOf(")");
        String cond = _v.substring(1, ptr);
        if (_v.charAt(ptr + 1) != '?') {
            return "";
        }
        String __v = _v.substring(ptr + 1);
        ptr = __v.indexOf(":");
        String trueValue = __v.substring(1, ptr);
        String falseValue = __v.substring(ptr + 1);
        ptr = cond.indexOf("=");
        if (ptr < 0) {
            return "";
        }
        String condKey = cond.substring(0, ptr);
        Object value = this.configMap.get(condKey);
        if (value == null) {
            return trueValue;
        }
        if (value instanceof Boolean) {
            Boolean _b = (Boolean)value;
            if (_b.booleanValue()) {
                return trueValue;
            }
            return falseValue;
        }
        return trueValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCssPropertyManager(ServletContext sc) {
        if (this.isReady()) {
            return;
        }
        String path = "/WEB-INF/css-dependency.properties";
        InputStream in = null;
        try {
            URL url = sc.getResource(path);
            if (url != null) {
                in = url.openStream();
                this.load(in);
                logger.info("(admin@localhost) * CssPropertyManager contains " + this.size() + " lines.");
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00050), LogCodeManager.getMessage(LogCode.JFC00050, path));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            block16: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block16;
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        CssPropertyManager cman = new CssPropertyManager();
        cman.setConfig("submenu", Boolean.FALSE);
        String csscontent = cman.getCssContentByBrowserTypeAndCssfilename("MSIE6", "wagby");
        System.out.println(csscontent);
    }
}

