/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Date;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ScreenMessageListener;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.util.ExcelFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpirationWarningScreenMessageListener
implements ScreenMessageListener {
    private static final Logger logger = LogManager.getLogger(ExpirationWarningScreenMessageListener.class);

    @Override
    public Jfcerrors createMessage(ActionParameter p) {
        Jfcerrors errors = new Jfcerrors();
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        ServletContext sc = p.request.getServletContext();
        if (sc == null) {
            return errors;
        }
        Long limitDate = (Long)sc.getAttribute("__jfc_licenseinfo_use_limit_date");
        if (limitDate == null) {
            return errors;
        }
        int warnPeriod = -7;
        if (JFCUtils.hasPrincipal(p.user, "all")) {
            warnPeriod = -30;
        }
        Date ldate = new Date(limitDate);
        java.sql.Date wdate = ExcelFunction.MOVEDAY((Date)ldate, (int)(warnPeriod - 1));
        if (!ExcelFunction.TODAY().after(wdate)) {
            return errors;
        }
        errors.addJfcwarn(errorManager.getJfcwarn("warn.near.system.ttl", new Object[]{ldate}, p.locale));
        return errors;
    }
}

