/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jp.jasminesoft.jfc.JFCBasePrincipal;
import jp.jasminesoft.jfc.JFCUserPrincipal;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.NoSuchUserException;
import jp.jasminesoft.jfc.PreferenceInfo;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.UserInfoBase;
import jp.jasminesoft.jfc.UserInfoUpdateEvent;
import jp.jasminesoft.jfc.app.HibernateMasterJprincipal;
import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.app.MasterJprincipal;
import jp.jasminesoft.jfc.model.jfcpreferenceitem.IJfcpreferenceitem;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.model.preference.Preference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class HibernateUserInfo
extends UserInfoBase {
    private static final Logger logger = LogManager.getLogger(HibernateUserInfo.class);
    private Session session;

    protected HibernateUserInfo() {
        if (logger.isDebugEnabled()) {
            logger.debug("create HibernateUserInfo instance.");
        }
    }

    protected void initSession() {
        if (this.session == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("open session");
            }
            this.session = HibernateUtil.openSession();
        }
    }

    @Override
    public IJuser getJuser(String username) {
        String expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.getJuser.query");
        return this.getJuser(username, expression);
    }

    @Override
    protected IJuser getJuserForPreference(String username) {
        String expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.getJuserForPreference.query");
        return this.getJuser(username, expression);
    }

    protected IJuser getJuser(String username, String expression) {
        IJuser juser;
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug("getJuser username:" + username + " expression:" + expression);
            }
            juser = null;
            if (username == null) {
                return null;
            }
            try {
                this.initSession();
                Query query = this.session.createQuery(expression);
                query.setString("userid", username);
                juser = (IJuser)query.uniqueResult();
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
                logger.debug("Failed to get user information. user " + username + ", " + e);
                if (!logger.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        return juser;
    }

    @Override
    public String getEmailByUserid(String userid) {
        String email;
        block4: {
            String expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.getEmailByUserid.query");
            if (logger.isDebugEnabled()) {
                logger.debug("getJuser userid:" + userid + " expression:" + expression);
            }
            if (userid == null) {
                return null;
            }
            email = null;
            try {
                this.initSession();
                Query query = this.session.createQuery(expression);
                query.setString("userid", userid);
                email = (String)query.uniqueResult();
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
                logger.debug("Failed to get email information. userid=" + userid + ", " + e);
                if (!logger.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        return email;
    }

    @Override
    public void updateJuser(IJuser juser) {
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug("updateJuser juser:" + juser);
            }
            if (juser == null) {
                return;
            }
            this.initSession();
            Transaction tx = this.session.beginTransaction();
            try {
                this.session.update((Object)juser);
                tx.commit();
                this.occurUpdateJuserEvent(new UserInfoUpdateEvent(juser.getUserid(), -1L, juser));
                logger.debug("success to update juser " + juser.getUserid() + ".");
            }
            catch (Exception e) {
                tx.rollback();
                logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void updateJuserInTransaction(IJuser juser) {
        if (logger.isDebugEnabled()) {
            logger.debug("updateJuserInTransaction juser:" + juser);
        }
        if (juser == null) {
            return;
        }
        try {
            this.session.update((Object)juser);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
                e.printStackTrace();
            }
            throw e;
        }
    }

    @Override
    public String[] getAllUsername() {
        if (logger.isDebugEnabled()) {
            logger.debug("getAllUsername");
        }
        String expression = null;
        try {
            expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.getAllUsername.query");
            this.initSession();
            Query query = this.session.createQuery(expression);
            List list = query.list();
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("close HibernateUserInfo");
        }
        if (this.session != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("close session");
            }
            this.session.close();
            this.session = null;
        }
    }

    @Override
    public boolean isSupportLastAccessTime() {
        return true;
    }

    @Override
    public long getLastAccessTime(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug("getLastAccessTime username:" + username);
        }
        String expression = null;
        try {
            expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.getLastAccessTime.query");
            this.initSession();
            Query query = this.session.createQuery(expression);
            query.setString("userid", username);
            Long ret = (Long)query.uniqueResult();
            if (ret == null) {
                return 0L;
            }
            return ret;
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00065), LogCodeManager.getMessage(LogCode.JFC00065, new String[0]));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return 0L;
        }
    }

    @Override
    public synchronized void setLastAccessTime(String username, long lastaccesstime) {
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug("setLastAccessTime username:" + username + " lastaccesstime:" + lastaccesstime);
            }
            String expression = null;
            this.initSession();
            Transaction tx = this.session.beginTransaction();
            try {
                expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.setLastAccessTime.query");
                Query query = this.session.createQuery(expression);
                query.setLong("lastaccesstime", lastaccesstime);
                query.setString("userid", username);
                int num = query.executeUpdate();
                if (num <= 0) {
                    logger.debug("No need to save lastaccess time, user " + username + ", update " + num);
                }
                tx.commit();
                this.occurUpdateLastAccessTimeEvent(new UserInfoUpdateEvent(username, lastaccesstime, null));
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00065), LogCodeManager.getMessage(LogCode.JFC00065, new String[0]));
                logger.debug((Object)e);
                if (!logger.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer sb;
        block9: {
            int i;
            block8: {
                if (logger.isDebugEnabled()) {
                    logger.debug("toString");
                }
                sb = new StringBuffer("HibernateUserInfo[");
                String expression = null;
                try {
                    sb.append("juser: [");
                    expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.toString.query");
                    this.initSession();
                    Query query = this.session.createQuery(expression);
                    ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
                    i = 0;
                    while (results.next()) {
                        Object obj;
                        if (i > 0) {
                            sb.append(", ");
                        }
                        if ((obj = results.get(0)) == null) continue;
                        sb.append(obj.toString());
                        ++i;
                    }
                    sb.append("]");
                }
                catch (Exception e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
                    sb.append(" " + e.getClass().getName() + ": " + e.getMessage());
                    logger.debug("Failed to get juser info.", (Throwable)e);
                    if (!logger.isDebugEnabled()) break block8;
                    e.printStackTrace();
                }
            }
            sb.append(" jprincipal: [");
            try {
                MasterJprincipal masterJprincipal = HibernateMasterJprincipal.getInstance();
                Object[] jprincipals = masterJprincipal.getData();
                for (i = 0; i < jprincipals.length; ++i) {
                    Jprincipal jprincipal = (Jprincipal)jprincipals[i];
                    sb.append(jprincipal.toString());
                }
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00064), LogCodeManager.getMessage(LogCode.JFC00064, new String[0]));
                sb.append(" " + e.getClass().getName() + ": " + e.getMessage());
                logger.debug("Failed to get jprincipal info.", (Throwable)e);
                if (!logger.isDebugEnabled()) break block9;
                e.printStackTrace();
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Principal[] getPrincipals(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug("getPrincipals username:" + username);
        }
        MasterJprincipal masterJprincipal = HibernateMasterJprincipal.getInstance();
        if (username == null) {
            return new Principal[0];
        }
        IJuser juser = this.getJuser(username);
        if (juser == null) {
            logger.debug("No user " + username + " is found.");
            throw new NoSuchUserException(username);
        }
        HashSet<JFCBasePrincipal> principal = new HashSet<JFCBasePrincipal>();
        principal.addAll(HibernateUserInfo.getPrincipalsInJprincipal(masterJprincipal, juser));
        principal.add(new JFCUserPrincipal(username));
        return principal.toArray(new Principal[0]);
    }

    @Override
    public Permission[] getPermissions(Principal principal) {
        return new Permission[0];
    }

    @Override
    public Preference loadPreference(IJuser juser) {
        Preference preference = super.loadPreference(juser);
        this.loadPreferenceJfcpreferenceitem(juser.getUserid(), preference);
        return preference;
    }

    protected void loadPreferenceJfcpreferenceitem(String username, Preference preference) {
        List<IJfcpreferenceitem> prefitems = this.getJfcpreferenceitem(username);
        if (prefitems == null) {
            return;
        }
        for (IJfcpreferenceitem prefitem : prefitems) {
            Item item = new Item();
            item.setType("jfcpreferenceitem");
            item.setKey(prefitem.getKey());
            item.setContent(prefitem.getContent());
            preference.addItem(item);
        }
    }

    @Override
    public synchronized void savePreference(String username, PreferenceInfo preferenceInfo) {
        this.initSession();
        Transaction tx = this.session.beginTransaction();
        try {
            IJuser juser = this.getJuserForPreference(username);
            if (juser == null) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00032), LogCodeManager.getMessage(LogCode.JFC00032, username));
                return;
            }
            this.savePreference(juser, preferenceInfo);
            tx.commit();
            this.occurUpdateJuserEvent(new UserInfoUpdateEvent(username, -1L, juser));
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    @Override
    protected synchronized void savePreference(IJuser juser, PreferenceInfo preferenceInfo) {
        super.savePreference(juser, preferenceInfo);
        String username = juser.getUserid();
        String prefitemtype = "jfcpreferenceitem";
        List<IJfcpreferenceitem> prefitems = this.getJfcpreferenceitem(username);
        if (prefitems == null) {
            return;
        }
        HashMap<String, Item> itemMap = new HashMap<String, Item>(preferenceInfo.updateMap);
        ArrayList<IJfcpreferenceitem> deleteitems = new ArrayList<IJfcpreferenceitem>();
        ArrayList<IJfcpreferenceitem> updateitems = new ArrayList<IJfcpreferenceitem>();
        for (IJfcpreferenceitem prefitem : prefitems) {
            String key = prefitem.getKey();
            if (preferenceInfo.deletekeys.contains(key)) {
                deleteitems.add(prefitem);
                continue;
            }
            if (!itemMap.containsKey(key)) continue;
            Item item = itemMap.remove(key);
            if (item.getType() == "jfcpreferenceitem") {
                prefitem.setContent(item.getContent());
                updateitems.add(prefitem);
                continue;
            }
            deleteitems.add(prefitem);
        }
        Iterator<Item> it = itemMap.values().iterator();
        while (it.hasNext()) {
            Item item = it.next();
            if (item.getType() == "jfcpreferenceitem") continue;
            it.remove();
        }
        if (itemMap.size() == 0 && updateitems.size() == 0 && deleteitems.size() == 0) {
            return;
        }
        try {
            this.updateJfcpreferenceitem(username, deleteitems, updateitems, itemMap.values());
            logger.debug("success to update jfcpreferenceitem " + username + ".");
        }
        catch (RuntimeException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
            logger.debug("Failed to delete jfcpreferenceitem. user " + username + ", ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void deletePreference(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug("deletePreference username:" + username);
        }
        Integer ret = null;
        if (username == null) {
            return;
        }
        String expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.deletePreference.query");
        if (expression == null) {
            return;
        }
        this.initSession();
        Transaction tx = this.session.beginTransaction();
        try {
            Query query = this.session.createQuery(expression);
            query.setString("userid", username);
            ret = query.executeUpdate();
            tx.commit();
            if (logger.isDebugEnabled()) {
                logger.debug("success to delete jfcpreferenceitem. user " + username + " (" + ret + ").");
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
            logger.debug("Failed to delete jfcpreferenceitem. user " + username + ", ", (Throwable)e);
        }
    }

    protected synchronized List<IJfcpreferenceitem> getJfcpreferenceitem(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug("getJfcpreferenceitem username:" + username);
        }
        List ret = null;
        if (username == null) {
            return null;
        }
        String expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.getJfcpreferenceitem.query");
        if (expression == null) {
            return null;
        }
        try {
            this.initSession();
            Query query = this.session.createQuery(expression);
            query.setString("userid", username);
            ret = query.list();
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, new String[0]));
            logger.debug("Failed to get jfcpreferenceitem. user " + username + ", ", (Throwable)e);
        }
        return ret;
    }

    protected String getJfcpreferenceitemClassname() {
        return PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.createJfcpreferenceitem.JfcpreferenceitemClassname");
    }

    protected IJfcpreferenceitem createJfcpreferenceitem(int id, String username, Item item) {
        String classname = this.getJfcpreferenceitemClassname();
        if (classname == null) {
            return null;
        }
        IJfcpreferenceitem prefitem = null;
        try {
            prefitem = (IJfcpreferenceitem)Class.forName(classname).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("failed create Jfcpreferenceitem object", e);
        }
        prefitem.setId(id);
        prefitem.setUserid(username);
        prefitem.setKey(item.getKey());
        prefitem.setContent(item.getContent());
        return prefitem;
    }

    private void updateJfcpreferenceitem(String username, List<IJfcpreferenceitem> deleteitems, List<IJfcpreferenceitem> updateitems, Collection<Item> insertitems) {
        String classname;
        if (logger.isDebugEnabled()) {
            logger.debug("updateJfcpreferenceitem");
        }
        if ((classname = this.getJfcpreferenceitemClassname()) == null) {
            return;
        }
        if (insertitems.size() > 0) {
            Integer maxidobj = this.getMaxIdJfcpreferenceitem();
            int maxid = maxidobj == null ? 0 : maxidobj;
            for (Item item : insertitems) {
                IJfcpreferenceitem prefitem = this.createJfcpreferenceitem(++maxid, username, item);
                this.session.save((Object)prefitem);
            }
        }
        for (IJfcpreferenceitem prefitem : updateitems) {
            this.session.update((Object)prefitem);
        }
        for (IJfcpreferenceitem prefitem : deleteitems) {
            this.session.delete((Object)prefitem);
        }
    }

    private Integer getMaxIdJfcpreferenceitem() {
        String expression = PropertyManager.getProperty("jp.jasminesoft.jfc.HibernateUserInfo.getMaxIdJfcpreferenceitem.query");
        if (expression == null) {
            throw new IllegalStateException();
        }
        Query query = this.session.createQuery(expression);
        return (Integer)query.uniqueResult();
    }
}

