/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jp.jasminesoft.jfc.JFCAppPrincipal;
import jp.jasminesoft.jfc.JFCDefaultPrincipal;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFCAppLoginModule
implements LoginModule {
    public static final String JSHPARAM_ALL_USERS = "jshparam_all_users";
    private static final Principal[] DefaultPrincipal = new Principal[]{new JFCDefaultPrincipal(""), new JFCAppPrincipal("jshparam_all_users")};
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private Principal[] plist;
    private static final Logger logger = LogManager.getLogger((String)JFCAppLoginModule.class.getName());

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        logger.debug("initialize " + subject + "," + callbackHandler + "," + sharedState + "," + options);
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        UserInfo userinfo;
        logger.debug("login username=" + this.username);
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available.");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("username:"), new PasswordCallback("password:", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information from the user");
        }
        if (this.debug) {
            logger.debug("user entered username: " + this.username);
            logger.debug("user entered password: ");
            for (int i = 0; i < this.password.length; ++i) {
                logger.debug(Character.valueOf(this.password[i]).toString());
            }
        }
        if ((userinfo = UserInfoFactory.getUserInfo()) == null) {
            logger.debug("Failed to get userinfo object. database configuration may be wrong.");
            throw new FailedLoginException("Failed to get UserInfo object.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("userinfo is " + userinfo);
        }
        try {
            if (this.verifyUser(userinfo, this.username, this.password)) {
                if (this.debug) {
                    logger.debug("authentication succeeded");
                }
                this.succeeded = true;
                boolean bl = true;
                return bl;
            }
            if (this.debug) {
                logger.debug("authentication failed");
            }
            this.succeeded = false;
            this.username = null;
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
            throw new FailedLoginException("Password Incorrect");
        }
        finally {
            userinfo.close();
        }
    }

    protected boolean verifyUser(UserInfo userinfo, String username, char[] password) throws AccountExpiredException {
        return userinfo.verifyUser(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() throws LoginException {
        int i;
        logger.debug("commit username=" + this.username);
        if (!this.succeeded || this.username == null) {
            return false;
        }
        UserInfo userinfo = UserInfoFactory.getUserInfo();
        if (logger.isDebugEnabled()) {
            logger.debug("userinfo is " + userinfo);
        }
        if (DefaultPrincipal != null) {
            for (i = 0; i < DefaultPrincipal.length; ++i) {
                Principal principal = DefaultPrincipal[i];
                if (this.subject.getPrincipals().contains(principal)) continue;
                this.subject.getPrincipals().add(principal);
                if (!this.debug) continue;
                logger.debug("added default " + principal + " to Subject");
            }
        }
        try {
            this.plist = userinfo.getPrincipals(this.username);
        }
        finally {
            userinfo.close();
        }
        if (this.plist != null) {
            for (i = 0; i < this.plist.length; ++i) {
                Principal userPrincipal = this.plist[i];
                if (this.subject.getPrincipals().contains(userPrincipal)) continue;
                this.subject.getPrincipals().add(userPrincipal);
                if (!this.debug) continue;
                logger.debug("added " + userPrincipal + " to Subject");
            }
        }
        for (int i2 = 0; i2 < this.password.length; ++i2) {
            this.password[i2] = 32;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        logger.debug("abort username=" + this.username);
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            this.plist = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        int i;
        logger.debug("logout username=" + this.username);
        if (DefaultPrincipal != null) {
            for (i = 0; i < DefaultPrincipal.length; ++i) {
                Principal principal = DefaultPrincipal[i];
                this.subject.getPrincipals().remove(principal);
            }
        }
        if (this.plist != null) {
            for (i = 0; i < this.plist.length; ++i) {
                Principal userPrincipal = this.plist[i];
                this.subject.getPrincipals().remove(userPrincipal);
            }
        }
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            for (int i2 = 0; i2 < this.password.length; ++i2) {
                this.password[i2] = 32;
            }
            this.password = null;
        }
        this.plist = null;
        return true;
    }
}

