/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import jp.jasminesoft.jfc.JFCAppMode;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatus;
import jp.jasminesoft.jfc.LogonStatusManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class JFCAppModeManager {
    private static final Logger logger = LogManager.getLogger(JFCAppModeManager.class);
    @Autowired
    private LogonStatusManager LSMAN;
    @Value(value="${wagby.startupmode:Normal}")
    private String defaultAppMode;
    private JFCAppMode _mode;

    protected JFCAppModeManager() {
    }

    public synchronized void setMode(JFCAppMode mode, String username) {
        this.setLocalMode(mode);
    }

    public synchronized void setLocalMode(JFCAppMode mode) {
        this._mode = mode;
    }

    public synchronized JFCAppMode getMode() {
        if (this._mode == null) {
            this._mode = JFCAppMode.valueOfIgnoreCase(this.defaultAppMode);
        }
        if (this._mode == null) {
            this._mode = JFCAppMode.Normal;
        }
        return this._mode;
    }

    public int checkLogon(String username) {
        int count = 0;
        for (LogonStatus lstatus : this.LSMAN.getCurrentLogonUsers()) {
            if (lstatus.getUsername().equals(username)) continue;
            ++count;
        }
        if (count > 0) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90021), LogCodeManager.getMessage(LogCode.JFC90021, String.valueOf(count)));
        }
        return count;
    }

    public void logoffAll(String username, StringBuilder sb) {
        LogonStatus[] lstatus_ary;
        for (LogonStatus lstatus : lstatus_ary = this.LSMAN.getCurrentLogonUsers()) {
            if (lstatus.getUsername().equals(username)) continue;
            this.LSMAN.releaseUserObject(lstatus.getUsername(), lstatus.getSessionId());
            sb.append(lstatus.getUsername()).append(" ");
            logger.log(LogCodeManager.getPriority(LogCode.JFC90022), LogCodeManager.getMessage(LogCode.JFC90022, lstatus.getUsername()));
        }
    }
}

