/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.JFCBasePermissionCollection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFCBasePermission
extends BasicPermission {
    private static final Logger logger = LogManager.getLogger(JFCBasePermission.class);
    public static final String JOKER = "all";
    private Set actionSet;

    public JFCBasePermission(String name) {
        super(name);
        this.setActionSet(null);
    }

    public JFCBasePermission(String name, String actions) {
        super(name, actions);
        this.setActionSet(actions);
    }

    private void setActionSet(String actions) {
        this.actionSet = new HashSet();
        if (actions == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.length() == 0) continue;
            this.actionSet.add(s);
        }
    }

    public String[] getActionsList() {
        return this.actionSet.toArray(new String[0]);
    }

    @Override
    public boolean implies(Permission p) {
        if (p == null || !(p instanceof JFCBasePermission)) {
            return false;
        }
        JFCBasePermission ap = (JFCBasePermission)p;
        boolean nameFlag = false;
        if (ap.getName().equals(JOKER)) {
            nameFlag = true;
        } else if (super.implies(p)) {
            nameFlag = true;
        }
        if (!nameFlag) {
            return false;
        }
        boolean actionFlag = false;
        String[] _actions = ap.getActionsList();
        if (_actions.length == 0) {
            actionFlag = true;
        } else if (_actions.length == 1 && _actions[0].equals(JOKER)) {
            actionFlag = true;
        } else {
            for (int i = 0; i < _actions.length; ++i) {
                if (!this.actionSet.contains(_actions[i])) continue;
                actionFlag = true;
                break;
            }
        }
        return actionFlag;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new JFCBasePermissionCollection();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[JFCBasePermission ");
        sb.append("Name:");
        sb.append(this.getName());
        String[] alist = this.getActionsList();
        if (alist != null && alist.length > 0) {
            sb.append(" Actionlist:");
            for (int i = 0; i < alist.length; ++i) {
                sb.append(alist[i]);
                sb.append(" ");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

