/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jp.jasminesoft.jfc.JFCBasePermission;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class JFCBasePermissionCollection
extends PermissionCollection {
    private static final Logger logger = LogManager.getLogger(JFCBasePermissionCollection.class);
    private Map permissions = Collections.synchronizedMap(new HashMap());

    JFCBasePermissionCollection() {
    }

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof JFCBasePermission)) {
            logger.debug("Wrong permission type");
            throw new IllegalArgumentException("Wrong permission type");
        }
        String name = permission.getName();
        JFCBasePermission inTable = (JFCBasePermission)this.permissions.get(name);
        if (inTable != null) {
            permission = this.merge((JFCBasePermission)permission, inTable);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("add " + permission.toString());
        }
        this.permissions.put(name, permission);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.permissions.values());
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof JFCBasePermission)) {
            return false;
        }
        String name = permission.getName();
        while (true) {
            logger.debug("name=" + name);
            Permission inTable = (Permission)this.permissions.get(name);
            if (inTable != null && inTable.implies(permission)) {
                return true;
            }
            if (name.equals("*")) break;
            int dotIndex = name.endsWith(".*") ? name.lastIndexOf(46, name.length() - 2) : name.lastIndexOf(46);
            if (dotIndex > 0) {
                name = name.substring(0, dotIndex) + ".*";
                continue;
            }
            name = "*";
        }
        return false;
    }

    protected JFCBasePermission merge(JFCBasePermission p1, JFCBasePermission p2) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(p1.getActionsList()));
        set.addAll(Arrays.asList(p2.getActionsList()));
        StringBuffer buf = new StringBuffer();
        Iterator i = set.iterator();
        if (i.hasNext()) {
            while (true) {
                buf.append(i.next().toString());
                if (!i.hasNext()) break;
                buf.append(",");
            }
        }
        return this.createPermission(p1.getName(), buf.toString());
    }

    protected JFCBasePermission createPermission(String name, String actions) {
        return new JFCBasePermission(name, actions);
    }
}

