/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.error.Jfcdebug;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcinfo;
import jp.jasminesoft.jfc.error.Jfcwarn;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFCErrorManager {
    private static final String ResourceName = "errormsg";
    private static final Logger logger = LogManager.getLogger();

    private JFCErrorManager() {
    }

    private String get(String key, String locale_str) {
        Locale locale = JFCUtils.createLocale(locale_str);
        if (locale == null) {
            return "";
        }
        ResourceBundle rb = JFCUtils.getProperResourceBundle(ResourceName, locale);
        if (rb == null) {
            rb = JFCUtils.getResourceBundleInLocaleStrings(JFCUtils.getLocaleString(), ResourceName);
        }
        String ret = null;
        while (rb != null && key != null) {
            try {
                ret = rb.getString(key);
                break;
            }
            catch (MissingResourceException e) {
                String newkey = this.createNextCandidate(key);
                if (newkey == null || key.equals(newkey)) break;
                key = newkey;
            }
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    private String createNextCandidate(String key) {
        String ret;
        if (key == null || key.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int numOfToken = 0;
        boolean firstFlag = true;
        StringTokenizer st = new StringTokenizer(key, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (firstFlag) {
                firstFlag = false;
                continue;
            }
            sb.append(token);
            sb.append(".");
            ++numOfToken;
        }
        if (numOfToken == 0) {
            sb.append(key);
        }
        if ((ret = sb.toString()).endsWith(".")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private String get(String key, Object[] o, String locale_str) {
        String content = this.get(key, locale_str);
        if (content == null) {
            String msg = "There is no data to support this key '" + key + "'.";
            logger.debug(msg);
            content = msg + " 0:{0} 1:{1} 2:{2} 3:{3} 4:{4} 5:{5} 6:{6} 7:{7} 8:{8} 9:{9}";
        }
        if (o != null) {
            ArrayList<Object> list = new ArrayList<Object>(o.length);
            for (Object _o : o) {
                if (_o instanceof String) {
                    list.add(StringEscapeUtils.escapeHtml4((String)_o.toString()));
                    continue;
                }
                list.add(_o);
            }
            o = list.toArray();
        }
        return MessageFormat.format(content, o);
    }

    public Jfcerror getJfcerror(String key, ActionParameter p) {
        return this.getJfcerror(null, key, null, p);
    }

    public Jfcerror getJfcerror(String name, String key, ActionParameter p) {
        return this.getJfcerror(name, key, null, p);
    }

    public Jfcerror getJfcerror(String key, String locale_str) {
        return this.getJfcerror(null, key, null, locale_str);
    }

    public Jfcerror getJfcerror(String name, String key, String locale_str) {
        return this.getJfcerror(name, key, null, locale_str);
    }

    public Jfcerror getJfcerror(String key, Object[] o, ActionParameter p) {
        return this.getJfcerror(null, key, o, p);
    }

    public Jfcerror getJfcerror(String name, String key, Object[] o, ActionParameter p) {
        String locale_str = (String)p.request.getAttribute("__jfc_locale");
        return this.getJfcerror(name, key, o, locale_str);
    }

    public Jfcerror getJfcerror(String key, Object[] o, String locale_str) {
        return this.getJfcerror(null, key, o, locale_str);
    }

    public Jfcerror getJfcerror(String name, String key, Object[] o, String locale_str) {
        Jfcerror _jfcerror = new Jfcerror();
        _jfcerror.setName(name);
        _jfcerror.setCode(key);
        _jfcerror.setSanitize(false);
        if (o == null) {
            _jfcerror.setContent(this.get(key, locale_str));
        } else {
            _jfcerror.setContent(this.get(key, o, locale_str));
        }
        return _jfcerror;
    }

    public Jfcwarn getJfcwarn(String key, ActionParameter p) {
        return this.getJfcwarn(null, key, null, p);
    }

    public Jfcwarn getJfcwarn(String name, String key, ActionParameter p) {
        return this.getJfcwarn(name, key, null, p);
    }

    public Jfcwarn getJfcwarn(String key, String locale_str) {
        return this.getJfcwarn(null, key, null, locale_str);
    }

    public Jfcwarn getJfcwarn(String name, String key, String locale_str) {
        return this.getJfcwarn(name, key, null, locale_str);
    }

    public Jfcwarn getJfcwarn(String key, Object[] o, ActionParameter p) {
        return this.getJfcwarn(null, key, o, p);
    }

    public Jfcwarn getJfcwarn(String name, String key, Object[] o, ActionParameter p) {
        String locale_str = (String)p.request.getAttribute("__jfc_locale");
        return this.getJfcwarn(name, key, o, locale_str);
    }

    public Jfcwarn getJfcwarn(String key, Object[] o, String locale_str) {
        return this.getJfcwarn(null, key, o, locale_str);
    }

    public Jfcwarn getJfcwarn(String name, String key, Object[] o, String locale_str) {
        Jfcwarn _jfcwarn = new Jfcwarn();
        _jfcwarn.setName(name);
        _jfcwarn.setCode(key);
        _jfcwarn.setSanitize(false);
        if (o == null) {
            _jfcwarn.setContent(this.get(key, locale_str));
        } else {
            _jfcwarn.setContent(this.get(key, o, locale_str));
        }
        return _jfcwarn;
    }

    public Jfcinfo getJfcinfo(String key, ActionParameter p) {
        return this.getJfcinfo(null, key, null, p);
    }

    public Jfcinfo getJfcinfo(String name, String key, ActionParameter p) {
        return this.getJfcinfo(name, key, null, p);
    }

    public Jfcinfo getJfcinfo(String key, String locale_str) {
        return this.getJfcinfo(null, key, null, locale_str);
    }

    public Jfcinfo getJfcinfo(String name, String key, String locale_str) {
        return this.getJfcinfo(name, key, null, locale_str);
    }

    public Jfcinfo getJfcinfo(String key, Object[] o, ActionParameter p) {
        return this.getJfcinfo(null, key, o, p);
    }

    public Jfcinfo getJfcinfo(String name, String key, Object[] o, ActionParameter p) {
        String locale_str = (String)p.request.getAttribute("__jfc_locale");
        return this.getJfcinfo(name, key, o, locale_str);
    }

    public Jfcinfo getJfcinfo(String key, Object[] o, String locale_str) {
        return this.getJfcinfo(null, key, o, locale_str);
    }

    public Jfcinfo getJfcinfo(String name, String key, Object[] o, String locale_str) {
        Jfcinfo _jfcinfo = new Jfcinfo();
        _jfcinfo.setName(name);
        _jfcinfo.setCode(key);
        _jfcinfo.setSanitize(false);
        if (o == null) {
            _jfcinfo.setContent(this.get(key, locale_str));
        } else {
            _jfcinfo.setContent(this.get(key, o, locale_str));
        }
        return _jfcinfo;
    }

    public Jfcdebug getJfcdebug(String key, ActionParameter p) {
        return this.getJfcdebug(null, key, null, p);
    }

    public Jfcdebug getJfcdebug(String name, String key, ActionParameter p) {
        return this.getJfcdebug(name, key, null, p);
    }

    public Jfcdebug getJfcdebug(String key, String locale_str) {
        return this.getJfcdebug(null, key, null, locale_str);
    }

    public Jfcdebug getJfcdebug(String name, String key, String locale_str) {
        return this.getJfcdebug(name, key, null, locale_str);
    }

    public Jfcdebug getJfcdebug(String key, Object[] o, ActionParameter p) {
        return this.getJfcdebug(null, key, o, p);
    }

    public Jfcdebug getJfcdebug(String name, String key, Object[] o, ActionParameter p) {
        String locale_str = (String)p.request.getAttribute("__jfc_locale");
        return this.getJfcdebug(name, key, o, locale_str);
    }

    public Jfcdebug getJfcdebug(String key, Object[] o, String locale_str) {
        return this.getJfcdebug(null, key, o, locale_str);
    }

    public Jfcdebug getJfcdebug(String name, String key, Object[] o, String locale_str) {
        Jfcdebug _jfcdebug = new Jfcdebug();
        _jfcdebug.setName(name);
        _jfcdebug.setCode(key);
        _jfcdebug.setSanitize(false);
        if (o == null) {
            _jfcdebug.setContent(this.get(key, locale_str));
        } else {
            _jfcdebug.setContent(this.get(key, o, locale_str));
        }
        return _jfcdebug;
    }
}

