/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.JFCClientAbortException;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.TableConfigManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;
import org.springframework.dao.DataAccessException;

public class JFCErrorMessageConverter {
    public static final String JFCErrorMessageConverterResourceName = "errormsgconv";
    private static JFCErrorMessageConverter _instance;
    private String dbType = TableConfigManager.getInstance().getDbtype();
    private static final Logger logger;

    private JFCErrorMessageConverter() {
    }

    private ResourceBundle rb(String locale) {
        return JFCUtils.getResourceBundleInLocaleStrings(locale, JFCErrorMessageConverterResourceName);
    }

    public static JFCErrorMessageConverter getInstance() {
        if (_instance == null) {
            _instance = new JFCErrorMessageConverter();
        }
        return _instance;
    }

    public String get(Exception e, String locale) {
        return this.get(e, null, locale);
    }

    public String get(Exception e, String[][] params, String locale) {
        if (e == null) {
            return "";
        }
        String msg = null;
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            msg = this.convertMessage(se, params, locale);
        } else if (e instanceof DataAccessException) {
            msg = this.get((Exception)e.getCause(), params, locale);
        } else if (e instanceof GenericJDBCException) {
            GenericJDBCException ge = (GenericJDBCException)e;
            SQLException se = ge.getSQLException();
            msg = this.convertMessage(se, params, locale);
        } else if (e instanceof ConstraintViolationException) {
            ConstraintViolationException ce = (ConstraintViolationException)e;
            SQLException se = ce.getSQLException();
            msg = this.convertMessage(se, params, locale);
        } else if (e instanceof JFCClientAbortException) {
            msg = this.convertMessage((JFCClientAbortException)e, params, locale);
        }
        if (StringUtils.isBlank((CharSequence)msg) && e != null) {
            msg = this.convertExceptionToMessage(e, params, locale);
        }
        return msg;
    }

    protected String convertExceptionToMessage(Exception exception, String[][] params, String locale) {
        String message;
        if (exception == null) {
            return "";
        }
        String messageKey = exception.getClass().getSimpleName();
        try {
            message = this.rb(locale).getString(messageKey);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                String arg = exception.getMessage();
                if (StringUtils.isBlank((CharSequence)arg)) {
                    arg = "";
                }
                message = MessageFormat.format(message, arg);
            }
            logger.debug(message);
        }
        catch (MissingResourceException e) {
            logger.debug("MissingResourceException", (Throwable)e);
            message = "";
        }
        return message;
    }

    private String convertMessage(SQLException se, String[][] params, String locale) {
        while (se.getNextException() != null) {
            se = se.getNextException();
        }
        String state = se.getSQLState();
        String message = null;
        ResourceBundle rb = this.rb(locale);
        String original_message_pattern_key = this.createPropKey("original_pattern", state);
        String original_message_pattern = null;
        try {
            original_message_pattern = rb.getString(original_message_pattern_key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (original_message_pattern != null) {
            String replace_message_key = this.createPropKey("replace_message", state);
            String replace_message = null;
            try {
                replace_message = rb.getString(replace_message_key);
            }
            catch (MissingResourceException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00104), LogCodeManager.getMessage(LogCode.JFC00104, replace_message_key));
                return null;
            }
            Pattern pattern = Pattern.compile(original_message_pattern);
            Matcher matcher = pattern.matcher(se.getMessage());
            if (!matcher.find()) {
                matcher = pattern.matcher(se.getMessage().toLowerCase());
            }
            if (matcher.find(0)) {
                String hitstr = matcher.group(1);
                Object[] oa = new Object[]{hitstr};
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        if (!hitstr.toLowerCase().equals(params[i][0].toLowerCase())) continue;
                        oa = new Object[]{params[i][1]};
                        break;
                    }
                }
                message = new MessageFormat(replace_message).format(oa);
            }
        }
        if (message == null) {
            String message_key = this.createPropKey("state", state);
            try {
                message = rb.getString(message_key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return message;
    }

    private String convertMessage(JFCClientAbortException cae, String[][] params, String locale) {
        String message;
        String message_key = "JFCClientAbortException";
        try {
            message = this.rb(locale).getString("JFCClientAbortException");
            logger.debug(message);
        }
        catch (MissingResourceException e) {
            logger.debug("MissingResourceException", (Throwable)e);
            message = "";
        }
        return message;
    }

    private String createPropKey(String key, String state) {
        StringBuffer sb = new StringBuffer(this.dbType);
        sb.append(".");
        sb.append(key);
        sb.append(".");
        sb.append(state);
        return sb.toString();
    }

    static {
        logger = LogManager.getLogger((String)JFCErrorMessageConverter.class.getName());
    }
}

