/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.JFCAppMode;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCJobTriggerListener;
import jp.jasminesoft.jfc.JFCQuartzJobManager;
import jp.jasminesoft.jfc.JFCQuartzJobManagerJobscheduleUtil;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.hibernate.CriteriaUtils;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.job.InitializeSchedulerListener;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import jp.jasminesoft.jfc.model.jfcjobschedule.IJfcjobschedule;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;

public abstract class JFCQuartzJobManagerBase
implements JFCQuartzJobManager {
    private static final Logger logger = LogManager.getLogger((String)JFCQuartzJobManagerBase.class.getName());
    @Autowired
    private ApplicationContext appctx;
    @Autowired
    protected JFCErrorManager errorManager;
    @Autowired
    @Qualifier(value="JfcjobscheduleEntityService")
    private JFCEntityService<?, Integer> service;
    @Autowired
    @Qualifier(value="JfcjobscheduleCriteriaConverter")
    private CriteriaConverter<?> criteriaConverter;
    @Autowired
    private JFCQuartzJobManagerJobscheduleUtil jobscheduleUtil;
    @Autowired(required=false)
    private List<InitializeSchedulerListener> initializeSchedulerListeners;

    protected List<IJfcjobschedule> getAllJob() {
        ActionParameter p = JFCUtils.createActionParameter(this.appctx);
        ((ActionParameterContainer)this.appctx.getBean("ActionParameterContainer")).set(p);
        List<IJfcjobschedule> list = this.service.find();
        return list;
    }

    protected List<IJfcjobschedule> getJDBCJob() {
        ActionParameter p = JFCUtils.createActionParameter(this.appctx);
        ((ActionParameterContainer)this.appctx.getBean("ActionParameterContainer")).set(p);
        DetachedCriteria criteria = this.criteriaConverter.defaultCriteria();
        criteria.add(CriteriaUtils.or(CriteriaUtils.eq("exectype_", "one"), CriteriaUtils.eq("exectype_", "domain"), CriteriaUtils.isNull("exectype_")));
        List<IJfcjobschedule> list = this.service.find(criteria);
        return list;
    }

    protected List<IJfcjobschedule> getRAMJob() {
        ActionParameter p = JFCUtils.createActionParameter(this.appctx);
        ((ActionParameterContainer)this.appctx.getBean("ActionParameterContainer")).set(p);
        DetachedCriteria criteria = this.criteriaConverter.defaultCriteria();
        criteria.add(CriteriaUtils.eq("exectype_", "all"));
        List<IJfcjobschedule> list = this.service.find(criteria);
        return list;
    }

    protected IJfcjobschedule getJob(int id) {
        ActionParameter p = JFCUtils.createActionParameter(this.appctx);
        ((ActionParameterContainer)this.appctx.getBean("ActionParameterContainer")).set(p);
        IJfcjobschedule schedule = (IJfcjobschedule)this.service.findById(id);
        return schedule;
    }

    @Override
    public void insertJob(IJfcjobschedule schedule) {
        this.updateJobAll();
    }

    @Override
    public void updateJob(IJfcjobschedule schedule) {
        this.updateJobAll();
    }

    @Override
    public void deleteJob(String id) {
        this.updateJobAll();
    }

    protected Map<String, IJfcjobschedule> createJobscheduleMap(Collection<IJfcjobschedule> jfcjobschedule_ary) {
        LinkedHashMap<String, IJfcjobschedule> jmap = new LinkedHashMap<String, IJfcjobschedule>();
        for (IJfcjobschedule schedule : jfcjobschedule_ary) {
            if (schedule.getEnable() == null || schedule.getEnable().length == 0 || schedule.getEnable()[0] != 1) continue;
            String jobName = this.getJobName(schedule);
            String o_jobName = new String(jobName);
            int i = 2;
            while (jmap.containsKey(jobName)) {
                jobName = o_jobName + i;
                ++i;
            }
            jmap.put(jobName, schedule);
        }
        return jmap;
    }

    protected void addJobDetail(Map<JobDetail, Set<? extends Trigger>> map1, String jobName, IJfcjobschedule schedule) {
        JobDetail job;
        String cronExpression = this.getCronExpression(schedule);
        if (logger.isDebugEnabled()) {
            logger.debug("Job " + jobName + " cronExpression is \"" + cronExpression + "\"");
        }
        if ((job = this.createJobDetail(jobName, schedule)) == null) {
            return;
        }
        Trigger trigger = this.createTrigger(jobName, cronExpression);
        HashSet<Trigger> set = new HashSet<Trigger>();
        set.add(trigger);
        map1.put(job, set);
    }

    protected Trigger createTrigger(String jobName, String cronExpression) {
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName + "Trig", "wagbyTrig").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).startNow().build();
        return trigger;
    }

    protected void unscheduleJob(Scheduler sched) {
        try {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)"wagbyTrig");
            Set triggerKeys = sched.getTriggerKeys(groupMatcher);
            sched.unscheduleJobs(new ArrayList(triggerKeys));
            if (logger.isDebugEnabled()) {
                for (TriggerKey triggerKey : triggerKeys) {
                    logger.debug("delete " + triggerKey.getName() + "::" + triggerKey.getGroup());
                }
            }
        }
        catch (SchedulerException e) {
            logger.error("occur scheduler exception", (Throwable)e);
        }
    }

    public void scheduleJobNow(ActionParameter p, IJfcjobschedule schedule, Scheduler sched) {
        block6: {
            String jobName = this.getJobName(schedule);
            try {
                Date now = new Date();
                SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHH24mmss");
                String tmpname = jobName + sf.format(now);
                JobDetail job = this.createJobDetail(tmpname, schedule);
                if (job == null) {
                    if (StringUtils.isBlank((CharSequence)jobName)) {
                        jobName = "(unknown)";
                    }
                    logger.error("No job is found, " + jobName);
                    if (p != null) {
                        p.errors.addJfcerror(this.errorManager.getJfcerror("fail.job.do_immediatly", new Object[]{jobName}, p.locale));
                    }
                    return;
                }
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(tmpname + "Trig", "wagbyTrig").startNow().build();
                sched.scheduleJob(job, trigger);
                logger.info(jobName + " is successfully registered now.");
                if (p != null) {
                    p.errors.addJfcinfo(this.errorManager.getJfcinfo("success.job.do_immediatly", new Object[]{jobName}, p.locale));
                }
            }
            catch (Exception e) {
                logger.error("An error has occured while getting bean, " + e.getMessage(), (Throwable)e);
                if (p == null) break block6;
                p.errors.addJfcerror(this.errorManager.getJfcerror("fail.job.do_immediatly", new Object[]{jobName}, p.locale));
            }
        }
    }

    private void setJobDataMap(IJfcjobschedule schedule, JobDetail job) {
        job.getJobDataMap().put("__jfcjob_jobname", this.getJobName(schedule));
        job.getJobDataMap().put("__jfcjob_username", schedule.getJusername());
        job.getJobDataMap().put("__jfcjob_password", schedule.getPassword());
        List<String[]> jobparams = this.getJobparam(schedule);
        if (jobparams != null) {
            for (String[] jobparam : jobparams) {
                String key = jobparam[0];
                String value = jobparam[1];
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                if (value == null) {
                    value = "";
                }
                if (job.getJobDataMap().containsKey((Object)key)) {
                    job.getJobDataMap().remove((Object)key);
                }
                job.getJobDataMap().put(key, value);
            }
        }
    }

    @Override
    public IJfcjobschedule createMaintenanceModeJobschedule(String username, JFCAppMode mode) {
        return this.jobscheduleUtil.createMaintenanceModeJobschedule(username, mode);
    }

    protected String getJobparam(IJfcjobschedule schedule, String key) {
        return this.jobscheduleUtil.getJobparam(schedule, key);
    }

    protected List<String[]> getJobparam(IJfcjobschedule schedule) {
        return this.jobscheduleUtil.getJobparam(schedule);
    }

    protected void addJobparam(IJfcjobschedule schedule, String key, String value) {
        this.jobscheduleUtil.addJobparam(schedule, key, value);
    }

    protected String getJobName(IJfcjobschedule schedule) {
        return StringUtil.lastToken((String)schedule.getJobname(), (String)".");
    }

    private String getCronExpression(IJfcjobschedule schedule) {
        String year_;
        String dayOfWeek_;
        String month_;
        String dayOfMonth_;
        String hour_;
        String minute_;
        StringBuilder sb = new StringBuilder();
        String second_ = schedule.getSecond();
        if (StringUtils.isBlank((CharSequence)second_)) {
            second_ = "*";
        }
        if (StringUtils.isBlank((CharSequence)(minute_ = schedule.getMinute()))) {
            minute_ = "*";
        }
        if (StringUtils.isBlank((CharSequence)(hour_ = schedule.getHour()))) {
            hour_ = "*";
        }
        if (StringUtils.isBlank((CharSequence)(dayOfMonth_ = schedule.getDayOfMonth()))) {
            dayOfMonth_ = "*";
        }
        if (StringUtils.isBlank((CharSequence)(month_ = schedule.getMonth()))) {
            month_ = "*";
        }
        if (StringUtils.isBlank((CharSequence)(dayOfWeek_ = schedule.getDayOfWeek()))) {
            dayOfWeek_ = "?";
        }
        if (StringUtils.isBlank((CharSequence)(year_ = schedule.getYear()))) {
            year_ = "*";
        }
        sb.append(second_);
        sb.append(" ");
        sb.append(minute_);
        sb.append(" ");
        sb.append(hour_);
        sb.append(" ");
        sb.append(dayOfMonth_);
        sb.append(" ");
        sb.append(month_);
        sb.append(" ");
        sb.append(dayOfWeek_);
        sb.append(" ");
        sb.append(year_);
        return sb.toString();
    }

    @Override
    public void processQueue(ActionParameter p, Map<String, Object> jobMap, Map<String, Object> paramMap, Map<String, Object> ctxMap, JFCErrorManager errorManager) {
        logger.debug("start");
        String jobName = (String)paramMap.get("__jfcjob_jobname");
        JobDetail job = null;
        try {
            job = this.getJobDetail(p, jobName);
            if (job == null) {
                if (StringUtils.isBlank((CharSequence)jobName)) {
                    jobName = "(unknown)";
                }
                logger.error("No job is found, " + jobName);
                p.errors.addJfcerror(errorManager.getJfcerror("fail.job.do_immediatly", new Object[]{jobName}, p.locale));
                return;
            }
            JFCBaseJobBean jobbean = (JFCBaseJobBean)((Object)job.getJobClass().newInstance());
            Map jobparamMap = (Map)paramMap.get("__jfcjob_jobparam");
            String username = (String)paramMap.get("__jfcjob_username");
            String locale = (String)paramMap.get("locale");
            HashMap<String, Object> jobDataMap = new HashMap<String, Object>();
            jobDataMap.putAll((Map<String, Object>)job.getJobDataMap());
            jobDataMap.put("__jfcjob_jobname", jobName);
            jobDataMap.put("__jfcjob_username", username);
            jobDataMap.put("__jfcjob_appctx", p.appctx);
            jobDataMap.put("locale", locale);
            jobDataMap.putAll(jobparamMap);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)((Object)jobbean));
            MutablePropertyValues pvs = new MutablePropertyValues();
            pvs.addPropertyValues(jobDataMap);
            bw.setPropertyValues((PropertyValues)pvs, true);
            jobbean.executeFromQueue(jobMap, jobDataMap, ctxMap);
            logger.info(jobName + " is successfully execute now.");
            p.errors.addJfcinfo(errorManager.getJfcinfo("success.job.do_immediatly", new Object[]{jobName}, p.locale));
        }
        catch (Exception e) {
            logger.error("An error has occured while getting bean, " + e.getMessage(), (Throwable)e);
            p.errors.addJfcerror(errorManager.getJfcerror("fail.job.do_immediatly", new Object[]{jobName}, p.locale));
        }
    }

    @Override
    public JFCBaseJobBean getJobBean(ActionParameter p, String jobName) throws InstantiationException, IllegalAccessException {
        JobDetail job = this.getJobDetail(p, jobName);
        if (job == null) {
            return null;
        }
        return (JFCBaseJobBean)((Object)job.getJobClass().newInstance());
    }

    protected JobDetail getJobDetail(ActionParameter p, String jobName) {
        JobDetailFactoryBean factoryBean = (JobDetailFactoryBean)p.appctx.getBean("&" + jobName);
        if (factoryBean == null) {
            return null;
        }
        Date now = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHH24mmss");
        String tmpname = jobName + sf.format(now);
        factoryBean.setName(tmpname);
        factoryBean.afterPropertiesSet();
        JobDetail job = factoryBean.getObject();
        return job;
    }

    protected JobDetail createJobDetail(String jobName, IJfcjobschedule schedule) {
        JobDetail job = null;
        try {
            JobDetailFactoryBean factoryBean = this.getJobDetailFactoryBean(schedule);
            if (factoryBean == null) {
                return null;
            }
            factoryBean.setName(jobName);
            factoryBean.afterPropertiesSet();
            job = factoryBean.getObject();
        }
        catch (Exception e) {
            logger.error("An error has occured while getting bean, " + e.getMessage(), (Throwable)e);
        }
        if (job == null) {
            logger.error("Job " + jobName + " is not found in the applicationContext. Skip.");
            return null;
        }
        this.setJobDataMap(schedule, job);
        return job;
    }

    protected JobDetailFactoryBean getJobDetailFactoryBean(IJfcjobschedule schedule) {
        String jobbeanName = this.getJobDetailFactoryBeanJobbeanName(schedule);
        JobDetailFactoryBean factoryBean = (JobDetailFactoryBean)this.appctx.getBean("&" + jobbeanName, JobDetailFactoryBean.class);
        return factoryBean;
    }

    protected String getJobDetailFactoryBeanJobbeanName(IJfcjobschedule schedule) {
        return this.getJobName(schedule);
    }

    protected void addJFCJobTriggerListener(Scheduler sched) {
        try {
            logger.info("sched.getListenerManager().addTriggerListener(new JFCJobTriggerListener());");
            sched.getListenerManager().addTriggerListener((TriggerListener)new JFCJobTriggerListener());
        }
        catch (SchedulerException e) {
            logger.error("addTriggerListener exception", (Throwable)e);
        }
    }

    protected void fireInitializeScheduler(Scheduler sched, int id) {
        if (this.initializeSchedulerListeners == null) {
            return;
        }
        this.initializeSchedulerListeners.forEach(l -> l.initializeScheduler(sched, id));
    }

    protected abstract void shutdownScheduler();

    @PreDestroy
    public void preDestroy() {
        this.shutdownScheduler();
    }
}

