/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXB;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import jp.jasminesoft.util.JaxbUtil;
import jp.jasminesoft.util.XMLUtil;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class JprincipalXmlCreator {
    private static final String JprincipalXmlFilename = "jprincipal.xml";
    private static final String IGNORE_INITDATADIR_MSG = " \u304c\u9069\u5207\u3067\u306a\u3044\u3067\u3059\u3002init/jprincipal\u3092\u542b\u3080\u30d5\u30a9\u30eb\u30c0\u306bJprincipal\u30c7\u30fc\u30bf\u304c\u683c\u7d0d\u3055\u308c\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
    private static final String IGNORE_SOURCEDIR_MSG = " \u304c\u9069\u5207\u3067\u306a\u3044\u3067\u3059\u3002init/jprincipal\u3092\u542b\u3080\u30d5\u30a9\u30eb\u30c0\u307e\u305f\u306fZIP\u30d5\u30a1\u30a4\u30eb\u306bJprincipal\u30c7\u30fc\u30bf\u304c\u683c\u7d0d\u3055\u308c\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";

    public static void main(String[] arg) {
        String source_importdir;
        String init_importdir;
        if (arg.length == 0) {
            JprincipalXmlCreator.help();
            return;
        }
        if (arg[0].equals("createEmpty")) {
            try {
                JprincipalXmlCreator.createEmptyFile();
                System.out.println("[INFO] jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                System.out.println("[ERROR] jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                e.printStackTrace();
            }
            return;
        }
        if (arg[0].equals("delete")) {
            File outxmlfile = new File(JprincipalXmlFilename);
            if (outxmlfile.exists()) {
                if (outxmlfile.delete()) {
                    System.out.println("[INFO] jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
                } else {
                    System.out.println("[ERROR] jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            } else {
                System.out.println("[INFO] jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            }
            return;
        }
        if (arg[0].equals("create")) {
            init_importdir = arg[1];
            source_importdir = arg[2];
        } else {
            init_importdir = arg[0];
            source_importdir = arg[1];
        }
        File initdata_file = new File(init_importdir);
        File sourcedata_file = new File(source_importdir);
        if (!initdata_file.exists() || !sourcedata_file.exists()) {
            if (!initdata_file.exists()) {
                System.out.println("[ERROR] \u6307\u5b9a\u3057\u305f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + init_importdir + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                JprincipalXmlCreator.help();
            }
            if (!sourcedata_file.exists()) {
                System.out.println("[ERROR] \u6307\u5b9a\u3057\u305f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + source_importdir + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                JprincipalXmlCreator.help();
            }
            return;
        }
        try {
            JprincipalXmlCreator.create(init_importdir, source_importdir);
            System.out.println("[INFO] jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Exception e) {
            System.out.println("[ERROR] jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("jprincipal.xml \u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3059\u308b\u30c4\u30fc\u30eb");
        System.out.println("Usage>[command] create [init_dir] [export_dir]");
        System.out.println("init_dir: \u30d3\u30eb\u30c9\u3057\u305f\u969b\u306b\u4f5c\u6210\u3055\u308c\u305f jprincipal \u304c\u542b\u307e\u308c\u3066\u3044\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        System.out.println("export_dir: export \u3057\u305f\u30c7\u30fc\u30bf\u306e jprincipal \u304c\u542b\u307e\u308c\u3066\u3044\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        System.out.println("create\u306f\u7701\u7565\u53ef");
        System.out.println("");
        System.out.println("Usage>[command] createEmpty");
        System.out.println("\u304b\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        System.out.println("");
        System.out.println("Usage>[command] delete");
        System.out.println("\u524a\u9664\u3057\u307e\u3059\u3002");
    }

    public static boolean delete() {
        File outxmlfile = new File(JprincipalXmlFilename);
        if (outxmlfile.exists()) {
            return outxmlfile.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(String initdata_importdir, String source_importdir) throws Exception {
        File temp_outxmlfile = new File(System.getProperty("java.io.tmpdir") + File.separator + JprincipalXmlFilename + ".tmp");
        FileOutputStream ostream = new FileOutputStream(temp_outxmlfile);
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)ostream, "UTF-8");
            writer = new BufferedWriter(writer);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write("<data>");
            if (initdata_importdir != null && source_importdir != null) {
                JprincipalXmlCreator.writeContent(initdata_importdir, source_importdir, writer);
            }
            writer.write("</data>");
        }
        finally {
            if (writer != null) {
                writer.close();
            } else {
                ostream.close();
            }
        }
        File temp2_outxmlfile = new File(System.getProperty("java.io.tmpdir") + File.separator + JprincipalXmlFilename + ".tmp2");
        if (temp2_outxmlfile.exists() && !temp2_outxmlfile.delete()) {
            throw new IOException("failed delete file " + temp2_outxmlfile);
        }
        File outxmlfile = new File(JprincipalXmlFilename);
        if (outxmlfile.exists() && !outxmlfile.renameTo(temp2_outxmlfile)) {
            throw new IOException("failed rename to file " + temp2_outxmlfile + " from " + outxmlfile);
        }
        if (!temp_outxmlfile.renameTo(outxmlfile)) {
            temp2_outxmlfile.renameTo(outxmlfile);
            throw new IOException("failed rename to file " + outxmlfile + " from " + temp_outxmlfile);
        }
    }

    private static void writeContent(String initdata_importdir, String source_importdir, Writer writer) throws IOException, Exception {
        File initdata_dir;
        boolean isOutputInitdata = false;
        File initdata_importdir_file = new File(initdata_importdir);
        if (initdata_importdir_file.isDirectory() && (initdata_dir = new File(new File(initdata_importdir, "init"), "jprincipal")).isDirectory()) {
            writer.write("<initdata>");
            isOutputInitdata = JprincipalXmlCreator.writeJprincipalDir(writer, initdata_dir, true);
            writer.write("</initdata>");
        }
        if (!isOutputInitdata) {
            System.out.println("[WARN] " + initdata_importdir_file.getAbsolutePath() + IGNORE_INITDATADIR_MSG);
        }
        boolean isOutputSource = false;
        File source_importdir_file = new File(source_importdir);
        if (source_importdir_file.isDirectory()) {
            File source_dir = new File(new File(source_importdir, "init"), "jprincipal");
            if (source_dir.isDirectory()) {
                writer.write("<source>");
                isOutputSource = JprincipalXmlCreator.writeJprincipalDir(writer, source_dir, false);
                writer.write("</source>");
            }
        } else if (source_importdir_file.isFile() && source_importdir.toLowerCase().endsWith(".zip")) {
            writer.write("<source>");
            isOutputSource = JprincipalXmlCreator.writeSourceJprincipalZip(writer, source_importdir_file);
            writer.write("</source>");
        }
        if (!isOutputSource) {
            System.out.println("[WARN] " + source_importdir_file.getAbsolutePath() + IGNORE_SOURCEDIR_MSG);
        }
    }

    private static boolean writeJprincipalDir(Writer writer, File dir, boolean ismarshal) throws Exception {
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        boolean existsdata = false;
        for (int i = 0; i < files.length; ++i) {
            String content;
            File file = files[i];
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".xml")) continue;
            String in = XMLUtil.readFileContent((File)file);
            if (ismarshal) {
                Jprincipal jprincipal = (Jprincipal)JaxbUtil.unmarshal((String)in, Jprincipal.class);
                StringWriter buf = new StringWriter();
                JAXB.marshal((Object)jprincipal, (Writer)buf);
                content = buf.toString();
            } else {
                content = in;
            }
            int ptr = content.indexOf("<jprincipal ");
            if (ptr < 0) {
                System.out.println("[WARN] \u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u306e\u305f\u3081\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\u3002 \u30d5\u30a1\u30a4\u30eb\u540d:" + file);
                continue;
            }
            writer.write(content.substring(ptr));
            existsdata = true;
        }
        return existsdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeSourceJprincipalZip(Writer writer, File zipFile) {
        boolean existsdata = false;
        BufferedInputStream zin = null;
        ZipArchiveInputStream zip_archive_in = null;
        try {
            zin = new BufferedInputStream(new FileInputStream(zipFile));
            zip_archive_in = new ZipArchiveInputStream((InputStream)zin);
            ZipArchiveEntry entry = null;
            while ((entry = zip_archive_in.getNextZipEntry()) != null) {
                String name = entry.getName();
                if (name.indexOf("/jprincipal/") <= 0 || !name.toLowerCase().endsWith(".xml")) continue;
                String s = XMLUtil.readFileContent((InputStream)zip_archive_in, (String)"UTF-8", (boolean)false);
                int ptr = s.indexOf("<jprincipal ");
                if (ptr < 0) {
                    System.out.println("[WARN] \u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u306e\u305f\u3081\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\u3002 \u30d5\u30a1\u30a4\u30eb\u540d:" + name + " Zip\u30d5\u30a1\u30a4\u30eb:" + zipFile);
                    continue;
                }
                writer.write(s.substring(ptr));
                existsdata = true;
            }
        }
        catch (Exception e) {
            System.out.println("[ERROR] " + e.getMessage());
        }
        finally {
            if (zip_archive_in != null) {
                try {
                    zip_archive_in.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    zip_archive_in = null;
                }
            }
            if (zin != null) {
                try {
                    ((InputStream)zin).close();
                }
                catch (Exception exception) {
                }
                finally {
                    zin = null;
                }
            }
        }
        return existsdata;
    }

    public static void createEmptyFile() throws Exception {
        JprincipalXmlCreator.create(null, null);
    }
}

