/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import jp.jasminesoft.jfc.LockSingleManager;
import jp.jasminesoft.jfc.LockSingleObject;
import jp.jasminesoft.jfc.LockSingleObjectImpl;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.model.jfclockobject.Jfclockobject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Value;

public class LockManagerDbImpl
implements Serializable,
LockSingleManager {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger((String)LockManagerDbImpl.class.getName());
    private static final String EmptyPrimaryKeyString = "(empty)";
    private static final String EmptySessionIdString = "(empty)";
    private String machinename = "localhost";
    protected Set<String> disabledModelIds = new HashSet<String>();
    @Value(value="${wagby.LockManagerDbImpl.clearThismachineAtPostConstruct:true}")
    private boolean clearThismachineAtPostConstruct;
    protected int lockCount;

    @PostConstruct
    public void postConstruct() {
        if (this.isClearThismachineAtPostConstruct()) {
            this.clearThismachine();
        }
    }

    public String getMachinename() {
        return this.machinename;
    }

    public void setMachinename(String machinename) {
        this.machinename = machinename;
    }

    public boolean isClearThismachineAtPostConstruct() {
        return this.clearThismachineAtPostConstruct;
    }

    public void setClearThismachineAtPostConstruct(boolean clearThismachineAtPostConstruct) {
        this.clearThismachineAtPostConstruct = clearThismachineAtPostConstruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LockSingleObject addLockObject(LockSingleObject lo) {
        if (this.disabledModelIds.contains(lo.getLockName())) {
            return null;
        }
        try (Session session = HibernateUtil.openSession();){
            Jfclockobject jlo = this.getJfclockobject(session, lo);
            if (jlo != null) {
                LockSingleObject _lo;
                LockSingleObject lockSingleObject = _lo = this.createLockObject(jlo);
                return lockSingleObject;
            }
            jlo = this.getJfclockobject3(session, lo);
            if (jlo != null) {
                LockSingleObject _lo = null;
                return _lo;
            }
            jlo = this.createJfclockobject(lo);
            logger.debug("add Jfclockobject " + jlo);
            Transaction tx = session.beginTransaction();
            session.save((Object)jlo);
            tx.commit();
            ++this.lockCount;
        }
        logger.debug("add " + lo);
        return null;
    }

    private Jfclockobject getJfclockobject2(Session session, LockSingleObject lo) {
        String expression = "select c from Jfclockobject as c where c.modelname_ = :modelname_ and c.pkey_ = :pkey_ and c.lockForAll_ = :lockForAll_";
        Query query = session.createQuery(expression);
        query.setString("modelname_", lo.getLockName());
        query.setString("pkey_", this.getPrimaryKeyString(lo));
        query.setInteger("lockForAll_", lo.isLockForAll() ? 2 : 1);
        Jfclockobject jlo = (Jfclockobject)query.uniqueResult();
        return jlo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jfclockobject getJfclockobject(Session session, LockSingleObject lo) {
        try (ScrollableResults results = null;){
            Query query;
            String expression;
            if (lo.isLockForAll()) {
                expression = "select c from Jfclockobject as c where c.modelname_ = :modelname_";
                query = session.createQuery(expression);
                query.setString("modelname_", lo.getLockName());
            } else {
                expression = "select c from Jfclockobject as c where c.modelname_ = :modelname_ and (c.lockForAll_ = 2 or (c.sessionid_ != :sessionid_ and c.pkey_ = :pkey_))";
                query = session.createQuery(expression);
                query.setString("modelname_", lo.getLockName());
                query.setString("sessionid_", this.getSessionIdString(lo));
                query.setString("pkey_", this.getPrimaryKeyString(lo));
            }
            results = query.scroll();
            if (results.first()) {
                Jfclockobject jlo;
                logger.debug(lo + " has already locked (1). canceled.");
                Jfclockobject jfclockobject = jlo = (Jfclockobject)results.get(0);
                return jfclockobject;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jfclockobject getJfclockobject3(Session session, LockSingleObject lo) {
        try (ScrollableResults results = null;){
            if (lo.isLockForAll()) {
                Jfclockobject jfclockobject = null;
                return jfclockobject;
            }
            String expression = "select c from Jfclockobject as c where c.modelname_ = :modelname_ and c.lockForAll_ != 2 and c.sessionid_ = :sessionid_ and c.pkey_ = :pkey_";
            Query query = session.createQuery(expression);
            query.setString("modelname_", lo.getLockName());
            query.setString("sessionid_", this.getSessionIdString(lo));
            query.setString("pkey_", this.getPrimaryKeyString(lo));
            results = query.scroll();
            if (results.first()) {
                Jfclockobject jlo;
                logger.debug(lo + " has already locked (1). canceled.");
                Jfclockobject jfclockobject = jlo = (Jfclockobject)results.get(0);
                return jfclockobject;
            }
        }
        return null;
    }

    private Jfclockobject createJfclockobject(LockSingleObject lo) {
        Jfclockobject jlo = new Jfclockobject();
        jlo.setModelname(lo.getLockName());
        jlo.setPkey(this.getPrimaryKeyString(lo));
        jlo.setLockForAll(lo.isLockForAll() ? 2 : 1);
        jlo.setMachinename(this.machinename);
        jlo.setUserid(lo.getUsername());
        jlo.setSessionid(this.getSessionIdString(lo));
        return jlo;
    }

    private LockSingleObject createLockObject(Jfclockobject jlo) {
        String sessionid = "(empty)".equals(jlo.getSessionid()) ? "" : jlo.getSessionid();
        LockSingleObjectImpl lo = new LockSingleObjectImpl(jlo.getModelname(), (Object)(jlo.getLockForAll() == 2 ? null : jlo.getPkey()), sessionid, jlo.getUserid(), jlo.getLockForAll() == 2);
        return lo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isLocked(LockSingleObject lo) {
        if (this.disabledModelIds.contains(lo.getLockName())) {
            return true;
        }
        try (Session session = HibernateUtil.openSession();){
            Jfclockobject jlo = this.getJfclockobject2(session, lo);
            if (jlo != null) {
                boolean bl = true;
                return bl;
            }
        }
        logger.debug("not contains " + lo);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean contains(LockSingleObject lo) {
        Jfclockobject jlo = null;
        try (Session session = HibernateUtil.openSession();){
            jlo = this.getJfclockobject(session, lo);
            if (jlo != null) {
                boolean bl = true;
                return bl;
            }
        }
        logger.debug("not contains " + lo);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getLockUser(LockSingleObject lo) {
        Jfclockobject jlo = null;
        try (Session session = HibernateUtil.openSession();){
            jlo = this.getJfclockobject(session, lo);
            if (jlo != null) {
                String string = jlo.getUserid();
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockSingleObject getLockObject(LockSingleObject lo) {
        Jfclockobject jlo = null;
        try (Session session = HibernateUtil.openSession();){
            jlo = this.getJfclockobject(session, lo);
            if (jlo != null) {
                LockSingleObject _lo;
                LockSingleObject lockSingleObject = _lo = this.createLockObject(jlo);
                return lockSingleObject;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean releaseLockObject(LockSingleObject lo) {
        Session session = HibernateUtil.openSession();
        Transaction tx = session.beginTransaction();
        try {
            Jfclockobject obj = this.getJfclockobject2(session, lo);
            Jfclockobject jlo = this.createJfclockobject(lo);
            if (obj == null) {
                logger.debug("Jfclockobject is null, " + jlo);
            } else {
                if (obj.getMachinename().equals(jlo.getMachinename()) && obj.getSessionid().equals(jlo.getSessionid())) {
                    logger.debug("delete Jfclockobject " + jlo);
                    session.delete((Object)obj);
                    tx.commit();
                    --this.lockCount;
                    boolean bl = true;
                    return bl;
                }
                logger.log(LogCodeManager.getPriority(LogCode.JFC00811), LogCodeManager.getMessage(LogCode.JFC00811, jlo != null ? jlo.toString() : "", obj != null ? obj.toString() : ""));
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00812), LogCodeManager.getMessage(LogCode.JFC00812, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            session.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove(String sessionid) {
        Session session = HibernateUtil.openSession();
        Transaction tx = session.beginTransaction();
        try {
            String expression = "delete from Jfclockobject as c where c.machinename_ = :machinename_ and c.sessionid_ = :sessionid_";
            Query query = session.createQuery(expression);
            query.setString("machinename_", this.machinename);
            query.setString("sessionid_", sessionid);
            int cnt = query.executeUpdate();
            tx.commit();
            this.lockCount -= cnt;
            logger.debug("delete " + cnt + " Jfclockobject for sessionid " + sessionid);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00813), LogCodeManager.getMessage(LogCode.JFC00813, sessionid, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            session.close();
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[LockManagerDbImpl lockCount:");
        sb.append(this.lockCount);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public LockSingleObject createLockObject(String key, String sessionid, User user) {
        return new LockSingleObjectImpl(key, null, sessionid, user, false);
    }

    @Override
    public LockSingleObject createLockObject(String modelname, Object pkey, String sessionid, User user) {
        return new LockSingleObjectImpl(modelname, pkey, sessionid, user, false);
    }

    @Override
    public LockSingleObject createLockObjectForAll(String modelname, String sessionid, User user) {
        return new LockSingleObjectImpl(modelname, null, sessionid, user, true);
    }

    @Override
    public LockSingleObject createLockObject(String lockname, Object lockdatakey, String sessionid, String username, boolean isLockForAll) {
        return new LockSingleObjectImpl(lockname, lockdatakey, sessionid, username, isLockForAll);
    }

    private String getSessionIdString(LockSingleObject lo) {
        String sessionid = lo.getSessionId();
        if (sessionid == null || sessionid.equals("")) {
            sessionid = "(empty)";
        }
        return sessionid;
    }

    private String getPrimaryKeyString(LockSingleObject lo) {
        if (lo.isLockForAll()) {
            return "(empty)";
        }
        return this._getPrimaryKeyString(lo.getLockDataKey());
    }

    private String _getPrimaryKeyString(Object o1) {
        if (o1 == null) {
            return null;
        }
        if (o1 instanceof String) {
            return (String)o1;
        }
        if (o1 instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            Object[] oa1 = (Object[])o1;
            for (int i = 0; i < oa1.length; ++i) {
                String s;
                if (i >= 1) {
                    sb.append(",");
                }
                if ((s = this._getPrimaryKeyString(oa1[i])) == null) continue;
                sb.append("\"");
                sb.append(s.replace("\"", "\"\""));
                sb.append("\"");
            }
            return sb.toString();
        }
        return o1.toString();
    }

    @Override
    public synchronized void clearThismachine() {
        this.clear(this.machinename);
        this.lockCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(String machinename) {
        Session session = HibernateUtil.openSession();
        Transaction tx = session.beginTransaction();
        try {
            String expression = "delete from Jfclockobject as c where c.machinename_ = :machinename_";
            Query query = session.createQuery(expression);
            query.setString("machinename_", machinename);
            int cnt = query.executeUpdate();
            tx.commit();
            if (cnt > 0) {
                logger.info("delete " + cnt + " Jfclockobject for machine " + machinename);
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00814), LogCodeManager.getMessage(LogCode.JFC00814, machinename, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            session.close();
        }
    }

    @Override
    public void setDisabledModelIds(String[] disabledModelIds) {
        this.disabledModelIds = new HashSet<String>(Arrays.asList(disabledModelIds));
    }
}

