/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.LockSingleManager;
import jp.jasminesoft.jfc.LockSingleObject;
import jp.jasminesoft.jfc.LockSingleObjectImpl;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockManagerImpl2
implements Serializable,
LockSingleManager {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger((String)LockManagerImpl2.class.getName());
    protected HashMap<String, LockSingleObjectList> lockobjKeyMap;
    protected Set<String> disabledModelIds = new HashSet<String>();

    public LockManagerImpl2() {
        this.lockobjKeyMap = new HashMap();
    }

    @Override
    public synchronized LockSingleObject addLockObject(LockSingleObject lo) {
        if (this.disabledModelIds.contains(lo.getLockName())) {
            return null;
        }
        LockSingleObjectList list = this.lockobjKeyMap.get(lo.getLockName());
        if (list != null) {
            if (!list.isEmpty()) {
                if (lo.isLockForAll()) {
                    LockSingleObject _lo = list.getDifferentSessionIdData(lo.getSessionId());
                    if (_lo != null) {
                        logger.debug(lo + " has already locked (1). canceled.");
                        return _lo;
                    }
                } else {
                    LockSingleObject _lo = list.getLockForAllData();
                    if (_lo != null && !_lo.getSessionId().equals(lo.getSessionId())) {
                        logger.debug(lo + " has already locked all. canceled.");
                        return _lo;
                    }
                    _lo = list.getSamePrimarykeyData(lo);
                    if (_lo != null) {
                        if (_lo.getSessionId().equals(lo.getSessionId())) {
                            logger.debug(lo + " has already locked same session id. skip to add lock object.");
                            return null;
                        }
                        logger.debug(lo + " has locked " + _lo.getUsername() + ". canceled.");
                        return _lo;
                    }
                }
            }
        } else {
            list = new LockSingleObjectList();
            this.lockobjKeyMap.put(lo.getLockName(), list);
        }
        list.add(lo);
        logger.debug("add " + lo);
        return null;
    }

    @Override
    public synchronized boolean isLocked(LockSingleObject lo) {
        if (this.disabledModelIds.contains(lo.getLockName())) {
            return true;
        }
        LockSingleObjectList list = this.lockobjKeyMap.get(lo.getLockName());
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        LockSingleObject _lo = list.getLockForAllData();
        if (_lo != null) {
            if (_lo.getSessionId().equals(lo.getSessionId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug(lo + " has already locked session id is same.");
                }
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(lo + " has already locked. session id is different.");
            }
            return false;
        }
        _lo = list.getSamePrimarykeyData(lo);
        if (_lo != null) {
            if (_lo.getSessionId().equals(lo.getSessionId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug(lo + " has already locked in the same session.");
                }
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(lo + " has locked " + _lo.getUsername() + ". session id is different.");
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("not contains " + lo);
        }
        return false;
    }

    @Override
    public synchronized boolean contains(LockSingleObject lo) {
        LockSingleObjectList list = this.lockobjKeyMap.get(lo.getLockName());
        if (list != null && !list.isEmpty()) {
            if (lo.isLockForAll()) {
                LockSingleObject _lo = list.getDifferentSessionIdData(lo.getSessionId());
                if (_lo != null) {
                    logger.debug(lo + " has already locked (1). session id is different.");
                    return false;
                }
                logger.debug("contains " + lo);
                return true;
            }
            LockSingleObject _lo = list.getLockForAllData();
            if (_lo != null && !_lo.getSessionId().equals(lo.getSessionId())) {
                logger.debug(lo + " has already locked all. session id is different.");
                return true;
            }
            _lo = list.getSamePrimarykeyData(lo);
            if (_lo != null) {
                if (_lo.getSessionId().equals(lo.getSessionId())) {
                    logger.debug(lo + " has already locked. session id is same.");
                    return false;
                }
                logger.debug(lo + " has locked " + _lo.getUsername() + ". session id is different.");
                return true;
            }
        }
        logger.debug("return false." + lo);
        return false;
    }

    protected static boolean equalsPrimaryKey(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Object[]) {
            if (o2 instanceof Object[]) {
                Object[] oa1 = (Object[])o1;
                Object[] oa2 = (Object[])o2;
                if (oa1.length != oa2.length) {
                    return false;
                }
                for (int i = 0; i < oa1.length; ++i) {
                    if (oa1[i].equals(oa2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o2 instanceof Object[]) {
            return false;
        }
        return o1.equals(o2);
    }

    protected static int hashCodePrimaryKey(Object o1) {
        if (o1 == null) {
            return 0;
        }
        if (o1 instanceof Object[]) {
            Object[] oa1 = (Object[])o1;
            int sum = 0;
            for (int i = 0; i < oa1.length; ++i) {
                sum += oa1[i].hashCode();
            }
            return sum;
        }
        return o1.hashCode();
    }

    @Override
    public synchronized String getLockUser(LockSingleObject lo) {
        LockSingleObject _lo = this.getLockObject(lo);
        if (_lo == null) {
            return null;
        }
        return _lo.getUsername();
    }

    public LockSingleObject getLockObject(LockSingleObject lo) {
        LockSingleObjectList list = this.lockobjKeyMap.get(lo.getLockName());
        if (list != null && !list.isEmpty()) {
            if (lo.isLockForAll()) {
                Iterator<LockSingleObject> i = list.getAll().iterator();
                return i.next();
            }
            LockSingleObject _lo = list.getLockForAllData();
            if (_lo != null) {
                return _lo;
            }
            _lo = list.getSamePrimarykeyData(lo);
            if (_lo != null) {
                return _lo;
            }
        }
        return null;
    }

    @Override
    public synchronized boolean releaseLockObject(LockSingleObject lo) {
        LockSingleObjectList list = this.lockobjKeyMap.get(lo.getLockName());
        if (list == null) {
            return false;
        }
        if (lo.isLockForAll()) {
            LockSingleObject _lo = list.getLockForAllData();
            if (_lo != null && _lo.getSessionId().equals(lo.getSessionId())) {
                list.remove(_lo);
                logger.debug("release " + lo);
                return true;
            }
            return false;
        }
        LockSingleObject _lo = list.getSamePrimarykeyData(lo);
        if (_lo != null && _lo.getSessionId().equals(lo.getSessionId())) {
            list.remove(_lo);
            logger.debug("release " + lo);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void remove(String sessionid) {
        for (LockSingleObjectList list : this.lockobjKeyMap.values()) {
            list.removeSessionId(sessionid);
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[LockManagerImpl2 ");
        Iterator<LockSingleObjectList> i = this.lockobjKeyMap.values().iterator();
        while (i.hasNext()) {
            sb.append(i.next().getAll());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public LockSingleObject createLockObject(String key, String sessionid, User user) {
        return new LockSingleObjectImpl(key, null, sessionid, user, false);
    }

    @Override
    public LockSingleObject createLockObject(String modelname, Object pkey, String sessionid, User user) {
        return new LockSingleObjectImpl(modelname, pkey, sessionid, user, false);
    }

    @Override
    public LockSingleObject createLockObjectForAll(String modelname, String sessionid, User user) {
        return new LockSingleObjectImpl(modelname, null, sessionid, user, true);
    }

    @Override
    public LockSingleObject createLockObject(String lockname, Object lockdatakey, String sessionid, String username, boolean isLockForAll) {
        return new LockSingleObjectImpl(lockname, lockdatakey, sessionid, username, isLockForAll);
    }

    @Override
    public synchronized void clearThismachine() {
        this.lockobjKeyMap.clear();
    }

    @Override
    public void clear(String machinename) {
        logger.log(LogCodeManager.getPriority(LogCode.JFC00800), LogCodeManager.getMessage(LogCode.JFC00800, machinename));
    }

    @Override
    public void setDisabledModelIds(String[] disabledModelIds) {
        this.disabledModelIds = new HashSet<String>(Arrays.asList(disabledModelIds));
    }

    private class LockSingleObjectList {
        private Set<LockSingleObject> alldata = new HashSet<LockSingleObject>();
        private HashMap<String, List<LockSingleObject>> sessionidDatas = new HashMap();
        private HashMap<LockSingleObjectPkey, LockSingleObject> pkeyDatas = new HashMap();
        private LockSingleObject lockForAllData;

        private LockSingleObjectList() {
        }

        public boolean isEmpty() {
            return this.alldata.size() == 0;
        }

        public Collection<LockSingleObject> getAll() {
            return this.alldata;
        }

        public LockSingleObject getLockForAllData() {
            return this.lockForAllData;
        }

        public LockSingleObject getDifferentSessionIdData(String sessionid) {
            for (Map.Entry<String, List<LockSingleObject>> e : this.sessionidDatas.entrySet()) {
                if (e.getKey().equals(sessionid)) continue;
                return e.getValue().get(0);
            }
            return null;
        }

        public LockSingleObject getSamePrimarykeyData(LockSingleObject lo) {
            return this.pkeyDatas.get(new LockSingleObjectPkey(lo.getLockDataKey()));
        }

        public void add(LockSingleObject data) {
            this.alldata.add(data);
            if (data.isLockForAll()) {
                this.lockForAllData = data;
            } else {
                this.pkeyDatas.put(new LockSingleObjectPkey(data.getLockDataKey()), data);
            }
            List<LockSingleObject> lolist = this.sessionidDatas.get(data.getSessionId());
            if (lolist == null) {
                lolist = new ArrayList<LockSingleObject>();
                this.sessionidDatas.put(data.getSessionId(), lolist);
            }
            lolist.add(data);
            if (logger.isDebugEnabled()) {
                logger.debug("add " + data);
            }
        }

        private void _remove(LockSingleObject data) {
            this.alldata.remove(data);
            if (data.isLockForAll()) {
                if (this.lockForAllData == data) {
                    this.lockForAllData = null;
                }
            } else {
                this.pkeyDatas.remove(new LockSingleObjectPkey(data.getLockDataKey()));
            }
        }

        private void _removeSessionidDatas(LockSingleObject data) {
            List<LockSingleObject> lolist = this.sessionidDatas.get(data.getSessionId());
            if (lolist == null) {
                return;
            }
            lolist.remove(data);
            if (lolist.size() == 0) {
                this.sessionidDatas.remove(data.getSessionId());
            }
        }

        public void remove(LockSingleObject data) {
            this._remove(data);
            this._removeSessionidDatas(data);
            if (logger.isDebugEnabled()) {
                logger.debug("release " + data);
            }
        }

        public void removeSessionId(String sessionid) {
            List<LockSingleObject> lolist = this.sessionidDatas.get(sessionid);
            if (lolist == null) {
                return;
            }
            for (LockSingleObject data : lolist) {
                this._remove(data);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("release " + data);
            }
            lolist.clear();
            this.sessionidDatas.remove(sessionid);
        }
    }

    private class LockSingleObjectPkey {
        private Object pkey;

        LockSingleObjectPkey(Object o) {
            this.pkey = o;
        }

        public boolean equals(Object o) {
            return LockManagerImpl2.equalsPrimaryKey(this.pkey, ((LockSingleObjectPkey)o).pkey);
        }

        public int hashCode() {
            int code = LockManagerImpl2.hashCodePrimaryKey(this.pkey);
            return code;
        }
    }
}

