/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ClusterManager;
import jp.jasminesoft.jfc.ClusterManagerFactory;
import jp.jasminesoft.jfc.JFCDataAccessManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatus;
import jp.jasminesoft.jfc.LogonStatusManagerMBean;
import jp.jasminesoft.jfc.MBeanServerConnectionFactoryBeanWrapper;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.controller.MobileMenuController;
import jp.jasminesoft.jfc.core.util.IOUtils;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.textsearch.servlet.MakeTextIndex;
import jp.jasminesoft.jfc.tools.appid.ApplicationID;
import jp.jasminesoft.jfc.tools.appid.ApplicationIDGenerator;
import jp.jasminesoft.util.JaxbUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LogonStatusManager
implements LogonStatusManagerMBean,
ApplicationContextAware,
ServletContextAware {
    private static String ae1;
    private static final String InternetAccount_UsernameHeader = "internet";
    private Map<String, Long> usernameMap = Collections.synchronizedMap(new HashMap());
    private Set<String> internetaccount_sessionidSet;
    private Map<String, User> userObjectMap = Collections.synchronizedMap(new HashMap());
    private LogonStatusBox logonStatusBox;
    private static final Logger logger;
    private static Logger logger2;
    private static ApplicationContext applicationContext;
    public static final ObjectName objname;
    private ServletContext sc;
    private Object[] oa;
    @Value(value="${wagby.redis.logonStatus:false}")
    private boolean isRedisStore;
    private RedisHandler redisHandler = null;

    public void setServletContext(ServletContext arg0) {
        this.sc = arg0;
        this.init();
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        applicationContext = arg0;
        this.init();
    }

    @Deprecated
    public static LogonStatusManager getInstance() {
        if (applicationContext != null) {
            return (LogonStatusManager)applicationContext.getBean(LogonStatusManager.class);
        }
        return null;
    }

    private LogonStatusManager() {
        this.internetaccount_sessionidSet = new HashSet<String>();
    }

    public void printStatus() {
        logger2.info(this.getStatusString());
    }

    public String getStatusString() {
        StringBuilder sb = new StringBuilder();
        sb.append("usernameMap:");
        sb.append(this.usernameMap);
        sb.append("\n");
        sb.append("userObjectMap:");
        sb.append(this.userObjectMap);
        sb.append("\n");
        sb.append("logonStatusMap:");
        sb.append(this.logonStatusBox);
        sb.append("\n");
        sb.append("internetaccount_sessionidSet:");
        sb.append(this.internetaccount_sessionidSet);
        sb.append("\n");
        return sb.toString();
    }

    private void init() {
        if (this.sc == null || applicationContext == null) {
            return;
        }
        try {
            this.a();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                try {
                    msg = LogonStatusManager.decode("T055i4x1gPR8-4x5fQ5ajQ57glnYj3RejQ4");
                }
                catch (Exception e1) {
                    msg = "";
                }
            }
            logger2.error(msg);
        }
        this.logonStatusBox = new LogonStatusBox();
        if (this.isRedisStore) {
            this.usernameMap = null;
            this.userObjectMap = null;
            this.internetaccount_sessionidSet = null;
            this.redisHandler = new RedisHandler();
        }
    }

    public int getCount() {
        if (this.isRedisStore) {
            return this.redisHandler.getCount();
        }
        return this.usernameMap.size();
    }

    public long getSessionCount() {
        if (this.isRedisStore) {
            return this.redisHandler.getSessionCount();
        }
        return this.userObjectMap.size();
    }

    private boolean isInternetAccount(String username) {
        return username.startsWith(InternetAccount_UsernameHeader);
    }

    public synchronized boolean check(String username) {
        int internetaccount_limit;
        long max_logon;
        if (username == null || username.length() == 0) {
            return false;
        }
        try {
            Object[] oa = this.a();
            max_logon = (Long)oa[2];
            internetaccount_limit = (Integer)oa[3];
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                try {
                    msg = LogonStatusManager.decode("T055i4x1gPR8-4x5fQ5ajQ57glnYj3RejQ4");
                }
                catch (Exception e1) {
                    msg = "";
                }
            }
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90001), LogCodeManager.getMessage(LogCode.JFC90001, username, msg));
            return false;
        }
        if (max_logon < 0L) {
            return true;
        }
        long count = this.getSessionCount();
        if (internetaccount_limit > 0) {
            count -= (long)this.internetaccount_sessionidSet.size();
            if (this.isInternetAccount(username)) {
                HashSet<String> set = new HashSet<String>();
                for (String sessionId : this.internetaccount_sessionidSet) {
                    User user = this.userObjectMap.get(sessionId);
                    set.add(user.getUsername());
                }
                set.add(username);
                int internetaccount_logon = set.size();
                return internetaccount_limit >= internetaccount_logon;
            }
        }
        if (count + 1L > max_logon && max_logon >= 0L) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC00019), LogCodeManager.getMessage(LogCode.JFC00019, username, String.valueOf(count), String.valueOf(max_logon)));
            return false;
        }
        return true;
    }

    public synchronized boolean addUserName(String username, int max_multiple_logon_size) {
        int internetaccount_limit;
        if (username == null || username.length() == 0) {
            return false;
        }
        try {
            Object[] oa = this.a();
            internetaccount_limit = (Integer)oa[3];
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                try {
                    msg = LogonStatusManager.decode("T055i4x1gPR8-4x5fQ5ajQ57glnYj3RejQ4");
                }
                catch (Exception e1) {
                    msg = "";
                }
            }
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90001), LogCodeManager.getMessage(LogCode.JFC90001, username, msg));
            return false;
        }
        boolean retFlag = true;
        Long _multiple = null;
        if (this.isHeaderAuthentication()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90024), LogCodeManager.getMessage(LogCode.JFC90024, username));
            return true;
        }
        if (this.isRedisStore) {
            _multiple = this.redisHandler.getCount(username) + 1L;
            if (!(_multiple <= (long)max_multiple_logon_size || max_multiple_logon_size < 1 || internetaccount_limit > 0 && this.isInternetAccount(username))) {
                retFlag = false;
            }
        } else {
            _multiple = this.usernameMap.get(username);
            if (_multiple == null) {
                _multiple = 1L;
                this.usernameMap.put(username, _multiple);
            } else {
                long m = _multiple;
                if (!(++m <= (long)max_multiple_logon_size || max_multiple_logon_size < 1 || internetaccount_limit > 0 && this.isInternetAccount(username))) {
                    retFlag = false;
                } else {
                    _multiple = m;
                    this.usernameMap.put(username, _multiple);
                }
            }
        }
        if (retFlag) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90000), LogCodeManager.getMessage(LogCode.JFC90000, username, String.valueOf(_multiple.intValue()), String.valueOf(this.getSessionCount() + 1L)));
        }
        return retFlag;
    }

    public boolean isHeaderAuthentication() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return false;
        }
        return JFCUtils.isRestAPIWithHeaderAuth(((ServletRequestAttributes)requestAttributes).getRequest());
    }

    public synchronized void removeUserName(String username) {
        if (username == null || username.length() == 0) {
            return;
        }
        if (this.isHeaderAuthentication()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90025), LogCodeManager.getMessage(LogCode.JFC90025, username));
            return;
        }
        if (this.isRedisStore) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90003), LogCodeManager.getMessage(LogCode.JFC90003, username, String.valueOf(this.redisHandler.getCount(username)), String.valueOf(Math.max(0L, this.getSessionCount()))));
            return;
        }
        Long _multiple = this.usernameMap.get(username);
        if (_multiple == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90002), LogCodeManager.getMessage(LogCode.JFC90002, username));
            this.usernameMap.remove(username);
        } else {
            long m = _multiple;
            if (--m <= 0L) {
                this.usernameMap.remove(username);
                m = 0L;
            } else {
                _multiple = m;
                this.usernameMap.put(username, _multiple);
            }
            logger.log(LogCodeManager.getPriority(LogCode.JFC90003), LogCodeManager.getMessage(LogCode.JFC90003, username, String.valueOf(m), String.valueOf(Math.max(0L, this.getSessionCount() - 1L))));
        }
    }

    public synchronized boolean registerUserObject(User user) {
        if (user == null) {
            return false;
        }
        if (this.isRedisStore) {
            return true;
        }
        String username = user.getUsername();
        HttpSession session = user.getSession();
        String sessionId = session.getId();
        this.userObjectMap.put(sessionId, user);
        this.logonStatusBox.putLogonStatus(sessionId, user);
        if (this.isInternetAccount(username)) {
            this.internetaccount_sessionidSet.add(sessionId);
        }
        return true;
    }

    public LogonStatus getLogonStatus(String sessionId) {
        return this.logonStatusBox.get(sessionId);
    }

    public LogonStatus createLogonStatus(String sessionId) {
        User user = this.userObjectMap.get(sessionId);
        if (user == null) {
            return null;
        }
        return this.createLogonStatus(user);
    }

    private LogonStatus createLogonStatus(User user) {
        HttpSession session = user.getSession();
        String sessionId = session.getId();
        long creationTime = session.getCreationTime();
        long lastAccessedTime = session.getLastAccessedTime();
        long maxInactiveInterval = session.getMaxInactiveInterval();
        return this.createLogonStatus(user, sessionId, creationTime, lastAccessedTime, maxInactiveInterval);
    }

    private LogonStatus createLogonStatus(User user, String sessionId, long creationTime, long lastAccessedTime, long maxInactiveInterval) {
        String username = user.getUsername();
        String jusername = null;
        IJuser juser = user.getJuser();
        if (juser != null && StringUtils.isEmpty((String)(jusername = juser.getName()))) {
            jusername = username;
        }
        LogonStatus logonStatus = new LogonStatus(username, jusername, sessionId, creationTime);
        logonStatus.setLastAccessedTime(lastAccessedTime);
        logonStatus.setMaxInactiveInterval(maxInactiveInterval);
        return logonStatus;
    }

    public boolean releaseUserObject(String username, String sessionId, String machinename) {
        MBeanServerConnectionFactoryBeanWrapper[] beans;
        ClusterManager cluster_man = ClusterManagerFactory.getClusterManager();
        boolean isCluster = cluster_man.getUseCluster();
        String thisMachineName = cluster_man.getThisMachinename();
        if (!isCluster || thisMachineName.equals(machinename)) {
            return this.releaseUserObject(username, sessionId);
        }
        ClusterManager clusterman = ClusterManagerFactory.getClusterManager();
        for (MBeanServerConnectionFactoryBeanWrapper bean : beans = clusterman.getMBeanServerConnectionFactoryBeanWrapperList()) {
            if (!bean.getMachineName().equals(machinename)) continue;
            MBeanServerConnection mbsc = bean.getMBeanServerConnection(objname);
            if (mbsc == null) {
                return false;
            }
            LogonStatusManagerMBean lsman_mbean = MBeanServerInvocationHandler.newProxyInstance(mbsc, objname, LogonStatusManagerMBean.class, false);
            return lsman_mbean.releaseUserObject(username, sessionId);
        }
        return false;
    }

    public synchronized boolean releaseLastUserObject(String username) {
        if (username == null) {
            return false;
        }
        if (this.isRedisStore) {
            return this.redisHandler.releaseLastUserObject(username);
        }
        TreeMap<Long, User> cmap = new TreeMap<Long, User>();
        for (User tmpUser : this.userObjectMap.values()) {
            long t;
            if (!username.equals(tmpUser.getUsername())) continue;
            HttpSession session_ = tmpUser.getSession();
            try {
                if (session_ == null || session_.getId() == null) continue;
                t = session_.getLastAccessedTime();
            }
            catch (IllegalStateException e) {
                continue;
            }
            cmap.put(t, tmpUser);
        }
        if (cmap.size() == 0) {
            return false;
        }
        Long[] ls = cmap.keySet().toArray(new Long[0]);
        User oldUser = (User)cmap.get(ls[0]);
        try {
            oldUser.getSession().invalidate();
        }
        catch (IllegalStateException ex) {
            logger.debug("failed session.invalidate", (Throwable)ex);
        }
        oldUser = null;
        return true;
    }

    @Override
    public synchronized boolean releaseUserObject(String username, String sessionId) {
        block16: {
            if (username == null) {
                logger.debug("cannot release user object. username is null.");
                return false;
            }
            if (sessionId == null || sessionId.trim().length() == 0) {
                logger.debug("cannot release user object. sessionId is empty or null. user :" + username);
                this.removeUserName(username);
                return false;
            }
            if (this.isRedisStore) {
                boolean success = this.redisHandler.releaseUserObject(username, sessionId);
                if (success) {
                    this.removeUserName(username);
                }
                return success;
            }
            if (!this.userObjectMap.containsKey(sessionId)) {
                boolean ignore = false;
                StackTraceElement[] elements = new Throwable().getStackTrace();
                for (int i = 2; i < elements.length; ++i) {
                    if (!this.getClass().getName().equals(elements[i].getClassName()) || !"releaseUserObject".equals(elements[i].getMethodName())) continue;
                    ignore = true;
                    break;
                }
                if (!ignore) {
                    logger.debug("cannot release user object. cannot get user object by the sessionId. user :" + username + ", sessionId :" + sessionId);
                }
                return false;
            }
            User tmpUser = this.userObjectMap.get(sessionId);
            String tmpSessionId = "";
            try {
                HttpSession tmpSession = tmpUser.getSession();
                if (tmpSession != null && tmpSession.getId() != null) {
                    tmpSessionId = tmpSession.getId();
                    this.removeUserName(username);
                    User oldUser = tmpUser;
                    this.logonStatusBox.remove(sessionId);
                    if (this.isInternetAccount(username)) {
                        this.internetaccount_sessionidSet.remove(sessionId);
                    }
                    this.userObjectMap.remove(sessionId);
                    try {
                        oldUser.getSession().invalidate();
                    }
                    catch (IllegalStateException ex) {
                        logger.debug("occur IllegalStateException", (Throwable)ex);
                    }
                    oldUser = null;
                    if (tmpSessionId.equals(sessionId)) {
                        logger.debug("user object was successfully released. user :" + username + ", sessionId :" + sessionId);
                    } else {
                        logger.debug("current sessionId differs from init sessionId.but user object was successfully released. current sessionId :" + tmpSessionId + ", init sessionId :" + sessionId);
                    }
                    break block16;
                }
                throw new IllegalStateException();
            }
            catch (IllegalStateException ise) {
                this.removeUserName(username);
                this.userObjectMap.remove(sessionId);
                this.logonStatusBox.remove(sessionId);
                if (this.isInternetAccount(username)) {
                    this.internetaccount_sessionidSet.remove(sessionId);
                }
                logger.debug("IllegalStateException is thrown.but user object was successfully released. current sessionId :" + tmpSessionId + ", init sessionId :" + sessionId, (Throwable)ise);
            }
        }
        return true;
    }

    public LogonStatus[] getCurrentLogonUsers() {
        LogonStatus[] ls_array;
        MBeanServerConnectionFactoryBeanWrapper[] beans;
        ArrayList<LogonStatus> list = new ArrayList<LogonStatus>();
        ClusterManager clusterman = ClusterManagerFactory.getClusterManager();
        String thisMachineName = clusterman.getThisMachinename();
        for (MBeanServerConnectionFactoryBeanWrapper bean : beans = clusterman.getMBeanServerConnectionFactoryBeanWrapperList()) {
            LogonStatus[] ls_array2;
            LogonStatusManagerMBean lsman_mbean;
            MBeanServerConnection mbsc = bean.getMBeanServerConnection(objname);
            if (mbsc == null || (lsman_mbean = MBeanServerInvocationHandler.newProxyInstance(mbsc, objname, LogonStatusManagerMBean.class, false)) == null) continue;
            for (LogonStatus logonstatus : ls_array2 = lsman_mbean.getCurrentLogonUsers(thisMachineName)) {
                logonstatus.setMachinename(bean.getMachineName());
                list.add(logonstatus);
            }
        }
        for (LogonStatus logonstatus : ls_array = this.getCurrentLogonUsers_local()) {
            logonstatus.setMachinename(clusterman.getThisMachinename());
            list.add(logonstatus);
        }
        return list.toArray(new LogonStatus[0]);
    }

    @Override
    public LogonStatus[] getCurrentLogonUsers(String machinename) {
        ClusterManagerFactory.getClusterManager().checkActive(machinename);
        return this.getCurrentLogonUsers_local();
    }

    public LogonStatus[] getCurrentLogonUsers_local() {
        Collection<LogonStatus> col = this.logonStatusBox.values();
        return col.toArray(new LogonStatus[0]);
    }

    public synchronized void setLastAccessedTimeBySessionId(String sessionId, long lastAccessedTime) {
        this.logonStatusBox.updateLastAccessedTime(sessionId, lastAccessedTime);
    }

    public boolean checkInsertAvailable(ActionParameter p) {
        int datacountall_limit;
        String username = p.user.getUsername();
        try {
            Object[] oa = this.a();
            datacountall_limit = (Integer)oa[1];
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                try {
                    msg = LogonStatusManager.decode("T055i4x1gPR8-4x5fQ5ajQ57glnYj3RejQ4");
                }
                catch (Exception e1) {
                    msg = "";
                }
            }
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90004), LogCodeManager.getMessage(LogCode.JFC90004, username, msg));
            return false;
        }
        if (datacountall_limit <= 0) {
            return true;
        }
        JFCDataAccessManager dam = (JFCDataAccessManager)applicationContext.getBean("JFCDataAccessManager");
        if (dam == null) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90005), LogCodeManager.getMessage(LogCode.JFC90005, new String[0]));
            return false;
        }
        int count = dam.getCountAll(p);
        if (count >= 0 && count < datacountall_limit) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90006), LogCodeManager.getMessage(LogCode.JFC90006, String.valueOf(count)));
            return true;
        }
        logger2.log(LogCodeManager.getPriority(LogCode.JFC90007), LogCodeManager.getMessage(LogCode.JFC90007, username, String.valueOf(count)));
        return false;
    }

    public boolean checkMaxAccount(User user) {
        long maxAccount;
        try {
            maxAccount = this.getMaxAccount(user);
        }
        catch (IllegalStateException e) {
            return false;
        }
        if (maxAccount < 0L) {
            return true;
        }
        if (maxAccount == 0L) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90016), LogCodeManager.getMessage(LogCode.JFC90016, new String[0]));
            return false;
        }
        int count = this.getUserCount();
        if (count < 0) {
            return false;
        }
        if ((long)count > maxAccount) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90017), LogCodeManager.getMessage(LogCode.JFC90017, user.getUsername(), String.valueOf(count), String.valueOf(maxAccount)));
            return false;
        }
        return true;
    }

    private long getMaxAccount(User user) {
        try {
            Object[] oa = this.a();
            return (Long)oa[5];
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                try {
                    msg = LogonStatusManager.decode("T055i4x1gPR8-4x5fQ5ajQ57glnYj3RejQ4");
                }
                catch (Exception e1) {
                    msg = "";
                }
            }
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90001), LogCodeManager.getMessage(LogCode.JFC90001, user.getUsername(), msg));
            throw new IllegalStateException(e);
        }
    }

    private int getUserCount() {
        int count = -1;
        try {
            ActionParameter adminp = ActionParameter.createActionParameter(logger2, "", applicationContext);
            count = ((JFCDataAccessManager)applicationContext.getBean("JFCDataAccessManager", JFCDataAccessManager.class)).getCount("juser", adminp);
        }
        catch (Exception e) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90018), LogCodeManager.getMessage(LogCode.JFC90018, new String[0]), (Throwable)e);
        }
        return count;
    }

    public boolean isAccountAddable(User user) {
        long maxAccount;
        try {
            maxAccount = this.getMaxAccount(user);
        }
        catch (IllegalStateException e) {
            return false;
        }
        if (maxAccount < 0L) {
            return true;
        }
        if (maxAccount == 0L) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90019), LogCodeManager.getMessage(LogCode.JFC90019, new String[0]));
            return false;
        }
        int count = this.getUserCount();
        if (count < 0) {
            return false;
        }
        if ((long)count > maxAccount - 1L) {
            logger2.log(LogCodeManager.getPriority(LogCode.JFC90020), LogCodeManager.getMessage(LogCode.JFC90020, user.getUsername(), String.valueOf(count), String.valueOf(maxAccount)));
            return false;
        }
        return true;
    }

    public boolean checkSystemMaxLogon(int sysMaxLogon) {
        if (sysMaxLogon < 1) {
            return true;
        }
        if (this.isRedisStore && this.isHeaderAuthentication()) {
            return true;
        }
        return this.getSessionCount() + 1L <= (long)sysMaxLogon;
    }

    private Object[] a() throws Exception {
        Object[] oa = this.b();
        Long oa4 = (Long)oa[4];
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(oa4);
        cal1.add(2, 1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTimeInMillis(System.currentTimeMillis());
        if (cal1.before(cal2)) {
            throw new IllegalStateException(LogonStatusManager.decode("pE-cNY-iOYG6QI-9OZjpOUqeBE+ixJDqRtq6QJndRti6SsLoTc-9OM"));
        }
        return oa;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] b() throws Exception {
        Long timestamp = null;
        String key = null;
        InputStream is = null;
        try {
            File f = new File(this.sc.getRealPath(ae1));
            timestamp = new Long(f.lastModified());
            if (this.oa != null && this.oa.length > 1 && timestamp.equals((Long)this.oa[0])) {
                Object[] objectArray = (Object[])this.oa.clone();
                return objectArray;
            }
            this.oa = null;
            is = new FileInputStream(f);
            if (is != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                Element elem = doc.getDocumentElement();
                Node node = elem.getFirstChild();
                StringBuffer buf = new StringBuffer();
                while (node instanceof Text) {
                    buf.append(node.getNodeValue());
                    if ((node = node.getNextSibling()) != null) continue;
                }
                key = buf.toString();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(LogonStatusManager.decode("FB7F1Njd6Ioo2MsaNx8f2gIk6gIh2N-630Yi2M"));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (this.oa == null) {
                Enumeration e = this.sc.getAttributeNames();
                while (e.hasMoreElements()) {
                    String attributeName = (String)e.nextElement();
                    if (!attributeName.startsWith(LogonStatusManager.decode("FKE51h0c2gki3MAb51Ab3Ngc5gk"))) continue;
                    this.sc.removeAttribute(attributeName);
                }
            }
        }
        if (key == null) {
            throw new IllegalStateException(LogonStatusManager.decode("tmiXRJXxSJClVZHmSpnxTJzqU+zqUdHKBtLuUtE"));
        }
        boolean is_test_use = false;
        long max_logon = -1L;
        int datacountall_limit = 0;
        int internetaccount_limit = 0;
        String applicationId = null;
        boolean is_google_maps = false;
        boolean is_text_search = false;
        boolean is_workflow = false;
        boolean is_mobile = false;
        boolean is_alloption_enable = false;
        long use_limit_date = 0L;
        long max_account = -1L;
        String devMachineId = null;
        boolean success = false;
        if (key != null && key.length() > 2 && key.charAt(0) == '1' && key.charAt(1) == '1') {
            try {
                long l;
                int VersionLen = 2;
                byte[] ba1 = LogonStatusManager.StringToByteArray(key.substring(2));
                if (ba1.length < 2) {
                    throw new IllegalArgumentException();
                }
                byte[] ba2 = new byte[ba1.length - 2];
                byte randombyte = ba1[0];
                int checkbyte = 0;
                for (int i = 2; i < ba1.length; ++i) {
                    byte b;
                    checkbyte = (byte)(checkbyte + ba1[i]);
                    ba2[i - 2] = b = (byte)(ba1[i] - randombyte);
                }
                if (ba1[1] != checkbyte) {
                    throw new IllegalArgumentException();
                }
                String key0 = new String(ba2, "8859_1");
                Iterator<String> it = Arrays.asList(key0.split(Pattern.quote("+"))).iterator();
                String s = it.next();
                if (!"w7".equals(s)) {
                    throw new IllegalArgumentException();
                }
                s = it.next();
                s = it.next();
                s = it.next();
                int i = Integer.parseInt(s, 36);
                s = it.next();
                i = Integer.parseInt(s, 36);
                s = it.next();
                i = Integer.parseInt(s, 36);
                s = it.next();
                use_limit_date = l = Long.parseLong(s, 36);
                s = it.next();
                if (s.equals("t")) {
                    is_test_use = true;
                } else {
                    if (!s.equals("f")) throw new IllegalArgumentException();
                    is_test_use = false;
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                    max_logon = l = Long.parseLong(s, 36);
                } else {
                    max_logon = -1L;
                }
                if (it.hasNext()) {
                    s = it.next();
                }
                if (it.hasNext()) {
                    s = it.next();
                }
                if (it.hasNext()) {
                    s = it.next();
                    datacountall_limit = i = Integer.parseInt(s, 36);
                } else {
                    datacountall_limit = 0;
                }
                if (it.hasNext()) {
                    s = it.next();
                    internetaccount_limit = i = Integer.parseInt(s, 36);
                } else {
                    internetaccount_limit = 0;
                }
                if (it.hasNext()) {
                    s = it.next();
                    if (s.equals("t")) {
                        is_alloption_enable = true;
                    } else {
                        if (!s.equals("f")) throw new IllegalArgumentException();
                        is_alloption_enable = false;
                    }
                } else {
                    is_alloption_enable = false;
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                    if (s.equals("t")) {
                        is_google_maps = true;
                    } else {
                        if (!s.equals("f")) throw new IllegalArgumentException();
                        is_google_maps = is_alloption_enable;
                    }
                } else {
                    is_google_maps = is_alloption_enable;
                }
                if (it.hasNext()) {
                    s = it.next();
                    if (s.equals("t")) {
                        is_workflow = true;
                    } else {
                        if (!s.equals("f")) throw new IllegalArgumentException();
                        is_workflow = is_alloption_enable;
                    }
                } else {
                    is_workflow = is_alloption_enable;
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                    if (s.equals("t")) {
                        is_mobile = true;
                    } else {
                        if (!s.equals("f")) throw new IllegalArgumentException();
                        is_mobile = is_alloption_enable;
                    }
                } else {
                    is_mobile = is_alloption_enable;
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                    if (s.equals("t")) {
                        is_text_search = true;
                    } else {
                        if (!s.equals("f")) throw new IllegalArgumentException();
                        is_text_search = is_alloption_enable;
                    }
                } else {
                    is_text_search = is_alloption_enable;
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    applicationId = s = it.next();
                }
                if (it.hasNext()) {
                    s = it.next();
                    max_account = l = Long.parseLong(s, 36);
                    if (max_logon < 0L) {
                        max_logon = max_account;
                    }
                } else {
                    max_account = -1L;
                }
                if (it.hasNext() && !(s = it.next()).equals("t") && !s.equals("f")) {
                    throw new IllegalArgumentException();
                }
                if (it.hasNext()) {
                    s = it.next();
                    if (!StringUtils.isBlank((String)s) && s.length() != 12) throw new IllegalArgumentException("v3-1");
                    devMachineId = s;
                }
                if (it.hasNext()) {
                    s = it.next();
                }
                if (it.hasNext()) {
                    s = it.next();
                }
                success = true;
            }
            catch (Exception VersionLen) {
                // empty catch block
            }
        }
        if (!is_test_use && StringUtils.isBlank(devMachineId)) {
            boolean isMatch = false;
            if (StringUtils.isNotBlank(applicationId)) {
                ApplicationIDGenerator tool = ApplicationIDGenerator.getInstance();
                ApplicationID[] thisMachines = tool.createCandidates();
                if (thisMachines == null) {
                    logger2.log(LogCodeManager.getPriority(LogCode.JFC90008), LogCodeManager.getMessage(LogCode.JFC90008, new String[0]));
                } else if (thisMachines.length == 0) {
                    logger2.log(LogCodeManager.getPriority(LogCode.JFC90009), LogCodeManager.getMessage(LogCode.JFC90009, new String[0]));
                }
                if (thisMachines != null && thisMachines.length > 0) {
                    for (ApplicationID thisMachine : thisMachines) {
                        if (!thisMachine.match(applicationId)) continue;
                        isMatch = true;
                        break;
                    }
                }
            }
            if (!isMatch) {
                logger2.log(LogCodeManager.getPriority(LogCode.JFC90010), LogCodeManager.getMessage(LogCode.JFC90010, new String[0]));
                applicationId = null;
                internetaccount_limit = 0;
                max_logon = 2L;
            }
        }
        if (!success) {
            throw new IllegalStateException(LogonStatusManager.decode("UKEHjAV7ikde0AVbhktglktdhRI"));
        }
        if (!is_test_use && StringUtils.isBlank(applicationId) && StringUtils.isBlank(devMachineId)) {
            ResourceBundle rb = ResourceBundle.getBundle(LogonStatusManager.decode("619Wzo64v8i7vM"));
            String build_timestamp = rb.getString(LogonStatusManager.decode("y0HG-v7QXbrYYvnJ+-PFZvw"));
            try {
                Date build_date = new SimpleDateFormat(LogonStatusManager.decode("oejpStDpzqSJzsj4wcz8CITdCJfj")).parse(build_timestamp);
                Calendar cal1 = Calendar.getInstance();
                cal1.setTime(build_date);
                cal1.add(5, 14);
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(new Date());
                if (cal1.before(cal2)) {
                    throw new IllegalStateException(LogonStatusManager.decode("iCCMGXeSHWVGJHeJHXyZHSFOv7dSqHS+KrFGJHCNKrxGLq+YMbeJHM"));
                }
            }
            catch (ParseException e) {
                throw new IllegalStateException(LogonStatusManager.decode("tarqRtTwStykUdTnSubDSpisFVSwBevEU+ikUefrU+akVZDCWJTnSg"));
            }
        }
        if (StringUtils.isNotBlank(devMachineId)) {
            InputStream inputStream = null;
            String devMachine = null;
            try {
                inputStream = this.getClass().getResourceAsStream(LogonStatusManager.decode("p8+jOcDqQsn7PcTiOg"));
                if (inputStream != null) {
                    ObjectInputStream ois = new ObjectInputStream(inputStream);
                    Object obj = ois.readObject();
                    if (obj == null || !(obj instanceof String)) {
                        throw new IllegalStateException(LogonStatusManager.decode("bBykzVuqAV9eCFuhAVOxAQVmnRVrnRtqjG6yDpVeCFSlDpNeEpewF9uhAM"));
                    }
                    devMachine = (String)obj;
                }
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException(LogonStatusManager.decode("YphnkBFtlBkhnlFklBZAlx4p8y4u8NEt4mhBo64hnm1oo5Yhp5pzpRFklw"));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            if (devMachine == null) {
                throw new IllegalStateException(LogonStatusManager.decode("efiuCq6ADpNoFa6rDqqHDlxwqmxBqS5AmaKIFWxoFauvFWpoGVSGHG6rDg"));
            }
            if (!devMachineId.equals(devMachine)) {
                throw new IllegalStateException(LogonStatusManager.decode("xkHHVKXNWKCBYuXEWLfUWGmJJHmOKqWNFvzVZfmBYvjIZfeB+eHT++XEWw"));
            }
        }
        boolean use_google_maps = false;
        String googlemapkey = null;
        try {
            googlemapkey = (String)applicationContext.getBean(LogonStatusManager.decode("lauXMYeXMbD1JsiPLXDd"));
        }
        catch (NoSuchBeanDefinitionException e) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(googlemapkey)) {
            if (!is_google_maps) {
                throw new IllegalStateException(LogonStatusManager.decode("eP6xDaiDE9ZrFWiuEaCKE5JzrShDmWWLGGJrFWGyGGBrHG2JIqiuE0"));
            }
            use_google_maps = true;
        }
        boolean use_workflow = false;
        Map ret = null;
        try {
            Object obj = applicationContext.getBean(LogonStatusManager.decode("63FynBJsuoNVmnJXvoKbpnC6unZZyw"));
            String packageName = obj.getClass().getPackage().getName();
            Class<?> clazz = Class.forName(packageName + LogonStatusManager.decode("SAI8920t6QFabzIYhzZ8eQs-"));
            Method method = clazz.getMethod(LogonStatusManager.decode("QqkUdAkEg4cYdPR0i1V0djoZ7P8+dAg"), String.class);
            ret = (Map)method.invoke(null, new Object[]{null});
        }
        catch (Exception e) {
            throw new IllegalStateException(LogonStatusManager.decode("8DO8wUKexUp2zEK5xV2lxQ9alQJegFmmAp92zF69Ap12BoukC8K5xM") + " :" + e.getClass().getSimpleName());
        }
        if (ret != null && ret.size() > 0) {
            if (!is_workflow) {
                throw new IllegalStateException(LogonStatusManager.decode("G64e2h4k3gP8514b3hor3szgTJ7kO1Is5Nz851sf5Nr86MQq7x4b3g"));
            }
            use_workflow = true;
        }
        boolean use_text_search = false;
        try {
            MakeTextIndex makeTextIndex = (MakeTextIndex)applicationContext.getBean(LogonStatusManager.decode("9vNOxF2auoGtCmWjyoGt"));
            if (makeTextIndex.sizeIndexInfo() > 0) {
                if (!is_text_search) {
                    throw new IllegalStateException(LogonStatusManager.decode("ewWwCWeCDVVqFGetDWyJDRFysmdCmGSKGqFqFGCxGqxqHp+IIaetDM"));
                }
                use_text_search = true;
            }
        }
        catch (NoSuchBeanDefinitionException makeTextIndex) {
            // empty catch block
        }
        boolean use_mobile = false;
        try {
            URL url = MobileMenuController.getAppmenu(this.sc);
            Menubar menubar = (Menubar)JaxbUtil.unmarshal((URL)url, Menubar.class);
            if (menubar.getMenu().length > 0) {
                if (!is_mobile) {
                    throw new IllegalStateException(LogonStatusManager.decode("gfeCEqCIFqhwHaCzFqWPFm1Eu6BIobeQHX1wHa+DHWVwIWmOJGCzFg"));
                }
                use_mobile = true;
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(LogonStatusManager.decode("Hi8j3xop4x7d6hog4xIw4ITlVJrpPi0x71Td6hMk71Ld818v8Nog4w") + " :" + e.getClass().getSimpleName());
        }
        if (this.isRedisStore && max_logon >= 0L) {
            throw new IllegalStateException(LogonStatusManager.decode("2dlKqn5QrmMEt75HrnpXriwMejANd2xXv7tUa7hTrTtSa7JJuDVNqSQ"));
        }
        boolean is_mismatch_applicationId = false;
        if (!is_test_use && StringUtils.isBlank(applicationId) && StringUtils.isBlank((String)devMachineId)) {
            is_mismatch_applicationId = true;
        }
        this.sc.setAttribute(LogonStatusManager.decode("ZoNkl5Zrm5hxnBxqoSxqnCdrp5hFmCxFl6FEmw"), (Object)is_test_use);
        this.sc.setAttribute(LogonStatusManager.decode("6SNWuEm1vDG7x7W0yoW0x8C1yDG8x8W8v8Z+wTFYyUK7x7VYzUiaymh-"), (Object)is_mismatch_applicationId);
        this.sc.setAttribute(LogonStatusManager.decode("QgQMc3ITd30ZezgSfQgSezYTg30+cAAMfk0Ug3Y"), (Object)max_logon);
        this.sc.setAttribute(LogonStatusManager.decode("bcObyVqizUKoBo+hCF+hBpGiCUKpzqibzo+fCW6qE0"), (Object)max_account);
        this.sc.setAttribute(LogonStatusManager.decode("7GhZvoy4wnSaxU63z963xUO4znS7z9a3A8O3AD+1woSjz99ZyEubxV8"), (Object)internetaccount_limit);
        this.sc.setAttribute(LogonStatusManager.decode("sirgQdLnRd3tSJjmT+jmSJ-nUd3qVd3oUe3oTtrgTJbxV0"), (Object)is_google_maps);
        this.sc.setAttribute(LogonStatusManager.decode("5UZStE5ZuDq3w7FYxoFYw8lZxDq0yDqexEC2voe6zw"), (Object)is_workflow);
        this.sc.setAttribute(LogonStatusManager.decode("mTeWKIn1LHH7NbX0OsX0NcD1OHH4PHHfMdffKIX0LcS+MM"), (Object)is_text_search);
        this.sc.setAttribute(LogonStatusManager.decode("VQV6hB5diApjk4FcllFck5ldlApgmApklABgkQM"), (Object)is_mobile);
        if (use_limit_date < 32503647600000L) {
            this.sc.setAttribute(LogonStatusManager.decode("-+punCBBoBVHq69Arn9Aq6RBrBVQsChuqSxIq7duoS1Pp0"), (Object)use_limit_date);
        }
        this.sc.setAttribute(LogonStatusManager.decode("LNou7yAB8xUHa28Abj8Aa2QBbxUQcygu9yUK9yIA7yMwbP8"), (Object)use_google_maps);
        this.sc.setAttribute(LogonStatusManager.decode("5LBRto1Yunm2vTBXx8BXvUhYxnmbynJRzom8wnO2xoQ"), (Object)use_workflow);
        this.sc.setAttribute(LogonStatusManager.decode("qeP7NZbeOYvkQsLdRJLdQtreRYvtSYT7TcTwTcvrPsDqOZ0"), (Object)use_text_search);
        this.sc.setAttribute(LogonStatusManager.decode("2lVEq7dLr6xRsCNKtTNKsDtLu6x+v6VEtDxHsDlK"), (Object)use_mobile);
        boolean needs_pro_plus = false;
        if (is_test_use && (use_google_maps || use_workflow || use_text_search || use_mobile)) {
            needs_pro_plus = true;
        }
        this.sc.setAttribute(LogonStatusManager.decode("+C1pmmhwnlBCoRRvq6RvoSxwqlBEnRZurlBGr6BpqCpLrg"), (Object)needs_pro_plus);
        this.oa = new Object[]{timestamp, datacountall_limit, max_logon, internetaccount_limit, use_limit_date, max_account};
        return (Object[])this.oa.clone();
    }

    private static String decode(String s) throws Exception {
        byte[] ba1 = LogonStatusManager.StringToByteArray(s);
        if (ba1.length < 2) {
            throw new IllegalArgumentException();
        }
        byte[] ba2 = new byte[ba1.length - 2];
        byte randombyte = ba1[0];
        byte checkbyte = 0;
        for (int i = 2; i < ba1.length; ++i) {
            byte b;
            checkbyte = (byte)(checkbyte + ba1[i]);
            ba2[i - 2] = b = (byte)(ba1[i] - randombyte);
        }
        if (ba1[1] != checkbyte) {
            throw new IllegalArgumentException();
        }
        String key0 = new String(ba2, "UTF-8");
        return key0;
    }

    private static byte[] StringToByteArray(String s) {
        int slen = s.length();
        int balen = slen * 6 / 8;
        byte[] ba = new byte[balen];
        for (int cnt = 0; cnt < balen; ++cnt) {
            int charcnt = cnt * 8 / 6;
            int b1 = LogonStatusManager.CharacterToBit6(s.charAt(charcnt));
            int shift1 = 8 * (cnt + 1) - 6 * (charcnt + 1);
            if (shift1 == 0) {
                ba[cnt] = (byte)(b1 & 0xFF);
                continue;
            }
            if (shift1 <= 0) {
                ba[cnt] = (byte)(b1 >> -shift1 & 0xFF);
                continue;
            }
            ba[cnt] = (byte)(b1 << shift1 & 0xFF);
            int b2 = LogonStatusManager.CharacterToBit6(s.charAt(charcnt + 1));
            int shift2 = 8 * (cnt + 1) - 6 * (charcnt + 2);
            if (shift2 == 0) {
                ba[cnt] = (byte)(ba[cnt] | b2 & 0xFF);
                continue;
            }
            if (shift2 <= 0) {
                ba[cnt] = (byte)(ba[cnt] | b2 >> -shift2 & 0xFF);
                continue;
            }
            ba[cnt] = (byte)(ba[cnt] | b2 << shift2 & 0xFF);
            int b3 = LogonStatusManager.CharacterToBit6(s.charAt(charcnt + 2));
            int shift3 = 8 * (cnt + 1) - 6 * (charcnt + 3);
            ba[cnt] = shift3 == 0 ? (byte)(ba[cnt] | b3 & 0xFF) : (shift3 <= 0 ? (byte)(ba[cnt] | b3 >> -shift3 & 0xFF) : (byte)(ba[cnt] | b3 << shift3 & 0xFF));
        }
        return ba;
    }

    private static int CharacterToBit6(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65 + 36;
        }
        if (ch == '+') {
            return 62;
        }
        if (ch == '-') {
            return 63;
        }
        return -1;
    }

    static {
        try {
            ae1 = LogonStatusManager.decode("Icnv1-nOTvD+ZJYj714z8NkzTOsh5N8FThMp4Nku8Nkr5iDua1Qs");
        }
        catch (Exception e) {
            ae1 = null;
        }
        logger = LogManager.getLogger(LogonStatusManager.class);
        String name = "";
        try {
            name = LogonStatusManager.decode("Qb4WgfUWckcZejURgPYShfUWdzf+bPcUdjcX-xMVcPk+gPkje3kPeNQNfz4Tdk8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger2 = LogManager.getLogger((String)name);
        applicationContext = null;
        ObjectName o = null;
        try {
            o = new ObjectName("jp.jasminesoft.jfc:type=LogonStatusManager");
        }
        catch (MalformedObjectNameException mone) {
            logger.error("invalid ObjectName.", (Throwable)mone);
        }
        objname = o;
    }

    private class LogonStatusBox {
        private Map<String, LogonStatus> ramStore = Collections.synchronizedMap(new HashMap());

        LogonStatusBox() {
        }

        public LogonStatus get(String sessionId) {
            if (LogonStatusManager.this.isRedisStore) {
                return LogonStatusManager.this.redisHandler.createLogonStatus((ExpiringSession)((LogonStatusManager)LogonStatusManager.this).redisHandler.repository.getSession(sessionId));
            }
            return this.ramStore.get(sessionId);
        }

        public Collection<LogonStatus> values() {
            if (!LogonStatusManager.this.isRedisStore) {
                return this.ramStore.values();
            }
            return LogonStatusManager.this.redisHandler.sessionStream().map(session -> LogonStatusManager.this.redisHandler.createLogonStatus((ExpiringSession)session)).filter(logonStatus -> logonStatus != null).collect(Collectors.toList());
        }

        public void putLogonStatus(String sessionId, User user) {
            if (LogonStatusManager.this.isRedisStore) {
                return;
            }
            this.ramStore.put(sessionId, LogonStatusManager.this.createLogonStatus(user));
        }

        public void updateLastAccessedTime(String sessionId, long lastAccessedTime) {
            if (LogonStatusManager.this.isRedisStore) {
                return;
            }
            LogonStatus logonStatus = this.ramStore.get(sessionId);
            if (logonStatus != null) {
                logonStatus.setLastAccessedTime(lastAccessedTime);
            }
        }

        public void remove(String sessionId) {
            if (LogonStatusManager.this.isRedisStore) {
                return;
            }
            this.ramStore.remove(sessionId);
        }

        public String toString() {
            if (LogonStatusManager.this.isRedisStore) {
                return "...";
            }
            return this.ramStore.toString();
        }
    }

    public class RedisHandler {
        protected RedisOperationsSessionRepository repository = (RedisOperationsSessionRepository)LogonStatusManager.access$000().getBean("sessionRepository", RedisOperationsSessionRepository.class);
        protected RedisOperations<Object, Object> sessionRedisTemplate;
        protected String redisKeyPrefix;

        RedisHandler() {
            RedisOperations srt;
            this.sessionRedisTemplate = srt = (RedisOperations)applicationContext.getBean("sessionRedisTemplate");
            this.redisKeyPrefix = StringUtils.removeEnd((String)this.repository.getSessionCreatedChannelPrefix(), (String)"event:created:") + "index:" + FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME + ":";
        }

        public boolean releaseLastUserObject(String userid) {
            ExpiringSession session = this.sessionStream(userid).sorted(Comparator.comparingLong(ExpiringSession::getLastAccessedTime)).findFirst().orElse(null);
            if (session == null) {
                return false;
            }
            this.repository.delete(session.getId());
            return true;
        }

        public long getSessionCount() {
            return this.sessionStream().count();
        }

        public int getCount() {
            return this.sessionRedisTemplate.keys((Object)(this.redisKeyPrefix + "*")).size();
        }

        public Stream<ExpiringSession> sessionStream() {
            return this.sessionRedisTemplate.keys((Object)(this.redisKeyPrefix + "*")).stream().map(key -> StringUtils.removeStart((String)((String)key), (String)this.redisKeyPrefix)).flatMap(userid -> this.sessionStream((String)userid));
        }

        public Stream<ExpiringSession> sessionStream(String userid) {
            Map map = this.repository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, userid);
            return map.values().stream().map(obj -> (ExpiringSession)obj).filter(session -> this.isValid((ExpiringSession)session));
        }

        private boolean isValid(ExpiringSession session) {
            if (session == null) {
                return false;
            }
            if (session.isExpired()) {
                return false;
            }
            return session.getAttribute("__jfc_user") != null;
        }

        public long getCount(String userid) {
            return this.sessionStream(userid).count();
        }

        public boolean releaseUserObject(String username, String sessionId) {
            try {
                this.repository.delete(sessionId);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("user object was successfully released. user :" + username + ", sessionId :" + sessionId);
            }
            return true;
        }

        public LogonStatus createLogonStatus(ExpiringSession session) {
            if (session == null) {
                return null;
            }
            User user = (User)session.getAttribute("__jfc_user");
            if (user == null) {
                return null;
            }
            return LogonStatusManager.this.createLogonStatus(user, session.getId(), session.getCreationTime(), session.getLastAccessedTime(), session.getMaxInactiveIntervalInSeconds());
        }
    }
}

