/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXProviderException;
import jp.jasminesoft.jfc.ClusterManagerFactory;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jmx.support.MBeanServerConnectionFactoryBean;

public class MBeanServerConnectionFactoryBeanWrapper {
    private static final Logger logger = LogManager.getLogger((String)MBeanServerConnectionFactoryBeanWrapper.class.getName());
    private MBeanServerConnectionFactoryBean factoryBean = null;
    private boolean isActive = false;
    private String machinename = null;
    private String jmxServiceUrl = null;
    private int retryCount = 2;
    private int sleepTime = 3000;

    public MBeanServerConnectionFactoryBeanWrapper(String machinename, String jmxServiceUrl, int retryCount, int sleepTime) {
        this.machinename = machinename;
        this.jmxServiceUrl = jmxServiceUrl;
        this.retryCount = retryCount;
        this.sleepTime = sleepTime;
        this.setActive(true);
    }

    public String getMachineName() {
        return this.machinename;
    }

    public String getjmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public boolean isActive() {
        if (this.factoryBean == null) {
            return false;
        }
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        if (isActive) {
            if (this.factoryBean == null) {
                this.createMBeanServerConnectionFactoryBean();
            }
            if (this.factoryBean != null) {
                this.isActive = true;
            }
        } else {
            this.isActive = false;
            this.factoryBean = null;
        }
    }

    private void createMBeanServerConnectionFactoryBean() {
        MBeanServerConnectionFactoryBean _factoryBean = new MBeanServerConnectionFactoryBean();
        try {
            _factoryBean.setServiceUrl(this.jmxServiceUrl);
            _factoryBean.setConnectOnStartup(false);
            _factoryBean.afterPropertiesSet();
        }
        catch (NullPointerException npe) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00815), LogCodeManager.getMessage(LogCode.JFC00815, this.machinename));
            _factoryBean = null;
        }
        catch (MalformedURLException murle) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00816), LogCodeManager.getMessage(LogCode.JFC00816, this.machinename, this.jmxServiceUrl, murle.getMessage()));
            logger.debug((Object)murle);
            if (logger.isDebugEnabled()) {
                murle.printStackTrace();
            }
            _factoryBean = null;
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00817), LogCodeManager.getMessage(LogCode.JFC00817, this.machinename, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            _factoryBean = null;
        }
        this.factoryBean = _factoryBean;
    }

    public MBeanServerConnection getMBeanServerConnection(ObjectName objectname) {
        MBeanServerConnection mbsc = this.getMBeanServerConnection();
        try {
            if (mbsc == null || !mbsc.isRegistered(objectname)) {
                return null;
            }
        }
        catch (IOException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00818), LogCodeManager.getMessage(LogCode.JFC00818, this.machinename, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            ClusterManagerFactory.getClusterManager().removeResponseMachine(this.machinename);
            return null;
        }
        return mbsc;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (!this.isActive()) {
            return null;
        }
        MBeanServerConnection mbsc = null;
        int cnt = this.retryCount - 1;
        while (true) {
            try {
                mbsc = this.factoryBean.getObject();
                if (mbsc.getMBeanCount() == 0) {
                    return null;
                }
            }
            catch (Exception e) {
                if (e instanceof JMXProviderException) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00819), LogCodeManager.getMessage(LogCode.JFC00819, this.machinename, e.getMessage()));
                    logger.debug((Object)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                } else if (e instanceof IOException) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00818), LogCodeManager.getMessage(LogCode.JFC00818, this.machinename, e.getMessage()));
                    logger.debug((Object)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                } else {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00817), LogCodeManager.getMessage(LogCode.JFC00817, this.machinename, e.getMessage()));
                    logger.debug((Object)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                }
                if (cnt <= 0) {
                    ClusterManagerFactory.getClusterManager().removeResponseMachine(this.machinename);
                    return null;
                }
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException ie) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00820), LogCodeManager.getMessage(LogCode.JFC00820, this.machinename));
                }
                --cnt;
                continue;
            }
            break;
        }
        return mbsc;
    }
}

