/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ModelitemCsvRowList {
    private Map<String, String> headerDataMap = new TreeMap<String, String>();
    private Map<String, String> headerDataMap1;
    private Map<HeaderDataMapKey, List<String>> insertHeaderDataMap = new TreeMap<HeaderDataMapKey, List<String>>();
    private Map<HeaderDataMapKey, List<String>> appendHeaderDataMap = new TreeMap<HeaderDataMapKey, List<String>>();
    private int endrownum;

    ModelitemCsvRowList(int rownum) {
    }

    public final void addRowNum(int rownum) {
        this.endrownum = rownum;
    }

    public final int getEndRowNum() {
        return this.endrownum;
    }

    private static String getHeader(String header, int cnt, String footer) {
        if (footer == null) {
            return header + "[" + cnt + "]";
        }
        return header + "[" + cnt + "]/" + footer;
    }

    private void addHeaderDataMap(Map<HeaderDataMapKey, List<String>> map, HeaderDataMapKey key, String value) {
        List<String> list = map.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(key, list);
        }
        list.add(value);
    }

    private Map<String, String> createHeaderDataMap() {
        String header;
        int cnt;
        Map<String, String> headerDataMap2 = this.headerDataMap1;
        if (headerDataMap2 != null) {
            return headerDataMap2;
        }
        headerDataMap2 = new TreeMap<String, String>(this.headerDataMap);
        for (Map.Entry<HeaderDataMapKey, List<String>> e : this.insertHeaderDataMap.entrySet()) {
            cnt = -e.getValue().size();
            for (String v : e.getValue()) {
                int cid = cnt++;
                header = e.getKey().getHeader(cid);
                if (e.getKey().isContainerId()) {
                    headerDataMap2.put(header, Integer.toString(cid));
                    continue;
                }
                headerDataMap2.put(header, v);
            }
        }
        for (Map.Entry<HeaderDataMapKey, List<String>> e : this.appendHeaderDataMap.entrySet()) {
            cnt = Integer.MAX_VALUE;
            ArrayList list = new ArrayList(e.getValue());
            Collections.reverse(list);
            for (String v : list) {
                int cid;
                do {
                    cid = cnt--;
                } while (headerDataMap2.containsKey(header = e.getKey().getHeader(cid)));
                if (e.getKey().isContainerId()) {
                    headerDataMap2.put(header, Integer.toString(cid));
                    continue;
                }
                headerDataMap2.put(header, v);
            }
        }
        this.headerDataMap1 = headerDataMap2;
        return headerDataMap2;
    }

    public final void addMultipleDataForAppend(String header, String value) {
        this.addHeaderDataMap(this.appendHeaderDataMap, new HeaderDataMapKey(header, null), value);
        this.headerDataMap1 = null;
    }

    public final void addMultipleData(String header, int cnt, String value) {
        if (cnt > 0) {
            this.headerDataMap.put(ModelitemCsvRowList.getHeader(header, cnt, null), value);
        } else {
            this.addHeaderDataMap(this.insertHeaderDataMap, new HeaderDataMapKey(header, null), value);
        }
        this.headerDataMap1 = null;
    }

    public final void addContainerDataForAppend(String header, String footer, String value) {
        this.addHeaderDataMap(this.appendHeaderDataMap, new HeaderDataMapKey(header, footer), value);
        this.headerDataMap1 = null;
    }

    public final void addContainerData(String header, int cnt, String footer, String value) {
        if (cnt > 0) {
            this.headerDataMap.put(ModelitemCsvRowList.getHeader(header, cnt, footer), value);
        } else {
            this.addHeaderDataMap(this.insertHeaderDataMap, new HeaderDataMapKey(header, footer), value);
        }
        this.headerDataMap1 = null;
    }

    public final void addContainerIdDataForAppend(String header, String footer, String value) {
        this.addHeaderDataMap(this.appendHeaderDataMap, new HeaderDataMapKey(header, footer, true), value);
        this.headerDataMap1 = null;
    }

    public final void addContainerIdData(String header, int cnt, String footer, String value) {
        if (cnt > 0) {
            this.headerDataMap.put(ModelitemCsvRowList.getHeader(header, cnt, footer), value);
        } else {
            this.addHeaderDataMap(this.insertHeaderDataMap, new HeaderDataMapKey(header, footer, true), value);
        }
        this.headerDataMap1 = null;
    }

    public final void addData(String header, String value) {
        this.headerDataMap.put(header, value);
        this.headerDataMap1 = null;
    }

    public final String[] getHeader() {
        Map<String, String> map = this.createHeaderDataMap();
        return map.keySet().toArray(new String[0]);
    }

    public final String[] getData() {
        Map<String, String> map = this.createHeaderDataMap();
        return map.values().toArray(new String[0]);
    }

    private static class HeaderDataMapKey
    implements Comparable<HeaderDataMapKey> {
        private String header;
        private String footer;
        private boolean isContainerId;

        HeaderDataMapKey(String header1, String footer1) {
            this(header1, footer1, false);
        }

        HeaderDataMapKey(String header1, String footer1, boolean isContainerId1) {
            this.header = header1;
            this.footer = footer1;
            this.isContainerId = isContainerId1;
        }

        @Override
        public int compareTo(HeaderDataMapKey arg0) {
            int c = this.header.compareTo(arg0.header);
            if (c != 0) {
                return c;
            }
            if (this.footer == null) {
                if (arg0.footer == null) {
                    return 0;
                }
                return -1;
            }
            if (arg0.footer == null) {
                return 1;
            }
            c = this.footer.compareTo(arg0.footer);
            return c;
        }

        public String getHeader(int cnt) {
            return ModelitemCsvRowList.getHeader(this.header, cnt, this.footer);
        }

        public boolean isContainerId() {
            return this.isContainerId;
        }
    }
}

