/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.model.preference.Preference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PreferenceInfo {
    private static final Logger logger = LogManager.getLogger(PreferenceInfo.class);
    private final String username;
    private final String preferenceId;
    private Map<String, Item> preferenceMap;
    Set<String> deletekeys = new HashSet<String>();
    Map<String, Item> updateMap = new HashMap<String, Item>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreferenceInfo(String username) {
        this.username = username;
        Preference preference = null;
        Map<String, Item> preferenceMap = null;
        UserInfo userinfo = UserInfoFactory.getUserInfo();
        if (userinfo != null) {
            try {
                Item[] items;
                preference = userinfo.loadPreference(username);
                preferenceMap = new TreeMap();
                for (Item item : items = preference.getItem()) {
                    preferenceMap.put(item.getKey(), item);
                }
                preferenceMap = Collections.unmodifiableMap(preferenceMap);
            }
            finally {
                userinfo.close();
            }
        }
        this.preferenceId = preference.getId();
        this.preferenceMap = preferenceMap;
    }

    private synchronized boolean isUpdate() {
        return this.deletekeys.size() > 0 || this.updateMap.size() > 0;
    }

    synchronized Preference preference() {
        Preference _preference = new Preference();
        _preference.setId(this.preferenceId);
        for (Item item : this.preferenceMap.values()) {
            Item _item = this.get(item.getKey());
            if (_item == null) continue;
            _preference.addItem(_item);
        }
        return _preference;
    }

    synchronized Item get(String key) {
        Item item = this._get(key);
        if (item != null) {
            return new Item(item);
        }
        return null;
    }

    private synchronized Item _get(String key) {
        if (this.deletekeys.contains(key)) {
            return null;
        }
        Item item = this.updateMap.get(key);
        if (item != null) {
            return item;
        }
        item = this.preferenceMap.get(key);
        return item;
    }

    synchronized void delete(String key) {
        Item item = this.preferenceMap.get(key);
        if (item != null) {
            this.deletekeys.add(key);
        }
        this.updateMap.remove(key);
    }

    synchronized void set(String key, String value) {
        this.set(key, value, null);
    }

    synchronized void set(String key, String value, String type) {
        Item item = this.preferenceMap.get(key);
        if (item != null) {
            item = new Item(item);
        } else {
            item = new Item();
            item.setKey(key);
        }
        item.setContent(value);
        if (type == null) {
            type = "juser";
        } else if (type != "juser" && type != "jfcpreferenceitem") {
            if (logger.isDebugEnabled()) {
                logger.debug("Illegal type (1) " + type);
            }
            if (type.equals("juser")) {
                type = "juser";
            } else if (type.equals("jfcpreferenceitem")) {
                type = "jfcpreferenceitem";
            } else {
                logger.error("Illegal type " + type);
            }
        }
        item.setType(type);
        this.deletekeys.remove(key);
        this.updateMap.put(key, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void save() {
        UserInfo userinfo = UserInfoFactory.getUserInfo();
        if (userinfo != null) {
            try {
                if (this.isUpdate()) {
                    logger.debug("save preference deletekeys:" + this.deletekeys + " updateMap:" + this.updateMap);
                    userinfo.savePreference(this.username, this);
                    TreeMap<String, Item> preferenceMap = new TreeMap<String, Item>(this.preferenceMap);
                    for (String key : this.deletekeys) {
                        preferenceMap.remove(key);
                    }
                    preferenceMap.putAll(this.updateMap);
                    this.preferenceMap = Collections.unmodifiableMap(preferenceMap);
                    this.updateMap.clear();
                    this.deletekeys.clear();
                }
            }
            finally {
                userinfo.close();
            }
        }
    }
}

