/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ProgressListener;
import jp.jasminesoft.jfc.ProgressRecordable;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.controller.DbBaseController;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessBean
implements PrivilegedAction,
Releasable,
ProgressRecordable {
    public static final String ResultStartParamName = "__jfc_resultbean_start";
    public static final String ResultEndParamName = "__jfc_resultbean_end";
    public static final String ResultSizeParamName = "__jfc_resultbean_size";
    public static final String ReturnWrappedObjectParamName = "__jfc_return_wrapped_object";
    public static final String TargetItemSetParamName = "__jfc_target_item_set";
    public static final String SortKeyParamName = "sort_key";
    public static final String ConditionParamName = "condition";
    public static final String MaxResultsParamName = "__jfc_query_maxresults";
    public static final String ShowListReturnTypeParamName = "__jfc_showListReturnType";
    public static final String AllSearchMessage = "all search";
    private CheckPermission checkp = CheckPermissionFactory.getCheckPermission();
    protected ActionParameter p;
    protected Map anotherParam;
    protected List listenerList;
    protected int jobid;
    private static final Logger logger = LogManager.getLogger((String)ProcessBean.class.getName());

    public ProcessBean() {
        this.init();
    }

    public ProcessBean(ActionParameter p) {
        this.init();
        this.setActionParameter(p);
    }

    protected void init() {
        this.anotherParam = new HashMap();
        this.listenerList = new ArrayList();
        this.jobid = 0;
    }

    public void setActionParameter(ActionParameter p) {
        this.p = p;
    }

    public void setParameter(String key, Object value) {
        this.anotherParam.put(key, value);
    }

    public Map getParameterMap() {
        return this.anotherParam;
    }

    public Object getParameter(String key) {
        return this.anotherParam.get(key);
    }

    public Set getParameterKeySet() {
        return this.anotherParam.keySet();
    }

    public int getParameterSize() {
        return this.anotherParam.size();
    }

    @Override
    public void setProgress(int p) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ProgressListener pl = (ProgressListener)this.listenerList.get(i);
            if (this.jobid <= 0) continue;
            pl.setProgress(this.jobid, p);
        }
    }

    @Override
    public void addProgressListener(int jobid, ProgressListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.add(l);
            this.jobid = jobid;
        }
    }

    @Override
    public void removeProgressListener(ProgressListener l) {
        this.listenerList.remove(l);
        this.jobid = 0;
    }

    public boolean isValidPermission() {
        return this.isValidPermission(this.getPermission());
    }

    public boolean isValidPermission(Permission perm) {
        if (this.p.user == null) {
            return true;
        }
        boolean checkFlag = false;
        if (this.checkp != null && perm != null) {
            checkFlag = this.checkp.process(this.p.user, perm);
        }
        return checkFlag;
    }

    public Object process() {
        long t1 = System.currentTimeMillis();
        if (!this.isValidPermission()) {
            throw new SecurityException(this.getPermission() != null ? this.getPermission().toString() : "");
        }
        Object ret = this.run();
        if (this.isOutputRunningTimeToLog() && logger.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            logger.debug(this.getClass().getSimpleName().toString() + " process time is " + (t2 - t1) + " msec.");
        }
        return ret;
    }

    public Object run() {
        return null;
    }

    public Permission getPermission() {
        return new JFCAppPermission("all", "all");
    }

    public String getUsername() {
        return this.p.user != null ? this.p.user.getUsername() : null;
    }

    @Override
    public void release() {
        this.anotherParam.clear();
        this.anotherParam = null;
        this.listenerList.clear();
        this.listenerList = null;
    }

    public String getMessage(int code) {
        return "";
    }

    public String convertErrorMessage(Exception e) {
        return this.convertErrorMessage(e, null);
    }

    public String convertErrorMessage(Exception e, String[][] params) {
        return DbBaseController.convertErrorMessage(e, params, this.p.locale);
    }

    public String toString() {
        String classname = this.getClass().getName();
        StringBuffer sb = new StringBuffer(classname);
        sb.append("[");
        if (this.p.user != null) {
            sb.append("User:");
            sb.append(this.p.user.getUsername());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isOutputRunningTimeToLog() {
        String StrIsOutputRunningTimeToLog = PropertyManager.getProperty("jp.jasminesoft.jfc.ProcessBean.isOutputRunningTimeToLog");
        boolean isOutputRunningTimeToLog = false;
        if (StrIsOutputRunningTimeToLog != null) {
            isOutputRunningTimeToLog = Boolean.valueOf(StrIsOutputRunningTimeToLog);
        }
        return isOutputRunningTimeToLog;
    }

    public boolean isOutputConditionToLog() {
        String StrIsOutputConditionToLog = PropertyManager.getProperty("jp.jasminesoft.jfc.ProcessBean.isOutputConditionToLog");
        boolean isOutputConditionToLog = false;
        if (StrIsOutputConditionToLog != null) {
            isOutputConditionToLog = Boolean.valueOf(StrIsOutputConditionToLog);
        }
        return isOutputConditionToLog;
    }

    public String convertParamMapToLogMessage(Map paramMap) {
        if (paramMap == null) {
            return "";
        }
        if (paramMap.size() == 0) {
            return AllSearchMessage;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry o : paramMap.entrySet()) {
            Map.Entry entry = o;
            String _valuestr = this.getValueString(entry.getValue());
            if (_valuestr.length() <= 0) continue;
            sb.append("[");
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append(_valuestr);
            sb.append("] ");
        }
        return sb.toString();
    }

    protected void outputConditionToLog(Map paramMap, Logger logger) {
        String msg;
        if (this.p != null && this.p.cmd != null && this.p.cmd == CommandType.GetJson) {
            return;
        }
        String StrIsOutputAllSearchMessage = PropertyManager.getProperty("jp.jasminesoft.jfc.ProcessBean.isOutputAllSearchMessage");
        boolean isOutputAllSearchMessage = false;
        if (StrIsOutputAllSearchMessage != null) {
            isOutputAllSearchMessage = Boolean.valueOf(StrIsOutputAllSearchMessage);
        }
        if (this.isOutputConditionToLog() && StringUtils.isNotEmpty((CharSequence)(msg = this.convertParamMapToLogMessage(paramMap))) && (isOutputAllSearchMessage || !AllSearchMessage.equals(msg))) {
            logger.info(JFCUtils.logmsg(this.p, msg));
        }
    }

    private String getValueString(Object value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (value instanceof int[]) {
            int[] values = (int[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof byte[]) {
            byte[] values = (byte[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof short[]) {
            short[] values = (short[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof float[]) {
            float[] values = (float[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof double[]) {
            double[] values = (double[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof long[]) {
            long[] values = (long[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof char[]) {
            char[] values = (char[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof boolean[]) {
            boolean[] values = (boolean[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                sb.append(" ");
            }
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                String s = this.getValueString(values[i]);
                if (s == null || s.length() <= 0) continue;
                sb.append(s);
            }
        } else {
            sb.append(value.toString());
        }
        return sb.toString();
    }

    public static enum ShowListReturnType {
        RHibernateList,
        ResultListWrapper;

    }
}

