/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbProcessBean;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.ResultBeanCacheInfo;
import jp.jasminesoft.jfc.ResultListWrapper;
import jp.jasminesoft.jfc.ResultListWrapperImpl_FixedList;
import jp.jasminesoft.jfc.ResultListWrapperImpl_List;
import jp.jasminesoft.jfc.app.RHibernateList;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultBean<T extends ContainerBase<T>> {
    public static final String cacheInfoPagemapName = "__jfc_cacheInfo";
    public static final String SortKeySeparator = "+";
    private static final Logger logger;
    public static final int DEFAULT_SIZE_PER_PAGE = 10;
    public static final int INIT_RESULT_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_CACHESIZE;
    private static final boolean isIgnoreSetCacheSizeMethod;
    protected int size_per_page;
    protected int result_size;
    protected int current;
    protected ProcessBean pbean;
    protected JFCEntityService<T, ?> entityService;
    protected FinderContext<?> finderContext;
    protected Object result;
    private int cachesize;
    private int max_result_size = Integer.MAX_VALUE;
    private String[] sort_key = null;

    public ResultBean() {
        this(10);
    }

    public ResultBean(int size_per_page) {
        this.result_size = Integer.MAX_VALUE;
        this.cachesize = DEFAULT_CACHESIZE;
        this.setSizePerPage(size_per_page);
    }

    public void reset() {
        this.result_size = Integer.MAX_VALUE;
        this.current = 0;
        this.release();
    }

    public int getSize() {
        if (this.result_size == Integer.MAX_VALUE) {
            return this.result_size;
        }
        if (this.result_size > this.max_result_size) {
            return this.max_result_size;
        }
        return this.result_size;
    }

    public void setSize(int result_size) {
        this.result_size = result_size;
    }

    public boolean isOverMaxSize() {
        return this.result_size > this.max_result_size;
    }

    public int getMaxSize() {
        return this.max_result_size;
    }

    public void setMaxSize(int max_result_size) {
        this.max_result_size = max_result_size;
    }

    public int getCurrent() {
        return this.current + 1;
    }

    public int getSizePerPage() {
        return this.size_per_page;
    }

    public void setSizePerPage(int size_per_page) {
        this.size_per_page = size_per_page;
    }

    public void setProcessBean(ProcessBean pbean) {
        this.pbean = pbean;
    }

    public ProcessBean getProcessBean() {
        return this.pbean;
    }

    public void setJFCEntityService(JFCEntityService<T, ?> entityService1) {
        this.entityService = entityService1;
    }

    public JFCEntityService<T, ?> getJFCEntityService() {
        return this.entityService;
    }

    public void setFinderContext(FinderContext<?> finderContext) {
        this.finderContext = finderContext;
    }

    public FinderContext<?> getFinderContext() {
        return this.finderContext;
    }

    public boolean isProcess() {
        return this.result_size != Integer.MAX_VALUE;
    }

    public void setSortKey(String s) {
        if (s == null || s.length() == 0) {
            this.sort_key = null;
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, SortKeySeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            list.add(token);
        }
        this.sort_key = list.toArray(new String[0]);
    }

    public void setResult(Object result) {
        this.releaseResult();
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public void next() {
        int next = this.getNext();
        this.current = next == this.getSize() ? this.getLast() : next;
        logger.debug("ResultBean::next()");
    }

    public void prev() {
        this.current = this.getPrev();
        logger.debug("ResultBean::prev()");
    }

    public void first() {
        this.current = 0;
    }

    public void last() {
        this.current = this.getLast();
    }

    public int getLast() {
        if (this.getSizePerPage() > 0) {
            int mod = this.getSize() % this.getSizePerPage();
            if (mod == 0) {
                return this.getSize() - this.getSizePerPage();
            }
            return this.getSize() - mod;
        }
        return 0;
    }

    public int getNext() {
        if (this.getSizePerPage() > 0) {
            int next = this.current + this.getSizePerPage();
            if (next > this.getSize()) {
                next = this.getSize();
            }
            return next;
        }
        return 0;
    }

    public int getPrev() {
        if (this.getSizePerPage() > 0) {
            int prev = this.current - this.getSizePerPage();
            if (prev <= 0) {
                prev = 0;
            }
            return prev;
        }
        return 0;
    }

    public boolean isNextPage() {
        if (this.isNotEmptyEntityService() && this.getSizePerPage() > 0) {
            return this.getSize() - this.current > this.getSizePerPage();
        }
        return false;
    }

    public boolean isPrevPage() {
        if (this.isNotEmptyEntityService() && this.getSizePerPage() > 0) {
            return this.current - this.getSizePerPage() >= 0;
        }
        return false;
    }

    public void setCurrentPage(int page) {
        if (this.getSizePerPage() > 0 && page >= 0 && page <= this.getMaxPage()) {
            if (page < 0) {
                page = 0;
            }
            if (page > this.getMaxPage()) {
                page = this.getMaxPage();
            }
            this.current = page * this.getSizePerPage();
        }
    }

    public int getCurrentPage() {
        if (this.getSizePerPage() > 0) {
            return this.current / this.getSizePerPage();
        }
        return 0;
    }

    public int getMaxPage() {
        if (this.getSizePerPage() > 0) {
            int mod = this.getSize() % this.getSizePerPage();
            if (mod == 0) {
                return this.getSize() / this.getSizePerPage() - 1;
            }
            return this.getSize() / this.getSizePerPage();
        }
        return 0;
    }

    public int getCacheSize() {
        return this.cachesize;
    }

    public void setCacheSize(int cachesize) {
        if (isIgnoreSetCacheSizeMethod) {
            return;
        }
        this.cachesize = cachesize;
    }

    public void release() {
        this.releaseResult();
        if (this.pbean != null) {
            this.pbean.release();
            this.pbean = null;
        }
        if (this.entityService != null) {
            this.entityService = null;
        }
    }

    public List<T> getCurrentPageItem(ActionParameter p, JFCErrorManager errorManager) {
        if (this.getSizePerPage() <= 0 || this.getCacheSize() < this.getSizePerPage()) {
            return this.getCurrentPageItemWithoutCache(p, errorManager);
        }
        int start = this.getCurrent() - 1;
        int end = this.getNext();
        ResultBeanCacheInfo<T> cacheInfo = this.getResultBeanCacheInfo(p);
        if (cacheInfo != null) {
            if (!cacheInfo.isValid()) {
                cacheInfo.clear();
            } else if (cacheInfo.getProcessBean() != this.getProcessBean()) {
                cacheInfo.clear();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[1] cache " + cacheInfo + " start:" + start + " end:" + end + " result is null:" + (this.getResult() == null));
        }
        if (cacheInfo == null || !cacheInfo.isIncludeResult(start, end)) {
            if (this.getProcessBean() == null) {
                this.setResult(null);
                return new ArrayList();
            }
            this.processProcessBean(p, errorManager, false);
            cacheInfo = this.getResultBeanCacheInfo(p);
            if (cacheInfo == null || !cacheInfo.isIncludeResult(start, end)) {
                return new ArrayList();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[2] cache " + cacheInfo + " start:" + start + " end:" + end + " result is null:" + (this.getResult() == null));
        }
        ArrayList<T> coll = new ArrayList<T>(end - start);
        try {
            coll.addAll(cacheInfo.getCacheSubList(start, end));
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00215), LogCodeManager.getMessage(LogCode.JFC00215, p.user, e.getMessage()));
        }
        return coll;
    }

    public synchronized List<T> getCurrentPageItemWithoutCache(ActionParameter p, JFCErrorManager errorManager) {
        int start = this.getCurrent() - 1;
        int end = this.getSizePerPage() <= 0 ? this.getSize() : start + this.getSizePerPage();
        Object op = this.getResult();
        ResultListWrapper<T> wrapper = null;
        if (op != null) {
            wrapper = this.createResultListWrapper(op);
            if (wrapper == null) {
                return new ArrayList();
            }
            if (!wrapper.isIncludeResults(start, end)) {
                op = null;
            }
        }
        if (op == null) {
            this.processProcessBeanWithoutCache(p, errorManager, start, end, false);
            op = this.getResult();
            if (op == null) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00216), LogCodeManager.getMessage(LogCode.JFC00216, p.user, new String[0]));
                return new ArrayList();
            }
            wrapper = this.createResultListWrapper(op);
        }
        if (wrapper == null) {
            return new ArrayList();
        }
        List<T> coll = wrapper.getResultList(start, end);
        this.setSize(wrapper.getResultSize());
        return coll;
    }

    private ResultListWrapper<T> createResultListWrapper(Object op) {
        if (op instanceof ResultListWrapper) {
            return (ResultListWrapper)op;
        }
        if (op instanceof List) {
            return new ResultListWrapperImpl_List((List)op, this.getSize());
        }
        logger.log(LogCodeManager.getPriority(LogCode.JFC00217), LogCodeManager.getMessage(LogCode.JFC00217, op != null ? op.getClass().getName() : ""));
        return null;
    }

    private synchronized Object processProcessBeanWithoutCache(ActionParameter p, JFCErrorManager errorManager, int start, int end, boolean wrapobj) {
        if (this.getProcessBean() != null) {
            return this.processProcessBeanWithoutCache1(p, errorManager, start, end, wrapobj);
        }
        if (this.getJFCEntityService() != null) {
            return this.processJFCEntityService(p, errorManager, start, end, wrapobj);
        }
        logger.log(LogCodeManager.getPriority(LogCode.JFC00218), LogCodeManager.getMessage(LogCode.JFC00218, p.user, new String[0]));
        this.setResult(null);
        return null;
    }

    private Object processProcessBeanWithoutCache1(ActionParameter p, JFCErrorManager errorManager, int start, int end, boolean wrapobj) {
        if (this.getProcessBean() instanceof DbProcessBean) {
            DbProcessBean pbean = (DbProcessBean)this.getProcessBean();
            pbean.setActionParameter(p);
        } else {
            this.getProcessBean().setActionParameter(p);
        }
        if (this.sort_key != null && this.sort_key.length > 0) {
            this.pbean.setParameter("sort_key", this.sort_key);
        } else {
            this.pbean.setParameter("sort_key", null);
        }
        this.pbean.setParameter("__jfc_resultbean_start", start);
        this.pbean.setParameter("__jfc_resultbean_end", end);
        this.pbean.setParameter("__jfc_resultbean_size", this.getSize());
        this.pbean.setParameter("__jfc_return_wrapped_object", wrapobj);
        this.pbean.setParameter("__jfc_showListReturnType", (Object)ProcessBean.ShowListReturnType.ResultListWrapper);
        Object op = this.getProcessBean().process();
        if (op == null) {
            p.errors.addJfcerror(errorManager.getJfcerror("error.dbaccess.nodata", p.locale));
        } else if (op instanceof String) {
            Object[] ep = new Object[]{(String)op};
            p.errors.addJfcerror(errorManager.getJfcerror("error.dbaccess", ep, p.locale));
            op = null;
        }
        this.setResult(op);
        if (op == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00219), LogCodeManager.getMessage(LogCode.JFC00219, p.user, new String[0]));
            return op;
        }
        logger.debug("result type is " + op.getClass());
        return op;
    }

    private Object processJFCEntityService(ActionParameter p, JFCErrorManager errorManager, int start, int end, boolean wrapobj) {
        JFCEntityService<T, ?> entityService1 = this.getJFCEntityService();
        this.finderContext.setFirstResult(start);
        this.finderContext.setPageSize(this.getSizePerPage());
        List<T> list = entityService1.find(this.finderContext);
        ResultListWrapperImpl_FixedList<T> op = new ResultListWrapperImpl_FixedList<T>(list, start, end, this.finderContext.getRowCount(), null);
        this.setResult(op);
        logger.debug("result type is " + op.getClass());
        return op;
    }

    public Object processProcessBean(ActionParameter p, JFCErrorManager errorManager) {
        return this.processProcessBean(p, errorManager, true);
    }

    public synchronized Object processProcessBean(ActionParameter p, JFCErrorManager errorManager, boolean isClearCache) {
        int end;
        int start;
        int newCacheEndCnt;
        if (this.getSizePerPage() <= 0) {
            int start2 = this.getCurrent() - 1;
            int end2 = this.getSize();
            return this.processProcessBeanWithoutCache(p, errorManager, start2, end2, false);
        }
        if (this.getCacheSize() < this.getSizePerPage()) {
            int start3 = this.getCurrent() - 1;
            int end3 = start3 + this.getSizePerPage();
            return this.processProcessBeanWithoutCache(p, errorManager, start3, end3, false);
        }
        ResultBeanCacheInfo<T> cacheInfo = this.getResultBeanCacheInfo(p);
        if (cacheInfo != null) {
            if (!cacheInfo.isValid()) {
                cacheInfo.clear();
            } else if (cacheInfo.getProcessBean() != this.getProcessBean()) {
                cacheInfo.clear();
            } else if (isClearCache) {
                cacheInfo.clear();
            }
        } else {
            cacheInfo = new ResultBeanCacheInfo(this.getCacheSize());
        }
        int newCacheBeginCnt = this.getCurrent() - 1;
        if ((newCacheBeginCnt -= this.getCacheSize() / this.getSizePerPage() / 2 * this.getSizePerPage()) < 0) {
            newCacheBeginCnt = 0;
        }
        if ((newCacheEndCnt = newCacheBeginCnt + this.getCacheSize()) > this.getSize()) {
            newCacheEndCnt = this.getSize();
        }
        boolean MODE_ALL = false;
        boolean MODE_HEAD = true;
        int MODE_FOOT = 2;
        int mode = 0;
        if (cacheInfo.isValid()) {
            int cmpmode = cacheInfo.getCompareRange(newCacheBeginCnt, newCacheEndCnt);
            if (cmpmode == 1) {
                mode = 1;
            } else if (cmpmode == 3) {
                mode = 2;
            }
        }
        if (mode == 1) {
            start = newCacheBeginCnt;
            end = cacheInfo.getCacheBeginCount();
        } else if (mode == 2) {
            start = cacheInfo.getCacheEndCount();
            end = newCacheEndCnt;
        } else {
            start = newCacheBeginCnt;
            end = newCacheEndCnt;
        }
        Object op = this.processProcessBeanWithoutCache(p, errorManager, start, end, true);
        if (op == null) {
            return op;
        }
        ResultListWrapper<T> wrapper = this.createResultListWrapper(op);
        if (wrapper == null) {
            return op;
        }
        List<T> coll = wrapper.getResultList(start, end);
        this.setSize(wrapper.getResultSize());
        if (mode == 1 && end - start != coll.size()) {
            mode = 0;
        }
        if (mode == 1) {
            cacheInfo.clearCacheSubList(newCacheEndCnt, cacheInfo.getCacheEndCount());
        } else if (mode == 2) {
            cacheInfo.clearCacheSubList(cacheInfo.getCacheBeginCount(), newCacheBeginCnt);
        } else {
            cacheInfo.clearCacheList();
        }
        cacheInfo.addCacheList(start, coll);
        cacheInfo.setProcessBean(this.getProcessBean());
        p.appMap.put(cacheInfoPagemapName, cacheInfo);
        return op;
    }

    private ResultBeanCacheInfo<T> getResultBeanCacheInfo(ActionParameter p) {
        return (ResultBeanCacheInfo)p.appMap.get(cacheInfoPagemapName);
    }

    public synchronized void clearCache(ActionParameter p) {
        ResultBeanCacheInfo<T> cacheInfo = this.getResultBeanCacheInfo(p);
        if (cacheInfo != null) {
            cacheInfo.clear();
        }
        p.appMap.remove(cacheInfoPagemapName);
    }

    public void setWishCloseConnection(boolean isWishCloseConnection) {
    }

    public boolean isWishCloseConnection() {
        return true;
    }

    public void beforeCloseConnection(Connection con, Map<String, Object> appMap, String username) {
        if (this.result != null) {
            this.releaseResult();
        }
    }

    public void afterCloseConnection(Map<String, Object> appMap, String username) {
    }

    public void releaseResult() {
        if (this.result == null) {
            logger.debug("No result object is contained.");
            return;
        }
        logger.debug("now being release object...");
        Class<?> resultClass = this.result.getClass();
        String className = resultClass.getName();
        if (this.result instanceof ResultSet) {
            try {
                ((ResultSet)this.result).close();
            }
            catch (SQLException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00220), LogCodeManager.getMessage(LogCode.JFC00220, className, e.getMessage()));
                logger.debug((Object)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.result = null;
                return;
            }
            logger.debug("close ResultSet result " + className);
        } else if (this.result instanceof Releasable) {
            ((Releasable)this.result).release();
            logger.debug("close Releasable result " + className);
        } else if (this.result instanceof RHibernateList) {
            try {
                ((RHibernateList)this.result).close();
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00220), LogCodeManager.getMessage(LogCode.JFC00220, className, e.getMessage()));
                logger.debug((Object)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.result = null;
                return;
            }
            logger.debug("close RHibernateList result " + className);
        } else if (this.isSuperclass(this.result, "RJDBCList")) {
            try {
                this.closeList(this.result);
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00220), LogCodeManager.getMessage(LogCode.JFC00220, className, e.getMessage()));
                logger.debug((Object)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.result = null;
                return;
            }
            logger.debug("close RJDBCList result " + className);
        } else if (this.result instanceof List) {
            logger.debug("close java.util.List result class " + className);
        } else {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00221), LogCodeManager.getMessage(LogCode.JFC00221, className));
        }
        this.result = null;
    }

    public boolean isSuperclass(Object result, String superclassname) {
        String sclassname = "." + superclassname;
        for (Class<?> resultClass = result.getClass(); resultClass != null; resultClass = resultClass.getSuperclass()) {
            String className = resultClass.getName();
            if (!className.endsWith(sclassname)) continue;
            return true;
        }
        return false;
    }

    private void closeList(Object result) throws Exception {
        Class<?> resultClass = result.getClass();
        Method closeMethod = resultClass.getMethod("close", new Class[0]);
        closeMethod.invoke(result, new Object[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ResultBean[");
        sb.append(" result_size=");
        sb.append(this.getSize());
        sb.append(" size_per_page=");
        sb.append(this.getSizePerPage());
        sb.append(" current=");
        sb.append(this.current);
        if (this.pbean != null) {
            sb.append(" pbean=");
            sb.append(this.pbean);
        }
        if (this.entityService != null) {
            sb.append(" entityService=");
            sb.append(this.entityService);
        }
        if (this.result != null) {
            sb.append(" result=");
            sb.append(this.result);
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean isNotEmptyEntityService() {
        return this.pbean != null || this.entityService != null;
    }

    static {
        String propertyName_isIgnoreSetCacheSizeMethod;
        String str_isIgnoreSetCacheSizeMethod;
        logger = LogManager.getLogger((String)ResultBean.class.getName());
        int _DEFAULT_CACHESIZE = 20;
        boolean _isIgnoreSetCacheSizeMethod = false;
        String propertyName_defaultCacheSize = "jp.jasminesoft.jfc.ResultBean.DEFAULT_CACHESIZE";
        String str_defaultCacheSize = PropertyManager.getProperty(propertyName_defaultCacheSize);
        if (str_defaultCacheSize != null) {
            try {
                _DEFAULT_CACHESIZE = Integer.parseInt(str_defaultCacheSize);
            }
            catch (NumberFormatException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00214), LogCodeManager.getMessage(LogCode.JFC00214, propertyName_defaultCacheSize, PropertyManager.getBundleName()));
            }
        }
        if ((str_isIgnoreSetCacheSizeMethod = PropertyManager.getProperty(propertyName_isIgnoreSetCacheSizeMethod = "jp.jasminesoft.jfc.ResultBean.isIgnoreSetCacheSizeMethod")) != null) {
            _isIgnoreSetCacheSizeMethod = Boolean.valueOf(str_isIgnoreSetCacheSizeMethod);
        }
        DEFAULT_CACHESIZE = _DEFAULT_CACHESIZE;
        isIgnoreSetCacheSizeMethod = _isIgnoreSetCacheSizeMethod;
    }
}

