/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Collections;
import java.util.List;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.ResultListWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;

public class ResultListWrapperImpl_FixedList<T>
implements ResultListWrapper<T>,
Releasable {
    private static final Logger logger = LogManager.getLogger(ResultListWrapperImpl_FixedList.class);
    private List<T> list;
    private int start;
    private int end;
    private int size;
    private Session session;

    public ResultListWrapperImpl_FixedList(List<T> list, int start, int end, int size, Session session) {
        this.list = list;
        this.start = start;
        this.end = end;
        this.size = size;
        this.session = session;
    }

    @Override
    public List<T> getResultList(int start, int end) {
        if (!this.isIncludeResults(start, end)) {
            logger.debug("!isIncludeResults(" + start + "," + end + "), this.start=" + this.start + " this.end=" + this.end);
            return Collections.EMPTY_LIST;
        }
        return this.list;
    }

    @Override
    public boolean isIncludeResults(int start, int end) {
        return this.start == start && this.end == end;
    }

    @Override
    public int getResultSize() {
        return this.size;
    }

    @Override
    public void release() {
        if (this.session != null) {
            this.session.close();
        }
    }
}

