/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.ResultListWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultListWrapperImpl_List<T>
implements ResultListWrapper<T> {
    private static final Logger logger = LogManager.getLogger((String)ResultListWrapperImpl_List.class.getName());
    public static final int INIT_RESULT_SIZE = Integer.MAX_VALUE;
    private List<T> resultList;
    private int size;
    private int type;
    private int cnt;

    public ResultListWrapperImpl_List(List<T> resultList, int size) {
        this.resultList = resultList;
        this.cnt = 0;
        this.setSize(size);
        this.setType();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public List<T> getResultList(int start, int end) {
        ArrayList<Object> coll = end == Integer.MAX_VALUE ? new ArrayList<Object>() : new ArrayList(end - start);
        if (end > this.getSize()) {
            end = this.getSize();
        }
        this.cnt = 0;
        try {
            Object item = null;
            if (this.type == 1003) {
                while (this.cnt < start) {
                    item = this.resultList.get(this.cnt);
                    if (item == null) {
                        logger.debug("result item " + this.cnt + " is null.");
                        this.setSize(this.cnt);
                        return coll;
                    }
                    ++this.cnt;
                }
            } else {
                this.cnt = start;
            }
            while (this.cnt < end) {
                item = this.resultList.get(this.cnt);
                if (item == null) {
                    logger.debug("result item " + this.cnt + " is null.");
                    this.setSize(this.cnt);
                    return coll;
                }
                coll.add(item);
                ++this.cnt;
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00222), LogCodeManager.getMessage(LogCode.JFC00222, e.getMessage()));
            logger.debug((Object)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.setSize(this.cnt);
        }
        return coll;
    }

    @Override
    public int getResultSize() {
        if (this.getSize() != Integer.MAX_VALUE) {
            return this.getSize();
        }
        if (this.type == 1003) {
            block6: {
                try {
                    while (this.resultList.get(this.cnt) != null) {
                        ++this.cnt;
                    }
                }
                catch (Exception e) {
                    logger.debug("catch exception", (Throwable)e);
                    if (!logger.isDebugEnabled()) break block6;
                    e.printStackTrace();
                }
            }
            this.setSize(this.cnt);
        } else {
            this.setSize(this.resultList.size());
        }
        return this.getSize();
    }

    private void setType() {
        block8: {
            ResultSet resultset = this.getResultSet(this.resultList);
            if (resultset != null) {
                try {
                    this.type = resultset.getType();
                    if (this.type == 1003) {
                        logger.debug("ResultSet.type = TYPE_FORWARD_ONLY");
                        break block8;
                    }
                    if (this.type == 1004) {
                        logger.debug("ResultSet.type = TYPE_SCROLL_INSENSITIVE");
                        break block8;
                    }
                    if (this.type == 1005) {
                        logger.debug("ResultSet.type = TYPE_SCROLL_SENSITIVE");
                        break block8;
                    }
                    logger.debug("ResultSet.type = unknown");
                    this.type = 1003;
                }
                catch (SQLException e) {
                    logger.debug("failed ResultSet.getType", (Throwable)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    this.type = 1003;
                }
            } else {
                logger.debug("Failed to get result set. list is not match for relaxer list object.");
                this.type = 1004;
                this.setSize(this.resultList.size());
            }
        }
    }

    private ResultSet getResultSet(Object obj) {
        Object retobj;
        Class<?> objclass = obj.getClass();
        try {
            Method method = objclass.getMethod("getResultSet", new Class[0]);
            retobj = method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        if (!(retobj instanceof ResultSet)) {
            return null;
        }
        return (ResultSet)retobj;
    }

    @Override
    public boolean isIncludeResults(int start, int end) {
        return true;
    }
}

