/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.PessimisticLockException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.core.util.LineSeparator;
import jp.jasminesoft.jfc.core.util.SystemUtils;
import jp.jasminesoft.util.JavaVersion;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ScriptCodeRunner {
    private static final Logger logger;
    public static final String JSOBJECTPREFIX = "__jsobj_";
    public static final String ScriptCodeAttributeKey = "__jfc_script_code_";
    public static final String ScriptEngineAttributeKey = "__jfc_script_engine_";
    public static final String ScriptFilename = "__jfc_script_engine_filename";
    private static boolean isOutputStatusToConsole;
    private static String engineName;
    private static Map<String, CachedCode> cacheMap;
    private static Set<String> declaredPreprocessFunction;
    protected String[] modelIds;
    private static final String HookPointNameAttrName = "ScriptCodeRunner_hookPointName";

    public ScriptCodeRunner(String ... modelIds) {
        this.modelIds = modelIds;
    }

    public String process(String clazzName, String hookPointName, ActionParameter p) {
        return this.process(clazzName, hookPointName, "process", null, p);
    }

    public String process(String clazzName, String hookPointName, String functionName, ActionParameter p) {
        return this.process(clazzName, hookPointName, functionName, null, p);
    }

    public String process(String clazzName, String hookPointName, Map<String, ?> params, ActionParameter p) {
        return this.process(clazzName, hookPointName, "process", params, p);
    }

    public String process(String clazzName, String hookPointName, String functionName, Map<String, ?> params, ActionParameter p) {
        String filename = this.getScriptFilename(clazzName, hookPointName, p);
        if (filename == null) {
            logger.debug("filename is null. clazzName=" + clazzName + " hookPointName=" + hookPointName);
            return "";
        }
        return this.processFile(filename, hookPointName, functionName, params, p);
    }

    public String processWithRootScript(String clazzName, String hookPointName, Map<String, ?> params, ActionParameter p) {
        return this.processWithRootScript(clazzName, hookPointName, "process", params, p);
    }

    public String processWithRootScript(String clazzName, String hookPointName, String functionName, Map<String, ?> params, ActionParameter p) {
        String filename = this.getScriptFilename(clazzName, hookPointName, p);
        if (filename == null) {
            logger.debug("model script filename is null. clazzName=" + clazzName + " hookPointName=" + hookPointName);
            return "";
        }
        String msg = this.processFile(filename, hookPointName, functionName, params, p);
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        filename = this.getRootScriptFilename(clazzName, hookPointName, p);
        if (filename == null) {
            logger.debug("root script filename is null. clazzName=" + clazzName + " hookPointName=" + hookPointName);
            return "";
        }
        return this.processFile(filename, hookPointName, functionName, params, p);
    }

    private String processFile(String filename, String hookPointName, String functionName, Map<String, ?> params, ActionParameter p) {
        if (isOutputStatusToConsole) {
            System.out.println(filename + " " + functionName);
            p.request.setAttribute("__jfc_script_outputstatus_to_console", (Object)Boolean.TRUE);
        }
        p.request.setAttribute(HookPointNameAttrName, (Object)hookPointName);
        Object ret = this.process0(filename, functionName, params, p);
        p.request.removeAttribute(HookPointNameAttrName);
        String status = "";
        if (ret != null && ret instanceof String) {
            status = (String)ret;
        }
        if (isOutputStatusToConsole && StringUtils.isNotBlank((String)status)) {
            System.out.println(status);
        }
        return status;
    }

    public boolean isProcessable(String clazzName, String hookPointName, ActionParameter p) {
        Resource res;
        String filename = this.getScriptFilename(clazzName, hookPointName, p);
        if (filename == null) {
            return false;
        }
        ResourceLoader resloader = (ResourceLoader)p.request.getAttribute("__jfc_script_fileresloader");
        if (resloader != null) {
            res = resloader.getResource("WEB-INF/script" + filename);
        } else {
            logger.debug("resouce loader is null. clazzName=" + clazzName + " hookPointName=" + hookPointName);
            res = new FileSystemResourceLoader().getResource("../webapps/wagby/WEB-INF/script" + filename);
        }
        return res.exists() && res.isReadable();
    }

    public String getScriptFilename(String clazzName, String hookPointName, ActionParameter p) {
        StringBuilder path = new StringBuilder();
        String fid = this.modelIds[0];
        if (fid.endsWith("_c")) {
            fid = fid.substring(0, fid.length() - "_c".length());
        } else if (fid.endsWith("_cp")) {
            fid = fid.substring(0, fid.length() - "_cp".length());
        }
        path.append("/").append(fid);
        path.append(this.getRootScriptFilename(clazzName, hookPointName, p));
        return path.toString();
    }

    public String getRootScriptFilename(String clazzName, String hookPointName, ActionParameter p) {
        String clazzNameCore = clazzName.indexOf(".") > 0 ? clazzName.substring(clazzName.lastIndexOf(".") + 1) : clazzName;
        String string = clazzNameCore = clazzNameCore.indexOf("$") > 0 ? clazzNameCore.substring(0, clazzNameCore.indexOf("$")) : clazzNameCore;
        if (clazzNameCore.startsWith("My")) {
            clazzNameCore = StringUtil.capFirst((String)clazzNameCore.substring("My".length()));
        }
        StringBuilder path = new StringBuilder();
        path.append("/");
        if (StringUtils.isNotBlank((String)clazzNameCore)) {
            path.append(clazzNameCore);
            if (StringUtils.isNotEmpty((String)hookPointName)) {
                path.append("_");
            }
        }
        path.append(hookPointName);
        String filename = path.toString();
        if (!filename.endsWith(".js")) {
            filename = filename + ".js";
        }
        return filename;
    }

    protected Object process0(String filename, ActionParameter p) {
        return this.process0(filename, "process", null, p);
    }

    protected Object process0(String filename, String functionName, ActionParameter p) {
        return this.process0(filename, functionName, null, p);
    }

    protected Object process0(String filename, Map<String, ?> params, ActionParameter p) {
        return this.process0(filename, "process", params, p);
    }

    public static boolean isReloadable() {
        String s = System.getProperty("ScriptCodeRunner.reloadable");
        if (s == null) {
            return true;
        }
        return Boolean.valueOf(s);
    }

    protected Object process0(String filename, String functionName, Map<String, ?> params, ActionParameter p) {
        String code = this.process0_read(filename, p);
        if (code != null) {
            if ("preprocess".equals(functionName) && !declaredPreprocessFunction.contains(filename)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Skip preprocess. (" + filename + ")");
                }
                return null;
            }
            String myfunctioncode = this.process0_read("/myfunction.js", p);
            if (StringUtils.isNotBlank((String)myfunctioncode)) {
                code = code + myfunctioncode;
            }
            String wagbyjsPath = "classpath:systemScripts/wagby.js";
            if ("graal.js".equals(engineName)) {
                wagbyjsPath = ((ServletContext)p.appctx.getBean(ServletContext.class)).getRealPath("/WEB-INF/classes/systemScripts/wagby.js");
                wagbyjsPath = wagbyjsPath.replace("\\", "\\\\");
            }
            code = "load(\"" + wagbyjsPath + "\");" + code;
            return this.invoke(filename, functionName, code, params, p);
        }
        return null;
    }

    private String process0_read(String filename, ActionParameter p) {
        String NOTHING_FILE_VALUE = "__jfc_ScritCodeRunner_NOTHING_FILE";
        long t1 = System.currentTimeMillis();
        String code = (String)p.request.getAttribute(ScriptCodeAttributeKey + filename);
        if (StringUtils.isNotBlank((String)code)) {
            if (logger.isDebugEnabled()) {
                logger.debug("use request cache __jfc_script_code_" + filename);
            }
            if ("__jfc_ScritCodeRunner_NOTHING_FILE".equals(code)) {
                return null;
            }
            return code;
        }
        code = ScriptCodeRunner.isReloadable() ? this.process0_read_reloadable(filename, p) : this.process0_read_noCheckUpdate(filename, p);
        long t2 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("[process0_read] " + (t2 - t1) + " msec.");
        }
        if (code == null) {
            p.request.setAttribute(ScriptCodeAttributeKey + filename, (Object)"__jfc_ScritCodeRunner_NOTHING_FILE");
            return null;
        }
        p.request.setAttribute(ScriptCodeAttributeKey + filename, (Object)code);
        return code;
    }

    private String process0_read_reloadable(String filename, ActionParameter p) {
        long lastmodified;
        boolean isReadable;
        String code = null;
        ResourceLoader resloader = (ResourceLoader)p.request.getAttribute("__jfc_script_fileresloader");
        Resource res = resloader != null ? resloader.getResource("WEB-INF/script" + filename) : new FileSystemResourceLoader().getResource("../webapps/wagby/WEB-INF/script" + filename);
        CachedCode cached = null;
        boolean bl = isReadable = res.exists() && res.isReadable();
        if (cacheMap.containsKey(filename)) {
            if (logger.isDebugEnabled()) {
                logger.debug("file is in cache.");
            }
            if ((cached = cacheMap.get(filename)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cached is found.");
                }
                if (!isReadable) {
                    cacheMap.put(filename, null);
                    if (logger.isDebugEnabled()) {
                        logger.debug("File " + filename + " is deleted. clear cache.");
                    }
                } else {
                    try {
                        lastmodified = res.lastModified();
                    }
                    catch (IOException e) {
                        lastmodified = 0L;
                    }
                    if (lastmodified > cached.lastmodified) {
                        declaredPreprocessFunction.remove(filename);
                        code = this.readSourceCode(filename, res);
                        CachedCode n_cached = new CachedCode(lastmodified, code);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Reload File " + filename);
                        }
                        cacheMap.put(filename, n_cached);
                    } else {
                        code = cached.code;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Use cache file " + filename);
                        }
                    }
                }
            }
        }
        if (code == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("cached is not found.");
            }
            if (isReadable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("file is found.");
                }
                try {
                    lastmodified = res.lastModified();
                }
                catch (IOException e) {
                    lastmodified = 0L;
                }
                code = this.readSourceCode(filename, res);
                cached = new CachedCode(lastmodified, code);
                cacheMap.put(filename, cached);
                if (logger.isDebugEnabled()) {
                    logger.debug("Load File " + filename + ", and save it as cache.");
                }
            }
        }
        return code;
    }

    private String process0_read_noCheckUpdate(String filename, ActionParameter p) {
        String code = null;
        CachedCode cached = null;
        if (cacheMap.containsKey(filename)) {
            if (logger.isDebugEnabled()) {
                logger.debug("file is in cache.");
            }
            if ((cached = cacheMap.get(filename)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cached is found.");
                }
                if ((code = cached.code).equals("")) {
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Use cache file " + filename);
                }
            }
        }
        if (code == null) {
            boolean isReadable;
            ResourceLoader resloader = (ResourceLoader)p.request.getAttribute("__jfc_script_fileresloader");
            Resource res = resloader != null ? resloader.getResource("WEB-INF/script" + filename) : new FileSystemResourceLoader().getResource("../webapps/wagby/WEB-INF/script" + filename);
            boolean bl = isReadable = res.exists() && res.isReadable();
            if (logger.isDebugEnabled()) {
                logger.debug("cached is not found.");
            }
            if (isReadable) {
                long lastmodified;
                if (logger.isDebugEnabled()) {
                    logger.debug("file is found.");
                }
                try {
                    lastmodified = res.lastModified();
                }
                catch (IOException e) {
                    lastmodified = 0L;
                }
                code = this.readSourceCode(filename, res);
                cached = new CachedCode(lastmodified, code);
                cacheMap.put(filename, cached);
                if (logger.isDebugEnabled()) {
                    logger.debug("Load File " + filename + ", and save it as cache.");
                }
            } else {
                cached = new CachedCode(Long.MAX_VALUE, "");
                cacheMap.put(filename, cached);
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSourceCode(String filename, Resource file) {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(file.getInputStream(), "UTF-8"));
            boolean checkedPreprocessFunction = false;
            while ((line = in.readLine()) != null) {
                sb.append(line);
                if (!checkedPreprocessFunction && line.indexOf(" preprocess") > 0) {
                    declaredPreprocessFunction.add(filename);
                    checkedPreprocessFunction = true;
                }
                sb.append((Object)LineSeparator.SYSTEM);
            }
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    private String invoke(String filename, String functionName, String code, Map<String, ?> params, ActionParameter p) {
        long t1 = System.currentTimeMillis();
        String status = "";
        boolean needsEval = false;
        ScriptEngineManager manager = null;
        ScriptEngine engine = (ScriptEngine)p.request.getAttribute(ScriptEngineAttributeKey + filename);
        if (engine == null) {
            manager = new ScriptEngineManager();
            if ("nashorn".equals(engineName)) {
                logger.debug("Use Nashorn as JavaScript engine.");
                engine = manager.getEngineByName("JavaScript");
            } else {
                logger.debug("Use " + engineName + " as JavaScript engine.");
                engine = manager.getEngineByName(engineName);
                try {
                    engine.eval("load('nashorn:mozilla_compat.js')");
                    logger.debug("mozilla_compat.js is loaded.");
                }
                catch (ScriptException e) {
                    logger.warn("mozilla_compat.js is not loaded.", (Throwable)e);
                }
            }
            needsEval = true;
        }
        if (engine == null) {
            engineName = "nashorn";
            logger.warn("Engine name '" + engineName + "' is not found. Use default (Nashorn) as JavaScript engine.");
            if (manager == null) {
                manager = new ScriptEngineManager();
            }
            ScriptEngine scriptEngine = engine = manager != null ? manager.getEngineByName("JavaScript") : null;
            if (engine == null) {
                logger.error("No ScriptEngine is available. All script will be ignored. engineName=" + engineName + ", manager=" + manager);
                return "";
            }
            needsEval = true;
        }
        LinkedHashMap<String, String> keyAndTypeMap = new LinkedHashMap<String, String>();
        try {
            long et;
            if (p.appctx != null) {
                engine.put("errorManager", p.appctx.getBean(JFCErrorManager.class));
                keyAndTypeMap.put("errorManager", JFCErrorManager.class.getName());
            }
            engine.put(ScriptFilename, filename);
            keyAndTypeMap.put(ScriptFilename, "java.lang.String");
            engine.put("p", p);
            keyAndTypeMap.put("p", p.getClass().getName());
            Logger scriptLogger = LogManager.getLogger((String)filename);
            engine.put("scriptLogger", scriptLogger);
            keyAndTypeMap.put("scriptLogger", scriptLogger.getClass().getName());
            if (p != null && p.request != null) {
                engine.put("SCREENTYPE", this.getScreenType(p));
                keyAndTypeMap.put("SCREENTYPE", "java.lang.String");
                try {
                    Session session;
                    if (p.appctx != null && (session = ((SessionFactory)p.appctx.getBean("sessionFactory")).getCurrentSession()) != null) {
                        engine.put("session", session);
                        keyAndTypeMap.put("session", session.getClass().getName());
                    }
                }
                catch (HibernateException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                if (p.request.getAttribute("UPLOADACTION") != null) {
                    engine.put("UPLOADACTION", (String)p.request.getAttribute("UPLOADACTION"));
                    keyAndTypeMap.put("UPLOADACTION", "java.lang.String");
                }
                String uufileentry = null;
                if (p.request.getAttribute("__jfc_uploadupdate_fileentry") != null) {
                    uufileentry = (String)p.request.getAttribute("__jfc_uploadupdate_fileentry");
                }
                if (p.request.getAttribute("__jfc_uploadupdate_filename") != null) {
                    String uufilename = (String)p.request.getAttribute("__jfc_uploadupdate_filename");
                    engine.put("UPLOADFILENAME", uufilename);
                    keyAndTypeMap.put("UPLOADFILENAME", "java.lang.String");
                    if (uufileentry == null) {
                        uufileentry = uufilename;
                    }
                }
                if (uufileentry != null) {
                    engine.put("UPLOADFILEENTRY", uufileentry);
                    keyAndTypeMap.put("UPLOADFILEENTRY", "java.lang.String");
                }
                if (p.request.getAttribute("__jfc_uploadupdate_filepath") != null) {
                    engine.put("UPLOADFILEPATH", p.request.getAttribute("__jfc_uploadupdate_filepath"));
                    keyAndTypeMap.put("UPLOADFILEPATH", "java.lang.String");
                }
                if (p.request.getAttribute("REPLACEMAP") != null) {
                    Map replaceMap = (Map)p.request.getAttribute("REPLACEMAP");
                    engine.put("REPLACEMAP", replaceMap);
                    keyAndTypeMap.put("REPLACEMAP", replaceMap.getClass().getName());
                }
                if (p.request.getAttribute("REPLACETYPEMAP") != null) {
                    Map replaceTypeMap = (Map)p.request.getAttribute("REPLACETYPEMAP");
                    engine.put("REPLACETYPEMAP", replaceTypeMap);
                    keyAndTypeMap.put("REPLACETYPEMAP", replaceTypeMap.getClass().getName());
                }
                if (p.request.getAttribute("RESTMAP") != null) {
                    Object obj = p.request.getAttribute("RESTMAP");
                    engine.put("RESTMAP", obj);
                    keyAndTypeMap.put("RESTMAP", obj.getClass().getName());
                }
                String _key = null;
                for (String modelId : this.modelIds) {
                    Object obj_lp;
                    Object obj_l;
                    Object obj_cp;
                    Object obj_p;
                    _key = modelId;
                    Object obj = this.getModelIdObject(_key, p);
                    if (obj != null && !keyAndTypeMap.containsKey(_key)) {
                        engine.put(_key, obj);
                        keyAndTypeMap.put(_key, obj.getClass().getName());
                    }
                    if ((obj_p = p.request.getAttribute(_key = modelId + "_p")) != null && !keyAndTypeMap.containsKey(_key)) {
                        engine.put(_key, obj_p);
                        keyAndTypeMap.put(_key, obj_p.getClass().getName());
                    }
                    if ((obj_cp = p.request.getAttribute(_key = modelId + "_cp")) != null && !keyAndTypeMap.containsKey(_key)) {
                        engine.put(_key, obj_cp);
                        keyAndTypeMap.put(_key, obj_cp.getClass().getName());
                    }
                    if ((obj_l = p.request.getAttribute(_key = modelId + "_l")) != null && !keyAndTypeMap.containsKey(_key)) {
                        engine.put(_key, obj_l);
                        keyAndTypeMap.put(_key, obj_l.getClass().getName());
                    }
                    if ((obj_lp = p.request.getAttribute(_key = modelId + "_lp")) == null || keyAndTypeMap.containsKey(_key)) continue;
                    engine.put(_key, obj_lp);
                    keyAndTypeMap.put(_key, obj_lp.getClass().getName());
                }
            }
            Enumeration em = p.request.getAttributeNames();
            while (em.hasMoreElements()) {
                Object object;
                String key = (String)em.nextElement();
                if (!key.startsWith("__index_") || (object = p.request.getAttribute(key)) == null || keyAndTypeMap.containsKey(key)) continue;
                engine.put(key, object);
                keyAndTypeMap.put(key, object.getClass().getName());
            }
            if (params != null) {
                for (Map.Entry entry : params.entrySet()) {
                    engine.put((String)entry.getKey(), entry.getValue());
                    if (entry.getValue() == null) continue;
                    keyAndTypeMap.put((String)entry.getKey(), entry.getValue().getClass().getName());
                }
            }
            engine.put("__keyAndType", keyAndTypeMap);
            engine.put("__status", ScriptCodeRunner.createStatusString(keyAndTypeMap));
            long t2 = System.currentTimeMillis();
            if (needsEval) {
                engine.eval(code);
                if (logger.isDebugEnabled()) {
                    logger.debug("[eval] " + (t2 - t1) + " msec.");
                }
                p.request.setAttribute(ScriptEngineAttributeKey + filename, (Object)engine);
            }
            Invocable inv = (Invocable)((Object)engine);
            status = (String)inv.invokeFunction(functionName, new Object[0]);
            long t3 = System.currentTimeMillis();
            long l = et = needsEval ? t3 - t2 : t3 - t1;
            if (logger.isDebugEnabled()) {
                logger.debug("[invoke] " + et + " msec.");
            }
        }
        catch (ScriptException e) {
            boolean bl;
            int index = ExceptionUtils.indexOfType((Throwable)e, BusinessLogicException.class);
            if (index != -1) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw (BusinessLogicException)BusinessLogicException.class.cast(ExceptionUtils.getThrowables((Throwable)e)[index]);
            }
            index = ExceptionUtils.indexOfType((Throwable)e, PessimisticLockException.class);
            if (index != -1) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw (PessimisticLockException)((Object)PessimisticLockException.class.cast(ExceptionUtils.getThrowables((Throwable)e)[index]));
            }
            boolean bl2 = false;
            String emsg = e.getMessage();
            if ("nashorn".equals(engineName) && emsg.indexOf("ReferenceError") >= 0) {
                int _p1 = emsg.indexOf("\"");
                int _p2 = emsg.lastIndexOf("\"");
                if (_p1 > 0 && _p2 > _p1) {
                    String _mid = emsg.substring(_p1 + 1, _p2);
                    for (String modelId : this.modelIds) {
                        if (!modelId.equals(_mid) || keyAndTypeMap.keySet().contains(modelId)) continue;
                        logger.debug(e.getMessage());
                        bl = true;
                        break;
                    }
                }
            }
            if (!bl) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            String filename0 = StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)filename, (String)"/"), (String)".");
            return "An error has detected in script " + filename0 + ". Check the grammar and variable name.";
        }
        catch (NoSuchMethodException e) {
            status = this.errorMessage(functionName, e);
        }
        catch (BusinessLogicException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (PessimisticLockException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            status = JFCUtils.ErrorMessage(p, "error.unknown");
        }
        return status;
    }

    public static String createStatusString(Map<String, String> keyAndTypeMap) {
        StringBuilder sb = new StringBuilder();
        int maxlength = 0;
        for (String _key : keyAndTypeMap.keySet()) {
            maxlength = Math.max(maxlength, _key.length());
        }
        String padding = StringUtil.concat((String)" ", (int)maxlength);
        for (Map.Entry<String, String> entry : keyAndTypeMap.entrySet()) {
            String k = (entry.getKey() + padding).substring(0, maxlength);
            String v = entry.getValue();
            sb.append(k).append(":").append(v).append(StringUtil.CR);
        }
        return sb.toString();
    }

    private String errorMessage(String functionName, NoSuchMethodException e) {
        String noSuchMethodErrorRhino = "no such method: " + functionName;
        String noSuchMethodErrorNashorn = "No such function " + functionName;
        if (noSuchMethodErrorRhino.equals(e.getMessage()) || noSuchMethodErrorNashorn.equals(e.getMessage())) {
            return "";
        }
        return e.getMessage();
    }

    private String getScreenType(ActionParameter p) {
        Object o = p.request.getAttribute("__jfc_screen_type");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    private Object getModelIdObject(String modelId, ActionParameter p) {
        Object obj4tran;
        String hookPointName = (String)p.request.getAttribute(HookPointNameAttrName);
        if (logger.isDebugEnabled()) {
            String screenType = this.getScreenType(p);
            logger.debug("screenType:" + screenType + " hookPointName:" + hookPointName);
            obj4tran = p.request.getAttribute(modelId);
            logger.debug("obj4tran:" + obj4tran);
            Object obj = p.request.getAttribute(JSOBJECTPREFIX + modelId);
            logger.debug("obj:" + obj);
            if (obj4tran != null && obj != null) {
                logger.debug("obj == obj4tran:" + (obj == obj4tran));
            }
        }
        boolean checkModelIdAttr = false;
        if (hookPointName != null && hookPointName.startsWith("doTransaction")) {
            checkModelIdAttr = true;
        }
        if (checkModelIdAttr && (obj4tran = p.request.getAttribute(modelId)) != null) {
            return obj4tran;
        }
        Object obj = p.request.getAttribute(JSOBJECTPREFIX + modelId);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    static {
        JavaVersion javaVersion;
        String EngineName;
        logger = LogManager.getLogger((String)ScriptCodeRunner.class.getName());
        isOutputStatusToConsole = false;
        engineName = null;
        cacheMap = Collections.synchronizedMap(new HashMap());
        declaredPreprocessFunction = Collections.synchronizedSet(new HashSet());
        String StrIsOutputStatusToConsole = PropertyManager.getProperty("jp.jasminesoft.jfc.ScriptCodeRunner.isOutputStatusToConsole");
        if (StrIsOutputStatusToConsole != null) {
            isOutputStatusToConsole = Boolean.valueOf(StrIsOutputStatusToConsole);
        }
        if ((EngineName = PropertyManager.getProperty("jp.jasminesoft.jfc.ScriptCodeRunner.engineName")) != null && EngineName.length() > 0) {
            engineName = EngineName;
        }
        if ((javaVersion = SystemUtils.getJavaVersion()).atLeast(JavaVersion.JAVA_15)) {
            engineName = "graal.js";
        } else if (engineName == null) {
            engineName = "nashorn";
        }
    }

    private static class CachedCode {
        long lastmodified;
        String code;

        public CachedCode(long lastmodified, String code) {
            this.lastmodified = lastmodified;
            this.code = code;
        }
    }
}

