/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Arrays;
import java.util.Enumeration;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptCodeRunner4Controller
extends ScriptCodeRunner {
    private static final Logger logger = LogManager.getLogger((String)ScriptCodeRunner4Controller.class.getName());
    private static boolean isOutputStatusToConsole = false;

    public ScriptCodeRunner4Controller(String modelId) {
        super(modelId);
    }

    public String process(String status, ActionParameter p) {
        Object o;
        String modelId = this.modelIds != null ? this.modelIds[0] : null;
        String[] statusAndAction = ScriptCodeRunner4Controller.getStatusAndAction(status, p);
        if (StringUtils.isBlank((CharSequence)modelId) || modelId.equals("___") || statusAndAction == null || p.action.equals("GetJson")) {
            return null;
        }
        status = statusAndAction[0];
        String actionstr = statusAndAction[1];
        StringBuilder path = new StringBuilder();
        path.append("/").append(modelId).append("/").append(status).append("_").append(actionstr);
        String filename = path.toString();
        if (!filename.endsWith(".js")) {
            filename = filename + ".js";
        }
        if (isOutputStatusToConsole) {
            System.out.println(filename + "," + Arrays.asList(this.modelIds) + ",actionstr=" + actionstr);
            p.request.setAttribute("__jfc_script_outputstatus_to_console", (Object)Boolean.TRUE);
        }
        if ((o = this.process0(filename, p)) != null && o instanceof String) {
            String ret = (String)o;
            if (isOutputStatusToConsole) {
                System.out.println(ret);
            }
            return ret;
        }
        return null;
    }

    private static String[] getStatusAndAction(String status, ActionParameter p) {
        String _action = p.action;
        if (StringUtils.isBlank((CharSequence)_action)) {
            if (p.cmd == CommandType.Search) {
                _action = "Search";
            } else if (p.cmd == CommandType.AsIs) {
                _action = "AsIs";
            }
        }
        if (p.cmd == CommandType.DoShow) {
            _action = "Show";
        }
        if (StringUtils.isBlank((CharSequence)status) || StringUtils.isBlank((CharSequence)_action)) {
            return null;
        }
        if (status.startsWith("my")) {
            status = status.substring(2);
        }
        status = StringUtil.capFirst((String)status);
        String actionstr = _action;
        if (actionstr.indexOf(":") > 0) {
            actionstr = StringUtils.left((String)actionstr, (int)actionstr.indexOf(":"));
        }
        if (actionstr.indexOf("_") > 0) {
            actionstr = StringUtils.left((String)actionstr, (int)actionstr.indexOf("_"));
        }
        if (actionstr.startsWith("UpdateAll")) {
            actionstr = "UpdateAll";
        }
        if (status.startsWith("Copy") && actionstr.startsWith("Copy")) {
            actionstr = "Copy";
        } else if (status.startsWith("Copy")) {
            String mid = status.substring("Copy".length());
            status = status.replace("Copy", "Insert");
            String objname = null;
            Enumeration _names = p.request.getAttributeNames();
            while (_names.hasMoreElements()) {
                String _rest;
                String _name = (String)_names.nextElement();
                if (mid.startsWith(_name) && (StringUtils.isBlank((CharSequence)(_rest = mid.substring(_name.length()))) || _rest.charAt(0) == 'C' && NumberUtils.toInt((String)_rest.substring(1)) > 0)) {
                    objname = _name;
                    break;
                }
                if (objname != null || !_name.startsWith("__jsobj_")) continue;
                objname = _name.substring("__jsobj_".length());
                if (status.startsWith("Insert" + objname)) break;
                objname = null;
            }
            if (objname != null) {
                String classname = StringUtil.capFirst(objname);
                int len = "Insert".length() + classname.length() + 1;
                if (status.length() > len) {
                    status = status.substring(0, len);
                }
            }
        } else if (status.startsWith("Show") && actionstr.startsWith("Print")) {
            actionstr = actionstr.startsWith("PrintAll") ? "PrintAll" : "Print";
        }
        return new String[]{status, actionstr};
    }

    public static String getScriptFilenameStatusPart(String status, ActionParameter p) {
        String[] statusAndAction = ScriptCodeRunner4Controller.getStatusAndAction(status, p);
        if (statusAndAction == null) {
            return null;
        }
        return statusAndAction[0];
    }

    static {
        String StrIsOutputStatusToConsole = PropertyManager.getProperty("jp.jasminesoft.jfc.ScriptCodeRunner4Controller.isOutputStatusToConsole");
        if (StrIsOutputStatusToConsole != null) {
            isOutputStatusToConsole = Boolean.valueOf(StrIsOutputStatusToConsole);
        }
    }
}

