/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.login.AccountExpiredException;
import jp.jasminesoft.jfc.JFCAppPrincipal;
import jp.jasminesoft.jfc.JFCBasePrincipal;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PreferenceInfo;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.UserInfoUpdateEvent;
import jp.jasminesoft.jfc.app.MasterJprincipal;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.model.juser.PreferenceItem;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.model.preference.Preference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class UserInfoBase
implements UserInfo {
    private static final Logger logger = LogManager.getLogger(UserInfoBase.class);

    @Override
    public abstract IJuser getJuser(String var1);

    protected IJuser getJuserForPreference(String username) {
        return this.getJuser(username);
    }

    public abstract String getEmailByUserid(String var1);

    @Override
    public abstract void updateJuser(IJuser var1);

    protected abstract void updateJuserInTransaction(IJuser var1);

    @Override
    public boolean verifyUser(String username, char[] password) throws AccountExpiredException {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't support this method.");
    }

    @Override
    public void updatePasswdChangeFlag(IJuser juser) {
        if (juser.getPasswdChangeDate() != null && !User.isValidPasswd(juser.getPasswdChangeDate().getTime()) && (juser.getPasswdChangeFlag() == null || juser.getPasswdChangeFlag().equals("off"))) {
            juser.setPasswdChangeFlag("on");
            this.updateJuser(juser);
        }
    }

    @Override
    public IJuser getValidJuser(String username) throws AccountExpiredException {
        if (logger.isDebugEnabled()) {
            logger.debug("input username = '" + username + "'");
        }
        if (username == null) {
            logger.debug("username is null");
            return null;
        }
        IJuser juser = this.getJuser(username);
        if (juser == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No user " + username + " is found in juser database.");
            }
            return null;
        }
        if (!juser.getUserid().equals(username)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bad user " + username + " is loaded, in:" + username + ",result=" + juser.getUserid());
            }
            return null;
        }
        if (!JFCUtils.isValidValue(juser.getValid())) {
            if (logger.isDebugEnabled()) {
                logger.debug("user " + username + " is expired.");
            }
            throw new AccountExpiredException(juser.getValid());
        }
        return juser;
    }

    @Override
    public abstract String[] getAllUsername();

    @Override
    public abstract void close();

    @Override
    public Preference loadPreference(String username) {
        IJuser juser = this.getJuserForPreference(username);
        if (juser == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00032), LogCodeManager.getMessage(LogCode.JFC00032, username));
            Preference preference = new Preference();
            preference.setId(username);
            return preference;
        }
        return this.loadPreference(juser);
    }

    @Override
    public Preference loadPreference(IJuser juser) {
        String username = juser.getUserid();
        Preference preference = new Preference();
        preference.setId(username);
        this.loadPreferenceJuser(juser, preference);
        return preference;
    }

    protected void loadPreferenceJuser(IJuser juser, Preference preference) {
        PreferenceItem[] prefitems;
        for (PreferenceItem prefitem : prefitems = juser.getPreferenceItem()) {
            if (prefitem == null) continue;
            Item item = new Item();
            item.setType("juser");
            item.setKey(prefitem.getKey());
            item.setContent(prefitem.getContent());
            preference.addItem(item);
        }
    }

    protected void savePreference(IJuser juser, PreferenceInfo preferenceInfo) {
        this.savePreferenceJuser(juser, preferenceInfo);
    }

    protected void savePreferenceJuser(IJuser juser, PreferenceInfo preferenceInfo) {
        boolean isChanged = false;
        String prefitemtype = "juser";
        PreferenceItem[] prefitems = juser.getPreferenceItem();
        HashMap<String, Item> itemMap = new HashMap<String, Item>(preferenceInfo.updateMap);
        ArrayList<PreferenceItem> list = new ArrayList<PreferenceItem>();
        for (int i = 0; i < prefitems.length; ++i) {
            PreferenceItem prefitem = prefitems[i];
            String key = prefitem.getKey();
            if (preferenceInfo.deletekeys.contains(key)) {
                isChanged = true;
                continue;
            }
            if (itemMap.containsKey(key)) {
                Item item = itemMap.remove(key);
                if (item.getType() == null || item.getType() == "juser") {
                    prefitem.setContent(item.getContent());
                    isChanged = true;
                } else {
                    isChanged = true;
                    continue;
                }
            }
            list.add(prefitem);
        }
        for (Item item : itemMap.values()) {
            if (item.getType() != null && item.getType() != "juser") continue;
            PreferenceItem prefitem = new PreferenceItem();
            prefitem.setKey(item.getKey());
            prefitem.setContent(item.getContent());
            list.add(prefitem);
            isChanged = true;
        }
        if (isChanged) {
            prefitems = list.toArray(new PreferenceItem[list.size()]);
            juser.setPreferenceItem(prefitems);
            this.updateJuserInTransaction(juser);
            if (logger.isDebugEnabled()) {
                logger.debug("savePreference: success update juser " + juser.getUserid());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("savePreference: no update juser " + juser.getUserid());
        }
    }

    @Override
    public void deletePreference(String username) {
    }

    @Override
    public boolean isSupportLastAccessTime() {
        return true;
    }

    @Override
    public abstract long getLastAccessTime(String var1);

    @Override
    public abstract void setLastAccessTime(String var1, long var2);

    @Override
    public abstract Principal[] getPrincipals(String var1);

    @Override
    public abstract Permission[] getPermissions(Principal var1);

    protected static Collection<JFCBasePrincipal> getPrincipalsInJprincipal(MasterJprincipal masterJprincipal, IJuser juser) {
        HashSet<JFCBasePrincipal> set;
        block6: {
            if (logger.isDebugEnabled()) {
                logger.debug("user " + juser);
            }
            set = new HashSet<JFCBasePrincipal>();
            try {
                int[] jprincipalids = juser.getJprincipalId();
                for (int i = 0; i < jprincipalids.length; ++i) {
                    int jprincipalid = jprincipalids[i];
                    if (logger.isDebugEnabled()) {
                        logger.debug("jprincipal id = " + jprincipalid);
                    }
                    Jprincipal jprincipal = masterJprincipal.getData(jprincipalid);
                    if (logger.isDebugEnabled()) {
                        logger.debug("jprincipal = " + jprincipal);
                    }
                    if (jprincipal == null) continue;
                    String principalname = jprincipal.getPrincipalId();
                    set.add(new JFCAppPrincipal(principalname));
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Failed to get jprincipal info for juser " + juser.getUserid() + ".", (Throwable)e);
                e.printStackTrace();
            }
        }
        return set;
    }

    protected void occurUpdateJuserEvent(UserInfoUpdateEvent event) {
        UserInfoFactory.occurUpdateJuserEvent(event);
    }

    protected void occurUpdateLastAccessTimeEvent(UserInfoUpdateEvent event) {
        UserInfoFactory.occurUpdateLastAccessTimeEvent(event);
    }
}

