/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.FileUserInfo;
import jp.jasminesoft.jfc.HibernateUserInfo;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoUpdateEvent;
import jp.jasminesoft.jfc.UserInfoUpdateListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserInfoFactory {
    private static final Logger logger = LogManager.getLogger(UserInfoFactory.class);
    private static final String UserInfoTypeSystemPropertyName = "userinfotype";
    private static final String UserInfoType_File = "FILE";
    private static final String UserInfoType_Hibernate = "Hibernate";
    private static final String DefaultUserInfoType = "Hibernate";
    public static final int File = 0;
    public static final int Hibernate = 4;
    private static final String UserInfoFilename = "userinfo.ser";
    private static UserInfo _userinfo = null;
    private static String _type = null;
    private static DataSource _dataSource = null;
    private static List<UserInfoUpdateListener> listeners;

    public static void setUserInfoType(String type0) {
        if (_type == null) {
            _type = type0;
        }
    }

    public static String getUserInfoType() {
        return _type;
    }

    static boolean isUseGetPermissionsInUserInfo() {
        return false;
    }

    public static synchronized int getUserInfoTypeCode() {
        if (_type == null) {
            _type = PropertyManager.getProperty(UserInfoTypeSystemPropertyName);
        }
        if (_type == null) {
            _type = "Hibernate";
        }
        if (_type.equals(UserInfoType_File)) {
            return 0;
        }
        if (_type.equals("Hibernate")) {
            return 4;
        }
        logger.log(LogCodeManager.getPriority(LogCode.JFC00109), LogCodeManager.getMessage(LogCode.JFC00109, _type));
        return -1;
    }

    public static UserInfo getUserInfo() {
        return UserInfoFactory.getUserInfo(null);
    }

    public static Connection createConnection() {
        Connection _con = null;
        if (_dataSource == null) {
            return null;
        }
        try {
            _con = _dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return _con;
    }

    public static synchronized UserInfo getUserInfo(Connection con) {
        UserInfo userinfo = null;
        int type = UserInfoFactory.getUserInfoTypeCode();
        if (type == 0) {
            if (_userinfo != null) {
                return _userinfo;
            }
            userinfo = FileUserInfo.create(UserInfoFilename);
            _userinfo = userinfo;
        } else if (type == 4) {
            userinfo = new HibernateUserInfo();
        }
        return userinfo;
    }

    public static void addUserInfoUpdateListener(UserInfoUpdateListener listener) {
        listeners.add(listener);
    }

    public static void removeUserInfoUpdateListener(UserInfoUpdateListener listener) {
        listeners.remove(listener);
    }

    static void occurUpdateJuserEvent(UserInfoUpdateEvent event) {
        for (UserInfoUpdateListener listener : listeners) {
            listener.updateJuser(event);
        }
    }

    static void occurUpdateLastAccessTimeEvent(UserInfoUpdateEvent event) {
        for (UserInfoUpdateListener listener : listeners) {
            listener.updateLastAccessTime(event);
        }
    }

    static {
        _dataSource = JFCUtils.getDataSource();
        listeners = new CopyOnWriteArrayList<UserInfoUpdateListener>();
    }
}

