/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import net.arnx.jsonic.JSON;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnormJsonClient {
    private static AnormJsonClient _instance;
    private static Logger logger;
    public static int CTV_CODE;
    public static int AREA_CODE;
    public static int PREF;
    public static int CTV;
    public static int AREA;
    public static int AREA_NUMBER;
    public static int KOAZA;
    public static int BANCHI_GO;
    public static int NAME;
    public static int CLASS;
    public static int PREF_K;
    public static int CTV_K;
    public static int AREA_K;
    public static int KOAZA_K;
    public static int C_CTV_CODE;
    public static int C_AREA_CODE;
    public static int C_PREF;
    public static int C_CTV;
    public static int C_AREA;
    public static int C_PREF_K;
    public static int C_CTV_K;
    public static int C_AREA_K;
    public static int C_KOAZA_K;
    public static int C_AREA_NUMBER;
    public static int C_KOAZA;
    public static int C_BANCHI_GO;
    public static int C_NAME;
    public static int C_CLASS;
    public static int LOGMESSAGE;
    public static int OFFICE_ZIP_REST;
    public static boolean CANDIDATE_ON;
    public static boolean CANDIDATE_OFF;
    private Map<String, Integer> indexMap;
    private Map<Integer, String> reverseMap;
    private CachedResultArray cachedArray;
    private HttpClient client;
    private String anormServerUrl;

    public void setAnormServerUrl(String url) {
        this.anormServerUrl = url;
    }

    public String getAnormServerUrl() {
        return this.anormServerUrl;
    }

    public static AnormJsonClient getInstance() {
        if (_instance == null) {
            _instance = new AnormJsonClient();
        }
        return _instance;
    }

    private AnormJsonClient() {
        HttpConnectionManagerParams hcmp = new HttpConnectionManagerParams();
        hcmp.setConnectionTimeout(3000);
        hcmp.setSoTimeout(3000);
        SimpleHttpConnectionManager hcm = new SimpleHttpConnectionManager();
        hcm.setParams(hcmp);
        this.client = new HttpClient((HttpConnectionManager)hcm);
        this.init();
    }

    private void init() {
        this.indexMap = new HashMap<String, Integer>();
        this.indexMap.put("CTV_CODE", new Integer(CTV_CODE));
        this.indexMap.put("AREA_CODE", new Integer(AREA_CODE));
        this.indexMap.put("PREF", new Integer(PREF));
        this.indexMap.put("CTV", new Integer(CTV));
        this.indexMap.put("AREA", new Integer(AREA));
        this.indexMap.put("AREA_NUMBER", new Integer(AREA_NUMBER));
        this.indexMap.put("KOAZA", new Integer(KOAZA));
        this.indexMap.put("BANCHI_GO", new Integer(BANCHI_GO));
        this.indexMap.put("NAME", new Integer(NAME));
        this.indexMap.put("CLASS", new Integer(CLASS));
        this.indexMap.put("PREF_K", new Integer(PREF_K));
        this.indexMap.put("CTV_K", new Integer(CTV_K));
        this.indexMap.put("AREA_K", new Integer(AREA_K));
        this.indexMap.put("KOAZA_K", new Integer(KOAZA_K));
        this.indexMap.put("C_CTV_CODE", new Integer(C_CTV_CODE));
        this.indexMap.put("C_AREA_CODE", new Integer(C_AREA_CODE));
        this.indexMap.put("C_PREF", new Integer(C_PREF));
        this.indexMap.put("C_CTV", new Integer(C_CTV));
        this.indexMap.put("C_AREA", new Integer(C_AREA));
        this.indexMap.put("C_PREF_K", new Integer(C_PREF_K));
        this.indexMap.put("C_CTV_K", new Integer(C_CTV_K));
        this.indexMap.put("C_AREA_K", new Integer(C_AREA_K));
        this.indexMap.put("C_KOAZA_K", new Integer(C_KOAZA_K));
        this.indexMap.put("C_AREA_NUMBER", new Integer(C_AREA_NUMBER));
        this.indexMap.put("C_KOAZA", new Integer(C_KOAZA));
        this.indexMap.put("C_BANCHI_GO", new Integer(C_BANCHI_GO));
        this.indexMap.put("C_NAME", new Integer(C_NAME));
        this.indexMap.put("C_CLASS", new Integer(C_CLASS));
        this.reverseMap = new HashMap<Integer, String>();
        for (String type : this.indexMap.keySet()) {
            Integer value = this.indexMap.get(type);
            this.reverseMap.put(value, type);
        }
        this.cachedArray = new CachedResultArray(20);
    }

    public String[] getResultByString(String input) {
        String banchigo;
        String[] array = new String[28];
        String e_input = null;
        try {
            e_input = WebStringEncodeUtilities.encodeString((String)input, (String)"utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException, " + input);
        }
        String ret = this.getJsonString("http://localhost:8080/anorm/v1/anorm?address=" + e_input);
        if (StringUtils.isBlank((String)ret)) {
            return array;
        }
        Map map = (Map)JSON.decode((String)ret);
        array[AnormJsonClient.PREF] = (String)map.get("PREF");
        array[AnormJsonClient.CTV] = (String)map.get("CITY");
        array[AnormJsonClient.AREA] = (String)map.get("AREA");
        array[AnormJsonClient.PREF_K] = (String)map.get("PREF_KANA");
        array[AnormJsonClient.CTV_K] = (String)map.get("CITY_KANA");
        array[AnormJsonClient.AREA_K] = (String)map.get("AREA_KANA");
        array[AnormJsonClient.KOAZA_K] = (String)map.get("SUBAREA_KANA");
        StringBuilder _areaNumber = new StringBuilder();
        String subarea = (String)map.get("SUBAREA");
        if (StringUtils.isNotBlank((String)subarea)) {
            array[AnormJsonClient.KOAZA] = subarea;
            _areaNumber.append(subarea);
            _areaNumber.append("-");
        }
        if (StringUtils.isNotBlank((String)(banchigo = (String)map.get("BANCHI_GO")))) {
            array[AnormJsonClient.BANCHI_GO] = banchigo;
            _areaNumber.append(banchigo);
        }
        if (_areaNumber.length() > 0) {
            array[AnormJsonClient.AREA_NUMBER] = _areaNumber.toString();
        }
        array[AnormJsonClient.NAME] = (String)map.get("BUILDING_NAME");
        array[AnormJsonClient.CLASS] = (String)map.get("BUILDING_NUMBER");
        array[AnormJsonClient.CTV_CODE] = (String)map.get("ADDR_CODE");
        array[AnormJsonClient.AREA_CODE] = (String)map.get("ZIPCODE");
        List c_addresses = (List)map.get("Candidates");
        if (c_addresses != null && c_addresses.size() > 0) {
            String c_banchigo;
            Map c_map = (Map)c_addresses.get(0);
            array[AnormJsonClient.C_PREF] = (String)c_map.get("PREF");
            array[AnormJsonClient.C_CTV] = (String)c_map.get("CITY");
            array[AnormJsonClient.C_AREA] = (String)c_map.get("AREA");
            array[AnormJsonClient.C_PREF_K] = (String)c_map.get("PREF_KANA");
            array[AnormJsonClient.C_CTV_K] = (String)c_map.get("CITY_KANA");
            array[AnormJsonClient.C_AREA_K] = (String)c_map.get("AREA_KANA");
            array[AnormJsonClient.C_KOAZA_K] = (String)c_map.get("SUBAREA_KANA");
            StringBuilder c_areaNumber = new StringBuilder();
            String c_subarea = (String)c_map.get("SUBAREA");
            if (StringUtils.isNotBlank((String)c_subarea)) {
                array[AnormJsonClient.C_KOAZA] = c_subarea;
                c_areaNumber.append(c_subarea);
                c_areaNumber.append("-");
            }
            if (StringUtils.isNotBlank((String)(c_banchigo = (String)c_map.get("BANCHI_GO")))) {
                array[AnormJsonClient.C_BANCHI_GO] = c_banchigo;
                c_areaNumber.append(c_banchigo);
            }
            if (c_areaNumber.length() > 0) {
                array[AnormJsonClient.C_AREA_NUMBER] = c_areaNumber.toString();
            }
            array[AnormJsonClient.C_NAME] = (String)c_map.get("BUILDING_NAME");
            array[AnormJsonClient.C_CLASS] = (String)c_map.get("BUILDING_NUMBER");
            array[AnormJsonClient.C_CTV_CODE] = (String)c_map.get("ADDR_CODE");
            array[AnormJsonClient.C_AREA_CODE] = (String)c_map.get("ZIPCODE");
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            array[i] = "";
        }
        return array;
    }

    public String getResultByString(String s, String part) {
        Integer _index;
        boolean needsToSaveCache = false;
        String[] results = this.findResultCache(s);
        if (results == null) {
            results = this.getResultByString(s);
            needsToSaveCache = true;
        }
        if ((_index = this.indexMap.get(part)) == null) {
            return part;
        }
        if (_index < 0 || _index >= results.length) {
            return part;
        }
        String ret = results[_index];
        if (ret == null) {
            ret = "";
        }
        if (needsToSaveCache) {
            this.saveResultCache(s, results);
        }
        return ret;
    }

    private String[] findResultCache(String address) {
        CachedResult cresult = this.cachedArray.find(address);
        if (cresult != null) {
            return cresult.getResult();
        }
        return null;
    }

    private void saveResultCache(String address, String[] result) {
        CachedResult cresult = new CachedResult(address, result);
        this.cachedArray.save(cresult);
    }

    public String normalize(String input) {
        if (StringUtils.isBlank((String)input)) {
            return "";
        }
        String e_input = null;
        try {
            e_input = WebStringEncodeUtilities.encodeString((String)input, (String)"utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException, " + input);
        }
        String ret = this.getJsonString("http://localhost:8080/anorm/v1/anorm?address=" + e_input);
        Map map = (Map)JSON.decode((String)ret);
        return this.createAddressExpressionString(map);
    }

    public String[] getAddress(String zipcode) {
        if (StringUtils.isBlank((String)zipcode)) {
            return new String[0];
        }
        if (zipcode.length() == 7) {
            return this.getAddress4ZipMatch(zipcode);
        }
        return this.getAddress4ZipSync(zipcode);
    }

    private String[] getAddress4ZipMatch(String zipcode) {
        if (StringUtils.isBlank((String)zipcode)) {
            return new String[0];
        }
        if (zipcode.length() != 7) {
            return this.getAddress4ZipSync(zipcode);
        }
        String ret = this.getJsonString("http://localhost:8080/anorm/v1/anorm?zipcode=" + zipcode);
        if (StringUtils.isBlank((String)ret)) {
            return new String[0];
        }
        String[] array = new String[4];
        Map map = (Map)JSON.decode((String)ret);
        array[0] = (String)map.get("PREF");
        array[1] = (String)map.get("CITY");
        array[2] = (String)map.get("AREA");
        array[3] = (String)map.get("NOT_NORMALIZED");
        return array;
    }

    public String[] getAddress4ZipSync(String zipcode) {
        if (StringUtils.isBlank((String)zipcode)) {
            return new String[0];
        }
        if (zipcode.length() == 7) {
            return this.getAddress4ZipMatch(zipcode);
        }
        String ret = this.getJsonString("http://localhost:8080/anorm/v1/anorm?zipcode=" + zipcode);
        if (StringUtils.isBlank((String)ret)) {
            return new String[0];
        }
        Map maps = (Map)JSON.decode((String)ret);
        String[] array = new String[maps.size()];
        int i = 0;
        for (String s : maps.values()) {
            Map map = (Map)JSON.decode((String)s);
            StringBuilder sb = new StringBuilder();
            sb.append((String)map.get("ZIPCODE"));
            sb.append(" ");
            sb.append(this.createAddressExpressionString(map));
            array[i++] = sb.toString();
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJsonString(String url) {
        GetMethod method = new GetMethod(url);
        int resp_code = 500;
        InputStream is = null;
        StringBuilder buf = new StringBuilder();
        try {
            resp_code = this.client.executeMethod((HttpMethod)method);
            if (resp_code == 200) {
                is = method.getResponseBodyAsStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buf.append(line);
                }
            } else {
                logger.info("Response code:" + resp_code);
            }
        }
        catch (Exception e) {
            logger.error(url + " " + e);
        }
        finally {
            method.releaseConnection();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buf.toString();
    }

    private String createAddressExpressionString(Map<String, String> map) {
        String s0 = null;
        StringBuilder sb = new StringBuilder();
        s0 = map.get("PREF");
        if (s0 != null && s0.length() > 0) {
            sb.append(s0);
        }
        if ((s0 = map.get("CITY")) != null && s0.length() > 0) {
            sb.append(s0);
        }
        if ((s0 = map.get("AREA")) != null && s0.length() > 0) {
            sb.append(s0);
        }
        boolean addChomeFlag = false;
        s0 = map.get("SUBAREA");
        if (s0 != null && s0.length() > 0) {
            sb.append(s0);
            addChomeFlag = true;
        }
        if ((s0 = map.get("BANCHI_GO")) != null && s0.length() > 0) {
            if (addChomeFlag) {
                sb.append("-");
            }
            sb.append(s0);
        }
        boolean addSpaceFlag = false;
        s0 = map.get("BUILDING_NAME");
        if (s0 != null && s0.length() > 0) {
            if (!addSpaceFlag) {
                sb.append(" ");
                addSpaceFlag = true;
            }
            sb.append(s0);
        }
        if ((s0 = map.get("BUILDING_NUMBER")) != null && s0.length() > 0) {
            if (!addSpaceFlag) {
                sb.append(" ");
                addSpaceFlag = true;
            }
            sb.append(s0);
        }
        if ((s0 = map.get("NOT_NORMALIZED")) != null && s0.length() > 0) {
            sb.append(" ");
            sb.append(s0);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        AnormJsonClient client = AnormJsonClient.getInstance();
        String url = null;
        if (args.length == 1) {
            url = args[0];
        }
        if (url == null) {
            url = "http://localhost:8080/anorm/v1/anorm";
        }
        client.setAnormServerUrl(url);
        String input = "\u5317\u533a\u5409\u91ce\u753a\uff12\u30fc\uff12\uff11\uff13 \u3064\u3064\u3058\u30f6\u4e18\u516c\u5712";
        String s1 = client.normalize(input);
        System.out.println("result=" + s1);
        String[] ss = client.getResultByString(input);
        for (int i = 0; i < ss.length; ++i) {
            System.out.println(i + "=" + ss[i]);
        }
        System.out.println("CTV_CODE=" + client.getResultByString(input, "CTV_CODE"));
        System.out.println("AREA_CODE=" + client.getResultByString(input, "AREA_CODE"));
        System.out.println("PREF=" + client.getResultByString(input, "PREF"));
        System.out.println("CTV=" + client.getResultByString(input, "CTV"));
        System.out.println("AREA=" + client.getResultByString(input, "AREA"));
        System.out.println("AREA_NUMBER=" + client.getResultByString(input, "AREA_NUMBER"));
        System.out.println("KOAZA=" + client.getResultByString(input, "KOAZA"));
        System.out.println("BANCHI_GO=" + client.getResultByString(input, "BANCHI_GO"));
        System.out.println("NAME=" + client.getResultByString(input, "NAME"));
        System.out.println("CLASS=" + client.getResultByString(input, "CLASS"));
    }

    static {
        logger = LogManager.getLogger(AnormJsonClient.class);
        CTV_CODE = 0;
        AREA_CODE = 1;
        PREF = 2;
        CTV = 3;
        AREA = 4;
        AREA_NUMBER = 5;
        KOAZA = 24;
        BANCHI_GO = 25;
        NAME = 6;
        CLASS = 7;
        PREF_K = 9;
        CTV_K = 10;
        AREA_K = 11;
        KOAZA_K = 8;
        C_CTV_CODE = 12;
        C_AREA_CODE = 13;
        C_PREF = 14;
        C_CTV = 15;
        C_AREA = 16;
        C_PREF_K = 17;
        C_CTV_K = 18;
        C_AREA_K = 19;
        C_KOAZA_K = 23;
        C_AREA_NUMBER = 20;
        C_KOAZA = 26;
        C_BANCHI_GO = 27;
        C_NAME = 21;
        C_CLASS = 22;
        LOGMESSAGE = 31;
        OFFICE_ZIP_REST = 1000;
        CANDIDATE_ON = true;
        CANDIDATE_OFF = false;
    }

    private class CachedResult {
        String address;
        String[] result;

        CachedResult(String address, String[] result) {
            this.address = address;
            this.result = result;
        }

        String getAddress() {
            return this.address;
        }

        String[] getResult() {
            return this.result;
        }

        public String toString() {
            return this.address;
        }
    }

    private class CachedResultArray {
        int size;
        int ptr;
        CachedResult[] carray;

        CachedResultArray(int size) {
            this.size = size;
            this.carray = new CachedResult[size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CachedResult find(String address) {
            CachedResult ret = null;
            CachedResult[] cachedResultArray = this.carray;
            synchronized (this.carray) {
                for (CachedResult cresult : this.carray) {
                    if (cresult == null || !cresult.getAddress().equals(address)) continue;
                    ret = cresult;
                    break;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void save(CachedResult cresult) {
            if (this.find(cresult.getAddress()) != null || cresult == null || cresult.getAddress() == null || cresult.getAddress().length() <= 0) return;
            CachedResult[] cachedResultArray = this.carray;
            synchronized (this.carray) {
                this.carray[this.ptr++] = cresult;
                if (this.ptr < this.size) return;
                this.ptr = 0;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

