/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Properties;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.app.CacheManagerBase;
import jp.jasminesoft.jfc.core.resources.PropertyUtils;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class CacheManagerUtil {
    private static final Logger logger = LogManager.getLogger(CacheManagerUtil.class);
    private static final String packagenameKey = "server.servlet.context-parameters.packagename";

    public static void clear(String[] ids, ActionParameter p) {
        String packagename;
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return;
        }
        Environment env = (Environment)p.appctx.getBean(Environment.class);
        String packagename_app = null;
        if (env != null && StringUtils.isNotBlank((String)(packagename = env.getProperty(packagenameKey)))) {
            packagename_app = packagename + ".app";
        }
        if (packagename_app == null) {
            packagename_app = "jp.jasminesoft.wagby";
            logger.debug("No package name is found in application properties. Use default packagename_app," + packagename_app);
        }
        CacheManagerUtil.clearCacheManager(ids, packagename_app, p);
    }

    public static void clearCacheManager(String[] ids, String packagename_app, ActionParameter p) {
        if (!packagename_app.endsWith(".")) {
            packagename_app = packagename_app + ".";
        }
        String cacheManagerClassName = packagename_app + "CacheManager";
        logger.debug("use cacheManager, class name=" + cacheManagerClassName);
        try {
            Class<?> cman_clazz_ = Class.forName(cacheManagerClassName);
            Method method_ = cman_clazz_.getMethod("getInstance", null);
            Object cman_obj_ = method_.invoke(null, null);
            for (String id : ids) {
                if (id.equals("*")) {
                    logger.debug("calling CacheManager.clearAll method...");
                    Method clear_method_ = cman_clazz_.getMethod("clearAll", null);
                    clear_method_.invoke(cman_obj_, null);
                    break;
                }
                String clear_method_name_ = "clear" + StringUtil.capFirst((String)id);
                Method clear_method_ = cman_clazz_.getMethod(clear_method_name_, null);
                clear_method_.invoke(cman_obj_, null);
                logger.debug(clear_method_name_ + " is called.");
            }
        }
        catch (NoSuchMethodException e) {
            String errmsg = e.getMessage();
            String search_str = "CacheManager.clear";
            int ep = errmsg.indexOf(search_str);
            String cnt = "";
            if (ep > 0) {
                cnt = errmsg.substring(ep + search_str.length());
                cnt = cnt.substring(0, cnt.length() - 2);
                cnt = StringUtil.uncapFirst((String)cnt);
            }
            logger.log(LogCodeManager.getPriority(LogCode.JFC00924), LogCodeManager.getMessage(LogCode.JFC00924, cnt));
        }
        catch (ClassNotFoundException e) {
            logger.warn("Failed to clear cache, ClassNotFoundException, " + e.getMessage());
        }
        catch (SecurityException e) {
            logger.warn("Failed to clear cache, SecurityException, " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Failed to clear cache, IllegalArgumentException, " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.warn("Failed to clear cache, IllegalAccessException, " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.warn("Failed to clear cache, InvocationTargetException, " + e.getMessage());
        }
    }

    public static CacheManagerBase getCacheManager(ApplicationContext applicationContext) {
        Environment env = Optional.ofNullable(applicationContext).map(appctx -> (Environment)appctx.getBean(Environment.class)).orElse(null);
        String packagename = null;
        if (env != null) {
            packagename = env.getProperty(packagenameKey);
        }
        if (StringUtils.isBlank(packagename)) {
            Properties properties;
            try {
                properties = PropertyUtils.loadResourceQuietly("application.properties");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            packagename = properties.getProperty(packagenameKey);
        }
        String cacheManagerClassName = packagename + ".app.CacheManager";
        try {
            Class<?> clazz = Class.forName(cacheManagerClassName);
            return (CacheManagerBase)ReflectionUtils.invokePrivateStaticMethod(clazz, "getInstance");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

