/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.FilenameList;
import jp.jasminesoft.jfc.IPresentationHelper;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemString;
import jp.jasminesoft.jfc.model.PresentationContainerBase;
import jp.jasminesoft.util.ClassUtils;
import jp.jasminesoft.util.MultiPartForm;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CreateObjectHelper<T>
implements IPresentationHelper {
    private static final Logger logger = LogManager.getLogger((String)CreateObjectHelper.class.getName());
    private static final String FILENAME_FOOTER = "_jshfilename";
    private static final String CLEARNAME_FOOTER = "_jshclear";
    private static final String NOTCLEAR_CONTENTMAP_KEY = CreateObjectHelper.class.getName() + "_notclear_contentmap";
    protected final String PARAM_HEADER = "/" + this.getPModelId() + "/";
    protected final String PARAM_HEADER2;

    public CreateObjectHelper() {
        String paramheader2 = this.getPModelId() + "/";
        this.PARAM_HEADER2 = paramheader2 = paramheader2.replace("/", StringUtil.convertHtmlIdString((String)"/"));
    }

    public T createObjectDoGetXml(ActionParameter p) {
        p.request.setAttribute(NOTCLEAR_CONTENTMAP_KEY, (Object)Boolean.TRUE);
        try {
            T t = this.createObject(p);
            return t;
        }
        finally {
            p.request.removeAttribute(NOTCLEAR_CONTENTMAP_KEY);
        }
    }

    public T createObject(ActionParameter p) {
        MultiPartForm multi = (MultiPartForm)p.pageMap.get("__jfc_multi");
        if (multi != null && multi.isMultipartContent(p.request)) {
            return this.createObject_MultiPartForm(p);
        }
        Map<String, String[]> parammap = this.createParamMap(p);
        if (parammap == null) {
            return null;
        }
        Map<String, Object[]> map = this.convertMap(parammap);
        String mitemFooter = this.getRealFilenameRefModelitemFooter();
        if (mitemFooter != null && mitemFooter.length() > 0) {
            this.createObject_MultiPartFormWithRealFilenameSuffix(map, mitemFooter, CLEARNAME_FOOTER, p);
        }
        return this.createObject(map, p);
    }

    private Map<String, String[]> createParamMap(ActionParameter p) {
        HashMap<String, String[]> parammap;
        Map mvmap = (Map)p.request.getAttribute("createObject_multiValueMap");
        if (mvmap != null) {
            parammap = new HashMap();
            for (Map.Entry e : mvmap.entrySet()) {
                parammap.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[0]));
            }
        } else {
            Map parammap1 = p.request.getParameterMap();
            parammap = parammap1;
        }
        return parammap;
    }

    public Map<String, Object[]> convertMap(Map<String, String[]> parammap) {
        if (parammap == null) {
            return null;
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.putAll(parammap);
        return map;
    }

    public abstract T createObject(Map<String, Object[]> var1, ActionParameter var2);

    protected T createObject_MultiPartForm(ActionParameter p) {
        Map<String, Object[]> map;
        MultiPartForm multi = (MultiPartForm)p.pageMap.get("__jfc_multi");
        if (multi == null) {
            if ("condition".equals(this.getPRefModelType())) {
                return null;
            }
            return this.newPresentationInstance();
        }
        String mitemFooter = this.getRealFilenameRefModelitemFooter();
        if (mitemFooter != null && mitemFooter.length() > 0) {
            map = this.createObject_MultiPartFormWithRealFilenameSuffix(multi, mitemFooter, CLEARNAME_FOOTER, p);
            if (this.isEmptyValue(map)) {
                return this.newPresentationInstance();
            }
        } else {
            map = multi.getContentsListMap();
        }
        return this.createObject(map, p);
    }

    protected boolean isStartsWithParameterHeader(String key) {
        return key.startsWith(this.PARAM_HEADER) || key.startsWith(this.PARAM_HEADER2);
    }

    protected String getRealFilenameRefModelitemFooter() {
        return null;
    }

    protected abstract String getPModelId();

    protected abstract String getPRefModelType();

    protected abstract T newPresentationInstance();

    protected Map<String, Object[]> createObject_MultiPartFormWithRealFilenameSuffix(MultiPartForm multi, String filenamefooter, String clearnamefooter, ActionParameter p) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        this.addMultiPartFormParameter(multi, filenamefooter, p, map);
        this.addSessionAttribute(filenamefooter, p, map);
        this.addFilenameListValue(filenamefooter, p, map);
        this.removeJshclearParameter(multi, filenamefooter, clearnamefooter, map);
        return map;
    }

    protected void createObject_MultiPartFormWithRealFilenameSuffix(Map<String, Object[]> map, String filenamefooter, String clearnamefooter, ActionParameter p) {
        this.addSessionAttribute(filenamefooter, p, map);
        this.addFilenameListValue(filenamefooter, p, map);
        this.removeJshclearParameter(filenamefooter, clearnamefooter, map);
    }

    protected boolean isEmptyValue(Map<String, Object[]> map) {
        if (map == null || map.size() == 0) {
            return true;
        }
        boolean isEmpty = true;
        block0: for (String key : map.keySet()) {
            Object[] ary;
            if (!this.isStartsWithParameterHeader(key) || (ary = map.get(key)) == null) continue;
            for (Object o : ary) {
                if (o == null || !StringUtils.isNotBlank((CharSequence)o.toString())) continue;
                isEmpty = false;
                break block0;
            }
        }
        return isEmpty;
    }

    private void addMultiPartFormParameter(MultiPartForm multi, String filenamefooter, ActionParameter p, Map<String, Object[]> map) {
        Iterator it = multi.getParameterList().iterator();
        HashSet<String> processedkeys = new HashSet<String>();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (processedkeys.contains(key)) continue;
            processedkeys.add(key);
            String[] filenamelist = multi.getSrcFilenameList(key);
            if (filenamelist != null) {
                Object[] files = multi.getContentsList(key);
                if (filenamelist.length == 0 || files.length == 0 || !(files[0] instanceof File) || this.checkFile(p, filenamelist, files, key)) continue;
                map.put(key, filenamelist);
                List c1 = Arrays.stream(files).map(c -> c.toString()).collect(Collectors.toList());
                map.put(key + filenamefooter, c1.toArray());
                continue;
            }
            map.put(key, multi.getContentsList(key));
        }
    }

    public String getModelId() {
        return null;
    }

    public boolean checkFile(ActionParameter p, String[] fname, Object[] file, String key) {
        return CreateObjectHelper.checkFile(p, fname, file, this.getModelId(), key);
    }

    public static boolean checkFile(ActionParameter p, String[] fname, Object[] file, String modelId, String key) {
        int len = Math.max(fname.length, file.length);
        for (int i = 0; i < len; ++i) {
            if (!CreateObjectHelper.checkFile(p, fname[i], (File)file[i], modelId, key)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkFile(ActionParameter p, String fname, File file, String modelId, String key) {
        logger.info("filename:" + fname + " path:" + file.getAbsolutePath() + " modelId:" + modelId + " key:" + key);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filename", fname);
        params.put("path", file);
        params.put("modelId", modelId);
        params.put("key", key);
        String msg = CreateObjectHelper._checkFile(p, fname, file, modelId, params);
        if (msg != null && msg.length() > 0) {
            Jfcerror _error = new Jfcerror();
            _error.setContent(msg);
            p.errors.addJfcerror(_error);
            return true;
        }
        return false;
    }

    private static String _checkFile(ActionParameter p, String fname, File file, String modelId, Map<String, Object> params) {
        String clazzName = "UpdateFile";
        String hookPointName = "afterUpload";
        String msg = new ScriptCodeRunner(modelId).processWithRootScript("UpdateFile", "afterUpload", params, p);
        if (msg != null && msg.length() > 0) {
            logger.info("Correspond upload file check. filename:" + fname + " path:" + file.getAbsolutePath() + " msg:" + msg + " modelId:" + modelId);
        }
        return msg;
    }

    private void addSessionAttribute(String filenamefooter, ActionParameter p, Map<String, Object[]> map) {
        HttpSession session = p.request.getSession();
        if (session == null) {
            return;
        }
        Enumeration enu = session.getAttributeNames();
        while (enu.hasMoreElements()) {
            Object o2;
            Object o1;
            String key1;
            String key2 = (String)enu.nextElement();
            if (!key2.endsWith(filenamefooter) || map.get(key1 = key2.substring(0, key2.length() - filenamefooter.length())) != null && map.get(key2) != null || (o1 = session.getAttribute(key1)) == null || !(o1 instanceof String) || (o2 = session.getAttribute(key2)) == null || !(o2 instanceof String)) continue;
            map.put(key1, new String[]{(String)o1});
            map.put(key2, new String[]{(String)o2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFilenameListValue(String filenamefooter, ActionParameter p, Map<String, Object[]> map) {
        FilenameList filenamelist = (FilenameList)p.pageMap.get("__jfc_filenamelist");
        if (filenamelist == null) {
            return;
        }
        ArrayList<String> removekeys = new ArrayList<String>();
        FilenameList filenameList = filenamelist;
        synchronized (filenameList) {
            Map<String, Object[]> srcfilenameMap = filenamelist.getSrcFilenameMap();
            Map<String, Object[]> contentsMap = filenamelist.getContentsMap();
            for (Map.Entry<String, Object[]> e : srcfilenameMap.entrySet()) {
                String key = e.getKey();
                if (!this.isStartsWithParameterHeader(key)) continue;
                removekeys.add(key);
                Object[] srcfilename1 = e.getValue();
                Object[] contents = contentsMap.get(key);
                if (contents == null) {
                    map.put(key, srcfilename1);
                    continue;
                }
                map.put(key, srcfilename1);
                List<String> c1 = Arrays.stream(contents).map(c -> c.toString()).collect(Collectors.toList());
                map.put(key + filenamefooter, c1.toArray(new String[c1.size()]));
            }
            Boolean notclear_contentmap = (Boolean)p.request.getAttribute(NOTCLEAR_CONTENTMAP_KEY);
            if (notclear_contentmap != null && notclear_contentmap.booleanValue()) {
                return;
            }
            srcfilenameMap.keySet().removeAll(removekeys);
            contentsMap.keySet().removeAll(removekeys);
        }
    }

    private void removeJshclearParameter(MultiPartForm multi, String filenamefooter, String clearnamefooter, Map<String, Object[]> map) {
        for (String key3 : multi.getParameterList()) {
            Object[] sa;
            if (!key3.endsWith(clearnamefooter) || (sa = multi.getContentsList(key3)).length == 0 || sa[0] instanceof String && ((String)sa[0]).equals("")) continue;
            String key1 = key3.substring(0, key3.length() - clearnamefooter.length());
            String key2 = key1 + filenamefooter;
            map.remove(key1);
            map.remove(key2);
            map.remove(key3);
        }
    }

    private void removeJshclearParameter(String filenamefooter, String clearnamefooter, Map<String, Object[]> map) {
        ArrayList<String> removekeys = new ArrayList<String>();
        for (Map.Entry<String, Object[]> e : map.entrySet()) {
            Object[] sa;
            String key3 = e.getKey();
            if (!key3.endsWith(clearnamefooter) || (sa = e.getValue()).length == 0 || sa[0] instanceof String && ((String)sa[0]).equals("")) continue;
            removekeys.add(key3);
        }
        for (String key3 : removekeys) {
            String key1 = key3.substring(0, key3.length() - clearnamefooter.length());
            String key2 = key1 + filenamefooter;
            map.remove(key1);
            map.remove(key2);
            map.remove(key3);
        }
    }

    public static final String convertEscaping(String key) {
        int len = key.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c != '_') {
                sb.append(c);
                continue;
            }
            if (len < i + 5) {
                sb.append(c);
                continue;
            }
            String hexs = key.substring(i + 1, i + 5);
            if (hexs.equals("002f") || hexs.equals("005b") || hexs.equals("005d") || hexs.equals("0040")) {
                try {
                    char c1 = (char)Integer.parseInt(hexs, 16);
                    sb.append(c1);
                }
                catch (NumberFormatException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Illegal format character escaping " + key, (Throwable)e);
                    }
                    sb.append(c);
                    continue;
                }
                i += 4;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String getValueForCreateObject(String key, Object value) {
        String mitemFooter = this.getRealFilenameRefModelitemFooter();
        if (mitemFooter != null && mitemFooter.length() > 0) {
            return this.getValueForCreateObjectWithRealFilenameSuffix(key, value, mitemFooter);
        }
        if (value instanceof String) {
            return JFCUtils.decodePrimaryKey((String)value);
        }
        if (value instanceof File) {
            return ((File)value).getPath();
        }
        return null;
    }

    protected String getValueForCreateObjectWithRealFilenameSuffix(String key, Object value, String suffix) {
        if (key.endsWith(suffix)) {
            return (String)value;
        }
        if (value instanceof String) {
            return JFCUtils.decodePrimaryKey((String)value);
        }
        return null;
    }

    protected void putDateComboValue(String key, Map<String, String> map) {
        String year = map.get(key + "_year");
        String month = map.get(key + "_month");
        String day = map.get(key + "_day");
        if (StringUtils.isBlank((CharSequence)year)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)month)) {
            month = "1";
        }
        if (StringUtils.isBlank((CharSequence)day)) {
            day = "1";
        }
        StringBuilder dateStr = new StringBuilder();
        dateStr.append(year).append("-").append(month).append("-").append(day);
        map.put(key, dateStr.toString());
    }

    protected void putTimeComboValue(String key, Map<String, String> map) {
        String hour = map.get(key + "_hour");
        String minute = map.get(key + "_minute");
        String second = map.get(key + "_second");
        if (StringUtils.isBlank((CharSequence)hour)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)minute)) {
            minute = "00";
        }
        if (StringUtils.isBlank((CharSequence)second)) {
            second = "00";
        }
        StringBuilder timeStr = new StringBuilder();
        timeStr.append(hour).append(":").append(minute).append(":").append(second);
        map.put(key, timeStr.toString());
    }

    public void clearJshfilenameSessionValue(ActionParameter p) {
        String mitemFooter = this.getRealFilenameRefModelitemFooter();
        if (mitemFooter != null) {
            this.clearJshfilenameSessionValue(mitemFooter, p);
            return;
        }
        this.clearJshfilenameSessionValue(FILENAME_FOOTER, p);
    }

    public void clearJshfilenameSessionValue(String filenamefooter, ActionParameter p) {
        HttpSession session = p.request.getSession();
        if (session != null) {
            ArrayList<String> removekeys = new ArrayList<String>();
            Enumeration enu = session.getAttributeNames();
            while (enu.hasMoreElements()) {
                String key2 = (String)enu.nextElement();
                if (!key2.endsWith(filenamefooter)) continue;
                String key1 = key2.substring(0, key2.length() - filenamefooter.length());
                removekeys.add(key1);
                removekeys.add(key2);
            }
            for (String key : removekeys) {
                session.removeAttribute(key);
            }
        }
    }

    protected boolean setSelectedCheckboxId(String itemname, String key, String paramheader1, Map<String, Set<String>> cbmap) {
        boolean useCheckBox = false;
        int paramheader1len = paramheader1.length();
        String idx1 = key.substring(paramheader1len, key.indexOf("]", paramheader1len));
        Set<String> idSet = cbmap.get(itemname);
        if (idSet == null) {
            idSet = new HashSet<String>();
            cbmap.put(itemname, idSet);
            useCheckBox = true;
        }
        idSet.add(idx1);
        return useCheckBox;
    }

    protected boolean setSelectedCheckboxId(String itemname, String key, String value, String paramheader1, Map<String, Set<String>> cbmap) {
        boolean useCheckBox = false;
        Set<String> idSet = cbmap.get(itemname);
        if (idSet == null) {
            idSet = new HashSet<String>();
            cbmap.put(itemname, idSet);
            useCheckBox = true;
        }
        idSet.add(value);
        return useCheckBox;
    }

    protected <Cont> void initContainerMap(Cont[] cont_ary, Map<Integer, Cont> contMap, String iditem) {
        int maxjshid = 1;
        String getterm = SourceGeneratorUtil.getterMethod((String)iditem);
        for (int i = 0; i < cont_ary.length; ++i) {
            String v = null;
            try {
                Object o = MethodUtils.invokeMethod(cont_ary[i], (String)getterm, null);
                if (o == null) {
                    logger.warn(cont_ary[i].getClass().getName() + " has container id '" + iditem + "', but this id has no value. Use alternate value " + maxjshid + ". " + cont_ary[i]);
                    v = String.valueOf(maxjshid++);
                } else {
                    v = (String)MethodUtils.invokeMethod((Object)o, (String)"getContent", null);
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int jshid = Integer.valueOf(v);
            contMap.put(jshid, cont_ary[i]);
            maxjshid = Math.max(jshid, maxjshid);
        }
    }

    protected <Presentation, Cont> void setContainer(Presentation pr, Map<Integer, Cont> contMap, Class<Cont> contClazz) {
        int _contSize = contMap.size();
        Object[] cont_ary = (Object[])Array.newInstance(contClazz, _contSize);
        for (Integer _i : contMap.keySet()) {
            int _index = _i - 1;
            if (_index < 0 || _index > _contSize) {
                logger.warn("illegal value cont index");
                continue;
            }
            cont_ary[_index] = contMap.get(_i);
        }
        for (int _index = 0; _index < cont_ary.length; ++_index) {
            if (cont_ary[_index] != null) continue;
            logger.warn("illegal value cont null data");
            cont_ary[_index] = ClassUtils.newInstance(contClazz);
        }
        String setterm = SourceGeneratorUtil.setterMethod((String)ClassUtils.getShortClassName((String)contClazz.getName()));
        try {
            MethodUtils.invokeMethod(pr, (String)setterm, (Object[])new Object[]{cont_ary});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getNewContainerSize(Map<String, Object[]> parammap, String cont_key, String[] filename_keys) {
        int cont_len = 0;
        for (String filename_key : filename_keys) {
            String cfilename_key = cont_key + filename_key;
            Object[] cfilename_arr = parammap.get(cfilename_key);
            if (cfilename_arr == null || cont_len >= cfilename_arr.length) continue;
            cont_len = cfilename_arr.length;
        }
        return cont_len;
    }

    protected void createNewContainer(Map<String, Object[]> parammap, T entityp, String entityp_name, String cont_name, String[] filename_keys) {
        this.createNewContainer(parammap, entityp, entityp_name, cont_name, filename_keys, this.getRealFilenameRefModelitemFooter());
    }

    protected void createNewContainer(Map<String, Object[]> parammap, T entityp, String entityp_name, String cont_name, String[] filename_keys, String suffix) {
        try {
            String getter = SourceGeneratorUtil.getterMethod((String)cont_name);
            PresentationContainerBase[] conts = (PresentationContainerBase[])MethodUtils.invokeMethod(entityp, (String)getter, null);
            Class<?> container_array_class = conts.getClass();
            Class<?> container_class = container_array_class.getComponentType();
            if (container_class == null) {
                logger.error("entityp." + getter + " method return type is not container array class");
                return;
            }
            ArrayList<PresentationContainerBase> new_conts = new ArrayList<PresentationContainerBase>();
            for (int i = 0; i < conts.length; ++i) {
                PresentationContainerBase cont1 = conts[i];
                cont1.setJshcontnum(i + 1);
                new_conts.add(cont1);
                String cont_key = entityp_name + StringUtil.convertHtmlIdString((String)"/") + cont_name + StringUtil.convertHtmlIdString((String)"[") + (i + 1) + StringUtil.convertHtmlIdString((String)"]/");
                int cont_len = this.getNewContainerSize(parammap, cont_key, filename_keys);
                if (cont_len <= 1) continue;
                for (int j = 1; j < cont_len; ++j) {
                    PresentationContainerBase cont = (PresentationContainerBase)container_class.newInstance();
                    cont.setJshcontnum(-1);
                    for (String filename_key : filename_keys) {
                        this.createNewContainer_child(parammap, cont_key, j, cont, filename_key, suffix);
                    }
                    new_conts.add(cont);
                }
            }
            if (conts.length != new_conts.size()) {
                String setter = SourceGeneratorUtil.setterMethod((String)cont_name);
                Object[] arg = new Object[]{new_conts.toArray((Object[])Array.newInstance(container_class, 0))};
                MethodUtils.invokeMethod(entityp, (String)setter, (Object[])arg);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void createNewContainer_child(Map<String, Object[]> parammap, String cont_key, int j, PresentationContainerBase cont, String filename_key, String suffix) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IllegalArgumentException {
        String cfilename_key = cont_key + filename_key;
        Object[] cfilename_arr = parammap.get(cfilename_key);
        if (cfilename_arr != null && cfilename_arr.length > j) {
            this.setContentFilenameKey(cont, filename_key, cfilename_arr[j].toString());
            if (suffix == null) {
                return;
            }
            String cfilenameJshfilename_key = cfilename_key + suffix;
            Object[] cfilename_jshfilename_arr = parammap.get(cfilenameJshfilename_key);
            if (cfilename_jshfilename_arr != null && cfilename_jshfilename_arr.length > j) {
                this.setContentFilenameKey(cont, filename_key + suffix, cfilename_jshfilename_arr[j].toString());
            }
        }
    }

    private void setContentFilenameKey(PresentationContainerBase cont, String filename_key, String cfilename_str) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IllegalArgumentException {
        Class<JFCPresentationModelitemString> cfilename_class = this.getFilenameKeyType(cont, filename_key);
        JFCPresentationModelitemString cfilename = cfilename_class.newInstance();
        cfilename.setContent(cfilename_str);
        String setter = SourceGeneratorUtil.setterMethod((String)filename_key);
        MethodUtils.invokeMethod((Object)cont, (String)setter, (Object[])new Object[]{cfilename});
    }

    private Class<JFCPresentationModelitemString> getFilenameKeyType(PresentationContainerBase cont, String key) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IllegalArgumentException {
        String getter = SourceGeneratorUtil.getterMethod((String)key);
        Method getmethod = cont.getClass().getMethod(getter, new Class[0]);
        return getmethod.getReturnType();
    }

    protected <T> void setChoose(T target, String iditem) {
        String getterm = SourceGeneratorUtil.getterMethod((String)iditem);
        try {
            Object o;
            Object ary = MethodUtils.invokeMethod(target, (String)getterm, null);
            if (ary != null && ary.getClass().isArray() && Array.getLength(ary) > 0 && (o = Array.get(ary, 0)) != null) {
                MethodUtils.invokeMethod((Object)o, (String)"setChoose", (Object[])new Object[]{Boolean.TRUE});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <Cont> void setChooseCont(Cont[] cont_ary, String iditem) {
        String getterm = SourceGeneratorUtil.getterMethod((String)iditem);
        for (int i = 0; i < cont_ary.length; ++i) {
            try {
                Object o;
                Object ary = MethodUtils.invokeMethod(cont_ary[i], (String)getterm, null);
                if (ary == null || !ary.getClass().isArray() || Array.getLength(ary) <= 0 || (o = Array.get(ary, 0)) == null) continue;
                MethodUtils.invokeMethod((Object)o, (String)"setChoose", (Object[])new Object[]{Boolean.TRUE});
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

