/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactoryS3BaseImpl;
import jp.jasminesoft.jfc.app.JfcfilestatusI;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.meta.ContainerChildMeta;
import jp.jasminesoft.jfc.meta.ContainerMeta;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public class DownloadFileObjectFactoryJfcfilestatusImpl<FS extends JfcfilestatusI<FS>>
implements DownloadFileObjectFactory {
    private static final Logger logger = LogManager.getLogger(DownloadFileObjectFactoryJfcfilestatusImpl.class);
    @Autowired
    private ApplicationContext appctx;
    @Autowired
    @Qualifier(value="DownloadFileObjectFactoryFileImpl")
    private DownloadFileObjectFactory dfofactory_file;
    @Autowired
    @Qualifier(value="DownloadFileObjectFactoryS3BaseImpl")
    private DownloadFileObjectFactoryS3BaseImpl dfofactory_s3base;
    @Autowired
    @Qualifier(value="JfcfilestatusEntityService")
    private JFCEntityService<FS, Integer> filestatusEntityService;
    @Autowired
    @Qualifier(value="JfcfilestatusMeta")
    private EntityMeta<FS> jfcfilestatusMeta;
    private static final String JSHFILENAME_FILESTATUS_HEADER = "jfcfilestatus:";
    private static final String INSERT_JFCFILESTATUS_REQKEY = "__jfc_" + DownloadFileObjectFactoryJfcfilestatusImpl.class.getName() + "_insertJfcfilestatus";
    private static final String SETLOCALFILEPATH_REQKEY = "__jfc_" + DownloadFileObjectFactoryJfcfilestatusImpl.class.getName() + "_setLocalfilepath";
    private static final String JSHFILENAME_FOOTER = "_jshfilename";

    public EntityMeta<FS> getJfcfilestatusEntityMeta() {
        return this.jfcfilestatusMeta;
    }

    public void setJfcfilestatusEntityMeta(EntityMeta<FS> jfcfilestatusMeta) {
        this.jfcfilestatusMeta = jfcfilestatusMeta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DownloadFileObject getDownloadFileObject(FS filestatus, HttpServletRequest request) {
        DownloadFileObjectFactory factory;
        JfcfilestatusStatus status = JfcfilestatusStatus.getById(((JfcfilestatusI)filestatus).getStatus());
        if (status == null) {
            logger.error("Unknown status code " + (Object)((Object)status));
            return null;
        }
        if (status == JfcfilestatusStatus.DELETE) {
            logger.error("Delete status code " + (Object)((Object)status) + " ");
            return null;
        }
        JfcfilestatusFiletype filetype = JfcfilestatusFiletype.getById(((JfcfilestatusI)filestatus).getFiletype());
        if (filetype == null) {
            return null;
        }
        if (filetype == JfcfilestatusFiletype.FILE) {
            if (!this.dfofactory_file.isAvailable()) return null;
            factory = this.dfofactory_file;
            return factory.create(((JfcfilestatusI)filestatus).getFilelocation(), request);
        } else {
            if (filetype != JfcfilestatusFiletype.S3) return null;
            if (!this.dfofactory_s3base.isAvailable()) return null;
            factory = this.dfofactory_s3base;
        }
        return factory.create(((JfcfilestatusI)filestatus).getFilelocation(), request);
    }

    @PostConstruct
    public void init() {
        if (!this.dfofactory_s3base.isAvailable()) {
            logger.info("nothing wagby.filestore.s3.bucket setting. use local file only");
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public DownloadFileObject create(String localfilename, HttpServletRequest request) {
        logger.debug("localfilename=" + localfilename);
        if (localfilename.startsWith(JSHFILENAME_FILESTATUS_HEADER)) {
            ActionParameterContainer pcon = (ActionParameterContainer)this.appctx.getBean(ActionParameterContainer.class);
            if (pcon.get() == null) {
                User user = JFCUtils.getUserInSession(request.getSession(), this.appctx);
                ActionParameter p = JFCUtils.createActionParameter(request, null, user, null, this.appctx);
                pcon.set(p);
            }
            String jshfilenameid = localfilename.substring(JSHFILENAME_FILESTATUS_HEADER.length());
            EntityMeta<FS> meta = this.getJfcfilestatusEntityMeta();
            PropertyMeta jshfilenameidMeta = (PropertyMeta)meta.propertyMeta("jshfilenameid");
            PropertyMeta filestatusidMeta = (PropertyMeta)meta.propertyMeta("filestatusid");
            DetachedCriteria criteria = DetachedCriteria.forClass(meta.entityClass()).eq(jshfilenameidMeta, jshfilenameid).addOrder(Order.desc((String)filestatusidMeta.name()));
            List<FS> list = this.filestatusEntityService.find(criteria);
            if (list.size() == 0) {
                return null;
            }
            JfcfilestatusI filestatus = (JfcfilestatusI)list.get(0);
            DownloadFileObject dfo = this.getDownloadFileObject(filestatus, request);
            return dfo;
        }
        DownloadFileObject dfo = this.dfofactory_file.create(localfilename, request);
        return dfo;
    }

    @Override
    public String putJshfilename(String modelid, String itemname, String title, byte[] data, HttpServletRequest request) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        return this.putJshfilename(modelid, itemname, title, map, request);
    }

    public String putJshfilename(String modelid, String itemname, String title, Map<String, Object> map, HttpServletRequest request) throws IOException {
        String key;
        HashMap<String, Map<String, Object>> putdatasmap = (HashMap<String, Map<String, Object>>)request.getAttribute(INSERT_JFCFILESTATUS_REQKEY);
        if (putdatasmap == null) {
            putdatasmap = new HashMap<String, Map<String, Object>>();
            request.setAttribute(INSERT_JFCFILESTATUS_REQKEY, putdatasmap);
        }
        String datestr = this.dfofactory_s3base.getDateStr(request);
        while (putdatasmap.containsKey(key = modelid + "/" + datestr + RandomStringUtils.randomAlphanumeric((int)8) + "_" + title)) {
        }
        map.put("modelid", modelid);
        map.put("itemname", itemname);
        map.put("title", title);
        putdatasmap.put(key, map);
        return JSHFILENAME_FILESTATUS_HEADER + key;
    }

    private void insertJfcfilestatus(HttpServletRequest request) {
        Map putdatasmap = (Map)request.getAttribute(INSERT_JFCFILESTATUS_REQKEY);
        if (putdatasmap == null) {
            return;
        }
        request.removeAttribute(INSERT_JFCFILESTATUS_REQKEY);
        HashMap putdatasmap2 = (HashMap)request.getAttribute(SETLOCALFILEPATH_REQKEY);
        if (putdatasmap2 == null) {
            putdatasmap2 = new HashMap();
            request.setAttribute(SETLOCALFILEPATH_REQKEY, putdatasmap2);
        }
        putdatasmap2.putAll(putdatasmap);
        logger.info("putdatamap2 " + putdatasmap2);
        for (String key : putdatasmap.keySet()) {
            logger.info("filestatus=" + key);
            Map putdata = (Map)putdatasmap.get(key);
            try {
                this.insertJfcfilestatus(key, putdata, request);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void insertJfcfilestatus(String jshfilenameid, Map<String, Object> putdata, HttpServletRequest request) throws IOException {
        JfcfilestatusI filestatus;
        String modelid = (String)putdata.get("modelid");
        String itemname = (String)putdata.get("itemname");
        String title = (String)putdata.get("title");
        try {
            filestatus = (JfcfilestatusI)this.getJfcfilestatusEntityMeta().entityClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("failed jfcfilestatus entity create", (Throwable)e);
            throw new IOException(e);
        }
        String s3key = null;
        if (putdata.containsKey("data")) {
            byte[] data = (byte[])putdata.get("data");
            s3key = this.dfofactory_s3base.putJshfilename(modelid, itemname, title, data, request);
            putdata.put("s3key", s3key);
            logger.info("s3key=" + s3key);
            filestatus.setJshfilenameid(jshfilenameid);
            filestatus.setStatus(JfcfilestatusStatus.STORE_SUCCESS.id());
            filestatus.setFiletype(JfcfilestatusFiletype.S3.id());
            filestatus.setFilelocation(s3key);
            try {
                this.filestatusEntityService.insert(filestatus);
            }
            catch (Exception e) {
                this.dfofactory_s3base.deleteObject(s3key);
                throw e;
            }
        } else if (putdata.containsKey("file")) {
            String file = (String)putdata.get("file");
            filestatus.setJshfilenameid(jshfilenameid);
            filestatus.setStatus(JfcfilestatusStatus.INSERT.id());
            filestatus.setFiletype(JfcfilestatusFiletype.FILE.id());
            filestatus.setFilelocation(file);
            this.filestatusEntityService.insert(filestatus);
        } else {
            throw new IllegalStateException();
        }
    }

    public <T extends ContainerBase<T>> void insertJfcfilestatusFromEntity(T entity, HttpServletRequest request) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, IOException {
        Field[] fields;
        Class<?> entityMetaClass = Class.forName(entity.getClass().getCanonicalName() + "Meta");
        EntityMeta entityMeta = (EntityMeta)entityMetaClass.newInstance();
        for (Field jshfilenamePropfield : fields = entityMetaClass.getFields()) {
            Class<?> jshfilenamePropfieldType = jshfilenamePropfield.getType();
            if (ContainerMeta.class.isAssignableFrom(jshfilenamePropfieldType)) {
                logger.info("1 " + jshfilenamePropfield);
                continue;
            }
            String jshfilenameItemname = jshfilenamePropfield.getName();
            if (!jshfilenameItemname.endsWith(JSHFILENAME_FOOTER)) {
                logger.info("2 " + jshfilenamePropfield);
                continue;
            }
            if (!PropertyMetaBase.class.isAssignableFrom(jshfilenamePropfieldType)) {
                logger.info("3 " + jshfilenamePropfield);
                continue;
            }
            PropertyMetaBase jshfilenamePropmeta = (PropertyMetaBase)jshfilenamePropfield.get(entityMeta);
            if (jshfilenamePropmeta instanceof ContainerChildMeta) {
                logger.info("4 " + jshfilenamePropfield);
                continue;
            }
            String jshfilenamePropname = jshfilenamePropmeta.name();
            Field jshfilenameField = entity.getClass().getDeclaredField(jshfilenamePropname);
            jshfilenameField.setAccessible(true);
            String jshfilename = (String)jshfilenameField.get(entity);
            if (jshfilename == null || jshfilename.startsWith(JSHFILENAME_FILESTATUS_HEADER)) {
                logger.info("5 " + jshfilenamePropfield);
                continue;
            }
            Path file = Paths.get(jshfilename, new String[0]);
            if (!Files.isReadable(file)) {
                logger.error("Can't read file " + jshfilename);
                continue;
            }
            String xxxItemname = jshfilenamePropfield.getName().substring(0, jshfilenameItemname.length() - JSHFILENAME_FOOTER.length());
            Field xxxPropfield = entityMetaClass.getField(xxxItemname);
            Class<?> xxxPropfieldType = xxxPropfield.getType();
            if (!PropertyMetaBase.class.isAssignableFrom(xxxPropfieldType)) {
                logger.info("6 " + jshfilenamePropfield);
                continue;
            }
            PropertyMetaBase xxxPropmeta = (PropertyMetaBase)xxxPropfield.get(entityMeta);
            if (jshfilenamePropmeta instanceof ContainerChildMeta) {
                logger.info("7 " + jshfilenamePropfield);
                continue;
            }
            String xxxPropname = xxxPropmeta.name();
            Field xxxField = entity.getClass().getDeclaredField(xxxPropname);
            xxxField.setAccessible(true);
            String xxx = (String)xxxField.get(entity);
            if (xxx == null || StringUtils.isBlank((CharSequence)xxx)) {
                logger.info("8 " + jshfilenamePropfield);
                continue;
            }
            String modelid = entityMeta.table();
            String itemname = xxxPropname;
            String title = xxx;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("file", jshfilename);
            String jshfilenameid = this.putJshfilename(modelid, itemname, title, map, request);
            jshfilenameField.set(entity, jshfilenameid);
        }
    }

    public <T extends ContainerBase<T>> void setLocalfilepathToEntity(T entity, HttpServletRequest request) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field[] fields;
        Class<?> entityMetaClass = Class.forName(entity.getClass().getCanonicalName() + "Meta");
        EntityMeta entityMeta = (EntityMeta)entityMetaClass.newInstance();
        Map putdatasmap2 = (Map)request.getAttribute(SETLOCALFILEPATH_REQKEY);
        logger.info("putdatasmap2 " + putdatasmap2);
        if (putdatasmap2 == null) {
            logger.info("0");
            return;
        }
        for (Field jshfilenamePropfield : fields = entityMetaClass.getFields()) {
            Class<?> jshfilenamePropfieldType = jshfilenamePropfield.getType();
            if (ContainerMeta.class.isAssignableFrom(jshfilenamePropfieldType)) {
                logger.info("1 " + jshfilenamePropfield);
                continue;
            }
            String jshfilenameItemname = jshfilenamePropfield.getName();
            if (!jshfilenameItemname.endsWith(JSHFILENAME_FOOTER)) {
                logger.info("2 " + jshfilenamePropfield);
                continue;
            }
            if (!PropertyMetaBase.class.isAssignableFrom(jshfilenamePropfieldType)) {
                logger.info("3 " + jshfilenamePropfield);
                continue;
            }
            PropertyMetaBase jshfilenamePropmeta = (PropertyMetaBase)jshfilenamePropfield.get(entityMeta);
            if (jshfilenamePropmeta instanceof ContainerChildMeta) {
                logger.info("4 " + jshfilenamePropfield);
                continue;
            }
            String jshfilenamePropname = jshfilenamePropmeta.name();
            Field jshfilenameField = entity.getClass().getDeclaredField(jshfilenamePropname);
            jshfilenameField.setAccessible(true);
            String jshfilename = (String)jshfilenameField.get(entity);
            if (jshfilename == null || !jshfilename.startsWith(JSHFILENAME_FILESTATUS_HEADER)) {
                logger.info("5 " + jshfilename);
                continue;
            }
            String jshfilenameid = jshfilename.substring(JSHFILENAME_FILESTATUS_HEADER.length());
            Map putdatamap = (Map)putdatasmap2.get(jshfilenameid);
            if (putdatamap == null) {
                logger.info("6 " + jshfilenameid);
                continue;
            }
            String file = (String)putdatamap.get("file");
            if (StringUtils.isBlank((CharSequence)file)) {
                logger.info("7 " + jshfilenameid);
                continue;
            }
            logger.info("8 " + jshfilenameid);
            jshfilenameField.set(entity, file);
        }
    }

    @Override
    public <T extends ContainerBase<T>> void beforeInsert(T entity, ActionParameter p) {
        logger.info("entity=" + entity);
        try {
            this.insertJfcfilestatusFromEntity(entity, p.request);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        logger.info("entity=" + entity);
        this.insertJfcfilestatus(p.request);
    }

    @Override
    public <T extends ContainerBase<T>> void afterInsert(T entity, ActionParameter p) {
        logger.info("entity=" + entity);
        try {
            this.setLocalfilepathToEntity(entity, p.request);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        logger.info("entity=" + entity);
    }

    @Override
    public <T extends ContainerBase<T>> void beforeUpdate(T entity, ActionParameter p) {
        logger.info("entity=" + entity);
        try {
            this.insertJfcfilestatusFromEntity(entity, p.request);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        logger.info("entity=" + entity);
        this.insertJfcfilestatus(p.request);
    }

    @Override
    public <T extends ContainerBase<T>> void afterUpdate(T entity, ActionParameter p) {
        logger.info("entity=" + entity);
        try {
            this.setLocalfilepathToEntity(entity, p.request);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        logger.info("entity=" + entity);
    }

    @Override
    public <T extends ContainerBase<T>> void beforeDelete(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void afterDelete(T entity, ActionParameter p) {
    }

    static enum JfcfilestatusFiletype {
        FILE(1),
        S3(2);

        int id;

        private JfcfilestatusFiletype(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static JfcfilestatusFiletype getById(int id) {
            for (JfcfilestatusFiletype value : JfcfilestatusFiletype.values()) {
                if (value.id() != id) continue;
                return value;
            }
            return null;
        }
    }

    static enum JfcfilestatusStatus {
        INSERT(1),
        UPDATE(2),
        DELETE(3),
        STORE_SUCCESS(4),
        STORE_FAILED(5);

        int id;

        private JfcfilestatusStatus(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static JfcfilestatusStatus getById(int id) {
            for (JfcfilestatusStatus value : JfcfilestatusStatus.values()) {
                if (value.id() != id) continue;
                return value;
            }
            return null;
        }
    }
}

