/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.springframework.context.ApplicationContext;

public class HibernateUtil {
    private static final Logger logger = LogManager.getLogger(HibernateUtil.class);
    private static final SessionFactory sessionFactory;
    public static final int JDBC_BATCH_SIZE;

    public static Session openSession() {
        return sessionFactory.openSession();
    }

    public static Session openSession(String sessionFactoryBeanId, ActionParameter p) {
        return HibernateUtil.openSession(sessionFactoryBeanId, p.appctx);
    }

    public static Session openSession(String sessionFactoryBeanId, ApplicationContext appctx) {
        return ((SessionFactory)appctx.getBean(sessionFactoryBeanId, SessionFactory.class)).openSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number getMax(String objclassname, String itemname) throws Exception {
        Session session = HibernateUtil.openSession();
        Transaction tx = session.beginTransaction();
        try {
            String expression = "select max(c." + itemname + ") from " + objclassname + " as c";
            logger.debug("select max expression: " + expression);
            Query query = session.createQuery(expression);
            Number ret = (Number)query.uniqueResult();
            tx.commit();
            if (ret == null) {
                logger.debug("max value is null.");
                Number number = null;
                return number;
            }
            logger.debug("max value: " + ret);
            Number number = ret;
            return number;
        }
        finally {
            session.close();
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    static {
        try {
            Configuration configuration = new Configuration();
            sessionFactory = configuration.configure().buildSessionFactory();
            JDBC_BATCH_SIZE = ConfigurationHelper.getInt((String)"hibernate.jdbc.batch_size", (Map)configuration.getProperties(), (int)0);
        }
        catch (Throwable ex) {
            logger.debug("Failed to create initial SessionFactory object.", ex);
            if (logger.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw new ExceptionInInitializerError(ex);
        }
    }
}

