/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JAXBPropertyNamingStrategy
extends PropertyNamingStrategy {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(JAXBPropertyNamingStrategy.class);
    private static final String XmlValueName = "content";

    public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
        Field f;
        String name;
        if (logger.isDebugEnabled()) {
            Class thisclass = field.getDeclaringClass();
            logger.debug("declaring class=" + thisclass);
            logger.debug("raw type=" + field.getRawType());
            logger.debug("type=" + field.getType());
            logger.debug("member=" + field.getMember());
        }
        if ((name = JAXBPropertyNamingStrategy.nameForField(f = field.getAnnotated())) == null) {
            return defaultName;
        }
        return name;
    }

    public static String nameForField(Field f) {
        XmlAttribute attr = f.getAnnotation(XmlAttribute.class);
        if (attr != null) {
            return attr.name();
        }
        XmlElement elem = f.getAnnotation(XmlElement.class);
        if (elem != null) {
            return elem.name();
        }
        XmlValue value = f.getAnnotation(XmlValue.class);
        if (value != null) {
            return XmlValueName;
        }
        return null;
    }
}

