/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.app.MailSendProcessBean;
import jp.jasminesoft.jfc.model.mailmessage.Attachment;
import jp.jasminesoft.jfc.model.mailmessage.Header;
import jp.jasminesoft.jfc.model.mailmessage.Mailmessage;
import jp.jasminesoft.jfc.model.mailmessage.Textattachment;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.ExtensionFilenameFilter;
import jp.jasminesoft.util.JaxbUtil;
import jp.jasminesoft.util.MimeMailUtilities;
import jp.jasminesoft.util.MultiPartForm;
import jp.jasminesoft.util.StringFilter;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;

public class MailMessageManager {
    private static String[] EXT_XML = new String[]{"xml"};
    private static String _basedir;
    private static final Logger logger;
    private Map<String, XMailmessage> messageMap = new HashMap<String, XMailmessage>();
    private boolean isLoadDoneFlag;
    private static String PARAM_REGEX_PATTERN;
    private static Pattern PATTERN;
    @Autowired
    protected ServletContext servletContext;

    protected MailMessageManager() {
    }

    @PostConstruct
    public void init() {
        this.initMailMessageManager(this.servletContext);
    }

    public boolean isReady() {
        return this.isLoadDoneFlag;
    }

    public Mailmessage getMailmessage(String mailid, ActionParameter p) {
        if (mailid == null) {
            return null;
        }
        if (mailid.endsWith(".xml")) {
            return this.getMailmessageFromXmlFile(mailid);
        }
        return this.getMailmessageFromMailTemplate(mailid, p);
    }

    public Mailmessage getMailmessageFromMailTemplate(String mailid, ActionParameter p) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mailmessage getMailmessageFromXmlFile(String mailid) {
        String path = _basedir != null ? _basedir + File.separator + mailid : mailid;
        File file = new File(path);
        long now = file.lastModified();
        XMailmessage xm = this.messageMap.get(mailid);
        if (xm != null && xm.time >= now) {
            try {
                return (Mailmessage)JaxbUtil.unmarshal((Document)xm.mailmessage.makeDocument(), Mailmessage.class);
            }
            catch (Exception e) {
                logger.debug("Exception", (Throwable)e);
                try {
                    return (Mailmessage)JaxbUtil.unmarshal((File)file, Mailmessage.class);
                }
                catch (Exception ee) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00237), LogCodeManager.getMessage(LogCode.JFC00237, mailid, path), (Throwable)ee);
                    return null;
                }
            }
        }
        xm = new XMailmessage();
        try {
            xm.mailmessage = (Mailmessage)JaxbUtil.unmarshal((File)file, Mailmessage.class);
            xm.time = now;
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00237), LogCodeManager.getMessage(LogCode.JFC00237, mailid, path), (Throwable)e);
            return null;
        }
        Map<String, XMailmessage> e = this.messageMap;
        synchronized (e) {
            this.messageMap.put(mailid, xm);
        }
        try {
            return (Mailmessage)JaxbUtil.unmarshal((Document)xm.mailmessage.makeDocument(), Mailmessage.class);
        }
        catch (Exception e2) {
            logger.debug("ParserConfigurationException", (Throwable)e2);
            try {
                return (Mailmessage)JaxbUtil.unmarshal((File)file, Mailmessage.class);
            }
            catch (Exception ee) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00237), LogCodeManager.getMessage(LogCode.JFC00237, mailid, path), (Throwable)ee);
                return null;
            }
        }
    }

    public int size() {
        return this.messageMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String dirname) {
        _basedir = dirname;
        File dir = new File(_basedir);
        if (!dir.exists()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00238), LogCodeManager.getMessage(LogCode.JFC00238, _basedir));
            return;
        }
        if (!dir.isDirectory()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00239), LogCodeManager.getMessage(LogCode.JFC00239, _basedir));
            return;
        }
        String[] s = dir.list((FilenameFilter)new ExtensionFilenameFilter(EXT_XML, true, false));
        if (s == null || s.length == 0) {
            logger.debug(_basedir + " contains no files. skip.");
            return;
        }
        File file = null;
        for (int i = 0; i < s.length; ++i) {
            String path = _basedir + File.separator + s[i];
            file = new File(path);
            if (file.isDirectory()) {
                this.load(path);
                continue;
            }
            XMailmessage xm = new XMailmessage();
            try {
                Mailmessage mailmessage = (Mailmessage)JaxbUtil.unmarshal((File)file, Mailmessage.class);
                if (mailmessage != null) {
                    xm.mailmessage = mailmessage;
                    xm.time = file.lastModified();
                }
                Map<String, XMailmessage> map = this.messageMap;
                synchronized (map) {
                    this.messageMap.put(mailmessage.getMid(), xm);
                    continue;
                }
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00240), LogCodeManager.getMessage(LogCode.JFC00240, path), (Throwable)e);
            }
        }
        this.isLoadDoneFlag = true;
    }

    public static String expandWildcard(String targetstr, Map<String, Object> replaceMap) {
        String[] targets;
        if (StringUtils.isEmpty((CharSequence)targetstr)) {
            return "";
        }
        Pattern RETCODE_PATTERN = Pattern.compile("(\\n|\\r|\\r\\n)");
        Matcher mat = RETCODE_PATTERN.matcher(targetstr);
        if (mat.find()) {
            ArrayList<String> sa = new ArrayList<String>();
            int cnt = 0;
            do {
                sa.add(targetstr.substring(cnt, mat.end()));
                cnt = mat.end();
            } while (mat.find());
            if (cnt < targetstr.length()) {
                sa.add(targetstr.substring(cnt));
            }
            targets = sa.toArray(new String[sa.size()]);
        } else {
            targets = new String[]{targetstr};
        }
        String[] dst = MailMessageManager.expandWildcard(targets, replaceMap);
        StringBuilder sb = new StringBuilder();
        for (String d : dst) {
            sb.append(d);
        }
        return sb.toString();
    }

    public static void expandTextattachmentWildcard(Textattachment[] attachments, Map<String, Object> replaceMap) {
        if (attachments == null || attachments.length == 0 || replaceMap == null || replaceMap.size() == 0) {
            return;
        }
        for (int i = 0; i < attachments.length; ++i) {
            attachments[i].setText(MailMessageManager.expandWildcard(attachments[i].getText(), replaceMap));
        }
    }

    public static String[] expandWildcard(String[] targets, Map<String, Object> replaceMap) {
        if (targets == null || targets.length == 0 || replaceMap == null || replaceMap.size() == 0) {
            return targets;
        }
        ArrayList<String> expanded_targets = new ArrayList<String>();
        for (String target : targets) {
            Matcher matcher = PATTERN.matcher(target);
            ArrayList<String> array = new ArrayList<String>();
            while (matcher.find()) {
                array.add(matcher.group().trim());
            }
            boolean needsExpand = false;
            TreeSet<Integer> indexSet = new TreeSet<Integer>();
            for (String placeHolder : array) {
                String prefix = null;
                String suffix = null;
                if (placeHolder.indexOf(".#.") > 0) {
                    needsExpand = true;
                    prefix = placeHolder.substring(0, placeHolder.indexOf(".#.") + 1);
                    suffix = placeHolder.substring(placeHolder.indexOf(".#.") + 2, placeHolder.length());
                } else if (placeHolder.endsWith(".#}")) {
                    needsExpand = true;
                    prefix = placeHolder.substring(0, placeHolder.indexOf(".#}") + 1);
                    suffix = "}";
                }
                if (StringUtils.isEmpty(prefix) || StringUtils.isEmpty(suffix)) continue;
                Set<String> keySet = replaceMap.keySet();
                for (String key : keySet) {
                    if (!key.startsWith(prefix) || !key.endsWith(suffix)) continue;
                    String str_index = key.substring(prefix.length(), key.lastIndexOf(suffix));
                    try {
                        indexSet.add(Integer.valueOf(str_index));
                    }
                    catch (NumberFormatException e) {
                        logger.debug("No number, key " + key, (Throwable)e);
                    }
                }
            }
            if (needsExpand) {
                for (Integer index : indexSet) {
                    String expanded_target = target.replaceAll("\\.\\#\\.", "." + index + ".");
                    expanded_target = expanded_target.replaceAll("\\.\\#\\}", "." + index + "}");
                    expanded_targets.add(expanded_target);
                }
                continue;
            }
            expanded_targets.add(target);
        }
        return expanded_targets.toArray(new String[0]);
    }

    public static Attachment[] expandAttachmentWildcard(Attachment[] targets, Map<String, Object> replaceMap) {
        if (targets == null || targets.length == 0 || replaceMap == null || replaceMap.size() == 0) {
            return new Attachment[0];
        }
        String[] str_attachments = new String[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            str_attachments[i] = targets[i].toString();
        }
        String[] str_expandedAttachments = MailMessageManager.expandWildcard(str_attachments, replaceMap);
        if (str_expandedAttachments == null || str_expandedAttachments.length == 0) {
            return new Attachment[0];
        }
        Attachment[] expandedAttachments = new Attachment[str_expandedAttachments.length];
        StringBuilder sb = new StringBuilder();
        if (str_expandedAttachments.length == 1) {
            sb.append(str_expandedAttachments[0].replace("<attachment>", "<mailmessage><attachment>").replace("</attachment>", "</attachment></mailmessage>"));
        } else if (str_expandedAttachments.length > 1) {
            for (int i = 0; i < str_expandedAttachments.length; ++i) {
                if (i == 0) {
                    sb.append(str_expandedAttachments[i].replace("<attachment>", "<mailmessage><attachment>"));
                    continue;
                }
                if (i == str_expandedAttachments.length - 1) {
                    sb.append(MailMessageManager.removeXMLDeclare(str_expandedAttachments[i]).replace("</attachment>", "</attachment></mailmessage>"));
                    continue;
                }
                sb.append(MailMessageManager.removeXMLDeclare(str_expandedAttachments[i]));
            }
        }
        try {
            Mailmessage mailMessage = (Mailmessage)JaxbUtil.unmarshal((Reader)new StringReader(sb.toString()), Mailmessage.class);
            for (int i = 0; i < str_expandedAttachments.length; ++i) {
                Attachment attachment;
                expandedAttachments[i] = attachment = mailMessage.getAttachment(i);
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00241), LogCodeManager.getMessage(LogCode.JFC00241, new String[0]), (Throwable)e);
            return targets;
        }
        return expandedAttachments;
    }

    private static String removeXMLDeclare(String s) {
        int ptr = s.indexOf("<?");
        int ptr2 = s.indexOf("?>");
        if (ptr >= 0 && ptr2 > 0 && ptr < ptr2) {
            return s.substring(ptr2 + 2);
        }
        return s;
    }

    public Mailmessage replace(Mailmessage mm, Map replaceMap) {
        Attachment[] attachments;
        if (logger.isDebugEnabled()) {
            logger.debug("mm=" + mm);
        }
        if (mm == null) {
            return null;
        }
        mm.setTo(MailMessageManager.expandWildcard(mm.getTo(), replaceMap));
        mm.setCc(MailMessageManager.expandWildcard(mm.getCc(), replaceMap));
        mm.setBcc(MailMessageManager.expandWildcard(mm.getBcc(), replaceMap));
        mm.setAttachment(MailMessageManager.expandAttachmentWildcard(mm.getAttachment(), replaceMap));
        mm.setBody(MailMessageManager.expandWildcard(mm.getBody(), replaceMap));
        MailMessageManager.expandTextattachmentWildcard(mm.getTextattachment(), replaceMap);
        replaceMap = this.refineReplaceMap(replaceMap, mm);
        Map<String, Object> newReplaceMap = this.remakeReplaceMap(replaceMap);
        mm.setMailhost(StringUtil.replace((String)mm.getMailhost(), newReplaceMap));
        mm.setProtocol(StringUtil.replace((String)mm.getProtocol(), newReplaceMap));
        mm.setAuthUser(StringUtil.replace((String)mm.getAuthUser(), newReplaceMap));
        mm.setAuthPassword(StringUtil.replace((String)mm.getAuthPassword(), newReplaceMap));
        mm.setSubject(StringUtil.replace((String)mm.getSubject(), newReplaceMap));
        mm.setFrom(StringUtil.replace((String)mm.getFrom(), newReplaceMap));
        mm.setTo(StringUtil.replace((String[])mm.getTo(), newReplaceMap));
        mm.setCc(StringUtil.replace((String[])mm.getCc(), newReplaceMap));
        mm.setBcc(StringUtil.replace((String[])mm.getBcc(), newReplaceMap));
        mm.setBody(StringUtil.replace((String)mm.getBody(), newReplaceMap));
        mm.setBodycontenttype(StringUtil.replace((String)mm.getBodycontenttype(), newReplaceMap));
        Textattachment[] tattachments = this.replaceTextattachment(mm.getTextattachment(), newReplaceMap);
        if (tattachments != null && tattachments.length > 0) {
            mm.setTextattachment(tattachments);
        }
        if ((attachments = this.replaceAttachment(mm.getAttachment(), newReplaceMap)) != null && attachments.length > 0) {
            mm.setAttachment(attachments);
        }
        for (Header h : mm.getHeader()) {
            h.setName(StringUtil.replace((String)h.getName(), newReplaceMap));
            h.setValue(StringUtil.replace((String)h.getValue(), newReplaceMap));
        }
        return mm;
    }

    public Map<String, Object> refineReplaceMap(Map<String, Object> replaceMap, Mailmessage mm) {
        if (replaceMap == null) {
            return null;
        }
        HashMap<String, Object> refineReplaceMap = new HashMap<String, Object>();
        String mmstr = mm.toString().replaceAll("&gt;", ">");
        Matcher matcher = PATTERN.matcher(mmstr);
        ArrayList<String> array = new ArrayList<String>();
        while (matcher.find()) {
            array.add(matcher.group());
        }
        String[] placeHolderList = array.toArray(new String[0]);
        for (int i = 0; i < placeHolderList.length; ++i) {
            refineReplaceMap.put(placeHolderList[i], replaceMap.get(placeHolderList[i]));
        }
        return refineReplaceMap;
    }

    public Map<String, Object> refineReplaceMap(Map<String, Object> replaceMap, MimeMessage msg) throws MessagingException, IOException {
        if (replaceMap == null) {
            return null;
        }
        HashMap<String, Object> refineReplaceMap = new HashMap<String, Object>();
        ArrayList<String> array = new ArrayList<String>();
        MailMessageManager.addPlaceHolderList(array, (Part)msg);
        String[] placeHolderList = array.toArray(new String[0]);
        for (int i = 0; i < placeHolderList.length; ++i) {
            refineReplaceMap.put(placeHolderList[i], replaceMap.get(placeHolderList[i]));
        }
        return refineReplaceMap;
    }

    private static void addPlaceHolderList(List<String> array, Part msg) throws MessagingException, IOException {
        Object content;
        String contentType = msg.getContentType();
        if (logger.isDebugEnabled()) {
            logger.debug("contentType is " + contentType);
        }
        if ((content = msg.getContent()) instanceof String) {
            if (logger.isDebugEnabled()) {
                logger.debug("content class is String class. " + content.getClass());
            }
            if (contentType.toLowerCase().startsWith("text/")) {
                String mmstr = ((String)content).replaceAll("&gt;", ">");
                Matcher matcher = PATTERN.matcher(mmstr);
                while (matcher.find()) {
                    array.add(matcher.group());
                }
            }
        } else if (content instanceof Multipart) {
            if (logger.isDebugEnabled()) {
                logger.debug("content class is Multipart class. " + content.getClass());
            }
            Multipart mp = (Multipart)content;
            int len = mp.getCount();
            for (int i = 0; i < len; ++i) {
                BodyPart part = mp.getBodyPart(i);
                MailMessageManager.addPlaceHolderList(array, (Part)part);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("content class is other class. " + content.getClass());
        }
    }

    public Map<String, Object> remakeReplaceMap(Map<String, Object> replaceMap) {
        HashMap<String, Object> newReplaceMap = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> set = replaceMap.entrySet();
        Iterator<Map.Entry<String, Object>> ite = set.iterator();
        Map.Entry<String, Object> ent = null;
        String key = null;
        Object val = null;
        while (ite.hasNext()) {
            ent = ite.next();
            key = ent.getKey();
            val = ent.getValue();
            if (val == null) {
                newReplaceMap.put(key, " ");
                continue;
            }
            if (val instanceof String) {
                newReplaceMap.put(key, val);
                continue;
            }
            if (val instanceof Number) {
                newReplaceMap.put(key, val);
                continue;
            }
            if (val instanceof Date) {
                newReplaceMap.put(key, ExcelFunction.TEXT((java.util.Date)((Date)val), (String)"yyyy-MM-dd"));
                continue;
            }
            if (val instanceof Time) {
                newReplaceMap.put(key, ExcelFunction.TEXT((java.util.Date)((Time)val), (String)"HH:mm:ss"));
                continue;
            }
            if (val instanceof Timestamp) {
                newReplaceMap.put(key, ExcelFunction.TEXT((java.util.Date)((Timestamp)val), (String)"yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            try {
                Method method = val.getClass().getMethod("getContentAsString", new Class[]{null});
                Object ret = method.invoke(val, new Object[]{null});
                if (ret instanceof String) {
                    newReplaceMap.put(key, (String)ret);
                    continue;
                }
                newReplaceMap.put(key, " ");
            }
            catch (Exception ignore) {
                logger.debug("Couldn't change place holder value in sending email.", (Throwable)ignore);
                newReplaceMap.put(key, " ");
            }
        }
        return newReplaceMap;
    }

    public MimeMessage createMimeMessage(Mailmessage mm, Map replaceMap) {
        String filename = mm.getEmlfilename();
        if (filename == null) {
            return null;
        }
        File emlfile = new File(filename);
        return this.createMimeMessage(emlfile, mm, replaceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMessage createMimeMessage(File emlfile, Mailmessage mm, Map replaceMap) {
        String mailhost = mm.getMailhost();
        mailhost = mailhost != null ? mailhost.trim() : "";
        String protocol = mm.getProtocol();
        boolean auth = mm.getAuth();
        String auth_user = mm.getAuthUser();
        String auth_password = mm.getAuthPassword();
        FileInputStream is = null;
        try {
            is = new FileInputStream(emlfile);
            MimeMessage msg = MimeMailUtilities.createMimeMessage((String)mailhost, (String)protocol, (boolean)auth, (String)auth_user, (String)auth_password, (InputStream)is);
            replaceMap = this.refineReplaceMap(replaceMap, msg);
            Map<String, Object> newReplaceMap = this.remakeReplaceMap(replaceMap);
            MailMessageManager.replace((Part)msg, newReplaceMap);
            MimeMessage mimeMessage = msg;
            return mimeMessage;
        }
        catch (FileNotFoundException e) {
            logger.error("No eml file " + emlfile, (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IO error eml file " + emlfile, (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error("Illegal eml file " + emlfile, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    logger.error("Failed to close for eml file " + emlfile, (Throwable)e);
                }
            }
        }
        return null;
    }

    private static void replace(Part msg, Map<String, Object> replaceMap) throws MessagingException, IOException {
        Object content;
        String contentType = msg.getContentType();
        if (logger.isDebugEnabled()) {
            logger.debug("contentType is " + contentType);
        }
        if ((content = msg.getContent()) instanceof String) {
            if (logger.isDebugEnabled()) {
                logger.debug("content class is String class. " + content.getClass());
            }
            if (contentType.toLowerCase().startsWith("text/")) {
                msg.setContent((Object)StringUtil.replace((String)((String)content), replaceMap), contentType);
                if (logger.isDebugEnabled()) {
                    logger.debug("replace " + content + " to " + (String)msg.getContent());
                }
            }
        } else if (content instanceof Multipart) {
            if (logger.isDebugEnabled()) {
                logger.debug("content class is Multipart class. " + content.getClass());
            }
            Multipart mp = (Multipart)content;
            int len = mp.getCount();
            for (int i = 0; i < len; ++i) {
                BodyPart part = mp.getBodyPart(i);
                MailMessageManager.replace((Part)part, replaceMap);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("content class is other class. " + content.getClass());
        }
    }

    public boolean send(String mid, Map<String, Object> replaceMap, JFCErrorManager errorManager, String logheader, ActionParameter p) {
        Mailmessage mm = this.getMailmessage(mid, p);
        if (mm == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00210), LogCodeManager.getMessage(LogCode.JFC00210, p.user, mid));
            return false;
        }
        Mailmessage n_mm = this.replace(mm, replaceMap);
        MimeMessage msg = this.createMimeMessage(mm, replaceMap);
        boolean status = this.send(n_mm, msg, errorManager, logheader, p);
        return status;
    }

    public boolean send(Mailmessage mm, JFCErrorManager errorManager, String logheader, ActionParameter p) {
        return this.send(mm, null, errorManager, logheader, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Mailmessage mm, MimeMessage msg, JFCErrorManager errorManager, String logheader, ActionParameter p) {
        String popauth_mailhost;
        String auth_password;
        String protocol;
        if (logger.isDebugEnabled()) {
            logger.debug("mm=" + mm);
        }
        boolean status = false;
        if (mm == null) {
            return status;
        }
        if (logheader == null) {
            logheader = "";
        }
        MailSendProcessBean pbean = (MailSendProcessBean)p.appctx.getBean(MailSendProcessBean.class);
        pbean.setActionParameter(p);
        String mailhost = mm.getMailhost();
        if (!StringUtils.isBlank((CharSequence)mailhost)) {
            pbean.setParameter("mailhost", mailhost);
        }
        if (!StringUtils.isBlank((CharSequence)(protocol = mm.getProtocol()))) {
            pbean.setParameter("protocol", protocol);
        }
        pbean.setParameter("auth", mm.getAuth());
        String auth_user = mm.getAuthUser();
        if (!StringUtils.isBlank((CharSequence)auth_user)) {
            pbean.setParameter("auth_user", auth_user);
        }
        if (!StringUtils.isBlank((CharSequence)(auth_password = mm.getAuthPassword()))) {
            pbean.setParameter("auth_password", auth_password);
        }
        if (StringUtils.isNotBlank((CharSequence)(popauth_mailhost = mm.getPopauthMailhost()))) {
            String popauth_password;
            String popauth_user;
            Boolean popauth_useapop;
            pbean.setParameter("popauth_mailhost", popauth_mailhost);
            String popauth_protocol = mm.getPopauthProtocol();
            if (StringUtils.isNotBlank((CharSequence)popauth_protocol)) {
                pbean.setParameter("popauth_protocol", popauth_protocol);
            }
            if ((popauth_useapop = mm.getPopauthUseapopAsBoolean()) != null) {
                pbean.setParameter("popauth_useapop", popauth_useapop);
            }
            if (StringUtils.isNotBlank((CharSequence)(popauth_user = mm.getPopauthAuthUser()))) {
                pbean.setParameter("popauth_user", popauth_user);
            }
            if (StringUtils.isNotBlank((CharSequence)(popauth_password = mm.getPopauthAuthPassword()))) {
                pbean.setParameter("popauth_password", popauth_password);
            }
        }
        pbean.setParameter("subject", mm.getSubject());
        pbean.setParameter("from", mm.getFrom());
        String[] to = mm.getTo();
        int to_length = to.length;
        if (to != null && to.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < to_length; ++i) {
                sb.append(to[i]);
                if (i >= to_length - 1) continue;
                sb.append(",");
            }
            pbean.setParameter("to", sb.toString());
        }
        String[] cc = mm.getCc();
        int cc_length = cc.length;
        if (cc != null && cc.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < cc_length; ++i) {
                sb.append(cc[i]);
                if (i >= cc_length - 1) continue;
                sb.append(",");
            }
            pbean.setParameter("cc", sb.toString());
        }
        String[] bcc = mm.getBcc();
        int bcc_length = bcc.length;
        if (bcc != null && bcc.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < bcc_length; ++i) {
                sb.append(bcc[i]);
                if (i >= bcc_length - 1) continue;
                sb.append(",");
            }
            pbean.setParameter("bcc", sb.toString());
        }
        pbean.setParameter("body", mm.getBody());
        pbean.setParameter("contenttype_body", mm.getBodycontenttype());
        pbean.setParameter("textattachment", mm.getTextattachment());
        pbean.setParameter("attachment", mm.getAttachment());
        pbean.setParameter("attachmentMaxSize", mm.getAttachmentMaxSizeAsInteger());
        pbean.setParameter("individualSend", mm.getIndividualSend());
        pbean.setParameter("header", mm.getHeader());
        pbean.setParameter("mimemessage", msg);
        try {
            Object op = pbean.process();
            if (op == null) {
                p.errors.addJfcerror(errorManager.getJfcerror("error.mailsend", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00242), LogCodeManager.getMessage(LogCode.JFC00242, p.user, logheader, mm.getSubject()));
            } else {
                logger.info(logheader + "send mail status = " + op);
                if (op instanceof Boolean) {
                    Boolean b = (Boolean)op;
                    if (b.booleanValue()) {
                        status = true;
                    }
                } else if (op instanceof String && p.request != null) {
                    p.request.setAttribute("__jfc_message_error", (Object)((String)op));
                }
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00242), LogCodeManager.getMessage(LogCode.JFC00242, p.user, logheader, mm.getSubject()), (Throwable)e);
        }
        finally {
            logger.debug((Object)mm);
        }
        if (pbean != null) {
            pbean.release();
        }
        return status;
    }

    protected Attachment[] replaceAttachment(Attachment[] attachments, Map<String, Object> replaceMap) {
        if (attachments == null || attachments.length == 0) {
            return null;
        }
        for (int i = 0; i < attachments.length; ++i) {
            attachments[i].setFilename(StringUtil.replace((String)attachments[i].getFilename(), replaceMap));
            attachments[i].setFilepath(StringUtil.replace((String)attachments[i].getFilepath(), replaceMap));
        }
        return attachments;
    }

    protected Textattachment[] replaceTextattachment(Textattachment[] attachments, Map<String, Object> replaceMap) {
        if (attachments == null || attachments.length == 0) {
            return null;
        }
        for (int i = 0; i < attachments.length; ++i) {
            attachments[i].setText(StringUtil.replace((String)attachments[i].getText(), replaceMap));
            attachments[i].setContenttype(StringUtil.replace((String)attachments[i].getContenttype(), replaceMap));
        }
        return attachments;
    }

    static String getHeaderValue(Message m, String field) {
        String fieldValue = null;
        try {
            String[] headers = m.getHeader(field);
            if (headers == null || headers.length == 0) {
                logger.debug("No header, " + field);
                return null;
            }
            fieldValue = MimeUtility.decodeText((String)headers[0]);
        }
        catch (Exception e) {
            logger.warn("field=" + field + ",message=" + m, (Throwable)e);
        }
        return fieldValue;
    }

    public static String getMessageIdAsString(Message m) {
        return MailMessageManager.getHeaderValue(m, "Message-ID");
    }

    public static String getInReplyToAsString(Message m) {
        return MailMessageManager.getHeaderValue(m, "In-Reply-To");
    }

    private static String decodeAndFilter(String s, StringFilter _filter) throws UnsupportedEncodingException {
        s = MimeUtility.decodeText((String)s);
        if (_filter != null) {
            s = _filter.filter(s);
        }
        return s;
    }

    public static String getSubjectAsString(Message m) {
        return MailMessageManager.getSubjectAsString(m, null);
    }

    public static String getSubjectAsString(Message m, StringFilter _filter) {
        String subject = null;
        try {
            String[] headers = m.getHeader("Subject");
            if (headers == null || headers.length == 0) {
                logger.debug("No Subject header.");
                return null;
            }
            subject = MailMessageManager.decodeAndFilter(headers[0], _filter);
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return subject;
    }

    public static String getBodyAsString(Message m) {
        return MailMessageManager.getBodyAsString(m, (StringFilter)null);
    }

    public static String getBodyAsString(Message m, StringFilter _filter) {
        try {
            Object o = m.getContent();
            if (o instanceof String) {
                String s = (String)o;
                if (_filter != null) {
                    s = _filter.filter(s);
                }
                return s;
            }
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return null;
    }

    public static String[] getFromAsStringArray(Message m) {
        return MailMessageManager.getFromAsStringArray(m, null);
    }

    public static String[] getFromAsStringArray(Message m, StringFilter _filter) {
        HashSet<String> set = new HashSet<String>();
        try {
            Address[] addresses = m.getFrom();
            if (addresses != null && addresses.length > 0) {
                for (Address address : addresses) {
                    set.add(MailMessageManager.decodeAndFilter(address.toString(), _filter));
                }
            }
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return set.toArray(new String[0]);
    }

    public static String[] getToAsStringArray(Message m) {
        return MailMessageManager.getToAsStringArray(m, null);
    }

    public static String[] getToAsStringArray(Message m, StringFilter _filter) {
        HashSet<String> set = new HashSet<String>();
        try {
            Address[] addresses = m.getRecipients(Message.RecipientType.TO);
            if (addresses != null && addresses.length > 0) {
                for (Address address : addresses) {
                    set.add(MailMessageManager.decodeAndFilter(address.toString(), _filter));
                }
            }
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return set.toArray(new String[0]);
    }

    public static String[] getCcAsStringArray(Message m) {
        return MailMessageManager.getCcAsStringArray(m, null);
    }

    public static String[] getCcAsStringArray(Message m, StringFilter _filter) {
        HashSet<String> set = new HashSet<String>();
        try {
            Address[] addresses = m.getRecipients(Message.RecipientType.CC);
            if (addresses != null && addresses.length > 0) {
                for (Address address : addresses) {
                    set.add(MailMessageManager.decodeAndFilter(address.toString(), _filter));
                }
            }
        }
        catch (Exception e) {
            logger.warn("MessagingException, message=" + m, (Throwable)e);
        }
        return set.toArray(new String[0]);
    }

    public static String[] getBccAsStringArray(Message m) {
        return MailMessageManager.getBccAsStringArray(m, null);
    }

    public static String[] getBccAsStringArray(Message m, StringFilter _filter) {
        HashSet<String> set = new HashSet<String>();
        try {
            Address[] addresses = m.getRecipients(Message.RecipientType.BCC);
            if (addresses != null && addresses.length > 0) {
                for (Address address : addresses) {
                    set.add(MailMessageManager.decodeAndFilter(address.toString(), _filter));
                }
            }
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return set.toArray(new String[0]);
    }

    public static Date getReceivedSQLDate(Message m) {
        java.util.Date d = null;
        try {
            d = m.getReceivedDate();
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return DateTimeUtil.getSQLDate((java.util.Date)d);
    }

    public static Time getReceivedSQLTime(Message m) {
        java.util.Date d = null;
        try {
            d = m.getReceivedDate();
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return DateTimeUtil.getSQLTime((java.util.Date)d);
    }

    public static Timestamp getReceivedSQLTimestamp(Message m) {
        java.util.Date d = null;
        try {
            d = m.getReceivedDate();
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return DateTimeUtil.getSQLTimestamp((java.util.Date)d);
    }

    public static Date getSentSQLDate(Message m) {
        java.util.Date d = null;
        try {
            d = m.getSentDate();
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return DateTimeUtil.getSQLDate((java.util.Date)d);
    }

    public static Time getSentSQLTime(Message m) {
        java.util.Date d = null;
        try {
            d = m.getSentDate();
        }
        catch (Exception e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return DateTimeUtil.getSQLTime((java.util.Date)d);
    }

    public static Timestamp getSentSQLTimestamp(Message m) {
        java.util.Date d = null;
        try {
            d = m.getSentDate();
        }
        catch (MessagingException e) {
            logger.warn("message=" + m, (Throwable)e);
        }
        return DateTimeUtil.getSQLTimestamp((java.util.Date)d);
    }

    public static String getBodyAsString(Message m, MultiPartForm _multi) {
        return MailMessageManager.getBodyAsString(m, _multi, null);
    }

    public static String getBodyAsString(Message m, MultiPartForm _multi, StringFilter _filter) {
        if (_multi == null) {
            return MailMessageManager.getBodyAsString(m, _filter);
        }
        return MailMessageManager.getBodyAsString(_multi, _filter);
    }

    public static String getBodyAsString(MultiPartForm _multi) {
        return MailMessageManager.getBodyAsString(_multi, null);
    }

    public static String getBodyAsString(MultiPartForm _multi, StringFilter _filter) {
        if (_multi == null) {
            return null;
        }
        String s = _multi.getText();
        if (_filter != null) {
            s = _filter.filter(s);
        }
        return s;
    }

    public static String getAttachment(MultiPartForm _multi) {
        return MailMessageManager.getAttachment(_multi, null);
    }

    public static String getAttachment(MultiPartForm _multi, StringFilter _filter) {
        if (_multi == null) {
            return null;
        }
        for (String key : _multi.getParameterList()) {
            File file;
            String filename = _multi.getSrcFilename(key);
            if (filename == null || (file = _multi.getFileContents(key)) == null) continue;
            if (_filter != null) {
                filename = _filter.filter(filename);
            }
            return filename;
        }
        return null;
    }

    public static String getAttachmentJshfilename(MultiPartForm _multi, List<File> _files) {
        return MailMessageManager.getAttachmentJshfilename(_multi, null, _files);
    }

    public static String getAttachmentJshfilename(MultiPartForm _multi, StringFilter _filter, List<File> _files) {
        String filename = MailMessageManager.getAttachmentJshfilename(_multi);
        if (_files != null && filename != null) {
            _files.remove(new File(filename));
        }
        if (_filter != null) {
            filename = _filter.filter(filename);
        }
        return filename;
    }

    public static String getAttachmentJshfilename(MultiPartForm _multi) {
        if (_multi == null) {
            return null;
        }
        for (String key : _multi.getParameterList()) {
            File file;
            String filename = _multi.getSrcFilename(key);
            if (filename == null || (file = _multi.getFileContents(key)) == null) continue;
            return file.toString();
        }
        return null;
    }

    public static String[][] getAllAttachmentfilename(MultiPartForm _multi, List<File> _files) {
        return MailMessageManager.getAllAttachmentfilename(_multi, null, _files);
    }

    public static String[][] getAllAttachmentfilename(MultiPartForm _multi, StringFilter _filter, List<File> _files) {
        String[][] filenames = MailMessageManager.getAllAttachmentfilename(_multi);
        if (filenames != null && filenames.length > 0) {
            for (int i = 0; i < filenames.length; ++i) {
                _files.remove(new File(filenames[i][1]));
                if (_filter == null) continue;
                filenames[i][0] = _filter.filter(filenames[i][0]);
            }
        }
        return filenames;
    }

    public static String[][] getAllAttachmentfilename(MultiPartForm _multi) {
        if (_multi == null) {
            return null;
        }
        ArrayList<String[]> ret = new ArrayList<String[]>();
        for (String key : _multi.getParameterList()) {
            File file;
            String filename = _multi.getSrcFilename(key);
            if (filename == null || (file = _multi.getFileContents(key)) == null) continue;
            String[] arrays = new String[]{filename, file.toString()};
            ret.add(arrays);
        }
        return (String[][])ret.toArray((T[])new String[0][]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<MailmessageManager>");
        for (String id : this.messageMap.keySet()) {
            XMailmessage xm = this.messageMap.get(id);
            sb.append(xm.mailmessage);
        }
        sb.append("</MailmessageManager>");
        return sb.toString();
    }

    public static void main(String[] argv) throws JAXBException {
        Attachment[] targets = new Attachment[]{new Attachment()};
        targets[0].setFilename("${report_p.Attach.#.Attachment}");
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        Attachment[] atts = MailMessageManager.expandAttachmentWildcard(targets, replaceMap);
        System.out.println(Arrays.asList(atts));
    }

    private void initMailMessageManager(ServletContext sc) {
        if (this.isReady()) {
            return;
        }
        String mailMessageDirectory = sc.getInitParameter("mailmessage");
        if (mailMessageDirectory != null) {
            mailMessageDirectory = StringUtil.replace((String)mailMessageDirectory, (String)"${DEPLOYHOME}", (String)JFCUtils.createDeployHomePath(sc));
            this.load(mailMessageDirectory);
        }
        logger.info("(admin@localhost) * MailMessageManager contains " + this.size() + " message format.");
    }

    static {
        logger = LogManager.getLogger((String)MailMessageManager.class.getName());
        PARAM_REGEX_PATTERN = "\\$\\{[^\\}]*\\}";
        PATTERN = Pattern.compile(PARAM_REGEX_PATTERN);
    }

    static class XMailmessage {
        long time;
        Mailmessage mailmessage;

        XMailmessage() {
        }
    }
}

