/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import javax.mail.internet.MimeMessage;
import jp.jasminesoft.jfc.app.MailSendProcessBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class MailSendChecker {
    private static final Logger logger = LogManager.getLogger((String)MailSendChecker.class.getName());
    @Value(value="${wagby.mailsend.sendcount.interval:86400000}")
    private long intervalSendCount;
    @Value(value="${wagby.mailsend.sendcount.limit:-1}")
    private int limitSendCount;
    private int sendcount = 0;
    private long sendcountdate = -1L;

    public synchronized boolean checkSendCount(MailSendProcessBean pbean) {
        if (this.limitSendCount < 0 || this.intervalSendCount <= 0L) {
            return true;
        }
        if (this.limitSendCount == 0) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now <= this.sendcountdate) {
            logger.warn("Illegal sendcountdate, reset.");
            this.sendcountdate = now;
        } else if (this.sendcountdate <= 0L || now - this.sendcountdate >= this.intervalSendCount) {
            this.sendcount = 0;
            this.sendcountdate = now;
            return true;
        }
        return this.sendcount + 1 <= this.limitSendCount;
    }

    public synchronized void success(MailSendProcessBean pbean, MimeMessage mimeMessage) {
        this.incrementSendCount();
    }

    private void incrementSendCount() {
        if (this.limitSendCount <= 0 || this.intervalSendCount <= 0L) {
            return;
        }
        ++this.sendcount;
    }
}

