/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.app.MailSendChecker;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.model.mailmessage.Attachment;
import jp.jasminesoft.jfc.model.mailmessage.Textattachment;
import jp.jasminesoft.util.MimeMailUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MailSendProcessBean
extends ProcessBean {
    public static final String CR = System.getProperty("line.separator");
    private static final Logger logger = LogManager.getLogger((String)MailSendProcessBean.class.getName());
    @Autowired
    @Qualifier(value="MailSendChecker")
    private MailSendChecker checker;

    @Deprecated
    protected Map createReplaceMap() {
        return null;
    }

    @Override
    public Object run() {
        Jfcerror error;
        Object[] o;
        jp.jasminesoft.jfc.model.mailmessage.Header[] _headers;
        StringBuffer errmsg = new StringBuffer();
        JFCErrorManager errorManager = (JFCErrorManager)this.p.appctx.getBean(JFCErrorManager.class);
        if (!this.checker.checkSendCount(this)) {
            Jfcerror error2 = errorManager.getJfcerror("mailsend.error.sendcount", this.p.locale);
            logger.debug(error2.getContent());
            errmsg.append(error2.getContent());
            return errmsg;
        }
        String mailhost = (String)this.anotherParam.get("mailhost");
        String protocol = (String)this.anotherParam.get("protocol");
        Boolean auth = (Boolean)this.anotherParam.get("auth");
        if (auth == null) {
            auth = Boolean.FALSE;
        }
        String auth_user = (String)this.anotherParam.get("auth_user");
        String auth_password = (String)this.anotherParam.get("auth_password");
        String popauth_mailhost = (String)this.anotherParam.get("popauth_mailhost");
        String popauth_protocol = (String)this.anotherParam.get("popauth_protocol");
        Boolean popauth_useapop = (Boolean)this.anotherParam.get("popauth_useapop");
        String popauth_user = (String)this.anotherParam.get("popauth_user");
        String popauth_password = (String)this.anotherParam.get("popauth_password");
        String subject = (String)this.anotherParam.get("subject");
        String from = (String)this.anotherParam.get("from");
        String to = (String)this.anotherParam.get("to");
        String cc = (String)this.anotherParam.get("cc");
        String bcc = (String)this.anotherParam.get("bcc");
        mailhost = mailhost != null ? mailhost.trim() : "";
        popauth_mailhost = popauth_mailhost != null ? popauth_mailhost.trim() : "";
        subject = subject != null ? subject.trim() : "";
        from = from != null ? from.trim() : "";
        to = to != null ? to.trim() : "";
        cc = cc != null ? cc.trim() : "";
        bcc = bcc != null ? bcc.trim() : "";
        Textattachment[] tattachments = (Textattachment[])this.anotherParam.get("textattachment");
        Attachment[] attachments = (Attachment[])this.anotherParam.get("attachment");
        Integer attachmentMaxSize = (Integer)this.anotherParam.get("attachmentMaxSize");
        Boolean isIndividualSend = (Boolean)this.anotherParam.get("individualSend");
        String bodyContentType = (String)this.anotherParam.get("contenttype_body");
        MimeMessage mimeMessage = (MimeMessage)this.anotherParam.get("mimemessage");
        String messageid = (String)this.anotherParam.get("messageid");
        String inreplyto = (String)this.anotherParam.get("inreplyto");
        ArrayList<Header> hlist = new ArrayList<Header>();
        if (StringUtils.isNotBlank((CharSequence)messageid)) {
            hlist.add(new Header("Message-ID", messageid));
        }
        if (StringUtils.isNotBlank((CharSequence)inreplyto)) {
            hlist.add(new Header("In-Reply-To", inreplyto));
        }
        if ((_headers = (jp.jasminesoft.jfc.model.mailmessage.Header[])this.anotherParam.get("header")) != null) {
            for (jp.jasminesoft.jfc.model.mailmessage.Header h : _headers) {
                hlist.add(new Header(h.getName(), h.getValue()));
            }
        }
        Header[] headers = hlist.size() > 0 ? hlist.toArray(new Header[0]) : null;
        StringBuffer body = new StringBuffer();
        TreeMap<String, String> bmap = new TreeMap<String, String>();
        for (String key : this.anotherParam.keySet()) {
            String cnt;
            if (!key.startsWith("body") || !StringUtils.isNotBlank((CharSequence)(cnt = (String)this.anotherParam.get(key)))) continue;
            bmap.put(key, cnt);
        }
        boolean outputBodyFlag = false;
        for (String cnt : bmap.values()) {
            if (!StringUtils.isNotBlank((CharSequence)cnt)) continue;
            outputBodyFlag = true;
            body.append(cnt);
        }
        if (outputBodyFlag) {
            body.append(CR);
            body.append(CR);
        }
        InternetAddress fromaddr = null;
        if (StringUtils.isNotBlank((CharSequence)from)) {
            try {
                fromaddr = MimeMailUtilities.getFromAddress((String)from);
            }
            catch (MessagingException e) {
                Object[] o2 = new Object[]{from};
                Jfcerror error3 = errorManager.getJfcerror("mailsend.error.address.from", o2, this.p.locale);
                logger.debug(error3.getContent(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                errmsg.append(error3.getContent());
            }
        }
        HashSet<String> maddressSet = new HashSet<String>();
        InternetAddress[] toaddr = null;
        if (StringUtils.isNotBlank((CharSequence)to)) {
            try {
                toaddr = MimeMailUtilities.getToAddress((String)to);
            }
            catch (MessagingException e) {
                Object[] o3 = new Object[]{to};
                Jfcerror error4 = errorManager.getJfcerror("mailsend.error.address.to", o3, this.p.locale);
                logger.debug(error4.getContent(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                errmsg.append(error4.getContent());
            }
            ArrayList<Object> alist = new ArrayList<Object>();
            for (InternetAddress _to : toaddr) {
                String maddress = _to.getAddress();
                if (maddressSet.contains(maddress)) continue;
                alist.add(_to);
                maddressSet.add(maddress);
            }
            toaddr = alist.toArray(new InternetAddress[alist.size()]);
        }
        InternetAddress[] ccaddr = null;
        if (StringUtils.isNotBlank((CharSequence)cc)) {
            try {
                ccaddr = MimeMailUtilities.getToAddress((String)cc);
            }
            catch (MessagingException e) {
                Object[] o4 = new Object[]{cc};
                Jfcerror error5 = errorManager.getJfcerror("mailsend.error.address.cc", o4, this.p.locale);
                logger.debug(error5.getContent(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                errmsg.append(error5.getContent());
            }
        }
        InternetAddress[] bccaddr = null;
        if (StringUtils.isNotBlank((CharSequence)bcc)) {
            try {
                bccaddr = MimeMailUtilities.getToAddress((String)bcc);
            }
            catch (MessagingException e) {
                Object[] o5 = new Object[]{cc};
                Jfcerror error6 = errorManager.getJfcerror("mailsend.error.address.bcc", o5, this.p.locale);
                logger.debug(error6.getContent(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                errmsg.append(error6.getContent());
            }
        }
        if (!(toaddr != null && toaddr.length != 0 || ccaddr != null && ccaddr.length != 0 || bccaddr != null && bccaddr.length != 0)) {
            Jfcerror error7 = errorManager.getJfcerror("mailsend.error.address.null", this.p.locale);
            logger.debug("toaddr:" + (toaddr == null ? "null" : Arrays.asList(toaddr).toString()));
            logger.debug("ccaddr:" + (ccaddr == null ? "null" : Arrays.asList(ccaddr).toString()));
            logger.debug("bccaddr:" + (bccaddr == null ? "null" : Arrays.asList(bccaddr).toString()));
            logger.debug("No To/Cc/Bcc address is existed.");
            errmsg.append(error7.getContent());
        }
        HashMap<String, List<MimeBodyPartOrder>> multipartSubtype_mbpos = new HashMap<String, List<MimeBodyPartOrder>>();
        if (tattachments != null && tattachments.length > 0) {
            for (int i = 0; i < tattachments.length; ++i) {
                Integer order = tattachments[i].getOrderAsInteger();
                String contentType = tattachments[i].getContenttype();
                String msgText = tattachments[i].getText();
                String multipartSubtype = tattachments[i].getMultipartsubtype();
                List<MimeBodyPartOrder> mbpos = multipartSubtype_mbpos.get(multipartSubtype);
                if (mbpos == null) {
                    mbpos = new ArrayList<MimeBodyPartOrder>();
                    multipartSubtype_mbpos.put(multipartSubtype, mbpos);
                }
                try {
                    MimeBodyPart mbp = MimeMailUtilities.createTextMimeBodyPart((String)msgText, (String)contentType);
                    mbpos.add(new MimeBodyPartOrder(order, mbpos.size(), mbp));
                    continue;
                }
                catch (MessagingException e) {
                    logger.debug("", (Throwable)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    errmsg.append(" ");
                }
            }
        }
        int fileAttachmentCount = 0;
        if (attachments != null && attachments.length > 0) {
            for (int i = 0; i < attachments.length; ++i) {
                Integer order = attachments[i].getOrderAsInteger();
                String filename = attachments[i].getFilename();
                String filepath = attachments[i].getFilepath();
                String multipartSubtype = attachments[i].getMultipartsubtype();
                if (StringUtils.isBlank((CharSequence)filename)) continue;
                if (File.separatorChar != '\\') {
                    filepath = filepath.replace('\\', '/');
                }
                File file = new File(filepath);
                if (StringUtils.isBlank((CharSequence)filename)) {
                    filename = file.getName();
                }
                if (file.exists()) {
                    List<MimeBodyPartOrder> mbpos = multipartSubtype_mbpos.get(multipartSubtype);
                    if (mbpos == null) {
                        mbpos = new ArrayList<MimeBodyPartOrder>();
                        multipartSubtype_mbpos.put(multipartSubtype, mbpos);
                    }
                    try {
                        MimeBodyPart mbp = MimeMailUtilities.createFileMimeBodyPart((String)filename, (File)file);
                        mbpos.add(new MimeBodyPartOrder(order, mbpos.size(), mbp));
                        ++fileAttachmentCount;
                    }
                    catch (MessagingException e) {
                        logger.debug("", (Throwable)e);
                        if (logger.isDebugEnabled()) {
                            e.printStackTrace();
                        }
                        errmsg.append(" ");
                    }
                    continue;
                }
                o = new Object[]{filename};
                error = errorManager.getJfcerror("mailsend.error.attachfile", o, this.p.locale);
                logger.debug(error.getContent());
                errmsg.append(error.getContent());
            }
        }
        List null_mbpos = (List)multipartSubtype_mbpos.remove(null);
        List mixed_mbpos = (List)multipartSubtype_mbpos.get("mixed");
        if (null_mbpos != null) {
            if (mixed_mbpos == null) {
                multipartSubtype_mbpos.put("mixed", null_mbpos);
            } else {
                mixed_mbpos.addAll(null_mbpos);
            }
        }
        Map<String, List<MimeBodyPart>> multipartSubtype_mbps = this.createMimeBodyPartList(multipartSubtype_mbpos);
        if (attachmentMaxSize != null && attachmentMaxSize >= 0 && fileAttachmentCount > attachmentMaxSize) {
            Object[] o6 = new Object[]{Integer.toString(attachmentMaxSize)};
            Jfcerror error8 = errorManager.getJfcerror("mailsend.error.attachfile.size", o6, this.p.locale);
            logger.debug(error8.getContent());
            errmsg.append(error8.getContent());
        }
        if (errmsg.length() > 0) {
            return errmsg.toString();
        }
        try {
            if (mimeMessage == null) {
                List<MimeBodyPart> mixed_mbps = multipartSubtype_mbps.get("mixed");
                List<MimeBodyPart> alternative_mbps = multipartSubtype_mbps.get("alternative");
                List<MimeBodyPart> related_mbps = multipartSubtype_mbps.get("related");
                mimeMessage = MimeMailUtilities.createMimeMessage((String)mailhost, (String)protocol, (boolean)auth, (String)auth_user, (String)auth_password, (String)popauth_mailhost, (String)popauth_protocol, (Boolean)popauth_useapop, (String)popauth_user, (String)popauth_password);
                MimeMailUtilities.setMimeMessageAttachment((MimeMessage)mimeMessage, (String)body.toString(), (String)bodyContentType, related_mbps, alternative_mbps, mixed_mbps);
            } else {
                MimeMailUtilities.setMimeMessageAttachment((MimeMessage)mimeMessage, multipartSubtype_mbps);
            }
            MimeMailUtilities.setMimeMessageHeader((MimeMessage)mimeMessage, (InternetAddress)fromaddr, (Header[])headers, (String)subject);
        }
        catch (Exception e) {
            if (isIndividualSend != null && isIndividualSend.booleanValue()) {
                Object[] o7 = toaddr != null && toaddr.length > 0 ? new Object[]{toaddr[0].getAddress()} : new Object[]{""};
                Jfcerror error9 = errorManager.getJfcerror("mailsend.error.send", o7, this.p.locale);
                logger.debug(error9.getContent(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                errmsg.append(error9.getContent());
            }
            logger.debug("", (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            errmsg.append(" ");
        }
        if (errmsg.length() == 0 && (toaddr != null && toaddr.length > 0 || ccaddr != null && ccaddr.length > 0 || bccaddr != null && bccaddr.length > 0)) {
            InternetAddress[][] _toaddr = new InternetAddress[][]{toaddr};
            if (isIndividualSend != null && isIndividualSend.booleanValue()) {
                _toaddr = new InternetAddress[toaddr.length][1];
                for (int i = 0; i < toaddr.length; ++i) {
                    _toaddr[i][0] = toaddr[i];
                }
            }
            for (int i = 0; i < _toaddr.length; ++i) {
                try {
                    MimeMailUtilities.setMimeMessageRecipients((MimeMessage)mimeMessage, (InternetAddress[])_toaddr[i], (InternetAddress[])ccaddr, (InternetAddress[])bccaddr);
                    MimeMailUtilities.mailsend((MimeMessage)mimeMessage);
                    this.checker.success(this, mimeMessage);
                    continue;
                }
                catch (MessagingException e) {
                    if (isIndividualSend != null && isIndividualSend.booleanValue()) {
                        o = new Object[]{_toaddr[i][0].getAddress()};
                        error = errorManager.getJfcerror("mailsend.error.send", o, this.p.locale);
                        logger.debug(error.getContent(), (Throwable)e);
                        if (logger.isDebugEnabled()) {
                            e.printStackTrace();
                        }
                        errmsg.append(error.getContent());
                        continue;
                    }
                    logger.debug("", (Throwable)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    errmsg.append(" ");
                }
            }
        }
        if (errmsg.length() > 0) {
            return errmsg.toString();
        }
        return Boolean.TRUE;
    }

    private Map<String, List<MimeBodyPart>> createMimeBodyPartList(Map<String, List<MimeBodyPartOrder>> multipartSubtype_mbpos) {
        HashMap<String, List<MimeBodyPart>> map = new HashMap<String, List<MimeBodyPart>>();
        for (Map.Entry<String, List<MimeBodyPartOrder>> entry : multipartSubtype_mbpos.entrySet()) {
            String key = entry.getKey();
            List<MimeBodyPartOrder> mbpo = entry.getValue();
            List<MimeBodyPart> mbp = this.createMimeBodyPartList(mbpo);
            map.put(key, mbp);
        }
        return map;
    }

    private List<MimeBodyPart> createMimeBodyPartList(List<MimeBodyPartOrder> mixed_mbpos) {
        Collections.sort(mixed_mbpos);
        ArrayList<MimeBodyPart> mbps = new ArrayList<MimeBodyPart>();
        for (MimeBodyPartOrder mbpo : mixed_mbpos) {
            mbps.add(mbpo.getMimeBodyPart());
        }
        return mbps;
    }

    private static class MimeBodyPartOrder
    implements Comparable<MimeBodyPartOrder> {
        private Integer order;
        private int localorder;
        private MimeBodyPart mbp;

        MimeBodyPartOrder(Integer order, int localorder, MimeBodyPart mbp) {
            this.order = order;
            this.localorder = localorder;
            this.mbp = mbp;
        }

        public MimeBodyPart getMimeBodyPart() {
            return this.mbp;
        }

        @Override
        public int compareTo(MimeBodyPartOrder o) {
            if (this.order == null) {
                if (o.order == null) {
                    return 0;
                }
                return 1;
            }
            if (o.order == null) {
                return -1;
            }
            int cmp = this.order.compareTo(o.order);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.valueOf(this.localorder).compareTo(o.localorder);
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        }
    }
}

