/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.app.CacheManagerBase;
import jp.jasminesoft.jfc.app.CacheManagerUtil;
import jp.jasminesoft.jfc.app.HibernateMasterJprincipal;
import jp.jasminesoft.jfc.master.app.AbstractMasterTable;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MasterJprincipal
extends AbstractMasterTable {
    private static final Logger logger = LogManager.getLogger(MasterJprincipal.class);
    protected CacheManagerBase cacheManager = CacheManagerUtil.getCacheManager(null);

    protected MasterJprincipal() {
    }

    abstract void init();

    public static synchronized MasterJprincipal getInstance(ActionParameter p) {
        if (UserInfoFactory.getUserInfoTypeCode() == 4) {
            return HibernateMasterJprincipal.getInstance();
        }
        return null;
    }

    @Override
    public String getTablename() {
        return "jprincipal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setData(Object[] code_m) {
        Jprincipal[] jprincipalByName = new Jprincipal[code_m.length];
        System.arraycopy(code_m, 0, jprincipalByName, 0, code_m.length);
        Arrays.sort(jprincipalByName, new JprincipalIdComparator());
        MasterJprincipal masterJprincipal = this;
        synchronized (masterJprincipal) {
            this.cacheManager.put(new MasterJprincipalCache(jprincipalByName), MasterJprincipalCache.class, "__jfc_MasterJprincipal", "masterJprincipal");
        }
    }

    @Override
    public synchronized void release() {
        this.cacheManager.clearJprincipalMaster();
        super.release();
    }

    public Jprincipal getDataByName(String name) {
        Jprincipal[] masters = this.getData();
        if (masters == null) {
            return null;
        }
        int i = Arrays.binarySearch(masters, name, new JprincipalIdComparator());
        if (i < 0) {
            return null;
        }
        return masters[i];
    }

    public static void clear() {
        MasterJprincipal instance = MasterJprincipal.getInstance(null);
        if (instance != null) {
            instance.release();
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public Jprincipal[] getData() {
        MasterJprincipalCache cache = this.cacheManager.get("masterJprincipal", MasterJprincipalCache.class, "__jfc_MasterJprincipal");
        if (cache == null) {
            this.init();
        }
        return this.cacheManager.get((String)"masterJprincipal", MasterJprincipalCache.class, (String)"__jfc_MasterJprincipal").jprincipals;
    }

    public Jprincipal getData(int id) {
        Jprincipal[] masters = this.getData();
        if (masters == null) {
            return null;
        }
        return Stream.of(masters).filter(jprincipal -> jprincipal.getId() == id).findFirst().orElse(null);
    }

    @Override
    public Object getDataByContent(String content) {
        throw new UnsupportedOperationException("MasterJprincipal#getDataByContent(String) is unspported.");
    }

    public static class MasterJprincipalCache
    implements Serializable {
        protected Jprincipal[] jprincipals = null;

        public MasterJprincipalCache(Jprincipal[] jprincipals) {
            this.jprincipals = jprincipals;
        }

        public MasterJprincipalCache(MasterJprincipalCache source) {
            if (ArrayUtils.isEmpty((Object[])source.jprincipals)) {
                return;
            }
            this.jprincipals = (Jprincipal[])SerializationUtils.clone((Serializable)source.jprincipals);
        }
    }

    private static class JprincipalIdComparator
    implements Comparator<Object> {
        private JprincipalIdComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s2;
            String s1;
            if (o1 == null) {
                if (o2 == null) {
                    logger.debug("o1 and o2 is null");
                    return 0;
                }
                logger.debug("o1 is null");
                return -1;
            }
            if (o1 instanceof Jprincipal) {
                s1 = ((Jprincipal)o1).getPrincipalId();
                if (s1 == null) {
                    logger.debug("s1 is null");
                    return -1;
                }
            } else if (o1 instanceof String) {
                s1 = (String)o1;
            } else {
                throw new ClassCastException("o1");
            }
            if (o2 == null) {
                logger.debug("o2 is null");
                return 1;
            }
            if (o2 instanceof Jprincipal) {
                s2 = ((Jprincipal)o2).getPrincipalId();
                if (s2 == null) {
                    logger.debug("s2 is null");
                    return 1;
                }
            } else if (o2 instanceof String) {
                s2 = (String)o2;
            } else {
                throw new ClassCastException("o2");
            }
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof JprincipalIdComparator;
        }
    }
}

