/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.core.util.PresentationModelUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelDataAccessManager<E extends ContainerBase<E>, PK extends Serializable> {
    private static final Logger logger = LogManager.getLogger(ModelDataAccessManager.class);
    protected String modelId;
    protected EntityHelper<E, PK> entityHelper;
    protected JFCEntityService<E, PK> entityService;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setEntityHelper(EntityHelper<E, PK> entityHelper) {
        this.entityHelper = entityHelper;
    }

    public void setEntityService(JFCEntityService<E, PK> entityService) {
        this.entityService = entityService;
    }

    protected String convertErrorMessage(Exception e, ActionParameter p) {
        return DbBaseController.convertErrorMessage(e, null, p.locale);
    }

    public int getCount(ActionParameter p) {
        try {
            return this.entityService.count();
        }
        catch (Exception e) {
            JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
            String errorMessage = this.convertErrorMessage(e, p);
            logger.error(JFCUtils.logmsg(p, errorMessage), (Throwable)e);
            p.errors.addJfcerror(errorManager.getJfcerror("error.dbaccess", (Object[])new String[]{errorMessage}, p.locale));
            return -1;
        }
    }

    public Map<String, String> getReplaceMap(String modelname, String[] pkey, ActionParameter p) {
        if (modelname != null && !modelname.equals(this.modelId)) {
            logger.error("Illegal modelname " + modelname);
            return null;
        }
        E entity = this.getStoreObject(pkey, p);
        if (entity == null) {
            return null;
        }
        return StoreModelUtils.replaceMapHelper(this.modelId, p).get(PresentationModelUtils.presentationHelper(this.modelId, p).s2p(entity, p, 1), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getStoreObject(String[] pkey, ActionParameter p) {
        String __key = "__jfc_control.skipBeforeShow_" + this.modelId + "_";
        Object __value = p.request.getAttribute(__key = __key + String.join((CharSequence)PrimaryKeyUtils.PKEY_SEPARATOR(), pkey));
        if (__value != null) {
            p.request.removeAttribute(__key);
        }
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        try {
            E entity = this.entityService.findById(this.entityHelper.getPrimarykey(PrimaryKeyUtils.toString(pkey)));
            if (entity == null) {
                p.errors.addJfcerror(errorManager.getJfcerror("error.dbaccess", (Object[])new String[]{""}, p.locale));
                E e = null;
                return e;
            }
            E e = entity;
            return e;
        }
        catch (Exception e) {
            String errorMessage = this.convertErrorMessage(e, p);
            logger.error(JFCUtils.logmsg(p, errorMessage), (Throwable)e);
            p.errors.addJfcerror(errorManager.getJfcerror("error.dbaccess", (Object[])new String[]{errorMessage}, p.locale));
        }
        finally {
            if (__value != null) {
                p.request.setAttribute(__key, __value);
            }
        }
        return null;
    }
}

