/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.app.CacheManagerBase;
import jp.jasminesoft.jfc.app.PresentationHelper;
import jp.jasminesoft.jfc.core.group.ElementUtils;
import jp.jasminesoft.jfc.core.util.ModelUtils;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcwarn;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefBase;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.TranslateJpEra;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PresentationPHelperBase<S, P>
extends PresentationHelper {
    private static final Logger logger = LogManager.getLogger(PresentationPHelperBase.class);
    private static CacheManagerBase _cacheManager = null;

    protected Date getSQLDate(String s, String[] formats, Locale locale, boolean isWarekiFlag) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            java.util.Date d = null;
            if (isWarekiFlag) {
                d = TranslateJpEra.getInstance().j2g(s);
            }
            if (d != null) {
                return new Date(d.getTime());
            }
            d = DateTimeUtil.getDateWithFormat((String)s, (String[])formats, (Locale)locale);
            if (d != null) {
                return new Date(d.getTime());
            }
            return null;
        }
        return null;
    }

    protected Time getSQLTime(String s, String[] formats, Locale locale, boolean isWarekiFlag) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            java.util.Date d = null;
            if (isWarekiFlag) {
                d = TranslateJpEra.getInstance().j2g(s);
            }
            if (d != null) {
                return new Time(d.getTime());
            }
            d = DateTimeUtil.getDateWithFormat((String)s, (String[])formats, (Locale)locale);
            if (d != null) {
                return new Time(d.getTime());
            }
            return null;
        }
        return null;
    }

    protected Timestamp getSQLTimestamp(String s, String[] formats, Locale locale, boolean isWarekiFlag) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            java.util.Date d = null;
            if (isWarekiFlag) {
                d = TranslateJpEra.getInstance().j2g(s);
            }
            if (d != null) {
                return new Timestamp(d.getTime());
            }
            d = DateTimeUtil.getDateWithFormat((String)s, (String[])formats, (Locale)locale);
            if (d != null) {
                return new Timestamp(d.getTime());
            }
            return null;
        }
        return null;
    }

    protected void addSQLDate(String s, List<Date> list, String[] formats, Locale locale, boolean isWarekiFlag, boolean isKeep) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            java.util.Date d = null;
            if (isWarekiFlag && (d = TranslateJpEra.getInstance().j2g(s)) != null) {
                list.add(new Date(d.getTime()));
            }
            if (d == null) {
                d = DateTimeUtil.getDateWithFormat((String)s, (String[])formats, (Locale)locale);
                if (d != null) {
                    list.add(new Date(d.getTime()));
                } else if (!isKeep) {
                    list.add(new Date(0L));
                }
            }
        }
    }

    protected void addSQLTime(String s, List<Time> list, String[] formats, Locale locale, boolean isWarekiFlag, boolean isKeep) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            java.util.Date d = null;
            if (isWarekiFlag && (d = TranslateJpEra.getInstance().j2g(s)) != null) {
                list.add(new Time(d.getTime()));
            }
            if (d == null) {
                d = DateTimeUtil.getDateWithFormat((String)s, (String[])formats, (Locale)locale);
                if (d != null) {
                    list.add(new Time(d.getTime()));
                } else if (!isKeep) {
                    list.add(new Time(0L));
                }
            }
        }
    }

    protected void addSQLTimestamp(String s, List<Timestamp> list, String[] formats, Locale locale, boolean isWarekiFlag, boolean isKeep) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            java.util.Date d = null;
            if (isWarekiFlag && (d = TranslateJpEra.getInstance().j2g(s)) != null) {
                list.add(new Timestamp(d.getTime()));
            }
            if (d == null) {
                d = DateTimeUtil.getDateWithFormat((String)s, (String[])formats, (Locale)locale);
                if (d != null) {
                    list.add(new Timestamp(d.getTime()));
                } else if (!isKeep) {
                    list.add(new Timestamp(0L));
                }
            }
        }
    }

    protected void setErrorcode(Object r_code, String varname, ActionParameter p) {
        int _ptr;
        String _target;
        String _varname;
        boolean isFoundErrorCode = false;
        if (p.errors.sizeJfcerror() > 0) {
            _varname = varname;
            for (Cloneable cloneable : p.errors.getJfcerror()) {
                _target = ((Jfcerror)cloneable).getName();
                if (StringUtils.isBlank((CharSequence)_target)) continue;
                _ptr = _target.indexOf("/");
                if (_ptr > 0) {
                    _target = _target.substring(_ptr + 1);
                    Integer __index2 = (Integer)p.request.getAttribute("__index");
                    if (__index2 != null) {
                        _varname = varname + "[" + __index2 + "]";
                    }
                }
                if (!_varname.equals(_target)) continue;
                try {
                    MethodUtils.invokeMethod((Object)r_code, (String)"setErrorcode", (Object)((Jfcerror)cloneable).getContent());
                }
                catch (NoSuchMethodException __index2) {
                }
                catch (IllegalAccessException __index2) {
                }
                catch (InvocationTargetException __index2) {
                    // empty catch block
                }
                isFoundErrorCode = true;
            }
        }
        if (p.errors.sizeJfcwarn() > 0 && !isFoundErrorCode) {
            _varname = varname;
            for (Cloneable cloneable : p.errors.getJfcwarn()) {
                _target = ((Jfcwarn)cloneable).getName();
                if (StringUtils.isBlank((CharSequence)_target)) continue;
                _ptr = _target.indexOf("/");
                if (_ptr > 0) {
                    _target = _target.substring(_ptr + 1);
                    Integer __index = (Integer)p.request.getAttribute("__index");
                    if (__index != null) {
                        _varname = varname + "[" + __index + "]";
                    }
                }
                if (!_varname.equals(_target)) continue;
                try {
                    MethodUtils.invokeMethod((Object)r_code, (String)"setErrorcode", (Object)((Jfcwarn)cloneable).getContent());
                }
                catch (NoSuchMethodException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected <T extends JFCPresentationModelitemStorerefBase> T setRcode_Notexists(T r_code, String code, String invalidMark, ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        String msg = JFCUtils.getRValue("__jfc_common.data.noexist", p.locale);
        if (StringUtils.isNotBlank((CharSequence)invalidMark)) {
            sb.append(msg).append(" ").append(code).append(invalidMark);
        } else if (StringUtils.isNotBlank((CharSequence)msg)) {
            sb.append(msg).append(" ").append(code);
        } else {
            sb.append(code);
        }
        r_code.setContent(sb.toString());
        r_code.setChoose(true);
        r_code.setInvalid(true);
        return r_code;
    }

    protected Comparator<?> getSelfComparator() {
        BeanComparator comparator = new BeanComparator("content");
        return new NullComparator((Comparator)comparator);
    }

    protected <Entity> Object getMethod(Entity entity, String itemname) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            Object o = MethodUtils.invokeMethod(entity, (String)getterm, null);
            if (o != null) {
                return o;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected <Entity> Boolean checkMethod(Entity entity, String itemname) {
        String checkerm = SourceGeneratorUtil.checkMethod((String)itemname);
        try {
            Object c = MethodUtils.invokeMethod(entity, (String)checkerm, null);
            if (c != null && c instanceof Boolean) {
                Boolean b = (Boolean)c;
                return (boolean)b;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected <Presentation> void setMethodAsString(Presentation pr, String itemname, Object value) {
        String setterm = SourceGeneratorUtil.setterMethod((String)itemname);
        try {
            if (value != null) {
                MethodUtils.invokeMethod(pr, (String)setterm, (Object[])new Object[]{value});
            } else {
                Method method = pr.getClass().getMethod(setterm, String.class);
                method.invoke(pr, new Object[]{null});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <Presentation> void setMethod(Presentation pr, String itemname, Class<?> tclazz, Object value) {
        String setterm = SourceGeneratorUtil.setterMethod((String)itemname);
        try {
            if (value != null) {
                MethodUtils.invokeMethod(pr, (String)setterm, (Object[])new Object[]{value});
            } else {
                Method method = pr.getClass().getMethod(setterm, this.getWrapperClass(tclazz));
                method.invoke(pr, new Object[]{null});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class<?> getWrapperClass(Class<?> tclazz) {
        Class wtclazz = null;
        if (tclazz.equals(Integer.TYPE)) {
            wtclazz = Integer.class;
        } else if (tclazz.equals(Long.TYPE)) {
            wtclazz = Long.class;
        } else if (tclazz.equals(Double.TYPE)) {
            wtclazz = Double.class;
        } else if (tclazz.equals(Float.TYPE)) {
            wtclazz = Float.class;
        } else if (tclazz.equals(Short.TYPE)) {
            wtclazz = Short.class;
        } else if (tclazz.equals(Byte.TYPE)) {
            wtclazz = Byte.class;
        }
        if (wtclazz != null) {
            return wtclazz;
        }
        return tclazz;
    }

    protected boolean isInitialValue(Class<?> tclazz, Object value) {
        Byte vnum;
        boolean ret = false;
        if (tclazz.equals(Integer.TYPE)) {
            Integer vnum2 = (Integer)value;
            if (vnum2 == 0) {
                ret = true;
            }
        } else if (tclazz.equals(Long.TYPE)) {
            Long vnum3 = (Long)value;
            if (vnum3 == 0L) {
                ret = true;
            }
        } else if (tclazz.equals(Double.TYPE)) {
            Double vnum4 = (Double)value;
            if (vnum4 == 0.0) {
                ret = true;
            }
        } else if (tclazz.equals(Float.TYPE)) {
            Float vnum5 = (Float)value;
            if (vnum5.floatValue() == 0.0f) {
                ret = true;
            }
        } else if (tclazz.equals(Short.TYPE)) {
            Short vnum6 = (Short)value;
            if (vnum6 == 0) {
                ret = true;
            }
        } else if (tclazz.equals(Byte.TYPE) && (vnum = (Byte)value) == 0) {
            ret = true;
        }
        return ret;
    }

    protected CacheManagerBase getCacheManager(ActionParameter p) {
        if (_cacheManager == null) {
            try {
                String clazzName = this.getClass().getName();
                String packageName = clazzName.substring(0, clazzName.indexOf(".app.") + 5);
                String cacheManagerClassName = packageName + "CacheManager";
                Class<?> cacheManagerClazz = Class.forName(cacheManagerClassName);
                _cacheManager = (CacheManagerBase)MethodUtils.invokeStaticMethod(cacheManagerClazz, (String)"getInstance", (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return _cacheManager;
    }

    protected void script(S entity, P dto, ActionParameter p, String methodName) {
        this.script(entity, dto, p, methodName, "process");
    }

    protected void script(S entity, P dto, ActionParameter p, String methodName, String functionName) {
        if (StringUtils.isBlank((CharSequence)methodName) || StringUtils.isBlank((CharSequence)functionName) || entity == null) {
            return;
        }
        String modelId = ModelUtils.getModelId(entity.getClass());
        String status = new ScriptCodeRunner(modelId).process(this.getClass().getName(), methodName, functionName, this.scriptParams(entity, dto, p), p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            Jfcerror _error = new Jfcerror();
            _error.setContent(status);
            p.errors.addJfcerror(_error);
        }
    }

    protected Map<String, ?> scriptParams(S entity, P dto, ActionParameter p) {
        String owner;
        HashMap<String, Object> params = new HashMap<String, Object>();
        String modelId = ModelUtils.getModelId(entity.getClass());
        params.put(modelId, entity);
        params.put("$rootGroup", ElementUtils.rootGroup(p.appctx));
        params.put("$allUsers", ElementUtils.allUsers(p.appctx));
        if (dto != null) {
            params.put(ModelUtils.getModelId(dto.getClass()), dto);
        }
        if (StringUtils.isNotBlank((CharSequence)(owner = this.dataOwner(entity)))) {
            params.put("$owner", ElementUtils.getUserElement(p.appctx, owner));
            return params;
        }
        return params;
    }

    protected String dataOwner(S entity) {
        return null;
    }

    protected boolean isGroupChartVisible(S entity, ActionParameter p) {
        String screenType = (String)p.request.getAttribute("__jfc_screen_type");
        String[] supports = new String[]{"insert", "update", "copy"};
        if (Stream.of(supports).noneMatch(type -> type.equals(screenType))) {
            return false;
        }
        this.script(entity, null, p, "groupSelection");
        return p.request.getAttribute("__jfc_groupChart") != null;
    }
}

