/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.app.CacheManagerBase;
import jp.jasminesoft.jfc.app.CacheManagerUtil;
import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.model.jcategory.Jcategory;
import jp.jasminesoft.jfc.model.jprincipal.Jprincipal;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class PrincipalCategoryManager {
    private static final Logger logger = LogManager.getLogger(PrincipalCategoryManager.class);
    public static final int CATEGORY_ID_UNDEFINED = 0x7FFFFFFE;
    @Autowired
    protected ApplicationContext applicationContext;
    protected CacheManagerBase cacheManager;
    private Integer maxOrderValue;

    private PrincipalCategoryManager() {
    }

    @PostConstruct
    protected void init() {
        this.cacheManager = CacheManagerUtil.getCacheManager(this.applicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JCategoryData data() {
        JCategoryData cache = this.cacheManager.get("principalCategory", JCategoryData.class, "__jfc_PrincipalGategory");
        if (cache != null) {
            return cache;
        }
        JCategoryData data = new JCategoryData();
        String expression = null;
        try (Session session = HibernateUtil.openSession();){
            Jcategory[] jcategories;
            expression = PropertyManager.getProperty("jp.jasminesoft.jfc.app.PrincipalCategoryManager.init.query");
            Query query = session.createQuery(expression);
            List list = query.list();
            for (Jcategory jcategory : jcategories = list.toArray(new Jcategory[list.size()])) {
                data.jcategoryMap.put(jcategory.getId(), jcategory);
            }
            this.cacheManager.put(data, JCategoryData.class, "__jfc_PrincipalGategory", "principalCategory");
        }
        return data;
    }

    public Jcategory getJcategoryById(int id) {
        return this.data().jcategoryMap.get(id);
    }

    public void clear() {
        this.cacheManager.clearPrincipalCategory();
    }

    private int getMaxOrderValue() {
        Map<Integer, Jcategory> jcategoryMap = this.data().jcategoryMap;
        if (this.maxOrderValue == null && jcategoryMap.size() > 0) {
            this.maxOrderValue = jcategoryMap.values().stream().max(Comparator.comparingInt(c -> c.getOrder())).get().getOrder();
        }
        return this.maxOrderValue == null ? 0 : this.maxOrderValue;
    }

    public void setCategory(Object r_code, Jprincipal jprincipal, ActionParameter p) {
        block6: {
            int radix = this.getMaxOrderValue() + 1;
            Jcategory jcategory = this.getJcategoryById(jprincipal.getCategory());
            if (jcategory != null) {
                try {
                    MethodUtils.invokeMethod((Object)r_code, (String)"setCategoryContent", (Object[])new Object[]{JFCUtils.interpretContentByLocale(p, jcategory.getContent())});
                    MethodUtils.invokeMethod((Object)r_code, (String)"setCategory", (Object[])new Object[]{jcategory.getOrder() * radix + jprincipal.getCategory()});
                    MethodUtils.invokeMethod((Object)r_code, (String)"setIsShowInSelect", (Object[])new Object[]{jprincipal.isShowInSelect()});
                    MethodUtils.invokeMethod((Object)r_code, (String)"setIsEditable", (Object[])new Object[]{jprincipal.isEditable()});
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    break block6;
                }
            }
            try {
                MethodUtils.invokeMethod((Object)r_code, (String)"setCategoryContent", (Object[])new Object[]{""});
                MethodUtils.invokeMethod((Object)r_code, (String)"setCategory", (Object[])new Object[]{0x7FFFFFFE});
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class JCategoryData
    implements Serializable {
        protected Map<Integer, Jcategory> jcategoryMap = null;

        public JCategoryData() {
            this.jcategoryMap = new HashMap<Integer, Jcategory>();
        }

        public JCategoryData(JCategoryData jcategoryData) {
            this.jcategoryMap = new HashMap<Integer, Jcategory>(jcategoryData.jcategoryMap);
        }
    }
}

